/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.types;

import de.be4.classicalb.core.parser.node.APartialFunctionExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.tla2b.exceptions.UnificationException;
import de.tla2b.output.TypeVisitorInterface;
import de.tla2b.types.AbstractHasFollowers;
import de.tla2b.types.IntType;
import de.tla2b.types.StringType;
import de.tla2b.types.TLAType;
import de.tla2b.types.TupleOrFunction;
import de.tla2b.types.TupleType;
import de.tla2b.types.UntypedType;

public class FunctionType
extends AbstractHasFollowers {
    private TLAType domain;
    private TLAType range;

    public FunctionType(TLAType domain, TLAType range) {
        super(FUNCTION);
        this.setDomain(domain);
        this.setRange(range);
    }

    public FunctionType() {
        this(new UntypedType(), new UntypedType());
    }

    public void update(TLAType oldType, TLAType newType) {
        if (this.domain == oldType) {
            this.setDomain(newType);
        }
        if (this.range == oldType) {
            this.setRange(newType);
        }
    }

    @Override
    public boolean compare(TLAType other) {
        if (this.contains(other)) {
            return false;
        }
        if (other.getKind() == UNTYPED) {
            return true;
        }
        if (other instanceof StringType && this.domain.compare(IntType.getInstance()) && this.range instanceof UntypedType) {
            return true;
        }
        if (other instanceof FunctionType) {
            FunctionType f = (FunctionType)other;
            return this.domain.compare(f.domain) && this.range.compare(f.range);
        }
        if (other instanceof TupleType) {
            return other.compare(this);
        }
        if (other instanceof TupleOrFunction) {
            return other.compare(this);
        }
        return false;
    }

    @Override
    public boolean contains(TLAType o) {
        return this.domain.equals(o) || this.domain.contains(o) || this.range.equals(o) || this.range.contains(o);
    }

    @Override
    public boolean isUntyped() {
        return this.domain.isUntyped() || this.range.isUntyped();
    }

    @Override
    public TLAType cloneTLAType() {
        return new FunctionType(this.domain.cloneTLAType(), this.range.cloneTLAType());
    }

    @Override
    public TLAType unify(TLAType other) throws UnificationException {
        if (other == null || !this.compare(other)) {
            throw new UnificationException();
        }
        if (other instanceof StringType) {
            this.setFollowersTo(other);
            return StringType.getInstance();
        }
        if (other instanceof UntypedType) {
            ((UntypedType)other).setFollowersTo(this);
            return this;
        }
        if (other instanceof FunctionType) {
            this.domain = this.domain.unify(((FunctionType)other).domain);
            this.range = this.range.unify(((FunctionType)other).range);
            return this;
        }
        if (other instanceof TupleType) {
            return other.unify(this);
        }
        if (other instanceof TupleOrFunction) {
            return other.unify(this);
        }
        throw new RuntimeException();
    }

    public TLAType getDomain() {
        return this.domain;
    }

    public TLAType getRange() {
        return this.range;
    }

    public void setDomain(TLAType domain) {
        this.domain = domain;
        if (domain instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)domain).addFollower(this);
        }
    }

    public void setRange(TLAType range) {
        this.range = range;
        if (range instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)range).addFollower(this);
        }
    }

    public String toString() {
        String res = "POW(" + this.domain + "*";
        res = this.range instanceof TupleType ? res + "(" + this.range + ")" : res + this.range;
        res = res + ")";
        return res;
    }

    @Override
    public PExpression getBNode() {
        return new APartialFunctionExpression(this.domain.getBNode(), this.range.getBNode());
    }

    @Override
    public void apply(TypeVisitorInterface visitor) {
        visitor.caseFunctionType(this);
    }
}

