/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.be4.classicalb.core.parser.Definitions;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.util.ASTBuilder;
import de.tla2b.analysis.AbstractASTVisitor;
import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.global.BBuildIns;
import de.tla2b.global.BBuiltInOPs;
import java.util.HashSet;
import java.util.Set;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;

public class UsedExternalFunctions
extends AbstractASTVisitor
implements BBuildIns {
    private final Set<String> usedExternalFunctions = new HashSet<String>();

    public static IDefinitions createDefinitions(SpecAnalyser specAnalyser) {
        UsedExternalFunctions externalFunctions = new UsedExternalFunctions(specAnalyser);
        Definitions definitions = new Definitions();
        if (externalFunctions.usedExternalFunctions.contains("CHOOSE")) {
            ASTBuilder.addChooseDefinition(definitions);
        }
        if (externalFunctions.usedExternalFunctions.contains("ASSERT_TRUE")) {
            ASTBuilder.addAssertTrueDefinition(definitions);
        }
        return definitions;
    }

    private UsedExternalFunctions(SpecAnalyser specAnalyser) {
        this.visitAssumptions(specAnalyser.getModuleNode().getAssumptions());
        for (OpDefNode def : specAnalyser.getUsedDefinitions()) {
            this.visitDefinition(def);
        }
    }

    @Override
    public void visitBuiltInNode(OpApplNode n) {
        ExprOrOpArgNode[] arguments;
        ExprNode[] in;
        switch (UsedExternalFunctions.getOpCode(n.getOperator().getName())) {
            case 1: 
            case 4: 
            case 24: {
                this.usedExternalFunctions.add("CHOOSE");
            }
        }
        for (ExprNode exprNode : in = n.getBdedQuantBounds()) {
            this.visitExprNode(exprNode);
        }
        for (ExprOrOpArgNode exprOrOpArgNode : arguments = n.getArgs()) {
            if (exprOrOpArgNode == null) continue;
            this.visitExprOrOpArgNode(exprOrOpArgNode);
        }
    }

    @Override
    public void visitBBuiltinsNode(OpApplNode n) {
        ExprOrOpArgNode[] arguments;
        if (BBuiltInOPs.getOpcode(n.getOperator().getName()) == 35) {
            this.usedExternalFunctions.add("ASSERT_TRUE");
        }
        for (ExprNode exprNode : n.getBdedQuantBounds()) {
            this.visitExprNode(exprNode);
        }
        for (ExprOrOpArgNode exprOrOpArgNode : arguments = n.getArgs()) {
            this.visitExprOrOpArgNode(exprOrOpArgNode);
        }
    }
}

