/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.tla2b.analysis.BOperation;
import de.tla2b.analysis.RecursiveDefinition;
import de.tla2b.config.ConfigfileEvaluator;
import de.tla2b.exceptions.ConfigFileErrorException;
import de.tla2b.exceptions.NotImplementedException;
import de.tla2b.exceptions.SemanticErrorException;
import de.tla2b.global.BBuiltInOPs;
import de.tla2b.translation.BDefinitionsFinder;
import de.tla2b.translation.OperationsFinder;
import de.tla2b.translation.UsedDefinitionsFinder;
import de.tla2b.util.DebugUtils;
import de.tla2b.util.TlaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.BuiltInOPs;

public class SpecAnalyser
extends BuiltInOPs {
    private OpDefNode spec;
    private OpDefNode init;
    private OpDefNode next;
    private List<OpDefNode> invariants = new ArrayList<OpDefNode>();
    private List<OpDeclNode> bConstants = new ArrayList<OpDeclNode>();
    private OpDefNode expressionOpdefNode;
    private final Map<String, SymbolNode> namingMap = new HashMap<String, SymbolNode>();
    private final ModuleNode moduleNode;
    private ExprNode nextExpr;
    private List<BOperation> bOperations = new ArrayList<BOperation>();
    private final List<ExprNode> inits = new ArrayList<ExprNode>();
    private Set<OpDefNode> bDefinitionsSet = new HashSet<OpDefNode>();
    private Set<OpDefNode> usedDefinitions = new HashSet<OpDefNode>();
    private final Map<OpDefNode, FormalParamNode[]> letParams = new HashMap<OpDefNode, FormalParamNode[]>();
    private final List<String> definitionMacros = new ArrayList<String>();
    private final List<OpDefNode> recursiveFunctions = new ArrayList<OpDefNode>();
    private final List<RecursiveDefinition> recursiveDefinitions = new ArrayList<RecursiveDefinition>();
    private ConfigfileEvaluator configFileEvaluator;

    private SpecAnalyser(ModuleNode m) {
        this.moduleNode = m;
    }

    public static SpecAnalyser createSpecAnalyser(ModuleNode m, ConfigfileEvaluator conEval) {
        SpecAnalyser specAnalyser = new SpecAnalyser(m);
        specAnalyser.spec = conEval.getSpecNode();
        specAnalyser.init = conEval.getInitNode();
        specAnalyser.next = conEval.getNextNode();
        specAnalyser.invariants = conEval.getInvariants();
        specAnalyser.bConstants = conEval.getbConstantList();
        specAnalyser.configFileEvaluator = conEval;
        return specAnalyser;
    }

    public static SpecAnalyser createSpecAnalyserForTlaExpression(ModuleNode m) {
        SpecAnalyser specAnalyser = new SpecAnalyser(m);
        specAnalyser.expressionOpdefNode = m.getOpDefs()[m.getOpDefs().length - 1];
        specAnalyser.usedDefinitions.add(specAnalyser.expressionOpdefNode);
        specAnalyser.bDefinitionsSet.add(specAnalyser.expressionOpdefNode);
        return specAnalyser;
    }

    public static SpecAnalyser createSpecAnalyser(ModuleNode m) {
        Map<String, OpDefNode> definitions = TlaUtils.getOpDefsMap(m.getOpDefs());
        SpecAnalyser specAnalyser = new SpecAnalyser(m);
        specAnalyser.spec = SpecAnalyser.detectClause(Stream.of("Spec", "SPECIFICATION", "SPEC"), definitions, "INITIALISATION+OPERATIONS");
        specAnalyser.init = SpecAnalyser.detectClause(Stream.of("Init", "INIT", "Initialisation", "INITIALISATION"), definitions, "INITIALISATION");
        specAnalyser.next = SpecAnalyser.detectClause(Stream.of("Next", "NEXT"), definitions, "OPERATIONS");
        OpDefNode invariant = SpecAnalyser.detectClause(Stream.of("Inv", "INVARIANTS", "INVARIANT", "INV", "Invariant", "Invariants", "TypeInv", "TypeOK", "IndInv"), definitions, "INVARIANTS");
        if (invariant != null) {
            specAnalyser.invariants.add(invariant);
        } else {
            DebugUtils.printMsg("No default Invariant detected");
        }
        specAnalyser.bConstants = Arrays.asList(m.getConstantDecls());
        return specAnalyser;
    }

    private static OpDefNode detectClause(Stream<String> keywords, Map<String, OpDefNode> definitions, String bClause) {
        return keywords.filter(definitions::containsKey).findFirst().map(keyword -> {
            DebugUtils.printMsg("Detected TLA+ Default Definition " + keyword + " for Clause: " + bClause);
            return (OpDefNode)definitions.get(keyword);
        }).orElse(null);
    }

    public void start() throws SemanticErrorException, ConfigFileErrorException, NotImplementedException {
        this.evalSpec();
        this.invariants.replaceAll(inv -> {
            try {
                OpApplNode opApplNode = (OpApplNode)inv.getBody();
                OpDefNode opDefNode = (OpDefNode)opApplNode.getOperator();
                if (opDefNode.getKind() == 5 && !BBuiltInOPs.contains(opDefNode.getName())) {
                    DebugUtils.printDebugMsg("replacing invariant definition " + inv.getName() + " by its inner definition " + opDefNode.getName());
                    return opDefNode;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return inv;
        });
        DebugUtils.printDebugMsg("Detecting OPERATIONS from disjunctions");
        this.bOperations = new OperationsFinder(this).getBOperations();
        DebugUtils.printDebugMsg("Finding used definitions");
        this.usedDefinitions = new UsedDefinitionsFinder(this).getUsedDefinitions();
        this.bDefinitionsSet = new BDefinitionsFinder(this).getBDefinitionsSet();
        DebugUtils.printDebugMsg("Computing variable declarations");
        if (this.moduleNode.getVariableDecls().length > 0 && this.inits.isEmpty()) {
            throw new SemanticErrorException("No initial predicate is defined.");
        }
        for (OpDeclNode con : this.bConstants) {
            if (con.getArity() <= 0) continue;
            throw new ConfigFileErrorException(String.format("Constant '%s' must be overridden in the configuration file.", con.getName()));
        }
        this.findRecursiveConstructs();
        this.namingMap.putAll(TlaUtils.getDeclarationsMap(this.moduleNode.getVariableDecls()));
        DebugUtils.printMsg("Number of variables detected: " + this.moduleNode.getVariableDecls().length);
        this.namingMap.putAll(TlaUtils.getDeclarationsMap(this.moduleNode.getConstantDecls()));
        DebugUtils.printMsg("Number of constants detected: " + this.moduleNode.getConstantDecls().length);
        this.namingMap.putAll(TlaUtils.getOpDefsMap(this.usedDefinitions.toArray(new OpDefNode[0])));
    }

    private void evalSpec() throws SemanticErrorException {
        if (this.spec != null) {
            DebugUtils.printMsg("Using TLA+ Spec to determine B INITIALISATION and OPERATIONS");
            this.processConfigSpec(this.spec.getBody());
        } else {
            if (this.init != null) {
                DebugUtils.printMsg("Using TLA+ Init definition to determine B INITIALISATION");
                this.inits.add(this.init.getBody());
            }
            if (this.next != null) {
                DebugUtils.printMsg("Using TLA+ Next definition to determine B OPERATIONS");
                this.nextExpr = this.next.getBody();
            }
        }
    }

    private void processConfigSpec(ExprNode exprNode) throws SemanticErrorException {
        if (exprNode instanceof OpApplNode) {
            ExprOrOpArgNode boxArg;
            OpApplNode opApp = (OpApplNode)exprNode;
            ExprOrOpArgNode[] args = opApp.getArgs();
            if (args.length == 0) {
                SymbolNode opNode = opApp.getOperator();
                if (opNode instanceof OpDefNode) {
                    OpDefNode def = (OpDefNode)opNode;
                    ExprNode body = def.getBody();
                    body.levelCheck(1);
                    if (body.getLevel() == 1) {
                        this.inits.add(exprNode);
                    } else {
                        this.processConfigSpec(body);
                    }
                    return;
                }
                throw new SemanticErrorException("Can not handle specification conjunction.");
            }
            int opcode = BuiltInOPs.getOpCode(opApp.getOperator().getName());
            if (opcode == 6 || opcode == 36) {
                for (ExprOrOpArgNode arg : args) {
                    this.processConfigSpec((ExprNode)arg);
                }
                return;
            }
            if (opcode == 59 && (boxArg = args[0]) instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                this.nextExpr = (ExprNode)((OpApplNode)boxArg).getArgs()[0];
                return;
            }
        }
        if (exprNode.getLevel() <= 1) {
            this.inits.add(exprNode);
        } else if (exprNode.getLevel() != 3) {
            throw new SemanticErrorException("Can not handle specification conjunction.");
        }
    }

    private void findRecursiveConstructs() throws NotImplementedException {
        HashSet<OpDefNode> set = new HashSet<OpDefNode>(this.usedDefinitions);
        for (OpDefNode def : set) {
            OpApplNode o;
            if (def.getInRecursive()) {
                throw new NotImplementedException("Recursive definitions are currently not supported: " + def.getName() + "\n" + def.getLocation());
            }
            if (!(def.getBody() instanceof OpApplNode) || SpecAnalyser.getOpCode((o = (OpApplNode)def.getBody()).getOperator().getName()) != 16) continue;
            this.bDefinitionsSet.remove(def);
            this.recursiveFunctions.add(def);
        }
    }

    public List<BOperation> getBOperations() {
        return this.bOperations;
    }

    public List<ExprNode> getInits() {
        return this.inits;
    }

    public ExprNode getNext() {
        return this.nextExpr;
    }

    public Set<OpDefNode> getBDefinitions() {
        return this.bDefinitionsSet;
    }

    public Map<OpDefNode, FormalParamNode[]> getLetParams() {
        return new HashMap<OpDefNode, FormalParamNode[]>(this.letParams);
    }

    public List<String> getDefinitionMacros() {
        return this.definitionMacros;
    }

    public Set<OpDefNode> getUsedDefinitions() {
        return this.usedDefinitions;
    }

    public List<OpDefNode> getRecursiveFunctions() {
        return this.recursiveFunctions;
    }

    public List<RecursiveDefinition> getRecursiveDefinitions() {
        return this.recursiveDefinitions;
    }

    public ModuleNode getModuleNode() {
        return this.moduleNode;
    }

    public ConfigfileEvaluator getConfigFileEvaluator() {
        return this.configFileEvaluator;
    }

    public List<OpDefNode> getInvariants() {
        return this.invariants;
    }

    public OpDefNode getInitDef() {
        return this.init;
    }

    public OpDefNode getExpressionOpdefNode() {
        return this.expressionOpdefNode;
    }

    public SymbolNode getSymbolNodeByName(String name) {
        return this.namingMap.get(name);
    }
}

