/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.analysis.transforming.DefinitionInjector;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AAssertionSubstitution;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AComputationOperation;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADefineSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADescriptionOperation;
import de.be4.classicalb.core.parser.node.ADescriptionPragma;
import de.be4.classicalb.core.parser.node.ADisjunctPredicate;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.AEmptySetExpression;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AForLoopSubstitution;
import de.be4.classicalb.core.parser.node.AForallSubMessageSubstitution;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AFunctionOperation;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIfSubstitution;
import de.be4.classicalb.core.parser.node.AIfThenElseExpression;
import de.be4.classicalb.core.parser.node.AImageExpression;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AIntervalExpression;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.AMinusOrSetSubtractExpression;
import de.be4.classicalb.core.parser.node.AMultOrCartExpression;
import de.be4.classicalb.core.parser.node.ANatural1SetExpression;
import de.be4.classicalb.core.parser.node.ANegationPredicate;
import de.be4.classicalb.core.parser.node.ANotEqualPredicate;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.AOperatorExpression;
import de.be4.classicalb.core.parser.node.AOperatorPredicate;
import de.be4.classicalb.core.parser.node.APowSubsetExpression;
import de.be4.classicalb.core.parser.node.APreconditionSubstitution;
import de.be4.classicalb.core.parser.node.ARangeExpression;
import de.be4.classicalb.core.parser.node.ARuleFailSubSubstitution;
import de.be4.classicalb.core.parser.node.ARuleOperation;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASequenceExtensionExpression;
import de.be4.classicalb.core.parser.node.ASequenceSubstitution;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASkipSubstitution;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.AStringSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicLambdaExpression;
import de.be4.classicalb.core.parser.node.ASymbolicQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ATruthPredicate;
import de.be4.classicalb.core.parser.node.AUnionExpression;
import de.be4.classicalb.core.parser.node.AVarSubstitution;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AWhileSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TIntegerLiteral;
import de.be4.classicalb.core.parser.node.TPragmaFreeText;
import de.be4.classicalb.core.parser.node.TStringLiteral;
import de.be4.classicalb.core.parser.rules.AbstractOperation;
import de.be4.classicalb.core.parser.rules.ComputationOperation;
import de.be4.classicalb.core.parser.rules.FunctionOperation;
import de.be4.classicalb.core.parser.rules.MissingPositionsAdder;
import de.be4.classicalb.core.parser.rules.RuleOperation;
import de.be4.classicalb.core.parser.rules.RulesMachineChecker;
import de.be4.classicalb.core.parser.util.ASTBuilder;
import de.be4.classicalb.core.parser.util.Utils;
import de.hhu.stups.sablecc.patch.PositionedNode;
import de.prob.prolog.output.PrologTermOutput;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RulesTransformation
extends DepthFirstAdapter {
    public static final String RULE_FAIL = "FAIL";
    public static final String RULE_SUCCESS = "SUCCESS";
    public static final String RULE_NOT_CHECKED = "NOT_CHECKED";
    public static final String RULE_DISABLED = "DISABLED";
    public static final String COMPUTATION_EXECUTED = "EXECUTED";
    public static final String COMPUTATION_NOT_EXECUTED = "NOT_EXECUTED";
    public static final String COMPUTATION_DISABLED = "COMPUTATION_DISABLED";
    public static final String RULE_COUNTER_EXAMPLE_VARIABLE_SUFFIX = "_Counterexamples";
    public static final String RULE_SUCCESSFUL_VARIABLE_SUFFIX = "_Successful";
    public static final String RULE_UNCHECKED_VARIABLE_SUFFIX = "_Unchecked";
    private static final String ALL_TUPLE = "$AllTuple";
    private static final String RESULT_TUPLE = "$ResultTuple";
    private final IDefinitions iDefinitions;
    private final Start start;
    private final RulesMachineChecker rulesMachineChecker;
    private final ArrayList<CheckException> errorList = new ArrayList();
    private final ArrayList<String> ruleNames = new ArrayList();
    private final ArrayList<TIdentifierLiteral> ruleOperationLiteralList = new ArrayList();
    private final ArrayList<TIdentifierLiteral> computationLiteralList = new ArrayList();
    private final List<AIdentifierExpression> variablesList = new ArrayList<AIdentifierExpression>();
    private final List<PPredicate> invariantList = new ArrayList<PPredicate>();
    private final List<PSubstitution> initialisationList = new ArrayList<PSubstitution>();
    private RuleOperation currentRule;
    private TIdentifierLiteral currentComputationIdentifier;
    private final Map<String, AbstractOperation> allOperations;
    private int nestedForLoopCount = 0;
    private int ruleBodyCount = 0;
    private final HashSet<String> operationsToBeDeleted = new HashSet();

    public RulesTransformation(Start start, BParser bParser, RulesMachineChecker rulesMachineChecker, Map<String, AbstractOperation> allOperations) {
        this.start = start;
        this.iDefinitions = bParser.getDefinitions();
        this.rulesMachineChecker = rulesMachineChecker;
        this.allOperations = allOperations;
        for (AbstractOperation operation : allOperations.values()) {
            if (null == operation.getReplacesIdentifier()) continue;
            AIdentifierExpression idExpr = operation.getReplacesIdentifier();
            String opName = Utils.getAIdentifierAsString(idExpr);
            this.operationsToBeDeleted.add(opName);
        }
    }

    public void runTransformation() throws BCompoundException {
        this.start.apply(this);
        DefinitionInjector.injectDefinitions(this.start, this.iDefinitions);
        MissingPositionsAdder.injectPositions(this.start);
        if (!this.errorList.isEmpty()) {
            File machineFile = this.rulesMachineChecker.getFile();
            String machineFilePath = machineFile == null ? null : machineFile.getPath();
            ArrayList<BException> list = new ArrayList<BException>();
            for (CheckException checkException : this.errorList) {
                list.add(new BException(machineFilePath, checkException));
            }
            throw new BCompoundException(list);
        }
    }

    public List<AbstractOperation> getOperations() {
        return this.rulesMachineChecker.getOperations();
    }

    public List<String> getComputations() {
        ArrayList<String> list = new ArrayList<String>();
        for (TIdentifierLiteral literal : this.computationLiteralList) {
            list.add(literal.getText());
        }
        return list;
    }

    @Override
    public void outStart(Start node) {
        ClauseFinder finder = new ClauseFinder();
        node.apply(finder);
        if (!this.variablesList.isEmpty()) {
            AInitialisationMachineClause initialisationMachineClause;
            AInvariantMachineClause invariantMachineClause;
            AVariablesMachineClause variablesMachineClause;
            AAbstractMachineParseUnit abstractMachineParseUnit = finder.abstractMachineParseUnit;
            if (finder.variablesMachineClause == null) {
                variablesMachineClause = new AVariablesMachineClause();
                abstractMachineParseUnit.getMachineClauses().add(0, variablesMachineClause);
                invariantMachineClause = new AInvariantMachineClause();
                abstractMachineParseUnit.getMachineClauses().add(1, invariantMachineClause);
                initialisationMachineClause = new AInitialisationMachineClause();
                abstractMachineParseUnit.getMachineClauses().add(2, initialisationMachineClause);
            } else {
                variablesMachineClause = finder.variablesMachineClause;
                invariantMachineClause = finder.invariantMachineClause;
                initialisationMachineClause = finder.initialisationMachineClause;
            }
            ArrayList<PPredicate> invariantPredicateList = new ArrayList<PPredicate>();
            if (invariantMachineClause.getPredicates() != null) {
                invariantPredicateList.add(invariantMachineClause.getPredicates());
            }
            ArrayList<PSubstitution> initSubstitutionList = new ArrayList<PSubstitution>();
            if (initialisationMachineClause.getSubstitutions() != null) {
                initSubstitutionList.add(initialisationMachineClause.getSubstitutions());
            }
            invariantPredicateList.addAll(this.invariantList);
            initSubstitutionList.addAll(this.initialisationList);
            variablesMachineClause.getIdentifiers().addAll(this.variablesList);
            PPredicate conjunction = ASTBuilder.createConjunction(invariantPredicateList);
            invariantMachineClause.setPredicates(conjunction);
            if (initSubstitutionList.size() == 1) {
                initialisationMachineClause.setSubstitutions((PSubstitution)initSubstitutionList.get(0));
            } else {
                ASequenceSubstitution seqSubstitution = new ASequenceSubstitution(this.initialisationList);
                initialisationMachineClause.setSubstitutions(seqSubstitution);
            }
        }
    }

    @Override
    public void caseAComputationOperation(AComputationOperation node) {
        if (this.operationsToBeDeleted.contains(node.getName().getText())) {
            node.replaceBy(null);
        } else {
            ComputationOperation computationOperation = this.rulesMachineChecker.getComputationOperation(node);
            this.currentComputationIdentifier = computationOperation.replacesOperation() ? computationOperation.getReplacesIdentifier().getIdentifier().getFirst() : computationOperation.getNameLiteral();
            super.caseAComputationOperation(node);
        }
    }

    public List<PPredicate> getOperationDependenciesAsPredicateList(AbstractOperation operation) {
        ArrayList<PPredicate> result = new ArrayList<PPredicate>();
        for (AbstractOperation op : operation.getRequiredDependencies()) {
            if (op instanceof RuleOperation) {
                result.add(ASTBuilder.createEqualPredicate(op.getNameLiteral(), RULE_SUCCESS));
                continue;
            }
            if (!(op instanceof ComputationOperation)) continue;
            result.add(ASTBuilder.createEqualPredicate(op.getNameLiteral(), COMPUTATION_EXECUTED));
        }
        return result;
    }

    @Override
    public void outAComputationOperation(AComputationOperation node) {
        AIdentifierExpression nameIdentifier;
        ComputationOperation compOperation = this.rulesMachineChecker.getComputationOperation(node);
        this.computationLiteralList.add(node.getName());
        if (this.operationsToBeDeleted.contains(node.getName().getText())) {
            node.replaceBy(null);
            return;
        }
        AOperation operation = new AOperation();
        ArrayList<TIdentifierLiteral> operationNameList = new ArrayList<TIdentifierLiteral>();
        if (null != compOperation.getReplacesIdentifier()) {
            TIdentifierLiteral first = compOperation.getReplacesIdentifier().getIdentifier().getFirst();
            operationNameList.add(first.clone());
            nameIdentifier = compOperation.getReplacesIdentifier().clone();
        } else {
            operationNameList.add(node.getName().clone());
            nameIdentifier = new AIdentifierExpression(operationNameList).clone();
        }
        operation.setOpName(operationNameList);
        AEqualPredicate grd1 = new AEqualPredicate(nameIdentifier.clone(), ASTBuilder.createStringExpression(COMPUTATION_NOT_EXECUTED));
        ASelectSubstitution select = new ASelectSubstitution();
        ArrayList<PPredicate> selectConditionList = new ArrayList<PPredicate>();
        selectConditionList.add(grd1);
        selectConditionList.addAll(this.getOperationDependenciesAsPredicateList(compOperation));
        select.setCondition(ASTBuilder.createConjunction(selectConditionList));
        ArrayList<PExpression> varList = new ArrayList<PExpression>();
        ArrayList<PExpression> exprList = new ArrayList<PExpression>();
        varList.add(nameIdentifier.clone());
        exprList.add(new AStringExpression(new TStringLiteral(COMPUTATION_EXECUTED)));
        AAssignSubstitution assign = new AAssignSubstitution(varList, exprList);
        select.setThen(new ASequenceSubstitution(ASTBuilder.createSubstitutionList(node.getBody(), assign)));
        operation.setOperationBody(select);
        node.replaceBy(operation);
        this.variablesList.add(nameIdentifier.clone());
        ASetExtensionExpression set = new ASetExtensionExpression(Stream.of(COMPUTATION_EXECUTED, COMPUTATION_NOT_EXECUTED, COMPUTATION_DISABLED).map(ASTBuilder::createStringExpression).collect(Collectors.toList()));
        AMemberPredicate member = new AMemberPredicate(nameIdentifier.clone(), set);
        this.invariantList.add(member);
        PExpression value = compOperation.getActivationPredicate() != null ? new AIfThenElseExpression(compOperation.getActivationPredicate().clone(), ASTBuilder.createStringExpression(COMPUTATION_NOT_EXECUTED), new LinkedList<PExpression>(), ASTBuilder.createStringExpression(COMPUTATION_DISABLED)) : ASTBuilder.createStringExpression(COMPUTATION_NOT_EXECUTED);
        AAssignSubstitution initSub = new AAssignSubstitution(ASTBuilder.createExpressionList(nameIdentifier.clone()), ASTBuilder.createExpressionList(value));
        this.initialisationList.add(initSub);
    }

    @Override
    public void caseARuleOperation(ARuleOperation node) {
        if (this.operationsToBeDeleted.contains(this.rulesMachineChecker.getRuleOperation(node).getOriginalName())) {
            node.replaceBy(null);
        } else {
            super.caseARuleOperation(node);
        }
    }

    @Override
    public void inARuleOperation(ARuleOperation node) {
        this.currentRule = this.rulesMachineChecker.getRuleOperation(node);
        this.ruleBodyCount = 0;
    }

    @Override
    public void outARuleOperation(ARuleOperation node) {
        String ruleName = this.currentRule.getOriginalName();
        this.currentRule.getReplacesIdentifier();
        this.ruleOperationLiteralList.add(node.getRuleName());
        this.ruleNames.add(ruleName);
        ArrayList<PPredicate> selectConditionList = new ArrayList<PPredicate>();
        selectConditionList.add(new AEqualPredicate(ASTBuilder.createIdentifier(ruleName), new AStringExpression(new TStringLiteral(RULE_NOT_CHECKED))));
        ASelectSubstitution select = new ASelectSubstitution();
        selectConditionList.addAll(this.getOperationDependenciesAsPredicateList(this.currentRule));
        select.setCondition(ASTBuilder.createConjunction(selectConditionList));
        ArrayList<PSubstitution> subList = new ArrayList<PSubstitution>();
        subList.add(this.createRuleSuccessAssignment(this.currentRule.getNameLiteral()));
        subList.add(node.getRuleBody());
        String ctName = ruleName + RULE_COUNTER_EXAMPLE_VARIABLE_SUFFIX;
        this.currentRule.setCounterExampleVariableName(ctName);
        String sfName = ruleName + RULE_SUCCESSFUL_VARIABLE_SUFFIX;
        this.currentRule.setSuccessfulVariableName(sfName);
        String ucName = ruleName + RULE_UNCHECKED_VARIABLE_SUFFIX;
        this.currentRule.setUncheckedVariableName(ucName);
        ASequenceSubstitution seq = new ASequenceSubstitution(subList);
        select.setThen(seq);
        StringWriter sw = new StringWriter();
        PrologTermOutput pout = new PrologTermOutput(sw, false);
        pout.openTerm("rules_info").openList();
        if (!this.currentRule.getTags().isEmpty()) {
            pout.openTerm("tags").openList();
            this.currentRule.getTags().forEach(pout::printAtom);
            pout.closeList().closeTerm();
        }
        if (this.currentRule.getClassification() != null) {
            pout.openTerm("classification").printAtom(this.currentRule.getClassification()).closeTerm();
        }
        if (this.currentRule.getRuleIdString() != null) {
            pout.openTerm("rule_id").printAtom(this.currentRule.getRuleIdString()).closeTerm();
        }
        pout.closeList().closeTerm().fullstop();
        node.replaceBy(new ADescriptionOperation(new ADescriptionPragma(Collections.singletonList(new TPragmaFreeText(((Object)sw).toString()))), new AOperation(new LinkedList<PExpression>(), Collections.singletonList(node.getRuleName().clone()), new LinkedList<PExpression>(), select)));
        this.variablesList.add(ASTBuilder.createIdentifier(node.getRuleName()));
        ASetExtensionExpression set = new ASetExtensionExpression(Stream.of(RULE_FAIL, RULE_SUCCESS, RULE_NOT_CHECKED, RULE_DISABLED).map(ASTBuilder::createStringExpression).collect(Collectors.toList()));
        AMemberPredicate member = ASTBuilder.createPositionedNode(new AMemberPredicate(ASTBuilder.createIdentifier(node.getRuleName()), set), node);
        this.invariantList.add(member);
        PExpression value = this.currentRule.getActivationPredicate() != null ? new AIfThenElseExpression(this.currentRule.getActivationPredicate().clone(), ASTBuilder.createStringExpression(RULE_NOT_CHECKED), new LinkedList<PExpression>(), ASTBuilder.createStringExpression(RULE_DISABLED)) : ASTBuilder.createStringExpression(RULE_NOT_CHECKED);
        AAssignSubstitution initSub = new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(node.getRuleName())), ASTBuilder.createExpressionList(value));
        this.initialisationList.add(initSub);
        this.variablesList.add(ASTBuilder.createIdentifier(ctName, node.getRuleName().clone()));
        this.variablesList.add(ASTBuilder.createIdentifier(sfName, node.getRuleName().clone()));
        this.variablesList.add(ASTBuilder.createIdentifier(ucName, node.getRuleName().clone()));
        AMemberPredicate ctTypingPredicate = new AMemberPredicate(ASTBuilder.createIdentifier(ctName), new APowSubsetExpression(new AMultOrCartExpression(new ANatural1SetExpression(), new AStringSetExpression())));
        this.invariantList.add(ASTBuilder.createPositionedNode(ctTypingPredicate, node));
        AMemberPredicate sfTypingPredicate = new AMemberPredicate(ASTBuilder.createIdentifier(sfName), new APowSubsetExpression(new AMultOrCartExpression(new ANatural1SetExpression(), new AStringSetExpression())));
        this.invariantList.add(ASTBuilder.createPositionedNode(sfTypingPredicate, node));
        AMemberPredicate ucTypingPredicate = new AMemberPredicate(ASTBuilder.createIdentifier(ucName), new APowSubsetExpression(new AMultOrCartExpression(new ANatural1SetExpression(), new AStringSetExpression())));
        this.invariantList.add(ASTBuilder.createPositionedNode(ucTypingPredicate, node));
        this.initialisationList.add(ASTBuilder.createAssignNode(ASTBuilder.createIdentifier(ctName, node.getRuleName().clone()), new AEmptySetExpression()));
        this.initialisationList.add(ASTBuilder.createAssignNode(ASTBuilder.createIdentifier(sfName, node.getRuleName().clone()), new AEmptySetExpression()));
        this.initialisationList.add(ASTBuilder.createAssignNode(ASTBuilder.createIdentifier(ucName, node.getRuleName().clone()), new AEmptySetExpression()));
    }

    @Override
    public void outAOperatorExpression(AOperatorExpression node) {
        String operatorName = node.getName().getText();
        LinkedList<PExpression> parameters = node.getIdentifiers();
        switch (operatorName) {
            case "STRING_FORMAT": {
                this.translateStringFormatOperator(node, parameters);
                return;
            }
            case "GET_RULE_COUNTEREXAMPLES": {
                this.translateGetRuleCounterExamplesOperator(node);
                return;
            }
        }
        throw new AssertionError((Object)("Unsupported operator " + operatorName));
    }

    private void translateGetRuleCounterExamplesOperator(AOperatorExpression node) {
        PExpression pExpression = node.getIdentifiers().get(0);
        AIdentifierExpression id = (AIdentifierExpression)pExpression;
        String ruleName = id.getIdentifier().get(0).getText();
        AbstractOperation operation = this.allOperations.get(ruleName);
        if (!(operation instanceof RuleOperation)) {
            this.errorList.add(new CheckException(String.format("'%s' does not match any rule visible to this machine.", ruleName), node));
            return;
        }
        RuleOperation rule = (RuleOperation)operation;
        String name = ruleName + RULE_COUNTER_EXAMPLE_VARIABLE_SUFFIX;
        if (node.getIdentifiers().size() == 1) {
            AIdentifierExpression ctVariable = ASTBuilder.createIdentifier(name, pExpression);
            ARangeExpression range = ASTBuilder.createPositionedNode(new ARangeExpression(ctVariable), node);
            node.replaceBy(range);
        } else {
            PExpression funcCall = this.getSetOfErrorMessagesByErrorType(name, node.getIdentifiers().get(1), rule.getNumberOfErrorTypes());
            node.replaceBy(funcCall);
        }
    }

    private void translateStringFormatOperator(AOperatorExpression node, LinkedList<PExpression> parameters) {
        ASTBuilder.addFormatToStringDefinition(this.iDefinitions);
        ASTBuilder.addToStringDefinition(this.iDefinitions);
        ArrayList<PExpression> seqList = new ArrayList<PExpression>();
        for (int i = 1; i < parameters.size(); ++i) {
            PExpression param = parameters.get(i);
            seqList.add(ASTBuilder.createPositionedNode(ASTBuilder.callExternalFunction("TO_STRING", param), param));
        }
        node.replaceBy(ASTBuilder.createPositionedNode(ASTBuilder.callExternalFunction("FORMAT_TO_STRING", parameters.get(0), new ASequenceExtensionExpression(seqList)), node));
    }

    private AAssignSubstitution createRuleSuccessAssignment(TIdentifierLiteral ruleLiteral) {
        return this.createRuleAssignment(ruleLiteral, RULE_SUCCESS);
    }

    private AAssignSubstitution createRuleFailAssignment(TIdentifierLiteral ruleLiteral) {
        return this.createRuleAssignment(ruleLiteral, RULE_FAIL);
    }

    private AAssignSubstitution createRuleAssignment(TIdentifierLiteral ruleLiteral, String ruleStatus) {
        return ASTBuilder.createAssignNode(ASTBuilder.createIdentifier(ruleLiteral), ASTBuilder.createStringExpression(ruleStatus));
    }

    private PSubstitution createConditionalFailAssignment() {
        ANotEqualPredicate ifCondition = new ANotEqualPredicate(ASTBuilder.createIdentifier(RESULT_TUPLE), new AEmptySetExpression());
        return new AIfSubstitution(ifCondition, this.createRuleFailAssignment(this.currentRule.getNameLiteral()), new ArrayList<PSubstitution>(), null);
    }

    @Override
    public void outADefineSubstitution(ADefineSubstitution node) {
        PExpression value;
        this.variablesList.add(ASTBuilder.createIdentifier(node.getName().getText(), node.getName()));
        if (node.getDummyValue() != null) {
            this.initialisationList.add(ASTBuilder.createAssignNode(ASTBuilder.createIdentifier(node.getName()), node.getDummyValue()));
        } else {
            this.initialisationList.add(ASTBuilder.createAssignNode(ASTBuilder.createIdentifier(node.getName()), new AEmptySetExpression()));
        }
        if (node.getValue() instanceof ASymbolicLambdaExpression || node.getValue() instanceof ASymbolicComprehensionSetExpression || node.getValue() instanceof ASymbolicEventBComprehensionSetExpression || node.getValue() instanceof ASymbolicQuantifiedUnionExpression) {
            value = node.getValue();
        } else {
            ASTBuilder.addForceDefinition(this.iDefinitions);
            value = ASTBuilder.createPositionedNode(ASTBuilder.callExternalFunction("FORCE", node.getValue()), node.getValue());
        }
        if (node.getType() != null) {
            TIdentifierLiteral computationIdentifierLiteral = this.currentComputationIdentifier.clone();
            AEqualPredicate compExecuted = new AEqualPredicate(ASTBuilder.createIdentifier(computationIdentifierLiteral), ASTBuilder.createStringExpression(COMPUTATION_EXECUTED));
            AMemberPredicate member = new AMemberPredicate(ASTBuilder.createIdentifier(node.getName()), node.getType());
            this.invariantList.add(new AImplicationPredicate(compExecuted, member));
        } else {
            this.invariantList.add(new ADisjunctPredicate(new ATruthPredicate(), new AEqualPredicate(ASTBuilder.createIdentifier(node.getName()), value.clone())));
        }
        node.replaceBy(ASTBuilder.createAssignNode(ASTBuilder.createIdentifier(node.getName()), value));
    }

    private PSubstitution createCounterExampleSubstitution(int errorIndex, PExpression setOfCounterexamples, boolean conditionalFail) {
        String ctName = this.currentRule.getOriginalName() + RULE_COUNTER_EXAMPLE_VARIABLE_SUFFIX;
        AUnionExpression union = new AUnionExpression(ASTBuilder.createIdentifier(ctName), ASTBuilder.createPositionedNode(new AMultOrCartExpression(new ASetExtensionExpression(ASTBuilder.createExpressionList(new AIntegerExpression(new TIntegerLiteral(Integer.toString(errorIndex))))), setOfCounterexamples.clone()), setOfCounterexamples));
        AAssignSubstitution assign = new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(ctName)), ASTBuilder.createExpressionList(union));
        if (conditionalFail) {
            return ASTBuilder.createSequenceSubstitution(assign, this.createConditionalFailAssignment(), new PSubstitution[0]);
        }
        return ASTBuilder.createSequenceSubstitution(assign, this.createRuleFailAssignment(this.currentRule.getNameLiteral()), new PSubstitution[0]);
    }

    private PSubstitution createSuccessfulSubstitution(PExpression setOfSuccessMessages) {
        String sfName = this.currentRule.getOriginalName() + RULE_SUCCESSFUL_VARIABLE_SUFFIX;
        AUnionExpression union = new AUnionExpression(ASTBuilder.createIdentifier(sfName), ASTBuilder.createPositionedNode(new AMultOrCartExpression(new ASetExtensionExpression(ASTBuilder.createExpressionList(ASTBuilder.createIntegerExpression(this.ruleBodyCount))), setOfSuccessMessages.clone()), setOfSuccessMessages));
        AAssignSubstitution assign = new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(sfName)), ASTBuilder.createExpressionList(union));
        return new ASequenceSubstitution(Collections.singletonList(assign));
    }

    private PSubstitution createUncheckedSubstitution(PExpression uncheckedMessage) {
        String ucName = this.currentRule.getOriginalName() + RULE_UNCHECKED_VARIABLE_SUFFIX;
        AUnionExpression union = new AUnionExpression(ASTBuilder.createIdentifier(ucName), ASTBuilder.createPositionedNode(new ASetExtensionExpression(Collections.singletonList(new ACoupleExpression(Arrays.asList(ASTBuilder.createIntegerExpression(this.ruleBodyCount), uncheckedMessage.clone())))), uncheckedMessage));
        AAssignSubstitution assign = new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(ucName)), ASTBuilder.createExpressionList(union));
        return new ASequenceSubstitution(Collections.singletonList(assign));
    }

    @Override
    public void outAFunctionOperation(AFunctionOperation node) {
        FunctionOperation func = this.rulesMachineChecker.getFunctionOperation(node);
        ArrayList<PPredicate> preConditionList = new ArrayList<PPredicate>();
        if (func.getPreconditionPredicate() != null) {
            preConditionList.add(func.getPreconditionPredicate());
        }
        preConditionList.addAll(this.getOperationDependenciesAsPredicateList(func));
        PSubstitution body = node.getBody();
        if (null != func.getPostconditionPredicate()) {
            body = ASTBuilder.createSequenceSubstitution(body, new AAssertionSubstitution(func.getPostconditionPredicate(), new ASkipSubstitution()), new PSubstitution[0]);
        }
        if (!preConditionList.isEmpty()) {
            body = new APreconditionSubstitution(ASTBuilder.createConjunction(preConditionList), body);
        }
        node.replaceBy(new AOperation(new LinkedList<PExpression>(node.getReturnValues()), Collections.singletonList(node.getName()), new LinkedList<PExpression>(node.getParameters()), body));
    }

    private PExpression getSetOfErrorMessagesByErrorType(String name, PExpression errorTypeNode, int numberOfErrorTypes) {
        String LAMBDA_IDENTIFIER = "$x";
        ALambdaExpression lambda = new ALambdaExpression(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier("$x")), new AMemberPredicate(ASTBuilder.createIdentifier("$x"), new AIntervalExpression(ASTBuilder.createIntegerExpression(1), ASTBuilder.createIntegerExpression(numberOfErrorTypes))), new AImageExpression(ASTBuilder.createIdentifier(name), ASTBuilder.createSetOfPExpression(ASTBuilder.createIdentifier("$x"))));
        return new AFunctionExpression(lambda, ASTBuilder.createExpressionList(errorTypeNode));
    }

    @Override
    public void outAOperatorPredicate(AOperatorPredicate node) {
        ArrayList<PExpression> arguments = new ArrayList<PExpression>(node.getIdentifiers());
        String operatorName = node.getName().getText();
        AIdentifierExpression ruleIdentifier = (AIdentifierExpression)arguments.get(0);
        String ruleName = ruleIdentifier.getIdentifier().get(0).getText();
        AbstractOperation operation = this.allOperations.get(ruleName);
        if (!(operation instanceof RuleOperation)) {
            this.errorList.add(new CheckException(String.format("'%s' does not match any rule visible to this machine.", ruleName), node));
            return;
        }
        RuleOperation rule = (RuleOperation)operation;
        switch (operatorName) {
            case "SUCCEEDED_RULE": {
                this.replacePredicateOperator(node, arguments, RULE_SUCCESS);
                return;
            }
            case "SUCCEEDED_RULE_ERROR_TYPE": {
                this.replaceSucceededRuleErrorTypeOperator(node, ruleName, rule);
                return;
            }
            case "FAILED_RULE": {
                this.replacePredicateOperator(node, arguments, RULE_FAIL);
                return;
            }
            case "FAILED_RULE_ALL_ERROR_TYPES": {
                this.replaceFailedRuleAllErrorTypesOperator(node, rule);
                return;
            }
            case "FAILED_RULE_ERROR_TYPE": {
                this.replaceFailedRuleErrorTypeOperator(node, rule);
                return;
            }
            case "NOT_CHECKED_RULE": {
                this.replacePredicateOperator(node, arguments, RULE_NOT_CHECKED);
                return;
            }
            case "DISABLED_RULE": {
                this.replacePredicateOperator(node, arguments, RULE_DISABLED);
                return;
            }
        }
        throw new AssertionError((Object)("should not happen: " + operatorName));
    }

    private void replaceSucceededRuleErrorTypeOperator(AOperatorPredicate node, String ruleName, RuleOperation rule) {
        String name = ruleName + RULE_COUNTER_EXAMPLE_VARIABLE_SUFFIX;
        PExpression funcCall = this.getSetOfErrorMessagesByErrorType(name, node.getIdentifiers().get(1), rule.getNumberOfErrorTypes());
        node.replaceBy(new AEqualPredicate(funcCall, new AEmptySetExpression()));
    }

    private void replaceFailedRuleAllErrorTypesOperator(AOperatorPredicate node, RuleOperation rule) {
        String name = rule.getOriginalName() + RULE_COUNTER_EXAMPLE_VARIABLE_SUFFIX;
        AEqualPredicate equal = new AEqualPredicate(new ADomainExpression(ASTBuilder.createIdentifier(name)), new AIntervalExpression(ASTBuilder.createIntegerExpression(1), ASTBuilder.createIntegerExpression(rule.getNumberOfErrorTypes())));
        node.replaceBy(equal);
    }

    private void replaceFailedRuleErrorTypeOperator(AOperatorPredicate node, RuleOperation rule) {
        PExpression pExpression = node.getIdentifiers().get(0);
        AIdentifierExpression id = (AIdentifierExpression)pExpression;
        String name = id.getIdentifier().get(0).getText() + RULE_COUNTER_EXAMPLE_VARIABLE_SUFFIX;
        PExpression funcCall = this.getSetOfErrorMessagesByErrorType(name, node.getIdentifiers().get(1), rule.getNumberOfErrorTypes());
        node.replaceBy(new ANotEqualPredicate(funcCall, new AEmptySetExpression()));
    }

    private void replacePredicateOperator(AOperatorPredicate node, List<PExpression> copy, String stringValue) {
        ArrayList<PPredicate> predList = new ArrayList<PPredicate>();
        for (PExpression e : copy) {
            predList.add(ASTBuilder.createPositionedNode(new AEqualPredicate(e, ASTBuilder.createStringExpression(stringValue)), e));
        }
        node.replaceBy(ASTBuilder.createConjunction(predList));
    }

    @Override
    public void inAForLoopSubstitution(AForLoopSubstitution node) {
        ++this.nestedForLoopCount;
    }

    @Override
    public void outAForLoopSubstitution(AForLoopSubstitution node) {
        PExpression element;
        PSubstitution assignSub;
        --this.nestedForLoopCount;
        String localSetVariableName = "$SET" + this.nestedForLoopCount;
        String localLoopCounter = "$c" + this.nestedForLoopCount;
        AAssignSubstitution assignSetVariable = new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(localSetVariableName, node.getSet())), ASTBuilder.createExpressionList(node.getSet().clone()));
        AAssignSubstitution assignCVariable = new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(localLoopCounter)), ASTBuilder.createExpressionList(new ACardExpression(ASTBuilder.createIdentifier(localSetVariableName, node.getSet()))));
        AWhileSubstitution whileSub = ASTBuilder.createPositionedNode(new AWhileSubstitution(), node);
        ArrayList<PSubstitution> subList = new ArrayList<PSubstitution>();
        subList.add(assignSetVariable);
        subList.add(assignCVariable);
        subList.add(whileSub);
        AVarSubstitution varSub = ASTBuilder.createPositionedNode(new AVarSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(localSetVariableName, node.getSet()), ASTBuilder.createIdentifier(localLoopCounter)), new ASequenceSubstitution(subList)), node);
        ANotEqualPredicate whileCon = new ANotEqualPredicate(ASTBuilder.createIdentifier(localSetVariableName, node.getSet()), new AEmptySetExpression());
        whileSub.setCondition(whileCon);
        whileSub.setInvariant(new ATruthPredicate());
        whileSub.setVariant(ASTBuilder.createIdentifier(localLoopCounter));
        AVarSubstitution varSub2 = new AVarSubstitution();
        whileSub.setDoSubst(varSub2);
        ArrayList<PExpression> varIdList = new ArrayList<PExpression>();
        for (PExpression pExpression : node.getIdentifiers()) {
            varIdList.add(pExpression.clone());
        }
        varSub2.setIdentifiers(varIdList);
        ASTBuilder.addChooseDefinition(this.iDefinitions);
        ADefinitionExpression chooseCall = ASTBuilder.callExternalFunction("CHOOSE", ASTBuilder.createIdentifier(localSetVariableName, node.getSet()));
        if (varIdList.size() >= 2) {
            ArrayList<PExpression> assignIdList = new ArrayList<PExpression>();
            for (PExpression pExpression : node.getIdentifiers()) {
                assignIdList.add(pExpression.clone());
            }
            assignSub = new ABecomesElementOfSubstitution(assignIdList, new ASetExtensionExpression(ASTBuilder.createExpressionList(chooseCall)));
        } else {
            assignSub = new AAssignSubstitution(ASTBuilder.createExpressionList(node.getIdentifiers().get(0).clone()), ASTBuilder.createExpressionList(chooseCall));
        }
        if (varIdList.size() >= 2) {
            ArrayList<PExpression> ids = new ArrayList<PExpression>();
            for (PExpression pExpression : node.getIdentifiers()) {
                ids.add(pExpression.clone());
            }
            element = ASTBuilder.createNestedCouple(ids);
        } else {
            element = node.getIdentifiers().get(0).clone();
        }
        AMinusOrSetSubtractExpression rhs = new AMinusOrSetSubtractExpression(ASTBuilder.createIdentifier(localSetVariableName, node.getSet()), new ASetExtensionExpression(ASTBuilder.createExpressionList(element)));
        AAssignSubstitution aAssignSubstitution = new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(localSetVariableName, node.getSet()), ASTBuilder.createIdentifier(localLoopCounter)), ASTBuilder.createExpressionList(rhs, new AMinusOrSetSubtractExpression(ASTBuilder.createIdentifier(localLoopCounter), ASTBuilder.createIntegerExpression(1))));
        varSub2.setSubstitution(new ASequenceSubstitution(Arrays.asList(assignSub, node.getDoSubst(), aAssignSubstitution)));
        node.replaceBy(varSub);
    }

    @Override
    public void outARuleFailSubSubstitution(ARuleFailSubSubstitution node) {
        Node newNode;
        ++this.ruleBodyCount;
        ASTBuilder.addForceDefinition(this.iDefinitions);
        if (!node.getIdentifiers().isEmpty()) {
            newNode = ASTBuilder.createPositionedNode(this.createCounterExampleSubstitutions(node.getIdentifiers(), node.getWhen(), null, null, node.getMessage(), null, node.getErrorType()), node);
        } else {
            int errorType = node.getErrorType() != null ? Integer.parseInt(node.getErrorType().getText()) : 1;
            PSubstitution sub = this.createCounterExampleSubstitution(errorType, ASTBuilder.createSetOfPExpression(node.getMessage(), (PositionedNode)node.getMessage()), false);
            newNode = node.getWhen() != null ? new AIfSubstitution(node.getWhen(), sub, new ArrayList<PSubstitution>(), null) : sub;
        }
        node.replaceBy(newNode);
    }

    public PSubstitution createCounterExampleSubstitutions(List<PExpression> identifiers, PPredicate wherePredicate, PPredicate expectPredicate, PExpression onSuccessMessage, PExpression counterExampleMessage, PExpression uncheckedMessage, TIntegerLiteral errorTypeNode) {
        ArrayList<PExpression> list2;
        ArrayList<PExpression> list;
        String ON_SUCCESS_STRINGS = "$OnSuccessStrings";
        String COUNTEREXAMPLE_STRINGS = "$CounterexampleStrings";
        String UNCHECKED_STRING = "$UncheckedString";
        AComprehensionSetExpression setWithoutExpect = new AComprehensionSetExpression();
        ArrayList<PExpression> list3 = new ArrayList<PExpression>();
        for (PExpression id : identifiers) {
            list3.add(id.clone());
        }
        setWithoutExpect.setIdentifiers(list3);
        setWithoutExpect.setPredicates(wherePredicate.clone());
        ASTBuilder.addToStringDefinition(this.iDefinitions);
        int errorType = errorTypeNode != null ? Integer.parseInt(errorTypeNode.getText()) : 1;
        AVarSubstitution var = new AVarSubstitution();
        List<PExpression> varIdentifiers = ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(RESULT_TUPLE), ASTBuilder.createIdentifier("$CounterexampleStrings"));
        if (expectPredicate != null) {
            varIdentifiers.add(ASTBuilder.createIdentifier(ALL_TUPLE));
        }
        if (onSuccessMessage != null) {
            varIdentifiers.add(ASTBuilder.createIdentifier("$OnSuccessStrings"));
        }
        if (uncheckedMessage != null) {
            varIdentifiers.add(ASTBuilder.createIdentifier("$UncheckedString"));
        }
        var.setIdentifiers(varIdentifiers);
        ArrayList<PSubstitution> subList = new ArrayList<PSubstitution>();
        AAssignSubstitution assign = new AAssignSubstitution();
        assign.setLhsExpression(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(expectPredicate != null ? ALL_TUPLE : RESULT_TUPLE)));
        assign.setRhsExpressions(ASTBuilder.createExpressionList(setWithoutExpect));
        subList.add(assign);
        if (expectPredicate != null) {
            AComprehensionSetExpression setWithExpect = new AComprehensionSetExpression();
            ArrayList<PExpression> list4 = new ArrayList<PExpression>();
            ArrayList list22 = new ArrayList();
            for (PExpression id : identifiers) {
                list4.add(id.clone());
                list22.add(id.clone());
            }
            setWithExpect.setIdentifiers(list4);
            setWithExpect.setPredicates(new AConjunctPredicate(new AMemberPredicate(list22.size() > 1 ? new ACoupleExpression(list22) : (PExpression)list22.get(0), ASTBuilder.createIdentifier(ALL_TUPLE)), new ANegationPredicate(expectPredicate.clone())));
            AAssignSubstitution assign2 = new AAssignSubstitution();
            assign2.setLhsExpression(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier(RESULT_TUPLE)));
            assign2.setRhsExpressions(ASTBuilder.createExpressionList(setWithExpect));
            subList.add(assign2);
        }
        if (onSuccessMessage != null) {
            list = new ArrayList<PExpression>();
            list2 = new ArrayList<PExpression>();
            for (PExpression id : identifiers) {
                list.add(id.clone());
                list2.add(id.clone());
            }
            AMemberPredicate member = new AMemberPredicate(list.size() > 1 ? new ACoupleExpression(list) : (PExpression)list.get(0), new AMinusOrSetSubtractExpression(ASTBuilder.createIdentifier(ALL_TUPLE), ASTBuilder.createIdentifier(RESULT_TUPLE)));
            subList.add(new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier("$OnSuccessStrings")), ASTBuilder.createExpressionList(new AEventBComprehensionSetExpression(list2, onSuccessMessage, member))));
        }
        if (uncheckedMessage != null) {
            subList.add(new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier("$UncheckedString")), ASTBuilder.createExpressionList(uncheckedMessage)));
        }
        list = new ArrayList();
        list2 = new ArrayList();
        for (PExpression id : identifiers) {
            list.add(id.clone());
            list2.add(id.clone());
        }
        PExpression couple = list.size() > 1 ? new ACoupleExpression(list) : (PExpression)list.get(0);
        AMemberPredicate member = new AMemberPredicate(couple, ASTBuilder.createIdentifier(RESULT_TUPLE));
        subList.add(new AAssignSubstitution(ASTBuilder.createExpressionList(ASTBuilder.createIdentifier("$CounterexampleStrings")), ASTBuilder.createExpressionList(new AEventBComprehensionSetExpression(list2, counterExampleMessage, member))));
        PSubstitution counterExampleSubstitution = this.createCounterExampleSubstitution(errorType, ASTBuilder.createIdentifier("$CounterexampleStrings"), true);
        subList.add(counterExampleSubstitution);
        if (onSuccessMessage != null) {
            PSubstitution successfulSubstitution = this.createSuccessfulSubstitution(ASTBuilder.createIdentifier("$OnSuccessStrings"));
            subList.add(successfulSubstitution);
        }
        if (uncheckedMessage != null) {
            AEqualPredicate ifUnchecked = new AEqualPredicate(ASTBuilder.createIdentifier(ALL_TUPLE), new AEmptySetExpression());
            AIfSubstitution uncheckedSubstitution = new AIfSubstitution(ifUnchecked, this.createUncheckedSubstitution(uncheckedMessage), new ArrayList<PSubstitution>(), null);
            subList.add(uncheckedSubstitution);
        }
        ASequenceSubstitution seqSub = new ASequenceSubstitution(subList);
        var.setSubstitution(seqSub);
        return var;
    }

    @Override
    public void outAForallSubMessageSubstitution(AForallSubMessageSubstitution node) {
        ++this.ruleBodyCount;
        ASTBuilder.addForceDefinition(this.iDefinitions);
        PSubstitution newNode = ASTBuilder.createPositionedNode(this.createCounterExampleSubstitutions(node.getIdentifiers(), node.getWhere(), node.getExpect(), node.getOnSuccess(), node.getMessage(), node.getUnchecked(), node.getErrorType()), node);
        node.replaceBy(newNode);
    }

    static class ClauseFinder
    extends DepthFirstAdapter {
        AAbstractMachineParseUnit abstractMachineParseUnit = null;
        AVariablesMachineClause variablesMachineClause = null;
        AInvariantMachineClause invariantMachineClause = null;
        AInitialisationMachineClause initialisationMachineClause = null;

        ClauseFinder() {
        }

        @Override
        public void inAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
            this.abstractMachineParseUnit = node;
        }

        @Override
        public void inAVariablesMachineClause(AVariablesMachineClause node) {
            this.variablesMachineClause = node;
        }

        @Override
        public void inAInvariantMachineClause(AInvariantMachineClause node) {
            this.invariantMachineClause = node;
        }

        @Override
        public void inAInitialisationMachineClause(AInitialisationMachineClause node) {
            this.initialisationMachineClause = node;
        }
    }
}

