/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.analysis.MachineClauseAdapter;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.analysis.prolog.MachineType;
import de.be4.classicalb.core.parser.analysis.prolog.PackageName;
import de.be4.classicalb.core.parser.analysis.prolog.ReferenceType;
import de.be4.classicalb.core.parser.analysis.prolog.ReferencedMachines;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.exceptions.VisitorException;
import de.be4.classicalb.core.parser.exceptions.VisitorIOException;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.ADefinitionFileParseUnit;
import de.be4.classicalb.core.parser.node.AExtendsMachineClause;
import de.be4.classicalb.core.parser.node.AFileMachineReference;
import de.be4.classicalb.core.parser.node.AFileMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.AImportPackage;
import de.be4.classicalb.core.parser.node.AImportsMachineClause;
import de.be4.classicalb.core.parser.node.AIncludesMachineClause;
import de.be4.classicalb.core.parser.node.AMachineHeader;
import de.be4.classicalb.core.parser.node.AMachineReference;
import de.be4.classicalb.core.parser.node.AMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.APackageParseUnit;
import de.be4.classicalb.core.parser.node.AReferencesMachineClause;
import de.be4.classicalb.core.parser.node.ARefinementMachineParseUnit;
import de.be4.classicalb.core.parser.node.ASeesMachineClause;
import de.be4.classicalb.core.parser.node.AUsesMachineClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PImportPackage;
import de.be4.classicalb.core.parser.node.PMachineClause;
import de.be4.classicalb.core.parser.node.PMachineReference;
import de.be4.classicalb.core.parser.node.PMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TPragmaIdOrString;
import de.be4.classicalb.core.parser.util.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class MachineReferencesFinder
extends MachineClauseAdapter {
    private final Path machineFile;
    private final boolean machineNameMustMatchFileName;
    private String machineName;
    private MachineType machineType;
    private PackageName packageName;
    private Path rootDirectory;
    private final Map<PackageName, Path> importedPackages;
    private final List<MachineReference> references;

    private MachineReferencesFinder(Path machineFile, boolean machineNameMustMatchFileName) {
        this.machineFile = machineFile;
        this.machineNameMustMatchFileName = machineNameMustMatchFileName;
        this.importedPackages = new LinkedHashMap<PackageName, Path>();
        this.references = new ArrayList<MachineReference>();
    }

    public static ReferencedMachines findReferencedMachines(Path machineFile, Node node, boolean machineNameMustMatchFileName) throws BException {
        MachineReferencesFinder referenceFinder = new MachineReferencesFinder(machineFile, machineNameMustMatchFileName);
        String fileName = machineFile.toAbsolutePath().toString();
        try {
            node.apply(referenceFinder);
        }
        catch (VisitorException e) {
            throw new BException(fileName, e.getException());
        }
        catch (VisitorIOException e) {
            throw new BException(fileName, e.getException());
        }
        if (referenceFinder.machineName == null) {
            throw new BException(fileName, "Could not determine the machine's name. Parse unit class: " + node.getClass(), null);
        }
        if (referenceFinder.machineType == null) {
            throw new BException(fileName, "Could not determine the machine's type. Parse unit class: " + node.getClass(), null);
        }
        return new ReferencedMachines(referenceFinder.machineName, referenceFinder.machineType, referenceFinder.references, referenceFinder.packageName, referenceFinder.rootDirectory, referenceFinder.importedPackages);
    }

    @Override
    public void caseAMachineHeader(AMachineHeader node) {
        if (node.getName().isEmpty()) {
            throw new VisitorException(new CheckException("Machine name cannot be empty", node));
        }
        if (node.getName().size() > 1) {
            throw new VisitorException(new CheckException("Machine name cannot contain dots", node.getName().get(1)));
        }
        this.machineName = Utils.getTIdentifierListAsString(node.getName());
        String fileNameWithoutExtension = Utils.getFileWithoutExtension(this.machineFile.getFileName().toString());
        if (this.machineNameMustMatchFileName && !this.machineName.equals(fileNameWithoutExtension)) {
            CheckException ch = new CheckException(String.format("Machine name does not match the file name: '%s' vs '%s'", this.machineName, fileNameWithoutExtension), node);
            throw new VisitorException(ch);
        }
    }

    @Override
    public void caseAPackageParseUnit(APackageParseUnit node) {
        this.determineRootDirectory(node.getPackage(), node);
        ArrayList<PImportPackage> copy = new ArrayList<PImportPackage>(node.getImports());
        for (PImportPackage e : copy) {
            e.apply(this);
        }
        node.getParseUnit().apply(this);
        node.replaceBy(node.getParseUnit());
    }

    @Override
    public void caseAImportPackage(AImportPackage node) {
        PackageName importedPackage = MachineReferencesFinder.getPackageName(node.getPackage(), node);
        Path path = importedPackage.getPath(this.rootDirectory);
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new VisitorException(new CheckException(String.format("Imported package is not a directory: %s", path), node));
            }
        } else {
            throw new VisitorException(new CheckException(String.format("Imported package does not exist: %s", path), node));
        }
        if (this.importedPackages.containsKey(importedPackage)) {
            throw new VisitorException(new CheckException(String.format("Duplicate import statement: %s", node.getPackage().getText()), node));
        }
        this.importedPackages.put(importedPackage, path);
    }

    private void determineRootDirectory(TPragmaIdOrString packageTerminal, Node node) {
        Path packageDir;
        this.packageName = MachineReferencesFinder.getPackageName(packageTerminal, node);
        try {
            packageDir = this.machineFile.toRealPath(new LinkOption[0]).getParent();
        }
        catch (IOException e) {
            throw new VisitorIOException(e);
        }
        try {
            this.rootDirectory = this.packageName.determineRootDirectory(packageDir);
        }
        catch (IllegalArgumentException e) {
            throw new VisitorException(new CheckException(e.getMessage(), node, (Throwable)e));
        }
    }

    private static PackageName getPackageName(TPragmaIdOrString packageTerminal, Node node) {
        try {
            return PackageName.fromPossiblyQuotedName(packageTerminal.getText());
        }
        catch (IllegalArgumentException e) {
            throw new VisitorException(new CheckException(e.getMessage(), node, (Throwable)e));
        }
    }

    private static MachineReference makeMachineReference(ReferenceType type, LinkedList<TIdentifierLiteral> ids, Node node, String path) {
        String renamedName;
        String name;
        if (ids.size() == 1) {
            name = ids.get(0).getText();
            renamedName = null;
        } else if (ids.size() == 2) {
            name = ids.get(1).getText();
            renamedName = ids.get(0).getText();
        } else {
            throw new VisitorException(new CheckException("A machine reference cannot contain more than one dot in the machine identifier", ids.get(2)));
        }
        if (path != null) {
            Path parsedPath = Paths.get(path, new String[0]);
            if (!parsedPath.isAbsolute() && path.contains("\\")) {
                throw new VisitorException(new CheckException("Relative path in file pragma uses backslashes. This is incompatible with non-Windows systems. Please use forward slashes instead.", node));
            }
            String baseName = Utils.getFileWithoutExtension(parsedPath.getFileName().toString());
            if (!baseName.equals(name)) {
                throw new VisitorException(new CheckException("Declared name in file pragma does not match the machine referenced: " + name + " vs. " + baseName + " in " + path, node));
            }
        }
        return new MachineReference(type, name, renamedName, node, path);
    }

    private void addMachineReference(ReferenceType type, PMachineReference node) {
        if (node instanceof AFileMachineReference) {
            AFileMachineReference fileNode = (AFileMachineReference)node;
            AMachineReference refNode = (AMachineReference)fileNode.getReference();
            String file = fileNode.getFile().getText();
            if (Utils.isQuoted(file, '\"')) {
                file = Utils.removeSurroundingQuotes(file, '\"');
            }
            this.references.add(MachineReferencesFinder.makeMachineReference(type, refNode.getMachineName(), refNode, file));
        } else if (node instanceof AMachineReference) {
            AMachineReference refNode = (AMachineReference)node;
            this.references.add(MachineReferencesFinder.makeMachineReference(type, refNode.getMachineName(), refNode, null));
        } else {
            throw new AssertionError((Object)("Unhandled machine reference type: " + node.getClass()));
        }
    }

    private void addMachineReferences(ReferenceType type, List<? extends PMachineReference> references) {
        references.forEach(ref -> this.addMachineReference(type, (PMachineReference)ref));
    }

    @Override
    public void caseAIncludesMachineClause(AIncludesMachineClause node) {
        this.addMachineReferences(ReferenceType.INCLUDES, node.getMachineReferences());
    }

    @Override
    public void caseAExtendsMachineClause(AExtendsMachineClause node) {
        this.addMachineReferences(ReferenceType.EXTENDS, node.getMachineReferences());
    }

    @Override
    public void caseAImportsMachineClause(AImportsMachineClause node) {
        this.addMachineReferences(ReferenceType.IMPORTS, node.getMachineReferences());
    }

    @Override
    public void caseAReferencesMachineClause(AReferencesMachineClause node) {
        this.addMachineReferences(ReferenceType.REFERENCES, node.getMachineReferences());
    }

    private void addMachineReferenceNoParams(ReferenceType type, PMachineReferenceNoParams node) {
        if (node instanceof AFileMachineReferenceNoParams) {
            AFileMachineReferenceNoParams fileNode = (AFileMachineReferenceNoParams)node;
            AMachineReferenceNoParams refNode = (AMachineReferenceNoParams)fileNode.getReference();
            String file = fileNode.getFile().getText();
            if (Utils.isQuoted(file, '\"')) {
                file = Utils.removeSurroundingQuotes(file, '\"');
            }
            this.references.add(MachineReferencesFinder.makeMachineReference(type, refNode.getMachineName(), refNode, file));
        } else if (node instanceof AMachineReferenceNoParams) {
            AMachineReferenceNoParams refNode = (AMachineReferenceNoParams)node;
            this.references.add(MachineReferencesFinder.makeMachineReference(type, refNode.getMachineName(), refNode, null));
        } else {
            throw new AssertionError((Object)("Unhandled machine reference type: " + node.getClass()));
        }
    }

    private void addMachineReferencesNoParams(ReferenceType type, List<? extends PMachineReferenceNoParams> references) {
        references.forEach(ref -> this.addMachineReferenceNoParams(type, (PMachineReferenceNoParams)ref));
    }

    @Override
    public void caseASeesMachineClause(ASeesMachineClause node) {
        this.addMachineReferencesNoParams(ReferenceType.SEES, node.getMachineNames());
    }

    @Override
    public void caseAUsesMachineClause(AUsesMachineClause node) {
        this.addMachineReferencesNoParams(ReferenceType.USES, node.getMachineNames());
    }

    @Override
    public void caseAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        this.machineType = MachineType.ABSTRACT_MACHINE;
        node.getHeader().apply(this);
        for (PMachineClause mclause : node.getMachineClauses()) {
            mclause.apply(this);
        }
    }

    @Override
    public void caseARefinementMachineParseUnit(ARefinementMachineParseUnit node) {
        this.machineType = MachineType.REFINEMENT;
        node.getHeader().apply(this);
        String name = node.getRefMachine().getText();
        this.references.add(new MachineReference(ReferenceType.REFINES, name, null, node.getRefMachine()));
        for (Node node2 : node.getMachineClauses()) {
            node2.apply(this);
        }
    }

    @Override
    public void caseAImplementationMachineParseUnit(AImplementationMachineParseUnit node) {
        this.machineType = MachineType.IMPLEMENTATION;
        node.getHeader().apply(this);
        String name = node.getRefMachine().getText();
        this.references.add(new MachineReference(ReferenceType.REFINES, name, null, node.getRefMachine()));
        for (Node node2 : node.getMachineClauses()) {
            node2.apply(this);
        }
    }

    @Override
    public void caseADefinitionFileParseUnit(ADefinitionFileParseUnit node) {
        this.machineName = Utils.getFileWithoutExtension(this.machineFile.getFileName().toString());
        this.machineType = MachineType.DEFINITION_FILE;
    }
}

