/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import de.be4.classicalb.core.preparser.lexer.Lexer;
import de.be4.classicalb.core.preparser.lexer.LexerException;
import de.be4.classicalb.core.preparser.node.EOF;
import de.be4.classicalb.core.preparser.node.TBeginNesting;
import de.be4.classicalb.core.preparser.node.TComment;
import de.be4.classicalb.core.preparser.node.TCommentEnd;
import de.be4.classicalb.core.preparser.node.TEndNesting;
import de.be4.classicalb.core.preparser.node.TLeftPar;
import de.be4.classicalb.core.preparser.node.TMultilineStringEnd;
import de.be4.classicalb.core.preparser.node.TMultilineStringStart;
import de.be4.classicalb.core.preparser.node.TMultilineTemplateEnd;
import de.be4.classicalb.core.preparser.node.TMultilineTemplateStart;
import de.be4.classicalb.core.preparser.node.TOtherClauseBegin;
import de.be4.classicalb.core.preparser.node.TRhsBody;
import de.be4.classicalb.core.preparser.node.TRightPar;
import de.be4.classicalb.core.preparser.node.TSemicolon;
import de.be4.classicalb.core.preparser.node.Token;
import java.io.IOException;
import java.io.PushbackReader;

public class PreLexer
extends Lexer {
    private TRhsBody rhsToken = null;
    private StringBuilder rhsBuffer = null;
    private int otherNestingLevel = 0;
    private int parenNestingLevel = 0;
    private Lexer.State previousState;

    public PreLexer(PushbackReader in) {
        super(in);
    }

    public void setPosition(int line, int column) {
        this.line = line - 1;
        this.pos = column - 1;
    }

    @Override
    protected Token getToken() throws IOException, LexerException {
        try {
            return super.getToken();
        }
        catch (LexerException e) {
            String msg = e.getRealMsg();
            if (this.state.equals((Object)Lexer.State.DEFINITIONS) && msg.length() > 3) {
                String last = msg.substring(msg.length() - 3).trim();
                if (last.equals("=")) {
                    throw new LexerException(e.getLine(), e.getPos(), msg + " in DEFINITIONS clause (use == to define a DEFINITION)", e);
                }
                throw new LexerException(e.getLine(), e.getPos(), msg + " in DEFINITIONS clause", e);
            }
            throw e;
        }
    }

    @Override
    protected void filter() throws LexerException, IOException {
        this.checkComment();
        this.checkMultiLineString();
        if (this.token != null) {
            this.collectRhs();
        }
    }

    private void printState() {
        System.out.println((Object)this.state);
        if (this.token != null) {
            System.out.println("Token = " + this.token + " at line = " + this.token.getLine() + ", col = " + this.token.getPos());
        }
    }

    private void collectRhs() throws LexerException, IOException {
        if (this.state.equals((Object)Lexer.State.DEFINITIONS_RHS) || this.previousState != null && this.previousState.equals((Object)Lexer.State.DEFINITIONS_RHS)) {
            if (this.rhsToken == null) {
                this.rhsToken = new TRhsBody("", -1, -1);
                this.rhsBuffer = new StringBuilder();
            } else {
                Lexer.State nextState = this.getNextState();
                if (nextState != null) {
                    try {
                        this.unread(this.token);
                    }
                    catch (IOException e) {
                        throw new IOException("Pushback buffer overflow on Token: " + this.token.getText(), e);
                    }
                    this.rhsToken.setText(this.rhsBuffer.toString());
                    this.token = this.rhsToken;
                    this.rhsToken = null;
                    this.rhsBuffer = null;
                    this.state = nextState;
                } else {
                    if (this.rhsToken.getLine() == -1) {
                        this.rhsToken.setLine(this.token.getLine());
                        this.rhsToken.setPos(this.token.getPos());
                    }
                    this.rhsBuffer.append(this.token.getText());
                    this.token = null;
                }
            }
        }
    }

    private Lexer.State getNextState() {
        if (this.otherNestingLevel == 0 && this.token instanceof TOtherClauseBegin || this.token instanceof EOF) {
            return Lexer.State.NORMAL;
        }
        if (this.token instanceof TLeftPar) {
            ++this.parenNestingLevel;
        } else if (this.token instanceof TRightPar) {
            --this.parenNestingLevel;
        } else if (this.token instanceof TBeginNesting) {
            ++this.otherNestingLevel;
        } else if (this.token instanceof TEndNesting) {
            --this.otherNestingLevel;
        }
        if (this.otherNestingLevel == 0 && this.parenNestingLevel == 0 && this.token instanceof TSemicolon) {
            return Lexer.State.DEFINITIONS;
        }
        if (this.otherNestingLevel < 0) {
            this.otherNestingLevel = 0;
            return Lexer.State.NORMAL;
        }
        return null;
    }

    private void checkComment() {
        if (this.token instanceof TComment) {
            this.previousState = this.state;
            this.state = Lexer.State.BLOCK_COMMENT;
        } else if (this.token instanceof TCommentEnd) {
            this.state = this.previousState;
            this.previousState = null;
        }
    }

    private void checkMultiLineString() throws LexerException {
        if (this.token instanceof TMultilineStringStart) {
            this.previousState = this.state;
            this.state = Lexer.State.MULTILINE_STRING;
        } else if (this.token instanceof TMultilineTemplateStart) {
            this.previousState = this.state;
            this.state = Lexer.State.MULTILINE_TEMPLATE;
        } else if (this.token instanceof TMultilineStringEnd || this.token instanceof TMultilineTemplateEnd) {
            if (this.previousState == null) {
                throw new LexerException("Encountered multiline string end token without corresponding start token");
            }
            this.state = this.previousState;
            this.previousState = null;
        }
    }
}

