/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.prolog.INodeIds;
import de.be4.classicalb.core.parser.exceptions.PreParseException;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.hhu.stups.sablecc.patch.SourcePosition;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Definitions
extends IDefinitions {
    private final Map<String, PDefinition> definitionsMap = new HashMap<String, PDefinition>();
    private final Map<String, IDefinitions.Type> types = new HashMap<String, IDefinitions.Type>();
    private final List<IDefinitions> referencedDefinitions = new ArrayList<IDefinitions>();
    private final File file;

    public Definitions() {
        this.file = null;
    }

    public Definitions(File file) {
        this.file = file;
    }

    @Override
    public Map<String, IDefinitions.Type> getTypes() {
        HashMap<String, IDefinitions.Type> map = new HashMap<String, IDefinitions.Type>(this.types);
        for (IDefinitions definitions : this.referencedDefinitions) {
            map.putAll(definitions.getTypes());
        }
        return map;
    }

    @Override
    public int getParameterCount(String defName) {
        PDefinition defNode = this.getDefinition(defName);
        return Definitions.getParameterCount(defNode);
    }

    private static int getParameterCount(PDefinition defNode) {
        if (defNode instanceof APredicateDefinitionDefinition) {
            return ((APredicateDefinitionDefinition)defNode).getParameters().size();
        }
        if (defNode instanceof ASubstitutionDefinitionDefinition) {
            return ((ASubstitutionDefinitionDefinition)defNode).getParameters().size();
        }
        if (defNode instanceof AExpressionDefinitionDefinition) {
            return ((AExpressionDefinitionDefinition)defNode).getParameters().size();
        }
        throw new AssertionError((Object)("Unhandled definition node type: " + defNode.getClass()));
    }

    @Override
    public IDefinitions.Type getType(String defName) {
        if (this.types.containsKey(defName)) {
            return this.types.get(defName);
        }
        for (IDefinitions definitions : this.referencedDefinitions) {
            IDefinitions.Type type = definitions.getType(defName);
            if (type == IDefinitions.Type.NoDefinition) continue;
            return type;
        }
        return IDefinitions.Type.NoDefinition;
    }

    @Override
    public Set<String> getDefinitionNames() {
        HashSet<String> resultSet = new HashSet<String>(this.definitionsMap.keySet());
        for (IDefinitions iDefinitions : this.referencedDefinitions) {
            resultSet.addAll(iDefinitions.getDefinitionNames());
        }
        return resultSet;
    }

    @Override
    public PDefinition getDefinition(String defName) {
        if (this.definitionsMap.containsKey(defName)) {
            return this.definitionsMap.get(defName);
        }
        for (IDefinitions iDefinitions : this.referencedDefinitions) {
            if (!iDefinitions.containsDefinition(defName)) continue;
            return iDefinitions.getDefinition(defName);
        }
        throw new NoSuchElementException(Definitions.getErrorMessageDefinitionDoesNotExist(defName));
    }

    private static String getErrorMessageDefinitionDoesNotExist(String defName) {
        return String.format("Definition %s does not exist.", defName);
    }

    @Override
    public File getFile(String defName) {
        if (this.definitionsMap.containsKey(defName)) {
            return this.file;
        }
        for (IDefinitions iDefinitions : this.referencedDefinitions) {
            if (!iDefinitions.containsDefinition(defName)) continue;
            return iDefinitions.getFile(defName);
        }
        throw new NoSuchElementException(Definitions.getErrorMessageDefinitionDoesNotExist(defName));
    }

    @Override
    public boolean containsDefinition(String defName) {
        if (this.definitionsMap.containsKey(defName)) {
            return true;
        }
        for (IDefinitions iDefinitions : this.referencedDefinitions) {
            if (!iDefinitions.containsDefinition(defName)) continue;
            iDefinitions.getDefinition(defName);
            return true;
        }
        return false;
    }

    @Override
    public void replaceDefinition(String defName, IDefinitions.Type type, PDefinition node) {
        if (this.types.containsKey(defName)) {
            this.types.put(defName, type);
            this.definitionsMap.put(defName, node);
            return;
        }
        for (IDefinitions iDefinitions : this.referencedDefinitions) {
            if (!iDefinitions.containsDefinition(defName)) continue;
            iDefinitions.replaceDefinition(defName, type, node);
            return;
        }
        throw new NoSuchElementException(Definitions.getErrorMessageDefinitionDoesNotExist(defName));
    }

    @Override
    public void addDefinitions(IDefinitions defs) throws PreParseException {
        for (String def : defs.getDefinitionNames()) {
            if (!this.containsDefinition(def) || this.getFile(def) == defs.getFile(def)) continue;
            SourcePosition posfile1 = this.getDefinition(def).getStartPos();
            SourcePosition posfile2 = defs.getDefinition(def).getStartPos();
            throw new PreParseException("Duplicate definition: " + def + ".\n(First appearance at Line: " + posfile1.getLine() + ", Column: " + posfile1.getPos() + " in file: " + this.getFile(def) + " And redefinition at Line: " + posfile2.getLine() + ", Column: " + posfile2.getPos() + " in file: " + defs.getFile(def) + ")");
        }
        this.referencedDefinitions.add(defs);
    }

    @Override
    public void addDefinition(PDefinition defNode, IDefinitions.Type type, String defName) {
        if (this.containsDefinition(defName)) {
            throw new IllegalArgumentException("Duplicate definition: " + defName);
        }
        this.definitionsMap.put(defName, defNode);
        this.types.put(defName, type);
    }

    public String toString() {
        return this.definitionsMap.keySet().toString();
    }

    @Override
    public void assignIdsToNodes(INodeIds nodeIdMapping, List<File> machineFilesLoaded) {
        if (this.file != null) {
            if (!machineFilesLoaded.contains(this.file)) {
                machineFilesLoaded.add(this.file);
            }
            int fileNumber = machineFilesLoaded.indexOf(this.file) + 1;
            for (PDefinition def : this.definitionsMap.values()) {
                nodeIdMapping.assignIdentifiers(fileNumber, def);
            }
        }
        for (IDefinitions defintions : this.referencedDefinitions) {
            defintions.assignIdsToNodes(nodeIdMapping, machineFilesLoaded);
        }
    }
}

