/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import de.be4.classicalb.core.parser.DefinitionTypes;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.ParseOptions;
import de.be4.classicalb.core.parser.exceptions.BLexerException;
import de.be4.classicalb.core.parser.lexer.Lexer;
import de.be4.classicalb.core.parser.lexer.LexerException;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.TAbstractConstants;
import de.be4.classicalb.core.parser.node.TAbstractVariables;
import de.be4.classicalb.core.parser.node.TAny;
import de.be4.classicalb.core.parser.node.TAssertions;
import de.be4.classicalb.core.parser.node.TBegin;
import de.be4.classicalb.core.parser.node.TBoolCast;
import de.be4.classicalb.core.parser.node.TCard;
import de.be4.classicalb.core.parser.node.TChoice;
import de.be4.classicalb.core.parser.node.TClosure;
import de.be4.classicalb.core.parser.node.TClosure1;
import de.be4.classicalb.core.parser.node.TComma;
import de.be4.classicalb.core.parser.node.TComment;
import de.be4.classicalb.core.parser.node.TCommentBody;
import de.be4.classicalb.core.parser.node.TCommentEnd;
import de.be4.classicalb.core.parser.node.TConc;
import de.be4.classicalb.core.parser.node.TConcatSequence;
import de.be4.classicalb.core.parser.node.TConcreteConstants;
import de.be4.classicalb.core.parser.node.TConcreteVariables;
import de.be4.classicalb.core.parser.node.TConjunction;
import de.be4.classicalb.core.parser.node.TConstants;
import de.be4.classicalb.core.parser.node.TConstraints;
import de.be4.classicalb.core.parser.node.TConvertIntCeiling;
import de.be4.classicalb.core.parser.node.TConvertIntFloor;
import de.be4.classicalb.core.parser.node.TConvertReal;
import de.be4.classicalb.core.parser.node.TDefLiteralPredicate;
import de.be4.classicalb.core.parser.node.TDefLiteralSubstitution;
import de.be4.classicalb.core.parser.node.TDivision;
import de.be4.classicalb.core.parser.node.TDom;
import de.be4.classicalb.core.parser.node.TDomainRestriction;
import de.be4.classicalb.core.parser.node.TDomainSubtraction;
import de.be4.classicalb.core.parser.node.TDoubleVerticalBar;
import de.be4.classicalb.core.parser.node.TElementOf;
import de.be4.classicalb.core.parser.node.TElse;
import de.be4.classicalb.core.parser.node.TElsif;
import de.be4.classicalb.core.parser.node.TEnd;
import de.be4.classicalb.core.parser.node.TEqual;
import de.be4.classicalb.core.parser.node.TEquivalence;
import de.be4.classicalb.core.parser.node.TFirst;
import de.be4.classicalb.core.parser.node.TFnc;
import de.be4.classicalb.core.parser.node.TFront;
import de.be4.classicalb.core.parser.node.TGreater;
import de.be4.classicalb.core.parser.node.TGreaterEqual;
import de.be4.classicalb.core.parser.node.THexLiteral;
import de.be4.classicalb.core.parser.node.TId;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TIf;
import de.be4.classicalb.core.parser.node.TIllegalUnicodeSymbol;
import de.be4.classicalb.core.parser.node.TImplies;
import de.be4.classicalb.core.parser.node.TInclusion;
import de.be4.classicalb.core.parser.node.TInitialisation;
import de.be4.classicalb.core.parser.node.TIntegerLiteral;
import de.be4.classicalb.core.parser.node.TIntersection;
import de.be4.classicalb.core.parser.node.TInterval;
import de.be4.classicalb.core.parser.node.TInvariant;
import de.be4.classicalb.core.parser.node.TIterate;
import de.be4.classicalb.core.parser.node.TLast;
import de.be4.classicalb.core.parser.node.TLeftBrace;
import de.be4.classicalb.core.parser.node.TLeftBracket;
import de.be4.classicalb.core.parser.node.TLeftPar;
import de.be4.classicalb.core.parser.node.TLess;
import de.be4.classicalb.core.parser.node.TLessEqual;
import de.be4.classicalb.core.parser.node.TLineComment;
import de.be4.classicalb.core.parser.node.TLocalOperations;
import de.be4.classicalb.core.parser.node.TLogicalOr;
import de.be4.classicalb.core.parser.node.TMaplet;
import de.be4.classicalb.core.parser.node.TMax;
import de.be4.classicalb.core.parser.node.TMin;
import de.be4.classicalb.core.parser.node.TMod;
import de.be4.classicalb.core.parser.node.TNonInclusion;
import de.be4.classicalb.core.parser.node.TNotBelonging;
import de.be4.classicalb.core.parser.node.TNotEqual;
import de.be4.classicalb.core.parser.node.TOperations;
import de.be4.classicalb.core.parser.node.TOr;
import de.be4.classicalb.core.parser.node.TOverwriteRelation;
import de.be4.classicalb.core.parser.node.TPerm;
import de.be4.classicalb.core.parser.node.TPlus;
import de.be4.classicalb.core.parser.node.TPowerOf;
import de.be4.classicalb.core.parser.node.TPragmaDescription;
import de.be4.classicalb.core.parser.node.TPragmaEnd;
import de.be4.classicalb.core.parser.node.TPragmaFreeText;
import de.be4.classicalb.core.parser.node.TPragmaIdOrString;
import de.be4.classicalb.core.parser.node.TPragmaLabel;
import de.be4.classicalb.core.parser.node.TPragmaSymbolic;
import de.be4.classicalb.core.parser.node.TProduct;
import de.be4.classicalb.core.parser.node.TProperties;
import de.be4.classicalb.core.parser.node.TRan;
import de.be4.classicalb.core.parser.node.TRangeRestriction;
import de.be4.classicalb.core.parser.node.TRangeSubtraction;
import de.be4.classicalb.core.parser.node.TRealLiteral;
import de.be4.classicalb.core.parser.node.TRec;
import de.be4.classicalb.core.parser.node.TRel;
import de.be4.classicalb.core.parser.node.TRev;
import de.be4.classicalb.core.parser.node.TRightBrace;
import de.be4.classicalb.core.parser.node.TRightBracket;
import de.be4.classicalb.core.parser.node.TRightPar;
import de.be4.classicalb.core.parser.node.TSelect;
import de.be4.classicalb.core.parser.node.TSemicolon;
import de.be4.classicalb.core.parser.node.TSetSubtraction;
import de.be4.classicalb.core.parser.node.TShebang;
import de.be4.classicalb.core.parser.node.TSize;
import de.be4.classicalb.core.parser.node.TStar;
import de.be4.classicalb.core.parser.node.TStrictInclusion;
import de.be4.classicalb.core.parser.node.TStringLiteral;
import de.be4.classicalb.core.parser.node.TStruct;
import de.be4.classicalb.core.parser.node.TTail;
import de.be4.classicalb.core.parser.node.TThen;
import de.be4.classicalb.core.parser.node.TUnion;
import de.be4.classicalb.core.parser.node.TUnrecognisedPragma;
import de.be4.classicalb.core.parser.node.TVariables;
import de.be4.classicalb.core.parser.node.TWhere;
import de.be4.classicalb.core.parser.node.TWhiteSpace;
import de.be4.classicalb.core.parser.node.Token;
import de.be4.classicalb.core.parser.util.Utils;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BLexer
extends Lexer {
    public static final int PUSHBACK_BUFFER_SIZE = 99;
    private static final Collection<Class<? extends Token>> CLAUSE_TOKEN_CLASSES;
    private static final Collection<Class<? extends Token>> BIN_EXPR_OPERATORS;
    private static final Collection<Class<? extends Token>> FUNCTION_OPERATOR_KEYWORDS;
    private static final Collection<Class<? extends Token>> LITERAL_TOKEN_CLASSES;
    private static final Map<String, String> INVALID_UNICODE_SYMBOL_MESSAGES;
    private static final Map<Class<? extends Token>, Map<Class<? extends Token>, String>> invalid;
    private final DefinitionTypes definitions;
    private ParseOptions parseOptions = null;
    private Token lastToken;
    private Token currentBlockCommentStart;

    private static void addInvalid(Class<? extends Token> f, Class<? extends Token> s, String message) {
        Map<Class<? extends Token>, String> secs = invalid.get(f);
        if (secs == null) {
            secs = new HashMap<Class<? extends Token>, String>();
        }
        secs.put(s, message);
        invalid.put(f, secs);
    }

    public BLexer(PushbackReader in, DefinitionTypes definitions) {
        super(in);
        this.definitions = definitions;
    }

    public BLexer(PushbackReader in) {
        this(in, null);
    }

    public void setPosition(int line, int column) {
        this.line = line - 1;
        this.pos = column - 1;
    }

    private void findSyntaxError() throws LexerException {
        if (this.token == null || this.state.equals((Object)Lexer.State.BLOCK_COMMENT) || this.token instanceof TWhiteSpace || this.token instanceof TLineComment || this.token instanceof TComment || this.token instanceof TCommentBody || this.token instanceof TStar || this.token instanceof TCommentEnd || this.token instanceof TPragmaIdOrString || this.token instanceof TPragmaFreeText || this.token instanceof TPragmaEnd) {
            return;
        }
        if (this.token instanceof TIllegalUnicodeSymbol) {
            String symbol = this.token.getText();
            String defaultMessage = "Invalid Unicode symbol: '" + symbol + "'.";
            String specificMessage = INVALID_UNICODE_SYMBOL_MESSAGES.get(symbol);
            if (specificMessage != null) {
                throw new BLexerException(this.token, defaultMessage + " " + specificMessage);
            }
            throw new BLexerException(this.token, defaultMessage);
        }
        Class<?> tokenClass = this.token.getClass();
        if (this.lastToken != null) {
            Class<?> lastTokenClass = this.lastToken.getClass();
            if (this.parseOptions == null || !this.parseOptions.isIgnoreCheckingValidCombinations()) {
                this.checkForInvalidCombinations(lastTokenClass, tokenClass);
            }
        }
        this.lastToken = this.token;
    }

    private void checkForInvalidCombinations(Class<? extends Token> lastTokenClass, Class<? extends Token> tokenClass) throws LexerException {
        String string;
        Map<Class<? extends Token>, String> map = invalid.get(lastTokenClass);
        if (map != null && (string = map.get(tokenClass)) != null) {
            if (this.token instanceof EOF) {
                throw new BLexerException(this.token, "Invalid combination of symbols: '" + this.lastToken.getText().trim() + "' before the end of file. " + string);
            }
            throw new BLexerException(this.token, "Invalid combination of symbols: '" + this.lastToken.getText().trim() + "' and '" + this.token.getText().trim() + "'. " + string);
        }
    }

    private void applyGrammarExtension() {
        if (this.parseOptions != null && this.token != null && this.parseOptions.getGrammar().containsAlternativeDefinitionForToken(this.token)) {
            this.token = this.parseOptions.getGrammar().createNewToken(this.token);
        }
    }

    @Override
    protected void filter() throws LexerException, IOException {
        this.optimizeToken();
        if (this.parseOptions != null && this.parseOptions.isStrictPragmaChecking() && this.token instanceof TUnrecognisedPragma) {
            throw new BLexerException(this.token, "Pragma '" + this.token.getText() + "' not recognised; supported pragmas are label, desc, symbolic, generated, package, import-package, file.");
        }
        if (this.token instanceof TCommentEnd) {
            this.currentBlockCommentStart = null;
        } else {
            if (this.token instanceof TShebang && this.token.getLine() != 1) {
                throw new BLexerException(this.token, "#! only allowed in first line of the file", "#!", this.token.getLine(), this.token.getPos());
            }
            if (this.state.equals((Object)Lexer.State.NORMAL)) {
                this.applyGrammarExtension();
                this.findSyntaxError();
            } else if (this.state.equals((Object)Lexer.State.BLOCK_COMMENT)) {
                if (this.token instanceof TComment || this.token instanceof TUnrecognisedPragma) {
                    this.currentBlockCommentStart = this.token;
                } else if (this.token instanceof EOF) {
                    throw new BLexerException(this.currentBlockCommentStart, "Comment not closed.");
                }
            } else if (this.state.equals((Object)Lexer.State.PRAGMA_DESCRIPTION_CONTENT) || this.state.equals((Object)Lexer.State.PRAGMA_CONTENT)) {
                this.findSyntaxError();
            }
        }
        if (this.token != null && this.definitions != null) {
            this.replaceDefTokens();
        }
    }

    private void replaceDefTokens() throws LexerException {
        if (this.token instanceof TIdentifierLiteral) {
            String definitionName;
            try {
                definitionName = Utils.unquoteIdentifier(this.token.getText());
            }
            catch (IllegalArgumentException exc) {
                throw new BLexerException(this.token, (Throwable)exc);
            }
            IDefinitions.Type type = this.definitions.getType(definitionName);
            if (type != null) {
                switch (type) {
                    case Predicate: {
                        TDefLiteralPredicate predToken = new TDefLiteralPredicate(this.token.getText());
                        predToken.setLine(this.token.getLine());
                        predToken.setPos(this.token.getPos());
                        this.token = predToken;
                        break;
                    }
                    case Substitution: {
                        TDefLiteralSubstitution substToken = new TDefLiteralSubstitution(this.token.getText());
                        substToken.setLine(this.token.getLine());
                        substToken.setPos(this.token.getPos());
                        this.token = substToken;
                        break;
                    }
                }
            }
        }
    }

    private void optimizeToken() {
        if (this.token instanceof TIdentifierLiteral) {
            this.token.setText(this.token.getText().intern());
        }
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public void setParseOptions(ParseOptions parseOptions) {
        this.parseOptions = parseOptions;
    }

    static {
        String opName;
        CLAUSE_TOKEN_CLASSES = Collections.unmodifiableCollection(Arrays.asList(TAssertions.class, TConstants.class, TAbstractConstants.class, TConcreteConstants.class, TProperties.class, TConstraints.class, TVariables.class, TAbstractVariables.class, TConcreteVariables.class, TInvariant.class, TInitialisation.class, TLocalOperations.class, TOperations.class, EOF.class));
        BIN_EXPR_OPERATORS = Collections.unmodifiableCollection(Arrays.asList(TEqual.class, TNotEqual.class, TInclusion.class, TNonInclusion.class, TElementOf.class, TNotBelonging.class, TIntersection.class, TUnion.class, TSetSubtraction.class, TPlus.class, TDivision.class, TMod.class, TProduct.class, TPowerOf.class, TLessEqual.class, TGreaterEqual.class, TLess.class, TGreater.class, TOverwriteRelation.class, TInterval.class, TConcatSequence.class, TMaplet.class, TRangeRestriction.class, TRangeSubtraction.class, TDomainRestriction.class, TDomainSubtraction.class));
        FUNCTION_OPERATOR_KEYWORDS = Collections.unmodifiableCollection(Arrays.asList(TConvertIntFloor.class, TConvertIntCeiling.class, TConvertReal.class, TBoolCast.class, TCard.class, TIterate.class, TClosure.class, TClosure1.class, TRel.class, TFnc.class, TPerm.class, TMin.class, TMax.class, TDom.class, TRan.class, TId.class, TStruct.class, TRec.class, TSize.class, TFront.class, TFirst.class, TTail.class, TLast.class, TRev.class, TConc.class));
        LITERAL_TOKEN_CLASSES = Collections.unmodifiableCollection(Arrays.asList(TIntegerLiteral.class, TStringLiteral.class, TRealLiteral.class, THexLiteral.class));
        HashMap<String, String> invalidUnicodeSymbolMessages = new HashMap<String, String>();
        invalidUnicodeSymbolMessages.put("\u22c0", "N-ary conjunction not allowed, use '\u2200' instead - or did you mean '\u2227' for binary conjunction?");
        invalidUnicodeSymbolMessages.put("\u22c1", "N-ary disjunction not allowed, use '\u2203' instead - or did you mean '\u2228' for binary disjunction?");
        invalidUnicodeSymbolMessages.put("\u220a", "Small element-of not allowed, use '\u2208' instead");
        invalidUnicodeSymbolMessages.put("\u220d", "Small contains as member not allowed, reorder arguments and use '\u2208' instead");
        invalidUnicodeSymbolMessages.put("\u2204", "Not-exists not supported, use '\u00ac' and '\u2203' instead");
        invalidUnicodeSymbolMessages.put("\u22a2", "Operator not allowed, use implication '\u21d2' instead");
        invalidUnicodeSymbolMessages.put("\u22a7", "Operator not allowed, use implication '\u21d2' instead");
        invalidUnicodeSymbolMessages.put("\u22a6", "operator not allowed, use implication '\u21d2' instead");
        invalidUnicodeSymbolMessages.put("\u21d0", "Inverse implication not supported, reorder arguments and use implication '\u21d2' instead");
        invalidUnicodeSymbolMessages.put("\u27f8", "Inverse implication not supported, reorder arguments and use implication '\u21d2' instead");
        INVALID_UNICODE_SYMBOL_MESSAGES = Collections.unmodifiableMap(invalidUnicodeSymbolMessages);
        invalid = new HashMap<Class<? extends Token>, Map<Class<? extends Token>, String>>();
        BLexer.addInvalid(TSemicolon.class, TSemicolon.class, "Two succeeding semicolons are not allowed.");
        BLexer.addInvalid(TDoubleVerticalBar.class, TDoubleVerticalBar.class, "is not allowed (probably one || too many).");
        BLexer.addInvalid(TSetSubtraction.class, TEqual.class, "You need to use /= for inequality and not \\=.");
        BLexer.addInvalid(TSetSubtraction.class, TElementOf.class, "You need to use /: for not membership and not \\:.");
        BLexer.addInvalid(TSetSubtraction.class, TInclusion.class, "You need to use /<: for not subset and not \\<:.");
        BLexer.addInvalid(TSetSubtraction.class, TStrictInclusion.class, "You need to use /<<: for not strict subset and not \\<<:.");
        for (Class clazz : CLAUSE_TOKEN_CLASSES) {
            String string = clazz.getSimpleName().substring(1).toUpperCase();
            BLexer.addInvalid(TPragmaLabel.class, clazz, "A label pragma must be put before a predicate.");
            BLexer.addInvalid(clazz, TPragmaDescription.class, "A description pragma must be put after a predicate or identifier.");
            BLexer.addInvalid(TLeftPar.class, clazz, "Closing parenthesis is missing.");
            BLexer.addInvalid(TLeftBrace.class, clazz, "Closing brace is missing.");
            BLexer.addInvalid(TLeftBracket.class, clazz, "Closing bracket is missing.");
            BLexer.addInvalid(TBegin.class, clazz, "Closing END is missing.");
        }
        BLexer.addInvalid(TLeftPar.class, TEnd.class, "Closing parenthesis is missing.");
        BLexer.addInvalid(TLeftPar.class, TRightBrace.class, "Closing parenthesis is missing.");
        BLexer.addInvalid(TLeftPar.class, TRightBracket.class, "Closing parenthesis is missing.");
        BLexer.addInvalid(TLeftBrace.class, TEnd.class, "Closing brace is missing.");
        BLexer.addInvalid(TLeftBrace.class, TRightPar.class, "Closing brace is missing.");
        BLexer.addInvalid(TLeftBrace.class, TRightBracket.class, "Closing brace is missing.");
        BLexer.addInvalid(TLeftBracket.class, TEnd.class, "Closing bracket is missing.");
        BLexer.addInvalid(TLeftBracket.class, TRightPar.class, "Closing bracket is missing.");
        BLexer.addInvalid(TLeftBracket.class, TRightBrace.class, "Closing bracket is missing.");
        BLexer.addInvalid(TBegin.class, TRightPar.class, "Closing END is missing.");
        BLexer.addInvalid(TBegin.class, TRightBrace.class, "Closing END is missing.");
        BLexer.addInvalid(TBegin.class, TRightBracket.class, "Closing END is missing.");
        HashSet<Class<Token>> binOpTokenClasses = new HashSet<Class<Token>>();
        binOpTokenClasses.add(TConjunction.class);
        binOpTokenClasses.add(TLogicalOr.class);
        binOpTokenClasses.add(TImplies.class);
        binOpTokenClasses.add(TEquivalence.class);
        for (Class clazz : binOpTokenClasses) {
            opName = clazz.getSimpleName().substring(1).toUpperCase();
            BLexer.addInvalid(clazz, TPragmaDescription.class, "A description pragma must be put *after* a predicate, not *before* it.");
            BLexer.addInvalid(TPragmaLabel.class, clazz, "A label pragma must be put *before* a predicate, not *after* it.");
        }
        binOpTokenClasses.addAll(BIN_EXPR_OPERATORS);
        binOpTokenClasses.add(TComma.class);
        for (Class clazz : binOpTokenClasses) {
            opName = clazz.getSimpleName().substring(1).toUpperCase();
            for (Class clazz2 : binOpTokenClasses) {
                String string = clazz2.getSimpleName().substring(1).toUpperCase();
                BLexer.addInvalid(clazz, clazz2, "Invalid combination of binary operators.");
            }
            for (Class clazz3 : CLAUSE_TOKEN_CLASSES) {
                String string = clazz3.getSimpleName().substring(1).toUpperCase();
                BLexer.addInvalid(clazz, clazz3, "Argument to binary operator is missing.");
                BLexer.addInvalid(clazz3, clazz, "Argument to binary operator is missing.");
            }
            BLexer.addInvalid(clazz, TEnd.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(clazz, TElse.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(clazz, TElsif.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(clazz, TThen.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(clazz, TRightPar.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(clazz, TRightBrace.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(clazz, TRightBracket.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(clazz, TSemicolon.class, "Argument to binary operator is missing.");
            BLexer.addInvalid(TLeftPar.class, clazz, "Argument to binary operator is missing.");
            BLexer.addInvalid(TSemicolon.class, clazz, "Argument to binary operator is missing.");
            BLexer.addInvalid(TPragmaSymbolic.class, clazz, "A symbolic pragma must be put *before* a set comprehension or lambda.");
        }
        for (Class<? extends Token> clazz : BIN_EXPR_OPERATORS) {
            BLexer.addInvalid(TPragmaLabel.class, clazz, "A label pragma must be put *before* a predicate, not inside it.");
            BLexer.addInvalid(clazz, TPragmaLabel.class, "A label pragma must be put before a *predicate*, it cannot be put before expressions.");
            BLexer.addInvalid(clazz, TPragmaDescription.class, "A description pragma must be put after a predicate or identifier.");
            opName = clazz.getSimpleName().substring(1).toUpperCase();
            BLexer.addInvalid(clazz, TEnd.class, "Missing argument for binary operator " + opName + ".");
        }
        BLexer.addInvalid(TConjunction.class, TConjunction.class, "Probably one & too many.");
        BLexer.addInvalid(TLogicalOr.class, TLogicalOr.class, "Probably one 'or' too many.");
        BLexer.addInvalid(TLess.class, TGreater.class, "<> is not allowed anymore, use [] for the empty sequence.");
        for (Class<? extends Token> clazz : FUNCTION_OPERATOR_KEYWORDS) {
            BLexer.addInvalid(clazz, TPragmaDescription.class, "A description pragma must be put after a predicate or identifier, not a keyword.");
            opName = clazz.getSimpleName().substring(1).toLowerCase();
            if (clazz == TConvertIntFloor.class) {
                opName = "floor";
            } else if (clazz == TConvertIntCeiling.class) {
                opName = "ceiling";
            } else if (clazz == TConvertReal.class) {
                opName = "real";
            } else if (clazz == TBoolCast.class) {
                opName = "bool";
            }
            String message = "This keyword (" + opName + ") must be followed by an opening parenthesis.";
            BLexer.addInvalid(clazz, TRightPar.class, message);
            BLexer.addInvalid(clazz, TRightBrace.class, message);
            BLexer.addInvalid(clazz, TRightBracket.class, message);
            BLexer.addInvalid(clazz, TSemicolon.class, message);
            BLexer.addInvalid(clazz, TWhere.class, message);
            BLexer.addInvalid(clazz, TThen.class, message);
            BLexer.addInvalid(clazz, TElse.class, message);
            BLexer.addInvalid(clazz, TEnd.class, message);
            for (Class<? extends Token> clazz4 : BIN_EXPR_OPERATORS) {
                BLexer.addInvalid(clazz, clazz4, message);
            }
            for (Class<? extends Token> clazz5 : CLAUSE_TOKEN_CLASSES) {
                BLexer.addInvalid(clazz, clazz5, message);
            }
            String string = "This keyword (" + opName + ") cannot be used as an identifier";
            BLexer.addInvalid(TAny.class, clazz, string);
            BLexer.addInvalid(TConstants.class, clazz, string);
            BLexer.addInvalid(TAbstractConstants.class, clazz, string);
            BLexer.addInvalid(TConcreteConstants.class, clazz, string);
            BLexer.addInvalid(TVariables.class, clazz, string);
            BLexer.addInvalid(TAbstractVariables.class, clazz, string);
            BLexer.addInvalid(TConcreteVariables.class, clazz, string);
            BLexer.addInvalid(TOperations.class, clazz, string);
        }
        BLexer.addInvalid(TLeftPar.class, TRightPar.class, "Parentheses must contain arguments.");
        BLexer.addInvalid(TBegin.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TIf.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TIf.class, TThen.class, "Block must contain statements.");
        BLexer.addInvalid(TThen.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TThen.class, TElse.class, "Block must contain statements.");
        BLexer.addInvalid(TThen.class, TElsif.class, "Block must contain statements.");
        BLexer.addInvalid(TElsif.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TElsif.class, TElse.class, "Block must contain statements.");
        BLexer.addInvalid(TElsif.class, TElsif.class, "Block must contain statements.");
        BLexer.addInvalid(TElse.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TSelect.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TSelect.class, TThen.class, "Block must contain statements.");
        BLexer.addInvalid(TChoice.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TChoice.class, TOr.class, "Block must contain statements.");
        BLexer.addInvalid(TOr.class, TEnd.class, "Block must contain statements.");
        BLexer.addInvalid(TComma.class, TRightPar.class, "Missing expression after comma.");
        BLexer.addInvalid(TComma.class, TRightBrace.class, "Missing expression after comma.");
        BLexer.addInvalid(TComma.class, TRightBracket.class, "Missing expression after comma.");
        BLexer.addInvalid(TSemicolon.class, TRightPar.class, "Missing expression after semicolon.");
        BLexer.addInvalid(TSemicolon.class, TRightBrace.class, "Missing expression after semicolon.");
        BLexer.addInvalid(TSemicolon.class, TRightBracket.class, "Missing expression after semicolon.");
        BLexer.addInvalid(TComma.class, TPragmaDescription.class, "A description pragma must be put *after* a predicate or identifier.");
        BLexer.addInvalid(TSemicolon.class, TPragmaDescription.class, "A description pragma must be put *after* a predicate or identifier.");
        BLexer.addInvalid(TPragmaLabel.class, TComma.class, "A label pragma must be put *before* a predicate.");
        BLexer.addInvalid(TPragmaLabel.class, TSemicolon.class, "A label pragma must be put *before* a predicate.");
        for (Class<? extends Token> clazz : LITERAL_TOKEN_CLASSES) {
            BLexer.addInvalid(TIdentifierLiteral.class, clazz, "Missing operator or separator between identifier and literal.");
            BLexer.addInvalid(clazz, TIdentifierLiteral.class, "Missing operator or separator between literal and identifier.");
            for (Class<? extends Token> litClass2 : LITERAL_TOKEN_CLASSES) {
                BLexer.addInvalid(clazz, litClass2, "Missing operator or separator between literals.");
            }
        }
    }
}

