/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cliparser;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.ClassicalBParser;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.MockedDefinitions;
import de.be4.classicalb.core.parser.ParsingBehaviour;
import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.analysis.prolog.ClassicalPositionPrinter;
import de.be4.classicalb.core.parser.analysis.prolog.NodeFileNumbers;
import de.be4.classicalb.core.parser.analysis.prolog.PrologExceptionPrinter;
import de.be4.classicalb.core.parser.analysis.prolog.RecursiveMachineLoader;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.rules.RulesProject;
import de.be4.classicalb.core.parser.util.PrettyPrinter;
import de.be4.ltl.core.parser.CtlParser;
import de.be4.ltl.core.parser.LtlParseException;
import de.be4.ltl.core.parser.LtlParser;
import de.be4.ltl.core.parser.PctlParser;
import de.be4.ltl.core.parser.TemporalLogicParser;
import de.prob.cliparser.ConsoleOptions;
import de.prob.cliparser.EPreplCommands;
import de.prob.parserbase.JoinedParserBase;
import de.prob.parserbase.ProBParserBase;
import de.prob.parserbase.UnparsedParserBase;
import de.prob.prolog.output.FastSicstusTermOutput;
import de.prob.prolog.output.FastSwiTermOutput;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class CliBParser {
    private static final String CLI_SWITCH_VERBOSE = "-v";
    private static final String CLI_SWITCH_VERSION = "-version";
    private static final String CLI_SWITCH_PRINT_STACK_SIZE = "-printstacksize";
    private static final String CLI_SWITCH_HELP = "-h";
    private static final String CLI_SWITCH_HELP2 = "-help";
    private static final String CLI_SWITCH_HELP3 = "--help";
    private static final String CLI_SWITCH_TIME = "-time";
    private static final String CLI_SWITCH_PP = "-pp";
    private static final String CLI_SWITCH_PROLOG = "-prolog";
    private static final String CLI_SWITCH_FASTPROLOG = "-fastprolog";
    private static final String CLI_SWITCH_SWI = "-swi";
    private static final String CLI_SWITCH_COMPACT_POSITIONS = "-compactpos";
    private static final String CLI_SWITCH_PROLOG_LINES = "-lineno";
    private static final String CLI_SWITCH_OUTPUT = "-out";
    private static final String CLI_SWITCH_PREPL = "-prepl";
    private static final String CLI_SWITCH_NAME_CHECK = "-checkname";
    private static final UnparsedParserBase UNPARSED_PARSER_BASE = new UnparsedParserBase("unparsed_expr", "unparsed_pred", "unparsed_trans");

    private static int getStackSize(int acc) {
        try {
            return CliBParser.getStackSize(acc + 1);
        }
        catch (StackOverflowError ignored) {
            return acc;
        }
    }

    public static void main(String[] args) throws Exception {
        AtomicReference<Object> maybeException = new AtomicReference<Object>(null);
        Thread t = new Thread(() -> {
            try {
                CliBParser.mainImpl(args);
            }
            catch (Exception e) {
                maybeException.set(e);
            }
        });
        t.start();
        t.join();
        if (maybeException.get() != null) {
            throw (Exception)maybeException.get();
        }
    }

    public static void mainImpl(String[] args) throws IOException {
        ConsoleOptions options = CliBParser.createConsoleOptions(args);
        if (options.isOptionSet(CLI_SWITCH_HELP) || options.isOptionSet(CLI_SWITCH_HELP2) || options.isOptionSet(CLI_SWITCH_HELP3)) {
            options.printUsage(System.err);
            System.exit(-1);
            return;
        }
        if (options.isOptionSet(CLI_SWITCH_VERSION)) {
            System.out.printf("Version:    %s%n", BParser.getVersion());
            System.out.printf("Git Commit: %s%n", BParser.getGitSha());
            System.exit(0);
            return;
        }
        if (options.isOptionSet(CLI_SWITCH_PRINT_STACK_SIZE)) {
            System.out.format("Local stack size:\t%d\n", CliBParser.getStackSize(0));
            System.exit(0);
            return;
        }
        String[] arguments = options.getRemainingOptions();
        if (!options.isOptionSet(CLI_SWITCH_PREPL) && arguments.length != 1) {
            System.err.println("\nYou have not provided a file to parse (nor specified the -prepl option).\n");
            System.err.println("Here is how to use the parser:");
            options.printUsage(System.err);
            System.exit(-1);
            return;
        }
        ParsingBehaviour behaviour = new ParsingBehaviour();
        behaviour.setPrintTime(options.isOptionSet(CLI_SWITCH_TIME));
        behaviour.setPrologOutput(options.isOptionSet(CLI_SWITCH_PROLOG));
        behaviour.setAddLineNumbers(options.isOptionSet(CLI_SWITCH_PROLOG_LINES));
        behaviour.setPrettyPrintB(options.isOptionSet(CLI_SWITCH_PP));
        behaviour.setVerbose(options.isOptionSet(CLI_SWITCH_VERBOSE));
        behaviour.setFastPrologOutput(options.isOptionSet(CLI_SWITCH_FASTPROLOG));
        behaviour.setSwiSupport(options.isOptionSet(CLI_SWITCH_SWI));
        behaviour.setCompactPrologPositions(options.isOptionSet(CLI_SWITCH_COMPACT_POSITIONS));
        behaviour.setMachineNameMustMatchFileName(options.isOptionSet(CLI_SWITCH_NAME_CHECK));
        if (options.isOptionSet(CLI_SWITCH_PREPL)) {
            CliBParser.runPRepl(behaviour);
        } else {
            if (options.getRemainingOptions().length != 1) {
                options.printUsage(System.err);
                System.exit(-1);
                return;
            }
            File bfile = new File(options.getRemainingOptions()[0]);
            PrintWriter err = new PrintWriter(System.err, true);
            if (options.isOptionSet(CLI_SWITCH_OUTPUT)) {
                String filename = options.getOptions(CLI_SWITCH_OUTPUT)[0];
                try (OutputStream out = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
                    int returnValue = CliBParser.doFileParsing(behaviour, out, err, bfile);
                    out.flush();
                    err.flush();
                    System.exit(returnValue);
                }
                catch (IOException e) {
                    if (options.isOptionSet(CLI_SWITCH_PROLOG)) {
                        PrologExceptionPrinter.printException((OutputStream)System.err, e);
                    } else {
                        System.err.println("Unable to create file '" + filename + "'");
                    }
                    System.exit(-1);
                }
            } else {
                int returnValue = CliBParser.doFileParsing(behaviour, System.out, err, bfile);
                System.out.flush();
                err.flush();
                System.exit(returnValue);
            }
        }
    }

    private static String getNamedOption(ParsingBehaviour behaviour, String name) {
        switch (name) {
            case "addLineNumbers": {
                return String.valueOf(behaviour.isAddLineNumbers());
            }
            case "verbose": {
                return String.valueOf(behaviour.isVerbose());
            }
            case "fastPrologOutput": {
                return String.valueOf(behaviour.isFastPrologOutput());
            }
            case "swiSupport": {
                return String.valueOf(behaviour.isSwiSupport());
            }
            case "compactPrologPositions": {
                return String.valueOf(behaviour.isCompactPrologPositions());
            }
            case "machineNameMustMatchFileName": {
                return String.valueOf(behaviour.isMachineNameMustMatchFileName());
            }
            case "defaultFileNumber": {
                return String.valueOf(behaviour.getDefaultFileNumber());
            }
            case "startLineNumber": {
                return String.valueOf(behaviour.getStartLineNumber());
            }
            case "startColumnNumber": {
                return String.valueOf(behaviour.getStartColumnNumber());
            }
        }
        return null;
    }

    private static boolean setNamedOption(ParsingBehaviour behaviour, String name, String value) {
        switch (name) {
            case "addLineNumbers": {
                behaviour.setAddLineNumbers(Boolean.parseBoolean(value));
                break;
            }
            case "verbose": {
                behaviour.setVerbose(Boolean.parseBoolean(value));
                break;
            }
            case "fastPrologOutput": {
                behaviour.setFastPrologOutput(Boolean.parseBoolean(value));
                break;
            }
            case "swiSupport": {
                behaviour.setSwiSupport(Boolean.parseBoolean(value));
                break;
            }
            case "compactPrologPositions": {
                behaviour.setCompactPrologPositions(Boolean.parseBoolean(value));
                break;
            }
            case "machineNameMustMatchFileName": {
                behaviour.setMachineNameMustMatchFileName(Boolean.parseBoolean(value));
                break;
            }
            case "defaultFileNumber": {
                behaviour.setDefaultFileNumber(Integer.parseInt(value));
                break;
            }
            case "startLineNumber": {
                behaviour.setStartLineNumber(Integer.parseInt(value));
                break;
            }
            case "startColumnNumber": {
                behaviour.setStartColumnNumber(Integer.parseInt(value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static void resetVolatilePositionOptions(ParsingBehaviour behaviour) {
        behaviour.setStartLineNumber(1);
        behaviour.setStartColumnNumber(1);
    }

    private static void runPRepl(ParsingBehaviour behaviour) throws IOException {
        ServerSocket serverSocket = new ServerSocket(0, 50, InetAddress.getLoopbackAddress());
        System.out.println(serverSocket.getLocalPort() + ".");
        Socket socket = serverSocket.accept();
        PrintWriter socketWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8)), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
        MockedDefinitions context = new MockedDefinitions();
        boolean terminate = false;
        while (!terminate) {
            String line = in.readLine();
            EPreplCommands command = line == null ? EPreplCommands.halt : EPreplCommands.valueOf(line);
            CliBParser.debugPrint(behaviour, "Received PREPL command: " + (Object)((Object)command));
            switch (command) {
                case version: {
                    socketWriter.println(BParser.getVersion() + "-" + BParser.getGitSha());
                    break;
                }
                case shortversion: {
                    socketWriter.println(BParser.getVersion());
                    break;
                }
                case gitsha: {
                    socketWriter.println(BParser.getGitSha());
                    break;
                }
                case commandsupported: {
                    String commandToCheck = in.readLine();
                    try {
                        EPreplCommands.valueOf(commandToCheck);
                    }
                    catch (IllegalArgumentException ignored) {
                        socketWriter.println("false.");
                        break;
                    }
                    socketWriter.println("true.");
                    break;
                }
                case featuresupported: {
                    socketWriter.println("false.");
                    break;
                }
                case definition: {
                    String name = in.readLine();
                    String type = in.readLine();
                    String parameterCount = in.readLine();
                    context.addMockedDefinition(name, type, parameterCount);
                    break;
                }
                case resetdefinitions: {
                    context = new MockedDefinitions();
                    break;
                }
                case getoption: {
                    String getOptionName = in.readLine();
                    String getOptionValue = CliBParser.getNamedOption(behaviour, getOptionName);
                    PrologTermOutput getOptionOut = new PrologTermOutput(socketWriter);
                    if (getOptionValue != null) {
                        getOptionOut.openTerm("value");
                        getOptionOut.printAtom(CliBParser.getNamedOption(behaviour, getOptionName));
                        getOptionOut.closeTerm();
                    } else {
                        getOptionOut.printAtom("unsupported");
                    }
                    getOptionOut.fullstop();
                    break;
                }
                case setoption: {
                    String setOptionName = in.readLine();
                    String setOptionValue = in.readLine();
                    String setOptionPrevValue = CliBParser.getNamedOption(behaviour, setOptionName);
                    boolean ok = CliBParser.setNamedOption(behaviour, setOptionName, setOptionValue);
                    PrologTermOutput setOptionOut = new PrologTermOutput(socketWriter);
                    if (ok) {
                        setOptionOut.openTerm("prev_value");
                        setOptionOut.printAtom(setOptionPrevValue);
                        setOptionOut.closeTerm();
                    } else {
                        setOptionOut.printAtom("unsupported");
                    }
                    setOptionOut.fullstop();
                    break;
                }
                case fastprolog: {
                    String newFVal = in.readLine();
                    CliBParser.debugPrint(behaviour, "Setting fastprolog to " + newFVal);
                    behaviour.setFastPrologOutput(Boolean.parseBoolean(newFVal));
                    break;
                }
                case swi: {
                    String newFVal = in.readLine();
                    CliBParser.debugPrint(behaviour, "Setting swi to " + newFVal);
                    behaviour.setSwiSupport(Boolean.parseBoolean(newFVal));
                    break;
                }
                case compactpos: {
                    behaviour.setCompactPrologPositions(Boolean.parseBoolean(in.readLine()));
                    break;
                }
                case verbose: {
                    behaviour.setVerbose(Boolean.parseBoolean(in.readLine()));
                    break;
                }
                case checkname: {
                    behaviour.setMachineNameMustMatchFileName(Boolean.parseBoolean(in.readLine()));
                    break;
                }
                case lineno: {
                    behaviour.setAddLineNumbers(Boolean.parseBoolean(in.readLine()));
                    break;
                }
                case machine: {
                    int returnValue;
                    CliBParser.resetVolatilePositionOptions(behaviour);
                    String filename = in.readLine();
                    Path outFile = Paths.get(in.readLine(), new String[0]);
                    File bfile = new File(filename);
                    try (OutputStream out = Files.newOutputStream(outFile, new OpenOption[0]);){
                        returnValue = CliBParser.doFileParsing(behaviour, out, socketWriter, bfile);
                    }
                    context = new MockedDefinitions();
                    if (returnValue == 0) {
                        socketWriter.println("exit(" + returnValue + ").");
                        break;
                    }
                    if (returnValue > -4) break;
                    System.out.println("% Erasing file contents of " + outFile);
                    Files.write(outFile, Collections.singletonList("% VM Error occurred"), new OpenOption[0]);
                    break;
                }
                case formula: 
                case expression: 
                case predicate: 
                case substitution: {
                    String formula = in.readLine();
                    CliBParser.parseFormula(command, formula, context, behaviour, socketWriter);
                    CliBParser.resetVolatilePositionOptions(behaviour);
                    break;
                }
                case ltl: {
                    String extension = in.readLine();
                    ProBParserBase extParser = CliBParser.getExtensionParser(extension, context);
                    TemporalLogicParser parser = new LtlParser(extParser);
                    CliBParser.parseTemporalFormula(in.readLine(), parser, socketWriter);
                    CliBParser.resetVolatilePositionOptions(behaviour);
                    break;
                }
                case ctl: {
                    String extension = in.readLine();
                    ProBParserBase extParser = CliBParser.getExtensionParser(extension, context);
                    TemporalLogicParser parser = new CtlParser(extParser);
                    CliBParser.parseTemporalFormula(in.readLine(), parser, socketWriter);
                    CliBParser.resetVolatilePositionOptions(behaviour);
                    break;
                }
                case pctl: {
                    String extension = in.readLine();
                    ProBParserBase extParser = CliBParser.getExtensionParser(extension, context);
                    TemporalLogicParser parser = new PctlParser(extParser);
                    CliBParser.parseTemporalFormula(in.readLine(), parser, socketWriter);
                    CliBParser.resetVolatilePositionOptions(behaviour);
                    break;
                }
                case halt: {
                    socket.close();
                    serverSocket.close();
                    terminate = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported Command " + line);
                }
            }
            System.out.flush();
            System.err.flush();
        }
    }

    private static ProBParserBase getExtensionParser(String pattern, IDefinitions context) {
        String[] langs = pattern.split(",");
        ProBParserBase[] sublangs = new ProBParserBase[langs.length];
        for (int i = 0; i < langs.length; ++i) {
            ProBParserBase sub;
            String lang = langs[i];
            if ("none".equals(lang)) {
                sub = UNPARSED_PARSER_BASE;
            } else if ("B".equals(lang)) {
                BParser bparser = new BParser();
                if (context != null) {
                    bparser.setDefinitions(context);
                }
                sub = new ClassicalBParser(bparser);
            } else {
                throw new IllegalArgumentException("Unknown language " + lang);
            }
            sublangs[i] = sub;
        }
        if (sublangs.length == 1) {
            return sublangs[0];
        }
        return new JoinedParserBase(sublangs);
    }

    private static void parseTemporalFormula(String theFormula, TemporalLogicParser<?> parser, Writer out) {
        PrologTermOutput pout = new PrologTermOutput(out, false);
        try {
            PrologTerm term = parser.generatePrologTerm(theFormula, null);
            pout.openTerm("ltl").printTerm(term).closeTerm();
        }
        catch (LtlParseException e) {
            pout.openTerm("syntax_error").printAtom(e.getMessage()).closeTerm();
        }
        catch (Throwable e) {
            PrologExceptionPrinter.printException((IPrologTermOutput)pout, new BCompoundException(new BException(null, e.toString(), e)));
        }
        pout.fullstop();
    }

    private static void parseFormula(EPreplCommands command, String theFormula, IDefinitions context, ParsingBehaviour behaviour, Writer out) {
        PrologTermOutput pout = new PrologTermOutput(out, false);
        try {
            Start start;
            BParser parser = new BParser();
            parser.setStartPosition(behaviour.getStartLineNumber(), behaviour.getStartColumnNumber());
            parser.setDefinitions(context);
            switch (command) {
                case formula: {
                    start = parser.parseFormula(theFormula);
                    break;
                }
                case expression: {
                    start = parser.parseExpression(theFormula);
                    break;
                }
                case predicate: {
                    start = parser.parsePredicate(theFormula);
                    break;
                }
                case substitution: {
                    start = parser.parseSubstitution(theFormula);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled parsing command: " + (Object)((Object)command)));
                }
            }
            NodeFileNumbers nodeIds = new NodeFileNumbers();
            if (behaviour.getDefaultFileNumber() != -1) {
                nodeIds.assignIdentifiers(behaviour.getDefaultFileNumber(), start);
            }
            ClassicalPositionPrinter pprinter = new ClassicalPositionPrinter(nodeIds);
            pprinter.setPrintSourcePositions(behaviour.isAddLineNumbers(), behaviour.isCompactPrologPositions());
            ASTProlog printer = new ASTProlog(pout, pprinter);
            start.apply(printer);
        }
        catch (BCompoundException e) {
            PrologExceptionPrinter.printException((IPrologTermOutput)pout, e);
        }
        catch (Throwable e) {
            PrologExceptionPrinter.printException((IPrologTermOutput)pout, new BCompoundException(new BException(null, e.toString(), e)));
        }
        pout.fullstop();
    }

    private static void debugPrint(ParsingBehaviour parsingBehaviour, String msg) {
        if (parsingBehaviour.isVerbose()) {
            if (parsingBehaviour.shouldPrintProlog()) {
                msg = "% " + msg;
            }
            System.out.println(msg);
        }
    }

    private static int doFileParsing(ParsingBehaviour behaviour, OutputStream out, PrintWriter err, File bfile) {
        try {
            if (bfile.getName().endsWith(".rmch")) {
                CliBParser.parseRulesProject(bfile, behaviour, out);
            } else {
                CliBParser.fullParsing(bfile, behaviour, out);
            }
            return 0;
        }
        catch (IOException | UncheckedIOException e) {
            IOException exc = !(e instanceof IOException) ? (IOException)e.getCause() : (IOException)e;
            if (behaviour.shouldPrintProlog()) {
                PrologExceptionPrinter.printException(err, exc);
            } else {
                err.println("Error reading input file: " + exc);
            }
            return -2;
        }
        catch (BCompoundException e) {
            if (behaviour.shouldPrintProlog()) {
                PrologExceptionPrinter.printException(err, e);
            } else {
                err.println("Error parsing input file: " + e);
            }
            return -3;
        }
        catch (Throwable e) {
            if (behaviour.shouldPrintProlog()) {
                PrologExceptionPrinter.printException(err, new BCompoundException(new BException(bfile.getAbsolutePath(), e.toString(), e)));
            } else {
                err.println("Error in parser: " + e);
            }
            return -4;
        }
    }

    private static void printPrologAst(ParsingBehaviour parsingBehaviour, OutputStream out, Consumer<? super IPrologTermOutput> printer) {
        long startOutput = System.currentTimeMillis();
        if (parsingBehaviour.isFastPrologOutput()) {
            CliBParser.printASTasFastProlog(parsingBehaviour, out, printer);
        } else {
            assert (parsingBehaviour.isPrologOutput());
            PrologTermOutput pto = new PrologTermOutput(out, false);
            printer.accept(pto);
        }
        long endOutput = System.currentTimeMillis();
        if (parsingBehaviour.isPrintTime() || parsingBehaviour.isVerbose()) {
            System.out.println("% Time for Prolog output: " + (endOutput - startOutput) + " ms");
        }
    }

    private static void fullParsing(File bfile, ParsingBehaviour parsingBehaviour, OutputStream out) throws IOException, BCompoundException {
        BParser parser = new BParser(bfile.getAbsolutePath());
        long startParseMain = System.currentTimeMillis();
        CliBParser.debugPrint(parsingBehaviour, "*** Debug: Parsing file '" + bfile + "'");
        Start tree = parser.parseFile(bfile);
        long endParseMain = System.currentTimeMillis();
        if (parsingBehaviour.isPrintTime() || parsingBehaviour.isVerbose()) {
            System.out.println("% Time for parsing of main file: " + (endParseMain - startParseMain) + " ms");
        }
        if (parsingBehaviour.isPrettyPrintB()) {
            CliBParser.debugPrint(parsingBehaviour, "Pretty printing " + bfile + " in B format:");
            PrettyPrinter pp = new PrettyPrinter();
            pp.setUseIndentation(true);
            tree.apply(pp);
            System.out.println(pp.getPrettyPrint());
        }
        if (parsingBehaviour.shouldPrintProlog()) {
            long startParseRecursive = System.currentTimeMillis();
            RecursiveMachineLoader rml = RecursiveMachineLoader.loadFromAst(parser, tree, parsingBehaviour, parser.getContentProvider());
            long endParseRecursive = System.currentTimeMillis();
            if (parsingBehaviour.isPrintTime() || parsingBehaviour.isVerbose()) {
                System.out.println("% Time for parsing of referenced files: " + (endParseRecursive - startParseRecursive) + " ms");
            }
            CliBParser.printPrologAst(parsingBehaviour, out, rml::printAsProlog);
        }
        if (parsingBehaviour.isVerbose()) {
            System.out.println("% Used memory : " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000L + " KB");
            System.out.println("% Total memory: " + Runtime.getRuntime().totalMemory() / 1000L + " KB");
        }
    }

    private static void printASTasFastProlog(ParsingBehaviour parsingBehaviour, OutputStream out, Consumer<? super IPrologTermOutput> printer) {
        if (!(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out);
        }
        IPrologTermOutput pto = parsingBehaviour.isSwiSupport() ? new FastSwiTermOutput(out) : new FastSicstusTermOutput(out);
        printer.accept(pto);
    }

    private static void parseRulesProject(File mainFile, ParsingBehaviour parsingBehaviour, OutputStream out) throws IOException, BCompoundException {
        RulesProject project = new RulesProject();
        project.setParsingBehaviour(parsingBehaviour);
        project.parseProject(mainFile);
        project.checkAndTranslateProject();
        if (project.hasErrors()) {
            throw new BCompoundException(project.getBExceptionList());
        }
        CliBParser.printPrologAst(parsingBehaviour, out, project::printProjectAsPrologTerm);
    }

    private static ConsoleOptions createConsoleOptions(String[] args) {
        ConsoleOptions options = new ConsoleOptions();
        options.setIntro("BParser (version " + BParser.getVersion() + ", commit " + BParser.getGitSha() + ")\nusage: java -jar probcliparser.jar [options] <BMachine file>\n\nAvailable options are:");
        options.addOption(CLI_SWITCH_VERBOSE, "Verbose output during lexing and parsing");
        options.addOption(CLI_SWITCH_TIME, "Output time used for complete parsing process");
        options.addOption(CLI_SWITCH_PP, "Pretty Print in B format on standard output");
        options.addOption(CLI_SWITCH_PROLOG, "Show AST as Prolog term");
        options.addOption(CLI_SWITCH_PROLOG_LINES, "Put line numbers into prolog terms");
        options.addOption(CLI_SWITCH_OUTPUT, "Specify output file", 1);
        options.addOption(CLI_SWITCH_VERSION, "Print the parser version and exit");
        options.addOption(CLI_SWITCH_HELP, "Print the parser help and exit");
        options.addOption(CLI_SWITCH_HELP2, "Print the parser help and exit");
        options.addOption(CLI_SWITCH_HELP3, "Print the parser help and exit");
        options.addOption(CLI_SWITCH_COMPACT_POSITIONS, "Use new more compact Prolog position terms");
        options.addOption(CLI_SWITCH_FASTPROLOG, "Show AST as Prolog term for fast loading (Do not use this representation in your tool! It depends on internal representation of Sicstus Prolog and will very likely change arbitrarily in the future!)");
        options.addOption(CLI_SWITCH_SWI, "Switch to SWI-Prolog mode. All prolog output will be compatible with the SWI Prolog system, especially the -fastprolog option.");
        options.addOption(CLI_SWITCH_PREPL, "Enter parser-repl. Should only be used from inside ProB's Prolog Core.");
        options.addOption(CLI_SWITCH_NAME_CHECK, "The name of a machine have to match file name (except for the file name extension)");
        options.addOption(CLI_SWITCH_PRINT_STACK_SIZE, "print the locally available depth of the call stack at runtime");
        try {
            options.parseOptions(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            options.printUsage(System.err);
            System.exit(-1);
        }
        return options;
    }
}

