/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.FileSearchPathProvider;
import de.be4.classicalb.core.parser.ParseOptions;
import de.be4.classicalb.core.parser.ParsingBehaviour;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReferencesFinder;
import de.be4.classicalb.core.parser.analysis.prolog.PackageName;
import de.be4.classicalb.core.parser.analysis.prolog.ReferencedMachines;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.grammars.RulesGrammar;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.rules.AbstractOperation;
import de.be4.classicalb.core.parser.rules.IModel;
import de.be4.classicalb.core.parser.rules.RulesMachineChecker;
import de.be4.classicalb.core.parser.rules.RulesTransformation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RulesParseUnit
extends IModel {
    private List<MachineReference> machineReferences = new ArrayList<MachineReference>();
    private String content;
    private File machineFile;
    private BCompoundException bCompoundException;
    private BParser bParser;
    private RulesMachineChecker rulesMachineChecker;
    private static final String[] SUFFICES = new String[]{".rmch", ".mch"};

    private RulesParseUnit(String machineContent) {
        this.content = machineContent;
    }

    private RulesParseUnit(File machineFile) {
        this.machineFile = machineFile;
    }

    public static RulesParseUnit parse(File machineFile, ParsingBehaviour parsingBehaviour) {
        RulesParseUnit rulesParseUnit = new RulesParseUnit(machineFile);
        rulesParseUnit.setParsingBehaviour(parsingBehaviour);
        rulesParseUnit.parse();
        return rulesParseUnit;
    }

    public static RulesParseUnit parse(String machineString) {
        RulesParseUnit rulesParseUnit = new RulesParseUnit(machineString);
        rulesParseUnit.parse();
        return rulesParseUnit;
    }

    private void parse() {
        if (this.bCompoundException != null) {
            return;
        }
        try {
            this.bParser = new BParser(this.machineFile != null ? this.machineFile.getPath() : null);
            this.machineFile = this.machineFile != null ? new File(this.bParser.getFileName()) : null;
            ParseOptions parseOptions = new ParseOptions();
            parseOptions.setGrammar(RulesGrammar.getInstance());
            this.bParser.setParseOptions(parseOptions);
            this.setStart(this.machineFile != null ? this.bParser.parseFile(this.machineFile) : this.bParser.parseMachine(this.content));
            if (this.machineFile != null) {
                ReferencedMachines machines = MachineReferencesFinder.findReferencedMachines(this.machineFile.toPath(), this.getStart(), true);
                this.setMachineName(machines.getMachineName());
                this.machineReferences = new ArrayList<MachineReference>();
                for (MachineReference mr : machines.getReferences()) {
                    File referencedFile;
                    String filePragma = mr.getPath();
                    if (filePragma == null) {
                        try {
                            referencedFile = this.lookupFile(mr.getName(), machines.getImportedPackages(), mr.getNode());
                        }
                        catch (CheckException e) {
                            throw new BException(this.machineFile.getAbsolutePath(), e);
                        }
                    } else {
                        File p = new File(filePragma);
                        referencedFile = p.isAbsolute() ? p : new File(this.machineFile.getParentFile(), filePragma);
                    }
                    this.machineReferences.add(new MachineReference(mr.getType(), mr.getName(), mr.getRenamedName(), mr.getNode(), referencedFile.getAbsolutePath()));
                }
            }
            this.rulesMachineChecker = new RulesMachineChecker(this.machineFile, this.machineReferences, this.getStart());
            this.rulesMachineChecker.runChecks();
        }
        catch (BCompoundException e) {
            this.bCompoundException = e;
        }
        catch (BException e) {
            this.bCompoundException = new BCompoundException(e);
        }
    }

    public void translate() {
        Map<String, AbstractOperation> allOperations = this.getOperations().stream().collect(Collectors.toMap(AbstractOperation::getOriginalName, op -> op));
        this.translate(allOperations);
    }

    public void translate(Map<String, AbstractOperation> allOperations) {
        if (this.hasError()) {
            return;
        }
        RulesTransformation ruleTransformation = new RulesTransformation(this.getStart(), this.bParser, this.rulesMachineChecker, allOperations);
        try {
            ruleTransformation.runTransformation();
        }
        catch (BCompoundException e) {
            this.bCompoundException = e;
        }
    }

    private File lookupFile(String name, Map<PackageName, Path> imports, Node node) throws CheckException {
        List<String> importPaths = imports.values().stream().map(v -> v.toAbsolutePath().toString()).collect(Collectors.toList());
        for (String suffix : SUFFICES) {
            try {
                return new FileSearchPathProvider(this.machineFile.getParentFile().getPath(), name + suffix, importPaths).resolve();
            }
            catch (IOException iOException) {
            }
        }
        throw new CheckException(String.format("Machine not found: '%s'", name), node);
    }

    public List<AbstractOperation> getOperations() {
        return this.rulesMachineChecker == null ? new ArrayList() : this.rulesMachineChecker.getOperations();
    }

    @Override
    public String getPath() {
        if (this.machineFile != null) {
            return this.machineFile.getAbsolutePath();
        }
        return this.getMachineName();
    }

    public RulesMachineChecker getRulesMachineChecker() {
        return this.rulesMachineChecker;
    }

    @Override
    public List<MachineReference> getMachineReferences() {
        return this.machineReferences == null ? new ArrayList() : this.machineReferences;
    }

    @Override
    public boolean hasError() {
        return this.bCompoundException != null;
    }

    @Override
    public BCompoundException getCompoundException() {
        return this.bCompoundException;
    }

    public BParser getBParser() {
        return this.bParser;
    }
}

