/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.ParsingBehaviour;
import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.analysis.prolog.ClassicalPositionPrinter;
import de.be4.classicalb.core.parser.analysis.prolog.INodeIds;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.node.Start;
import de.prob.prolog.output.IPrologTermOutput;
import java.util.List;

public abstract class IModel {
    private String machineName = "";
    private ParsingBehaviour parsingBehaviour = new ParsingBehaviour();
    private Start start;

    IModel() {
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setParsingBehaviour(ParsingBehaviour parsingBehaviour) {
        this.parsingBehaviour = parsingBehaviour;
    }

    public void setStart(Start start) {
        this.start = start;
    }

    public Start getStart() {
        return this.start;
    }

    public abstract List<MachineReference> getMachineReferences();

    public void printAsProlog(IPrologTermOutput pout, INodeIds nodeIdMapping) {
        this.printAsPrologWithFullstops(pout, nodeIdMapping, true);
    }

    public void printAsPrologDirect(IPrologTermOutput pout, INodeIds nodeIdMapping) {
        this.printAsPrologWithFullstops(pout, nodeIdMapping, false);
    }

    public void printAsPrologWithFullstops(IPrologTermOutput pout, INodeIds nodeIdMapping, boolean withFullstops) {
        assert (this.start != null);
        ClassicalPositionPrinter pprinter = new ClassicalPositionPrinter(nodeIdMapping);
        pprinter.setPrintSourcePositions(this.parsingBehaviour.isAddLineNumbers(), this.parsingBehaviour.isCompactPrologPositions());
        ASTProlog prolog = new ASTProlog(pout, pprinter);
        pout.openTerm("machine");
        this.start.apply(prolog);
        pout.closeTerm();
        if (withFullstops) {
            pout.fullstop();
        } else {
            pout.flush();
        }
    }

    public abstract String getPath();

    public abstract boolean hasError();

    public abstract BCompoundException getCompoundException();
}

