/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.CachingDefinitionFileProvider;
import de.be4.classicalb.core.parser.FileSearchPathProvider;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.IFileContentProvider;
import de.be4.classicalb.core.parser.ParsingBehaviour;
import de.be4.classicalb.core.parser.analysis.MachineClauseAdapter;
import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.analysis.prolog.Ancestor;
import de.be4.classicalb.core.parser.analysis.prolog.ClassicalPositionPrinter;
import de.be4.classicalb.core.parser.analysis.prolog.INodeIds;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReferencesFinder;
import de.be4.classicalb.core.parser.analysis.prolog.MachineType;
import de.be4.classicalb.core.parser.analysis.prolog.NodeFileNumbers;
import de.be4.classicalb.core.parser.analysis.prolog.PositionPrinter;
import de.be4.classicalb.core.parser.analysis.prolog.ReferencedMachines;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.Start;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class RecursiveMachineLoader {
    private static final String[] SUFFIXES = new String[]{".ref", ".mch", ".sys", ".imp"};
    private final File rootDirectory;
    private final INodeIds nodeIds;
    private final Map<String, Start> parsedMachines = new TreeMap<String, Start>();
    private final Map<String, ReferencedMachines> machineReferenceInfo = new TreeMap<String, ReferencedMachines>();
    private final Map<String, File> parsedFiles = new TreeMap<String, File>();
    private final List<File> machineFilesLoaded = new ArrayList<File>();
    private final IFileContentProvider contentProvider;
    private final ParsingBehaviour parsingBehaviour;
    private PositionPrinter positionPrinter;
    private String main;

    public RecursiveMachineLoader(String directory, IFileContentProvider contentProvider, ParsingBehaviour parsingBehaviour) throws BCompoundException {
        this.parsingBehaviour = parsingBehaviour;
        File file = this.rootDirectory = directory == null ? new File(".") : new File(directory);
        if (!this.rootDirectory.exists()) {
            throw new BCompoundException(new BException(null, new IOException("Directory does not exist: " + directory)));
        }
        this.nodeIds = new NodeFileNumbers();
        this.contentProvider = contentProvider;
    }

    public RecursiveMachineLoader(String path, IFileContentProvider contentProvider) throws BCompoundException {
        this(path, contentProvider, new ParsingBehaviour());
    }

    public void setPositionPrinter(PositionPrinter positionPrinter) {
        this.positionPrinter = positionPrinter;
    }

    private static void printLoadProgress(File machineFile) {
        System.out.println("*** Debug: Parsing file '" + machineFile + "'");
    }

    public static RecursiveMachineLoader loadFromAst(BParser parser, Start ast, ParsingBehaviour parsingBehaviour, IFileContentProvider contentProvider) throws BCompoundException {
        File mainFile = new File(parser.getFileName());
        String parent = mainFile.getParent() == null ? "." : mainFile.getParent();
        RecursiveMachineLoader rml = new RecursiveMachineLoader(parent, contentProvider, parsingBehaviour);
        rml.loadAllMachines(mainFile, ast, parser.getDefinitions());
        return rml;
    }

    public static RecursiveMachineLoader loadFile(File mainFile, ParsingBehaviour parsingBehaviour, IFileContentProvider contentProvider) throws BCompoundException {
        if (parsingBehaviour.isVerbose()) {
            RecursiveMachineLoader.printLoadProgress(mainFile);
        }
        BParser parser = new BParser(mainFile.toString());
        parser.setContentProvider(contentProvider);
        Start ast = parser.parseFile(mainFile);
        return RecursiveMachineLoader.loadFromAst(parser, ast, parsingBehaviour, contentProvider);
    }

    public static RecursiveMachineLoader loadFile(File mainFile, ParsingBehaviour parsingBehaviour) throws BCompoundException {
        return RecursiveMachineLoader.loadFile(mainFile, parsingBehaviour, new CachingDefinitionFileProvider());
    }

    public static RecursiveMachineLoader loadFile(File mainFile) throws BCompoundException {
        return RecursiveMachineLoader.loadFile(mainFile, new ParsingBehaviour());
    }

    public void loadAllMachines(File startFile, Start start, IDefinitions definitions) throws BCompoundException {
        this.recursivelyLoadMachine(startFile, start, new ArrayList<Ancestor>(), true, this.rootDirectory, definitions);
    }

    private void loadMachine(List<Ancestor> ancestors, File machineFile) throws BCompoundException {
        if (this.parsingBehaviour.isVerbose()) {
            RecursiveMachineLoader.printLoadProgress(machineFile);
        }
        BParser parser = new BParser(machineFile.getAbsolutePath());
        parser.setContentProvider(this.contentProvider);
        Start tree = parser.parseFile(machineFile);
        this.recursivelyLoadMachine(machineFile, tree, ancestors, false, machineFile.getParentFile(), parser.getDefinitions());
    }

    public void printAsProlog(PrintWriter out) {
        PrologTermOutput pout = new PrologTermOutput(out, false);
        this.printAsProlog(pout);
    }

    public void printAsProlog(IPrologTermOutput pout) {
        this.printAsPrologWithFullstops(pout, true);
    }

    public void printAsPrologDirect(IPrologTermOutput pout) {
        this.printAsPrologWithFullstops(pout, false);
    }

    private void printAsPrologWithFullstops(IPrologTermOutput pout, boolean withFullstops) {
        PositionPrinter pprinter;
        pout.openTerm("parser_version");
        pout.printAtom(BParser.getGitSha());
        pout.closeTerm();
        if (withFullstops) {
            pout.fullstop();
        }
        pout.openTerm("classical_b");
        pout.printAtom(this.getMainMachineName());
        pout.openList();
        for (File file : this.getMachineFilesLoaded()) {
            try {
                pout.printAtom(file.getCanonicalPath());
            }
            catch (IOException e) {
                pout.printAtom(file.getPath());
            }
        }
        pout.closeList();
        pout.closeTerm();
        if (withFullstops) {
            pout.fullstop();
        }
        if (this.positionPrinter != null) {
            pprinter = this.positionPrinter;
        } else {
            ClassicalPositionPrinter classicalPositionPrinter = new ClassicalPositionPrinter(this.getNodeIdMapping());
            classicalPositionPrinter.setPrintSourcePositions(this.parsingBehaviour.isAddLineNumbers(), this.parsingBehaviour.isCompactPrologPositions());
            pprinter = classicalPositionPrinter;
        }
        ASTProlog prolog = new ASTProlog(pout, pprinter);
        for (Map.Entry<String, Start> entry : this.getParsedMachines().entrySet()) {
            pout.openTerm("machine");
            entry.getValue().apply(prolog);
            pout.closeTerm();
            if (!withFullstops) continue;
            pout.fullstop();
        }
        if (!withFullstops) {
            pout.flush();
        }
    }

    private File lookupFile(File parentMachineDirectory, MachineReference machineRef, List<Ancestor> ancestors, Collection<Path> importedDirs) throws CheckException {
        String filePragma = machineRef.getPath();
        if (filePragma != null) {
            File p = new File(filePragma);
            if (p.isAbsolute()) {
                return p;
            }
            return new File(parentMachineDirectory, filePragma);
        }
        for (String suffix : SUFFIXES) {
            try {
                List<String> paths = importedDirs.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList());
                return new FileSearchPathProvider(parentMachineDirectory.getAbsolutePath(), machineRef.getName() + suffix, paths).resolve();
            }
            catch (IOException paths) {
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Machine not found: '");
        sb.append(machineRef.getName());
        sb.append("'");
        if (!ancestors.isEmpty()) {
            String fileNameOfErrorMachine = this.parsedFiles.get(ancestors.get(ancestors.size() - 1).getName()).getName();
            sb.append(" in '").append(fileNameOfErrorMachine).append("'");
            for (int i = ancestors.size() - 2; i >= 0; --i) {
                String name = ancestors.get(i).getName();
                String fileName = this.parsedFiles.get(name).getName();
                sb.append(" loaded by ").append("'").append(fileName).append("'");
            }
        }
        throw new CheckException(sb.toString(), machineRef.getNode());
    }

    private void recursivelyLoadMachine(File machineFile, Start currentAst, List<Ancestor> ancestors, boolean isMain, File directory, IDefinitions definitions) throws BCompoundException {
        ReferencedMachines refMachines;
        boolean machineNameMustMatchFileName = !isMain || this.parsingBehaviour.isMachineNameMustMatchFileName();
        try {
            refMachines = MachineReferencesFinder.findReferencedMachines(machineFile.toPath(), currentAst, machineNameMustMatchFileName);
        }
        catch (BException e) {
            throw new BCompoundException(e);
        }
        String name = refMachines.getMachineName();
        if (!isMain && refMachines.getType() == MachineType.DEFINITION_FILE) {
            throw new BCompoundException(new BException(machineFile.getName(), "Expecting a B machine but was a definition file in file: '" + machineFile.getName() + "'", null));
        }
        int machineFileIndex = this.machineFilesLoaded.indexOf(machineFile);
        if (machineFileIndex != -1) {
            if (this.parsedFiles.containsValue(machineFile)) {
                throw new BCompoundException(new BException(machineFile.toString(), "Machine " + name + " is being loaded more than once - this should never happen", null));
            }
        } else {
            this.machineFilesLoaded.add(machineFile);
            machineFileIndex = this.machineFilesLoaded.indexOf(machineFile);
        }
        int fileNumber = machineFileIndex + 1;
        this.getNodeIdMapping().assignIdentifiers(fileNumber, currentAst);
        definitions.assignIdsToNodes(this.getNodeIdMapping(), this.machineFilesLoaded);
        this.injectDefinitions(currentAst, definitions);
        if (this.parsedFiles.containsKey(name)) {
            throw new BCompoundException(new BException(machineFile.getName(), "Multiple files define the MACHINE '" + name + "' :" + this.parsedFiles.get(name) + " and " + machineFile.getName(), null));
        }
        this.getParsedMachines().put(name, currentAst);
        this.parsedFiles.put(name, machineFile);
        this.machineReferenceInfo.put(name, refMachines);
        if (isMain) {
            this.main = name;
        }
        this.checkForCycles(ancestors, machineFile, name, refMachines);
        List<MachineReference> references = refMachines.getReferences();
        for (MachineReference refMachine : references) {
            File referencedFile;
            ArrayList<Ancestor> newAncestors = new ArrayList<Ancestor>(ancestors);
            newAncestors.add(new Ancestor(name, refMachine));
            try {
                referencedFile = this.lookupFile(directory, refMachine, newAncestors, refMachines.getImportedPackages().values());
            }
            catch (CheckException e) {
                throw new BCompoundException(new BException(machineFile.getAbsolutePath(), e));
            }
            if (referencedFile.exists() && this.parsedFiles.containsKey(refMachine.getName())) {
                String alreadyParsedCanonical;
                String referencedFileCanonical;
                try {
                    referencedFileCanonical = referencedFile.getCanonicalPath();
                    alreadyParsedCanonical = this.parsedFiles.get(refMachine.getName()).getCanonicalPath();
                }
                catch (IOException e) {
                    throw new BCompoundException(new BException(machineFile.getAbsolutePath(), e));
                }
                if (!alreadyParsedCanonical.equals(referencedFileCanonical)) {
                    String message = "Two files with the same name are referenced:\n" + alreadyParsedCanonical + "\n" + referencedFileCanonical;
                    throw new BCompoundException(new BException(machineFile.getAbsolutePath(), new CheckException(message, refMachine.getNode())));
                }
            }
            if (this.getParsedMachines().containsKey(refMachine.getName())) continue;
            try {
                this.loadMachine(newAncestors, referencedFile);
            }
            catch (BCompoundException e) {
                throw e.withMissingLocations(BException.Location.locationsFromNodes(machineFile.getAbsolutePath(), Collections.singletonList(refMachine.getNode())));
            }
        }
    }

    private void checkForCycles(List<Ancestor> ancestors, File currentMachineFile, String currentMachineName, ReferencedMachines refMachines) throws BCompoundException {
        for (MachineReference machineReference : refMachines.getReferences()) {
            ArrayList<Ancestor> tempAncestors = new ArrayList<Ancestor>(ancestors);
            tempAncestors.add(new Ancestor(currentMachineName, machineReference));
            for (Ancestor ancestor : tempAncestors) {
                this.checkSiblings(ancestor, currentMachineFile, tempAncestors, new Ancestor(currentMachineName, machineReference));
            }
        }
    }

    private void checkSiblings(Ancestor current, File currentMachineFile, List<Ancestor> ancestors, Ancestor sibling) throws BCompoundException {
        String closeTheCycle;
        String name = current.getName();
        if (name.equals(closeTheCycle = sibling.getMachineReference().getName())) {
            String path;
            StringBuilder dependency = new StringBuilder();
            boolean foundStartOfCycle = false;
            for (Ancestor ancestor : ancestors) {
                if (ancestor.getName().equals(closeTheCycle)) {
                    foundStartOfCycle = true;
                    dependency.append(ancestor.getName());
                }
                if (!foundStartOfCycle) continue;
                dependency.append(ancestor);
            }
            try {
                path = this.lookupFile(currentMachineFile.getParentFile(), sibling.getMachineReference(), Collections.emptyList(), Collections.emptyList()).toString();
            }
            catch (CheckException e) {
                throw new BCompoundException(new BException(currentMachineFile.toString(), e));
            }
            Node node = current.getMachineReference().getNode();
            throw new BCompoundException(new BException(path, new CheckException("Cycle in " + (Object)((Object)current.getMachineReference().getType()) + " clause: " + dependency, node)));
        }
    }

    private void injectDefinitions(Start tree, IDefinitions definitions) {
        DefInjector defInjector = new DefInjector(definitions);
        tree.apply(defInjector);
    }

    public INodeIds getNodeIdMapping() {
        return this.nodeIds;
    }

    public Map<String, Start> getParsedMachines() {
        return this.parsedMachines;
    }

    public Map<String, ReferencedMachines> getMachineReferenceInfo() {
        return Collections.unmodifiableMap(this.machineReferenceInfo);
    }

    public Map<String, File> getParsedFiles() {
        return this.parsedFiles;
    }

    public List<File> getMachineFilesLoaded() {
        return this.machineFilesLoaded;
    }

    public String getMainMachineName() {
        return this.main;
    }

    private static class DefInjector
    extends MachineClauseAdapter {
        private final IDefinitions definitions;

        public DefInjector(IDefinitions definitions) {
            this.definitions = definitions;
        }

        @Override
        public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
            node.getDefinitions().clear();
            for (String name : this.definitions.getDefinitionNames()) {
                PDefinition def = this.definitions.getDefinition(name);
                node.getDefinitions().add(def);
            }
        }
    }
}

