/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.checking;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.ARefinementMachineParseUnit;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PMachineClause;
import de.be4.classicalb.core.parser.node.PMachineHeader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClausesCollector
extends DepthFirstAdapter {
    private final Map<Class<? extends Node>, Set<Node>> availableClauses = new HashMap<Class<? extends Node>, Set<Node>>();
    private boolean scalarParameter = false;
    boolean refinement = false;

    public boolean hasScalarParameter() {
        return this.scalarParameter;
    }

    public boolean isRefinement() {
        return this.refinement;
    }

    private void collectParams(PMachineHeader machineHeader) {
        machineHeader.apply(new DepthFirstAdapter(){

            @Override
            public void caseAIdentifierExpression(AIdentifierExpression node) {
                ClausesCollector.this.scalarParameter = ClausesCollector.this.scalarParameter || ClausesCollector.this.allLowerCase(node.getIdentifier().getLast().getText());
            }
        });
    }

    private void addMachineClauses(List<PMachineClause> machineClauses) {
        for (PMachineClause clause : machineClauses) {
            Set<Node> nodesForclause = this.availableClauses.get(clause.getClass());
            if (nodesForclause == null) {
                nodesForclause = new HashSet<Node>();
            }
            nodesForclause.add(clause);
            this.availableClauses.put(clause.getClass(), nodesForclause);
        }
    }

    @Override
    public void caseAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        this.collectParams(node.getHeader());
        this.addMachineClauses(node.getMachineClauses());
    }

    @Override
    public void caseARefinementMachineParseUnit(ARefinementMachineParseUnit node) {
        this.collectParams(node.getHeader());
        this.addMachineClauses(node.getMachineClauses());
        this.refinement = true;
    }

    @Override
    public void caseAImplementationMachineParseUnit(AImplementationMachineParseUnit node) {
        this.collectParams(node.getHeader());
        this.addMachineClauses(node.getMachineClauses());
        this.refinement = true;
    }

    private boolean allLowerCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Map<Class<? extends Node>, Set<Node>> getAvailableClauses() {
        return this.availableClauses;
    }
}

