/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.prolog.INodeIds;
import de.be4.classicalb.core.parser.node.PDefinition;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockedDefinitions
extends IDefinitions {
    private final Map<String, IDefinitions.Type> types = new HashMap<String, IDefinitions.Type>();
    private final Map<String, Integer> arity = new HashMap<String, Integer>();

    public void addMockedDefinition(String name, String type, String parameterCount) {
        if ("predicate".equals(type)) {
            this.types.put(name, IDefinitions.Type.Predicate);
        } else if ("expression".equals(type)) {
            this.types.put(name, IDefinitions.Type.Expression);
        } else if ("substitution".equals(type)) {
            this.types.put(name, IDefinitions.Type.Substitution);
        } else {
            throw new IllegalArgumentException("Unknown definition type: " + type);
        }
        this.arity.put(name, Integer.parseInt(parameterCount));
    }

    public void addMockedDefinition(String name, IDefinitions.Type type, int parameterCount) {
        this.types.put(name, type);
        this.arity.put(name, parameterCount);
    }

    @Override
    public PDefinition getDefinition(String defName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, IDefinitions.Type> getTypes() {
        return this.types;
    }

    @Override
    public int getParameterCount(String defName) {
        return this.arity.get(defName);
    }

    @Override
    public IDefinitions.Type getType(String defName) {
        IDefinitions.Type type = this.types.get(defName);
        if (type == null) {
            return IDefinitions.Type.NoDefinition;
        }
        return type;
    }

    @Override
    public Set<String> getDefinitionNames() {
        return this.types.keySet();
    }

    @Override
    public void addDefinition(PDefinition defNode, IDefinitions.Type type, String defName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDefinitions(IDefinitions defs) {
        for (String d : defs.getDefinitionNames()) {
            this.addMockedDefinition(d, defs.getType(d), defs.getParameterCount(d));
        }
    }

    @Override
    public void assignIdsToNodes(INodeIds nodeIdMapping, List<File> machineFilesLoaded) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsDefinition(String defName) {
        return false;
    }

    @Override
    public void replaceDefinition(String defName, IDefinitions.Type type, PDefinition node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFile(String defName) {
        throw new UnsupportedOperationException();
    }
}

