/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.types;

import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.util.ASTBuilder;
import de.tla2b.exceptions.UnificationException;
import de.tla2b.output.TypeVisitorInterface;
import de.tla2b.types.AbstractHasFollowers;
import de.tla2b.types.FunctionType;
import de.tla2b.types.IntType;
import de.tla2b.types.TLAType;
import de.tla2b.types.TupleOrFunction;
import de.tla2b.types.UntypedType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TupleType
extends AbstractHasFollowers {
    private List<TLAType> types;

    public TupleType(List<TLAType> typeList) {
        super(TUPLE);
        this.setTypes(typeList);
    }

    public TupleType(int size) {
        this(IntStream.range(0, size).mapToObj(i -> new UntypedType()).collect(Collectors.toList()));
    }

    public List<TLAType> getTypes() {
        return new ArrayList<TLAType>(this.types);
    }

    public void setTypes(List<TLAType> types) {
        this.types = new ArrayList<TLAType>(types);
        for (TLAType tlaType : this.types) {
            if (!(tlaType instanceof AbstractHasFollowers)) continue;
            ((AbstractHasFollowers)tlaType).addFollower(this);
        }
    }

    public void update(TLAType oldType, TLAType newType) {
        for (int i = 0; i < this.types.size(); ++i) {
            TLAType t = this.types.get(i);
            if (oldType != t) continue;
            this.types.set(i, newType);
            if (!(newType instanceof AbstractHasFollowers)) continue;
            ((AbstractHasFollowers)newType).addFollower(this);
        }
    }

    @Override
    public boolean compare(TLAType o) {
        if (this.contains(o)) {
            return false;
        }
        if (o.getKind() == UNTYPED) {
            return true;
        }
        if (o instanceof TupleType) {
            TupleType t = (TupleType)o;
            if (this.types.size() != t.types.size()) {
                return false;
            }
            for (int i = 0; i < this.types.size(); ++i) {
                if (this.types.get(i).compare(t.types.get(i))) continue;
                return false;
            }
            return true;
        }
        if (o instanceof TupleOrFunction) {
            return o.compare(this);
        }
        return false;
    }

    @Override
    public boolean contains(TLAType o) {
        for (TLAType tlaType : this.types) {
            if (!tlaType.equals(o) && !tlaType.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUntyped() {
        for (TLAType tlaType : this.types) {
            if (!tlaType.isUntyped()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TLAType cloneTLAType() {
        ArrayList<TLAType> list = new ArrayList<TLAType>();
        for (TLAType tlaType : this.types) {
            list.add(tlaType.cloneTLAType());
        }
        return new TupleType(list);
    }

    @Override
    public TLAType unify(TLAType o) throws UnificationException {
        if (!this.compare(o)) {
            throw new UnificationException();
        }
        if (o instanceof UntypedType) {
            ((UntypedType)o).setFollowersTo(this);
            return this;
        }
        if (o instanceof TupleType) {
            TupleType tuple = (TupleType)o;
            for (int i = 0; i < this.types.size(); ++i) {
                TLAType res = this.types.get(i).unify(tuple.types.get(i));
                this.types.set(i, res);
                if (!(res instanceof AbstractHasFollowers)) continue;
                ((AbstractHasFollowers)res).addFollower(this);
            }
            return this;
        }
        if (o instanceof TupleOrFunction) {
            return o.unify(this);
        }
        throw new RuntimeException();
    }

    public String toString() {
        if (this.types.size() <= 1) {
            return new FunctionType(IntType.getInstance(), this.types.isEmpty() ? new UntypedType() : this.types.get(0).cloneTLAType()).toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.types.size(); ++i) {
            TLAType type = this.types.get(i);
            if (i != 0 && type instanceof TupleType && ((TupleType)type).types.size() > 1) {
                sb.append("(").append(this.types.get(i)).append(")");
            } else {
                sb.append(this.types.get(i));
            }
            if (i >= this.types.size() - 1) continue;
            sb.append("*");
        }
        return sb.toString();
    }

    @Override
    public PExpression getBNode() {
        if (this.types.isEmpty()) {
            throw new IllegalStateException("TupleType without types has no corresponding B node");
        }
        if (this.types.size() == 1) {
            return new FunctionType(IntType.getInstance(), this.types.get(0).cloneTLAType()).getBNode();
        }
        return ASTBuilder.createNestedMultOrCard(this.types.stream().map(TLAType::getBNode).collect(Collectors.toList()));
    }

    @Override
    public void apply(TypeVisitorInterface visitor) {
        visitor.caseTupleType(this);
    }
}

