/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.transforming;

import de.be4.classicalb.core.parser.analysis.OptimizedTraversingAdapter;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import java.util.ArrayList;
import java.util.List;

public final class CoupleToIdentifierTransformation
extends OptimizedTraversingAdapter {
    private static List<PExpression> tryLift(List<? extends Node> identifiers) {
        Node child;
        if (identifiers.size() == 1 && (child = identifiers.get(0)) instanceof ACoupleExpression) {
            return new ArrayList<PExpression>(((ACoupleExpression)child).getList());
        }
        return null;
    }

    @Override
    public void inAComprehensionSetExpression(AComprehensionSetExpression node) {
        List<PExpression> lifted = CoupleToIdentifierTransformation.tryLift(node.getIdentifiers());
        if (lifted != null) {
            node.setIdentifiers(lifted);
        }
    }

    @Override
    public void inASymbolicComprehensionSetExpression(ASymbolicComprehensionSetExpression node) {
        List<PExpression> lifted = CoupleToIdentifierTransformation.tryLift(node.getIdentifiers());
        if (lifted != null) {
            node.setIdentifiers(lifted);
        }
    }

    @Override
    public void inAEventBComprehensionSetExpression(AEventBComprehensionSetExpression node) {
        List<PExpression> lifted = CoupleToIdentifierTransformation.tryLift(node.getIdentifiers());
        if (lifted != null) {
            node.setIdentifiers(lifted);
        }
    }

    @Override
    public void inASymbolicEventBComprehensionSetExpression(ASymbolicEventBComprehensionSetExpression node) {
        List<PExpression> lifted = CoupleToIdentifierTransformation.tryLift(node.getIdentifiers());
        if (lifted != null) {
            node.setIdentifiers(lifted);
        }
    }
}

