/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.AAbstractConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceSubstitution;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AComputationOperation;
import de.be4.classicalb.core.parser.node.AConcatExpression;
import de.be4.classicalb.core.parser.node.AConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AConstructorFreetypeConstructor;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.ADefineSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADescriptionExpression;
import de.be4.classicalb.core.parser.node.AElementFreetypeConstructor;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AForLoopSubstitution;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AForallSubMessageSubstitution;
import de.be4.classicalb.core.parser.node.AFreetype;
import de.be4.classicalb.core.parser.node.AFreetypesMachineClause;
import de.be4.classicalb.core.parser.node.AFunctionOperation;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.ALetExpressionExpression;
import de.be4.classicalb.core.parser.node.ALetPredicatePredicate;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.AMachineHeader;
import de.be4.classicalb.core.parser.node.AOperationAttribute;
import de.be4.classicalb.core.parser.node.AOperationCallSubstitution;
import de.be4.classicalb.core.parser.node.AOperatorExpression;
import de.be4.classicalb.core.parser.node.AOperatorPredicate;
import de.be4.classicalb.core.parser.node.APredicateAttributeOperationAttribute;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.AReferencesMachineClause;
import de.be4.classicalb.core.parser.node.ARuleFailSubSubstitution;
import de.be4.classicalb.core.parser.node.ARuleOperation;
import de.be4.classicalb.core.parser.node.ASeesMachineClause;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASymbolicComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicLambdaExpression;
import de.be4.classicalb.core.parser.node.ASymbolicQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.AUsesMachineClause;
import de.be4.classicalb.core.parser.node.AVarSubstitution;
import de.be4.classicalb.core.parser.node.AWhileSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PFreetype;
import de.be4.classicalb.core.parser.node.PFreetypeConstructor;
import de.be4.classicalb.core.parser.node.POperationAttribute;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TIntegerLiteral;
import de.be4.classicalb.core.parser.node.TStringLiteral;
import de.be4.classicalb.core.parser.rules.AbstractOperation;
import de.be4.classicalb.core.parser.rules.ComputationOperation;
import de.be4.classicalb.core.parser.rules.FunctionOperation;
import de.be4.classicalb.core.parser.rules.RuleOperation;
import de.be4.classicalb.core.parser.util.ASTBuilder;
import de.be4.classicalb.core.parser.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RulesMachineChecker
extends DepthFirstAdapter {
    private String machineName;
    private final File file;
    private final Map<ARuleOperation, RuleOperation> rulesMap = new HashMap<ARuleOperation, RuleOperation>();
    private final Map<AComputationOperation, ComputationOperation> computationMap = new HashMap<AComputationOperation, ComputationOperation>();
    private final Map<AFunctionOperation, FunctionOperation> functionMap = new HashMap<AFunctionOperation, FunctionOperation>();
    private final List<CheckException> errorList = new ArrayList<CheckException>();
    private final Set<AIdentifierExpression> referencedRuleOperations = new HashSet<AIdentifierExpression>();
    private final List<Node> loopNodes = new ArrayList<Node>();
    private final KnownIdentifier knownIdentifier = new KnownIdentifier();
    private final LocalIdentifierScope identifierScope = new LocalIdentifierScope();
    private final Set<String> definitions = new HashSet<String>();
    private final Map<String, Set<Node>> readIdentifier = new HashMap<String, Set<Node>>();
    private final List<MachineReference> machineReferences;
    private AbstractOperation currentOperation;
    private final Map<RuleOperation, Set<Integer>> implementedErrorTypes = new HashMap<RuleOperation, Set<Integer>>();
    private final Start start;
    private TIdentifierLiteral nameLiteral;

    public RulesMachineChecker(File file, List<MachineReference> machineReferences, Start start) {
        this.file = file;
        this.machineReferences = machineReferences;
        this.start = start;
    }

    public void runChecks() throws BCompoundException {
        this.start.apply(this);
        if (!this.errorList.isEmpty()) {
            ArrayList<BException> bExceptionList = new ArrayList<BException>();
            String filePath = this.file == null ? null : this.file.getPath();
            for (CheckException checkException : this.errorList) {
                BException bException = new BException(filePath, checkException);
                bExceptionList.add(bException);
            }
            throw new BCompoundException(bExceptionList);
        }
    }

    public File getFile() {
        return this.file;
    }

    public Set<RuleOperation> getRuleOperations() {
        return new HashSet<RuleOperation>(this.rulesMap.values());
    }

    public TIdentifierLiteral getNameLiteral() {
        return this.nameLiteral;
    }

    public Set<AIdentifierExpression> getReferencedRuleOperations() {
        return new HashSet<AIdentifierExpression>(this.referencedRuleOperations);
    }

    public List<AbstractOperation> getOperations() {
        ArrayList<AbstractOperation> list = new ArrayList<AbstractOperation>();
        list.addAll(this.rulesMap.values());
        list.addAll(this.computationMap.values());
        list.addAll(this.functionMap.values());
        return list;
    }

    public RuleOperation getRuleOperation(ARuleOperation aRuleOperation) {
        return this.rulesMap.get(aRuleOperation);
    }

    public ComputationOperation getComputationOperation(AComputationOperation node) {
        return this.computationMap.get(node);
    }

    private boolean isNotInRule() {
        return this.currentOperation == null || !(this.currentOperation instanceof RuleOperation);
    }

    public FunctionOperation getFunctionOperation(AFunctionOperation funcOp) {
        return this.functionMap.get(funcOp);
    }

    public Set<String> getFunctionOperationNames() {
        HashSet<String> set = new HashSet<String>();
        for (FunctionOperation func : this.functionMap.values()) {
            set.add(func.getName());
        }
        return set;
    }

    public Map<String, Set<Node>> getUnknownIdentifier() {
        HashMap<String, Set<Node>> result = new HashMap<String, Set<Node>>();
        for (Map.Entry<String, Set<Node>> entry : this.readIdentifier.entrySet()) {
            String name = entry.getKey();
            Set<Node> nodes = entry.getValue();
            if (this.knownIdentifier.getKnownIdentifierNames().contains(name) || this.definitions.contains(name) || this.getFunctionOperationNames().contains(name)) continue;
            result.put(name, nodes);
        }
        return result;
    }

    public Set<String> getGlobalIdentifierNames() {
        return this.knownIdentifier.getKnownIdentifierNames();
    }

    public Set<TIdentifierLiteral> getGlobalIdentifiers() {
        return this.knownIdentifier.getKnownIdentifiers();
    }

    public Set<String> getDefinitionNames() {
        return this.definitions;
    }

    @Override
    public void caseAMachineHeader(AMachineHeader node) {
        LinkedList<TIdentifierLiteral> nameList;
        if (!node.getParameters().isEmpty()) {
            this.errorList.add(new CheckException("A RULES_MACHINE must not have any machine parameters", node));
        }
        if ((nameList = node.getName()).size() > 1) {
            this.errorList.add(new CheckException("Renaming of a RULES_MACHINE name is not allowed.", node));
        }
        this.nameLiteral = (TIdentifierLiteral)nameList.get(0);
        this.machineName = this.nameLiteral.getText();
        for (MachineReference machineReference : this.machineReferences) {
            if (!machineReference.getName().equals(this.machineName)) continue;
            this.errorList.add(new CheckException("The reference '" + machineReference.getName() + "' has the same name as the machine in which it is contained.", machineReference.getNode()));
        }
    }

    @Override
    public void caseAReferencesMachineClause(AReferencesMachineClause node) {
    }

    @Override
    public void caseAFreetypesMachineClause(AFreetypesMachineClause node) {
        ArrayList<PExpression> identifiers = new ArrayList<PExpression>();
        for (PFreetype freetype : node.getFreetypes()) {
            if (!(freetype instanceof AFreetype)) continue;
            AFreetype aFreetype = (AFreetype)freetype;
            identifiers.add(ASTBuilder.createIdentifier(aFreetype.getName()));
            for (PFreetypeConstructor freetypeConstructor : aFreetype.getConstructors()) {
                TIdentifierLiteral identifier;
                if (freetypeConstructor instanceof AElementFreetypeConstructor) {
                    identifier = ((AElementFreetypeConstructor)freetypeConstructor).getName();
                    identifiers.add(ASTBuilder.createIdentifier(identifier));
                    continue;
                }
                if (!(freetypeConstructor instanceof AConstructorFreetypeConstructor)) continue;
                identifier = ((AConstructorFreetypeConstructor)freetypeConstructor).getName();
                identifiers.add(ASTBuilder.createIdentifier(identifier));
            }
        }
        this.knownIdentifier.addKnownIdentifierList(identifiers);
    }

    @Override
    public void caseAAbstractConstantsMachineClause(AAbstractConstantsMachineClause node) {
        this.knownIdentifier.addKnownIdentifierList(node.getIdentifiers());
    }

    @Override
    public void caseAConstantsMachineClause(AConstantsMachineClause node) {
        this.knownIdentifier.addKnownIdentifierList(node.getIdentifiers());
    }

    @Override
    public void caseAEnumeratedSetSet(AEnumeratedSetSet node) {
        ArrayList<TIdentifierLiteral> copy = new ArrayList<TIdentifierLiteral>(node.getIdentifier());
        this.knownIdentifier.addKnownIdentifier((TIdentifierLiteral)copy.get(0));
        this.knownIdentifier.addKnownIdentifierList(new ArrayList<PExpression>(node.getElements()));
    }

    private void visitOperationAttributes(List<POperationAttribute> attributes) {
        OccurredAttributes occurredAttributes = new OccurredAttributes();
        for (POperationAttribute pOperationAttribute : attributes) {
            if (pOperationAttribute instanceof APredicateAttributeOperationAttribute) {
                this.checkOperationPredicateAttribute(occurredAttributes, pOperationAttribute);
                continue;
            }
            this.checkOperationExpressionAttribute(occurredAttributes, pOperationAttribute);
        }
    }

    private void checkOperationExpressionAttribute(OccurredAttributes occurredAttributes, POperationAttribute pOperationAttribute) throws AssertionError {
        AOperationAttribute attribute = (AOperationAttribute)pOperationAttribute;
        LinkedList<PExpression> arguments = attribute.getArguments();
        String name = attribute.getName().getText();
        occurredAttributes.add(name, pOperationAttribute);
        switch (name) {
            case "DEPENDS_ON_RULE": {
                this.checkDependsOnRuleAttribute(pOperationAttribute, arguments);
                return;
            }
            case "DEPENDS_ON_COMPUTATION": {
                this.checkDependsOnComputationAttribute(pOperationAttribute, arguments);
                return;
            }
            case "RULEID": {
                this.checkRuleIdAttribute(pOperationAttribute, arguments);
                return;
            }
            case "ERROR_TYPES": {
                this.checkErrorTypesAttribute(pOperationAttribute, arguments);
                return;
            }
            case "CLASSIFICATION": {
                this.checkClassificationAttribute(pOperationAttribute, arguments);
                return;
            }
            case "TAGS": {
                this.checkTagsAttribute(pOperationAttribute, arguments);
                return;
            }
            case "REPLACES": {
                this.checkReplacesAttribute(pOperationAttribute, arguments);
                return;
            }
        }
        throw new AssertionError((Object)("Unexpected operation attribute: " + name));
    }

    private void checkReplacesAttribute(POperationAttribute pOperationAttribute, List<PExpression> arguments) {
        if (arguments.size() != 1 || !(arguments.get(0) instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("Expected exactly one identifier after REPLACES.", pOperationAttribute));
            return;
        }
        AIdentifierExpression idExpr = (AIdentifierExpression)arguments.get(0);
        this.currentOperation.addReplacesIdentifier(idExpr);
    }

    private void checkTagsAttribute(POperationAttribute pOperationAttribute, List<PExpression> arguments) {
        ArrayList<String> tags = new ArrayList<String>();
        for (PExpression pExpression : arguments) {
            if (pExpression instanceof AIdentifierExpression) {
                AIdentifierExpression ident = (AIdentifierExpression)pExpression;
                String identifierAsString = Utils.getTIdentifierListAsString(ident.getIdentifier());
                tags.add(identifierAsString);
                continue;
            }
            if (pExpression instanceof AStringExpression) {
                AStringExpression stringExpr = (AStringExpression)pExpression;
                tags.add(stringExpr.getContent().getText());
                continue;
            }
            this.errorList.add(new CheckException("Expected identifier or string after the TAGS attribute.", pOperationAttribute));
        }
        this.currentOperation.addTags(tags);
    }

    private void checkClassificationAttribute(POperationAttribute pOperationAttribute, List<PExpression> arguments) {
        if (this.currentOperation instanceof RuleOperation) {
            RuleOperation rule = (RuleOperation)this.currentOperation;
            if (arguments.size() == 1 && arguments.get(0) instanceof AIdentifierExpression) {
                AIdentifierExpression identifier = (AIdentifierExpression)arguments.get(0);
                String identifierString = Utils.getTIdentifierListAsString(identifier.getIdentifier());
                rule.setClassification(identifierString);
            } else {
                this.errorList.add(new CheckException("Expected exactly one identifier after CLASSIFICATION.", pOperationAttribute));
            }
        } else {
            this.errorList.add(new CheckException("CLASSIFICATION is not an attribute of a FUNCTION or COMPUTATION operation.", pOperationAttribute));
        }
    }

    private void checkErrorTypesAttribute(POperationAttribute pOperationAttribute, List<PExpression> arguments) {
        if (this.currentOperation instanceof RuleOperation) {
            RuleOperation rule = (RuleOperation)this.currentOperation;
            if (arguments.size() == 1 && arguments.get(0) instanceof AIntegerExpression) {
                AIntegerExpression intExpr = (AIntegerExpression)arguments.get(0);
                rule.setErrorTypes(intExpr);
            } else {
                this.errorList.add(new CheckException("Expected exactly one integer after ERROR_TYPES.", pOperationAttribute));
            }
        } else {
            this.errorList.add(new CheckException("ERROR_TYPES is not an attribute of a FUNCTION or COMPUTATION operation.", pOperationAttribute));
        }
    }

    private void checkRuleIdAttribute(POperationAttribute pOperationAttribute, List<PExpression> arguments) {
        if (this.currentOperation instanceof RuleOperation) {
            RuleOperation rule = (RuleOperation)this.currentOperation;
            if (arguments.size() == 1 && arguments.get(0) instanceof AIdentifierExpression) {
                rule.setRuleId((AIdentifierExpression)arguments.get(0));
            } else {
                this.errorList.add(new CheckException("Expected exactly one identifier behind RULEID.", pOperationAttribute));
            }
        } else {
            this.errorList.add(new CheckException("RULEID is not an attribute of a FUNCTION or Computation operation.", pOperationAttribute));
        }
    }

    private void checkDependsOnComputationAttribute(POperationAttribute pOperationAttribute, List<PExpression> arguments) {
        ArrayList<AIdentifierExpression> list = new ArrayList<AIdentifierExpression>();
        for (PExpression pExpression : arguments) {
            if (pExpression instanceof AIdentifierExpression) {
                list.add((AIdentifierExpression)pExpression);
                continue;
            }
            this.errorList.add(new CheckException("Expected a list of identifiers after DEPENDS_ON_COMPUTATION.", pOperationAttribute));
        }
        this.currentOperation.addAllComputationDependencies(list);
    }

    private void checkDependsOnRuleAttribute(POperationAttribute pOperationAttribute, List<PExpression> arguments) {
        ArrayList<AIdentifierExpression> list = new ArrayList<AIdentifierExpression>();
        for (PExpression pExpression : arguments) {
            if (pExpression instanceof AIdentifierExpression) {
                list.add((AIdentifierExpression)pExpression);
                continue;
            }
            this.errorList.add(new CheckException("Expected a list of identifiers after DEPENDS_ON_RULE.", pOperationAttribute));
        }
        this.currentOperation.addAllRuleDependencies(list);
    }

    private void checkOperationPredicateAttribute(OccurredAttributes occurredAttributes, POperationAttribute pOperationAttribute) throws AssertionError {
        APredicateAttributeOperationAttribute attr = (APredicateAttributeOperationAttribute)pOperationAttribute;
        PPredicate predicate = attr.getPredicate();
        String attrName = attr.getName().getText();
        occurredAttributes.add(attrName, pOperationAttribute);
        switch (attrName) {
            case "ACTIVATION": {
                if (this.currentOperation instanceof FunctionOperation) {
                    this.errorList.add(new CheckException("ACTIVATION is not a valid attribute of a FUNCTION operation.", pOperationAttribute));
                    break;
                }
                this.currentOperation.setActivationPredicate(predicate);
                break;
            }
            case "PRECONDITION": {
                if (this.currentOperation instanceof FunctionOperation) {
                    FunctionOperation func = (FunctionOperation)this.currentOperation;
                    func.setPreconditionPredicate(predicate);
                    break;
                }
                this.errorList.add(new CheckException("PRECONDITION clause is not allowed for a RULE or COMPUTATION operation.", pOperationAttribute));
                break;
            }
            case "POSTCONDITION": {
                if (this.currentOperation instanceof RuleOperation) {
                    this.errorList.add(new CheckException("POSTCONDITION attribute is not allowed for a RULE operation", pOperationAttribute));
                    break;
                }
                this.currentOperation.setPostcondition(predicate);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected operation attribute: " + attrName));
            }
        }
        predicate.apply(this);
    }

    private boolean containsRule(String name) {
        for (RuleOperation rule : this.rulesMap.values()) {
            if (!name.equals(rule.getOriginalName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void caseARuleOperation(ARuleOperation node) {
        this.currentOperation = new RuleOperation(node.getRuleName(), this.file == null ? null : this.file.getPath(), this.machineName, this.machineReferences);
        if (this.containsRule(this.currentOperation.getOriginalName())) {
            this.errorList.add(new CheckException("Duplicate operation name '" + this.currentOperation.getOriginalName() + "'.", node.getRuleName()));
        }
        RuleOperation ruleOp = (RuleOperation)this.currentOperation;
        this.rulesMap.put(node, ruleOp);
        this.visitOperationAttributes(node.getAttributes());
        node.getRuleBody().apply(this);
        this.checkAllErrorTypesImplemented(ruleOp);
        this.currentOperation = null;
    }

    private void checkAllErrorTypesImplemented(RuleOperation ruleOp) {
        Set<Integer> implemented = this.implementedErrorTypes.get(ruleOp);
        for (int i = 1; i <= ruleOp.getNumberOfErrorTypes(); ++i) {
            if (implemented != null && implemented.contains(i)) continue;
            this.errorList.add(new CheckException(String.format("Error type '%s' is not implemented in rule '%s'.", i, ruleOp.getOriginalName()), ruleOp.getNameLiteral()));
        }
    }

    @Override
    public void caseAComputationOperation(AComputationOperation node) {
        this.currentOperation = new ComputationOperation(node.getName(), this.file == null ? null : this.file.getPath(), this.machineName, this.machineReferences);
        this.computationMap.put(node, (ComputationOperation)this.currentOperation);
        this.visitOperationAttributes(node.getAttributes());
        node.getBody().apply(this);
        this.currentOperation = null;
    }

    @Override
    public void caseAFunctionOperation(AFunctionOperation node) {
        this.currentOperation = new FunctionOperation(node.getName(), this.file == null ? null : this.file.getPath(), this.machineName, this.machineReferences);
        this.functionMap.put(node, (FunctionOperation)this.currentOperation);
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getParameters()));
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getReturnValues()), true);
        this.visitOperationAttributes(node.getAttributes());
        node.getBody().apply(this);
        this.currentOperation = null;
        this.identifierScope.removeScope();
    }

    @Override
    public void outADefineSubstitution(ADefineSubstitution node) {
        if (this.currentOperation != null && this.currentOperation instanceof ComputationOperation) {
            ComputationOperation computationOperation = (ComputationOperation)this.currentOperation;
            try {
                computationOperation.addDefineVariable(node.getName());
                this.knownIdentifier.addKnownIdentifier(node.getName());
            }
            catch (CheckException e) {
                this.errorList.add(e);
            }
        }
        if (!this.loopNodes.isEmpty()) {
            this.errorList.add(new CheckException("A DEFINE substitution must not be contained in a loop substitution.", node));
        }
    }

    @Override
    public void caseAVarSubstitution(AVarSubstitution node) {
        HashSet<String> variables = new HashSet<String>();
        LinkedList<PExpression> identifiers = node.getIdentifiers();
        for (PExpression e : identifiers) {
            if (e instanceof AIdentifierExpression) {
                AIdentifierExpression id = (AIdentifierExpression)e;
                String name = id.getIdentifier().get(0).getText();
                variables.add(name);
                continue;
            }
            this.errorList.add(new CheckException("There must be a list of identifiers in VAR substitution.", node));
        }
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()), true);
        node.getSubstitution().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAOperatorExpression(AOperatorExpression node) {
        String operatorName = node.getName().getText();
        LinkedList<PExpression> parameters = node.getIdentifiers();
        switch (operatorName) {
            case "STRING_FORMAT": {
                this.checkStringFormatOperator(node, parameters);
                return;
            }
            case "GET_RULE_COUNTEREXAMPLES": {
                this.checkGetRuleCounterExamplesOperator(node, parameters);
                return;
            }
        }
        throw new AssertionError((Object)("Unknown expression operator: " + operatorName));
    }

    private void checkStringFormatOperator(AOperatorExpression node, List<PExpression> parameters) {
        PExpression firstParam = parameters.get(0);
        Integer count = this.countPlaceHoldersInExpression(firstParam);
        if (count != null && count != parameters.size() - 1) {
            this.errorList.add(new CheckException("The number of arguments (" + (parameters.size() - 1) + ") does not match the number of placeholders (" + count + ") in the string.", node));
        }
        LinkedList<PExpression> identifiers = node.getIdentifiers();
        for (PExpression pExpression : identifiers) {
            pExpression.apply(this);
        }
    }

    private Integer countPlaceHoldersInExpression(PExpression param) {
        if (param instanceof AConcatExpression) {
            AConcatExpression con = (AConcatExpression)param;
            Integer left = this.countPlaceHoldersInExpression(con.getLeft());
            Integer right = this.countPlaceHoldersInExpression(con.getRight());
            if (left == null || right == null) {
                return null;
            }
            return left + right;
        }
        if (param instanceof AStringExpression) {
            AStringExpression string = (AStringExpression)param;
            String content = string.getContent().getText();
            String subString = "~w";
            return this.countOccurrences(content, subString);
        }
        return null;
    }

    private int countOccurrences(String content, String subString) {
        int subStringLength = subString.length();
        return (content.length() - content.replace(subString, "").length()) / subStringLength;
    }

    private void checkGetRuleCounterExamplesOperator(AOperatorExpression node, List<PExpression> parameters) {
        PExpression pExpression;
        if (parameters.size() > 2) {
            this.errorList.add(new CheckException("Invalid number of arguments. Expected one or two arguments.", node));
        }
        if (!((pExpression = node.getIdentifiers().get(0)) instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The first argument of GET_RULE_COUNTEREXAMPLES must be an identifier.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)pExpression);
    }

    @Override
    public void inAAssignSubstitution(AAssignSubstitution node) {
        ArrayList<PExpression> righthand = new ArrayList<PExpression>(node.getRhsExpressions());
        for (PExpression pExpression : righthand) {
            pExpression.apply(this);
        }
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getLhsExpression());
        this.checkThatIdentifiersAreLocalVariables(copy);
    }

    @Override
    public void inAOperationCallSubstitution(AOperationCallSubstitution node) {
        LinkedList<TIdentifierLiteral> opNameList = node.getOperation();
        if (opNameList.size() > 1) {
            this.errorList.add(new CheckException("Renaming of operation names is not allowed.", node));
        }
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getResultIdentifiers());
        this.checkThatIdentifiersAreLocalVariables(copy);
        if (this.currentOperation != null) {
            this.currentOperation.addFunctionCall((TIdentifierLiteral)opNameList.get(0));
        }
    }

    private void checkThatIdentifiersAreLocalVariables(List<PExpression> identifiers) {
        for (PExpression e : identifiers) {
            if (e instanceof AIdentifierExpression) {
                AIdentifierExpression id = (AIdentifierExpression)e;
                String name = id.getIdentifier().get(0).getText();
                if (this.identifierScope.isAssignableVariable(name)) continue;
                this.errorList.add(new CheckException("Identifier '" + name + "' is not a local variable (VAR). Hence, it can not be assigned here.", id));
                continue;
            }
            this.errorList.add(new CheckException("There must be an identifier on the left side of the assign substitution. A function assignment 'f(1) := 1' is also not permitted.", e));
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        ArrayList<TIdentifierLiteral> copy = new ArrayList<TIdentifierLiteral>(node.getIdentifier());
        if (copy.size() > 1) {
            this.errorList.add(new CheckException("Identifier renaming is not allowed in a RULES_MACHINE.", node));
        }
        String name = ((TIdentifierLiteral)copy.get(0)).getText();
        if (this.currentOperation != null) {
            this.currentOperation.addReadVariable(node);
        }
        if (!this.identifierScope.contains(name)) {
            this.addReadIdentifier(node);
        }
    }

    private void addReadIdentifier(AIdentifierExpression node) {
        LinkedList<TIdentifierLiteral> list = node.getIdentifier();
        String name = ((TIdentifierLiteral)list.get(0)).getText();
        if (this.readIdentifier.containsKey(name)) {
            Set<Node> hashSet = this.readIdentifier.get(name);
            hashSet.add(node);
        } else {
            HashSet<AIdentifierExpression> hashSet = new HashSet<AIdentifierExpression>();
            hashSet.add(node);
            this.readIdentifier.put(name, hashSet);
        }
    }

    @Override
    public void caseAOperatorPredicate(AOperatorPredicate node) {
        String operatorName;
        ArrayList<PExpression> arguments = new ArrayList<PExpression>(node.getIdentifiers());
        switch (operatorName = node.getName().getText()) {
            case "SUCCEEDED_RULE": {
                this.checkSucceededRuleOperator(node, arguments);
                return;
            }
            case "SUCCEEDED_RULE_ERROR_TYPE": {
                this.checkSucceededRuleErrorTypeOperator(node, arguments);
                return;
            }
            case "FAILED_RULE": {
                this.checkFailedRuleOperator(node, arguments);
                return;
            }
            case "FAILED_RULE_ALL_ERROR_TYPES": {
                this.checkFailedRuleAllErrorTypesOperator(node, arguments);
                return;
            }
            case "FAILED_RULE_ERROR_TYPE": {
                this.checkFailedRuleErrorTypeOperator(node, arguments);
                return;
            }
            case "NOT_CHECKED_RULE": {
                this.checkNotCheckedRuleOperator(node, arguments);
                return;
            }
            case "DISABLED_RULE": {
                this.checkDisabledRuleOperator(node, arguments);
                return;
            }
        }
        throw new AssertionError((Object)("Unsupported predicate operator: " + operatorName));
    }

    private void checkDisabledRuleOperator(AOperatorPredicate node, List<PExpression> arguments) {
        if (arguments.size() != 1 && !(arguments.get(0) instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The DISABLED_RULE predicate operator expects exactly one rule identifier.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)arguments.get(0));
    }

    private void checkNotCheckedRuleOperator(AOperatorPredicate node, List<PExpression> arguments) {
        if (arguments.size() != 1 && !(arguments.get(0) instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The NOT_CHECKED_RULE predicate operator expects exactly one rule identifier.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)arguments.get(0));
    }

    private void checkFailedRuleErrorTypeOperator(AOperatorPredicate node, List<PExpression> arguments) {
        if (arguments.size() != 2) {
            this.errorList.add(new CheckException("The FAILED_RULE_ERROR_TYPE predicate operator expects exactly two arguments.", node));
            return;
        }
        PExpression pExpression = node.getIdentifiers().get(0);
        if (!(pExpression instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The first argument of FAILED_RULE_ERROR_TYPE must be an identifier.", node));
            return;
        }
        PExpression secondArg = node.getIdentifiers().get(1);
        if (!(secondArg instanceof AIntegerExpression)) {
            this.errorList.add(new CheckException("The second argument of FAILED_RULE_ERROR_TYPE must be an integer literal.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)arguments.get(0));
    }

    private void checkFailedRuleAllErrorTypesOperator(AOperatorPredicate node, List<PExpression> arguments) {
        if (arguments.size() != 1 && !(arguments.get(0) instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The FAILED_RULE_ALL_ERROR_TYPES predicate operator expects exactly one rule identifier.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)arguments.get(0));
    }

    private void checkFailedRuleOperator(AOperatorPredicate node, List<PExpression> arguments) {
        if (arguments.size() != 1 && !(arguments.get(0) instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The FAILED_RULE predicate operator expects exactly one rule identifier.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)arguments.get(0));
    }

    private void checkSucceededRuleOperator(AOperatorPredicate node, List<PExpression> arguments) {
        if (arguments.size() != 1 || !(arguments.get(0) instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The SUCCEEDED_RULE predicate operator expects exactly one rule identifier.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)arguments.get(0));
    }

    private void checkSucceededRuleErrorTypeOperator(AOperatorPredicate node, List<PExpression> arguments) {
        if (arguments.size() != 2) {
            this.errorList.add(new CheckException("The SUCCEEDED_RULE_ERROR_TYPE predicate operator expects exactly two arguments.", node));
            return;
        }
        PExpression pExpression = node.getIdentifiers().get(0);
        if (!(pExpression instanceof AIdentifierExpression)) {
            this.errorList.add(new CheckException("The first argument of SUCCEEDED_RULE_ERROR_TYPE must be an identifier.", node));
            return;
        }
        PExpression secondArg = node.getIdentifiers().get(1);
        if (!(secondArg instanceof AIntegerExpression)) {
            this.errorList.add(new CheckException("The second argument of SUCCEEDED_RULE_ERROR_TYPE must be an integer value.", node));
            return;
        }
        this.referencedRuleOperations.add((AIdentifierExpression)arguments.get(0));
    }

    @Override
    public void caseARuleFailSubSubstitution(ARuleFailSubSubstitution node) {
        if (this.isNotInRule()) {
            this.errorList.add(new CheckException("RULE_FAIL used outside of a RULE operation.", node));
            return;
        }
        this.checkErrorType(node.getErrorType());
        if (!node.getIdentifiers().isEmpty() && node.getWhen() == null) {
            this.errorList.add(new CheckException("The WHEN predicate must be provided if RULE_FAIL has at least one parameter.", node));
            return;
        }
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        if (node.getWhen() != null) {
            if (!node.getIdentifiers().isEmpty()) {
                this.checkTopLevelPredicate(node.getWhen(), "(WHEN predicate in RULE_FAIL)");
            }
            node.getWhen().apply(this);
        }
        node.getMessage().apply(this);
        this.identifierScope.removeScope();
    }

    public void checkTopLevelPredicate(PPredicate node, String text) {
        if (node instanceof AImplicationPredicate) {
            this.errorList.add(new CheckException("Implication is not allowed as the top level predicate " + text + ".", node));
        }
    }

    @Override
    public void caseAForallSubMessageSubstitution(AForallSubMessageSubstitution node) {
        if (this.isNotInRule()) {
            this.errorList.add(new CheckException("RULE_FORALL used outside of a RULE operation.", node));
            return;
        }
        this.checkTopLevelPredicate(node.getWhere(), "(WHERE predicate in RULE_FORALL)");
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getWhere().apply(this);
        node.getExpect().apply(this);
        if (node.getOnSuccess() != null) {
            node.getOnSuccess().apply(this);
        }
        node.getMessage().apply(this);
        this.identifierScope.removeScope();
        this.checkErrorType(node.getErrorType());
    }

    private void checkErrorType(TIntegerLiteral node) {
        if (!(this.currentOperation instanceof RuleOperation)) {
            return;
        }
        RuleOperation ruleOp = (RuleOperation)this.currentOperation;
        if (node != null) {
            int errorType = Integer.parseInt(node.getText());
            if (errorType > ruleOp.getNumberOfErrorTypes()) {
                this.errorList.add(new CheckException("The error type exceeded the number of error types specified for this rule operation.", node));
            } else if (errorType < 1) {
                this.errorList.add(new CheckException("The ERROR_TYPE must be a natural number greater than zero.", node));
            } else {
                this.addImplementedErrorType(ruleOp, errorType);
            }
        } else {
            this.addImplementedErrorType(ruleOp, 1);
        }
    }

    private void addImplementedErrorType(RuleOperation ruleOp, int errorType) {
        if (this.implementedErrorTypes.containsKey(ruleOp)) {
            Set<Integer> set = this.implementedErrorTypes.get(ruleOp);
            set.add(errorType);
        } else {
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(errorType);
            this.implementedErrorTypes.put(ruleOp, set);
        }
    }

    @Override
    public void inAWhileSubstitution(AWhileSubstitution node) {
        this.loopNodes.add(node);
    }

    @Override
    public void outAWhileSubstitution(AWhileSubstitution node) {
        this.loopNodes.remove(node);
    }

    @Override
    public void caseAForLoopSubstitution(AForLoopSubstitution node) {
        this.loopNodes.add(node);
        node.getSet().apply(this);
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getDoSubst().apply(this);
        this.identifierScope.removeScope();
        this.loopNodes.remove(node);
    }

    @Override
    public void caseALetSubstitution(ALetSubstitution node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicate().apply(this);
        node.getSubstitution().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseALetPredicatePredicate(ALetPredicatePredicate node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getAssignment().apply(this);
        node.getPred().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseALetExpressionExpression(ALetExpressionExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getAssignment().apply(this);
        node.getExpr().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAGeneralProductExpression(AGeneralProductExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAGeneralSumExpression(AGeneralSumExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseASymbolicQuantifiedUnionExpression(ASymbolicQuantifiedUnionExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseASymbolicComprehensionSetExpression(ASymbolicComprehensionSetExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseASymbolicEventBComprehensionSetExpression(ASymbolicEventBComprehensionSetExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAEventBComprehensionSetExpression(AEventBComprehensionSetExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseASymbolicLambdaExpression(ASymbolicLambdaExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicate().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseALambdaExpression(ALambdaExpression node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicate().apply(this);
        node.getExpression().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAExistsPredicate(AExistsPredicate node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getPredicate().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAForallPredicate(AForallPredicate node) {
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getIdentifiers()));
        node.getImplication().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        String name = node.getName().getText();
        this.definitions.add(name);
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getParameters()));
        node.getRhs().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        String name = node.getName().getText();
        this.definitions.add(name);
        if ("GOAL".equals(name)) {
            this.errorList.add(new CheckException("The GOAL definition must be a predicate.", node));
            return;
        }
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getParameters()));
        node.getRhs().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        String name = node.getName().getText();
        this.definitions.add(name);
        if ("GOAL".equals(name)) {
            this.errorList.add(new CheckException("The GOAL definition must be a predicate.", node));
            return;
        }
        this.identifierScope.createNewScope(new ArrayList<PExpression>(node.getParameters()));
        node.getRhs().apply(this);
        this.identifierScope.removeScope();
    }

    @Override
    public void caseADefinitionExpression(ADefinitionExpression node) {
        node.getDefLiteral().apply(this);
        String defName = node.getDefLiteral().getText();
        if ("READ_XML_FROM_STRING".equals(defName)) {
            if (node.getParameters().size() != 1) {
                this.errorList.add(new CheckException("The external function 'READ_XML_FROM_STRING' requires exactly one argument.", node));
                return;
            }
            PExpression pExpression = node.getParameters().get(0);
            if (pExpression instanceof AStringExpression) {
                AStringExpression aStringExpr = (AStringExpression)pExpression;
                TStringLiteral content = aStringExpr.getContent();
                String text = content.getText();
                int xmlStartIndex = text.indexOf("<?");
                if (xmlStartIndex == -1) {
                    return;
                }
                String testString = text.substring(0, xmlStartIndex);
                int numberOfNewLines = testString.length() - testString.replace("\n", "").length();
                try {
                    InputSource inputSource = new InputSource(new StringReader(text.trim()));
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    Locale.setDefault(Locale.UK);
                    saxParser.setProperty("http://apache.org/xml/properties/locale", Locale.UK);
                    saxParser.parse(inputSource, new DefaultHandler());
                }
                catch (SAXParseException e) {
                    int line = content.getLine() + numberOfNewLines + e.getLineNumber() - 1;
                    int column = numberOfNewLines == 0 && e.getLineNumber() == 1 ? content.getPos() + e.getColumnNumber() : e.getColumnNumber();
                    TStringLiteral dummy = new TStringLiteral("", line, column);
                    String message = e.getMessage();
                    this.errorList.add(new CheckException(message, dummy, (Throwable)e));
                }
                catch (SAXException e) {
                    String message = e.getMessage();
                    this.errorList.add(new CheckException(message, aStringExpr, (Throwable)e));
                }
                catch (IOException | ParserConfigurationException exception) {
                    // empty catch block
                }
            }
        }
        super.caseADefinitionExpression(node);
    }

    @Override
    public void caseAChoiceSubstitution(AChoiceSubstitution node) {
        this.errorList.add(new CheckException("A CHOICE substitution is not allowed in a RULES_MACHINE.", node));
    }

    @Override
    public void caseASeesMachineClause(ASeesMachineClause node) {
        this.errorList.add(new CheckException("The SEES clause is not allowed in a RULES_MACHINE.", node));
    }

    @Override
    public void caseAUsesMachineClause(AUsesMachineClause node) {
        this.errorList.add(new CheckException("The USES clause is not allowed in a RULES_MACHINE.", node));
    }

    @Override
    public void caseAAnySubstitution(AAnySubstitution node) {
        this.errorList.add(new CheckException("The ANY substitution is not allowed in a RULES_MACHINE.", node));
    }

    @Override
    public void caseABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        this.errorList.add(new CheckException("The BecomesElementOf substitution (a,b:(P)) is not allowed in a RULES_MACHINE.", node));
    }

    @Override
    public void caseADeferredSetSet(ADeferredSetSet node) {
        this.errorList.add(new CheckException("Deferred sets are not allowed in a RULES_MACHINE.", node));
    }

    static class Scope {
        final Set<String> identifiers;
        final boolean assignable;

        Scope(Set<String> identifiers, boolean assignable) {
            this.identifiers = identifiers;
            this.assignable = assignable;
        }
    }

    class LocalIdentifierScope {
        private final LinkedList<Scope> localVariablesScope = new LinkedList();

        LocalIdentifierScope() {
        }

        public void createNewScope(List<PExpression> parameters) {
            this.createNewScope(parameters, false);
        }

        public void createNewScope(List<PExpression> parameters, boolean assignable) {
            HashSet<String> set = new HashSet<String>();
            for (PExpression expression : parameters) {
                if (expression instanceof AIdentifierExpression) {
                    AIdentifierExpression identifier = (AIdentifierExpression)expression;
                    TIdentifierLiteral tIdentifierLiteral = identifier.getIdentifier().getFirst();
                    String identifierName = tIdentifierLiteral.getText();
                    set.add(identifierName);
                    continue;
                }
                RulesMachineChecker.this.errorList.add(new CheckException("Identifier expected.", expression));
            }
            this.localVariablesScope.add(new Scope(set, assignable));
        }

        public void removeScope() {
            this.localVariablesScope.removeLast();
        }

        public boolean contains(String identifier) {
            return this.contains(identifier, false);
        }

        public boolean isAssignableVariable(String name) {
            return this.contains(name, true);
        }

        public boolean contains(String identifier, boolean checkAssignable) {
            for (int i = this.localVariablesScope.size() - 1; i >= 0; --i) {
                Scope scope = this.localVariablesScope.get(i);
                if (!scope.identifiers.contains(identifier)) continue;
                if (checkAssignable) {
                    return scope.assignable;
                }
                return true;
            }
            return false;
        }
    }

    class KnownIdentifier {
        final Map<String, TIdentifierLiteral> knownIdentifiers = new HashMap<String, TIdentifierLiteral>();

        KnownIdentifier() {
        }

        public void addKnownIdentifierList(List<PExpression> parameters) {
            for (PExpression pExpression : parameters) {
                this.addKnownIdentifier(pExpression);
            }
        }

        public void addKnownIdentifier(TIdentifierLiteral identifier) {
            this.knownIdentifiers.put(identifier.getText(), identifier);
        }

        public Set<String> getKnownIdentifierNames() {
            return new HashSet<String>(this.knownIdentifiers.keySet());
        }

        public Set<TIdentifierLiteral> getKnownIdentifiers() {
            return new HashSet<TIdentifierLiteral>(this.knownIdentifiers.values());
        }

        public void addKnownIdentifier(PExpression expression) {
            if (expression instanceof ADescriptionExpression) {
                this.addKnownIdentifier(((ADescriptionExpression)expression).getExpression());
            } else if (expression instanceof AIdentifierExpression) {
                AIdentifierExpression identifier = (AIdentifierExpression)expression;
                LinkedList<TIdentifierLiteral> list = identifier.getIdentifier();
                TIdentifierLiteral tIdentifierLiteral = (TIdentifierLiteral)list.get(0);
                String constantName = tIdentifierLiteral.getText();
                if (this.knownIdentifiers.containsKey(constantName)) {
                    RulesMachineChecker.this.errorList.add(new CheckException("Identifier already exists.", expression));
                    return;
                }
                this.knownIdentifiers.put(constantName, tIdentifierLiteral);
            } else {
                RulesMachineChecker.this.errorList.add(new CheckException("Identifier expected.", expression));
            }
        }
    }

    class OccurredAttributes {
        final Map<String, POperationAttribute> map = new HashMap<String, POperationAttribute>();

        OccurredAttributes() {
        }

        public void add(String attrName, POperationAttribute node) {
            if (this.map.containsKey(attrName)) {
                RulesMachineChecker.this.errorList.add(new CheckException(String.format("%s clause is used more than once in operation '%s'.", attrName, RulesMachineChecker.this.currentOperation.getOriginalName()), node));
            }
            this.map.put(attrName, node);
        }
    }
}

