/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import tlc2.output.AbstractSpecWriter;
import tlc2.output.SpecWriterUtilities;

public class TraceExpressionExplorerSpecWriter
extends AbstractSpecWriter {
    private static final String EXPRESSION_VARIABLE_NAME_PREFIX = "_traceExpression_";
    private static final String EXPRESSION_COMMENT_LINE_PREFIX = "\\*  TRACE EXPRESSION: ";
    private static final String TE_INIT_ID = "_TEInit";
    private static final String TE_INIT_ATTRIBUTE_NAME = "teBehaviorInit";
    private static final String TE_NEXT_ID = "_TENext";
    private static final String TE_NEXT_ATTRIBUTE_NAME = "teBehaviorNext";
    private final TreeMap<String, String> variableExpressionMap = new TreeMap();

    public static HashMap<String, String> getVariableExpressionMapFromTLAFile(File tlaFile) throws IOException {
        if (tlaFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(tlaFile));){
                String line;
                ArrayList<String> declarations = new ArrayList<String>();
                boolean foundLine = true;
                while (foundLine && (line = br.readLine()) != null) {
                    if (line.startsWith(EXPRESSION_COMMENT_LINE_PREFIX)) {
                        declarations.add(line.substring(EXPRESSION_COMMENT_LINE_PREFIX.length()));
                        continue;
                    }
                    foundLine = false;
                }
                if (declarations.size() > 0) {
                    HashMap<String, String> variableExpressionMap = new HashMap<String, String>();
                    for (String declaration : declarations) {
                        int index = declaration.indexOf(" = ");
                        if (index == -1) continue;
                        String variable = declaration.substring(0, index);
                        String expression = declaration.substring(index + " = ".length());
                        variableExpressionMap.put(variable, expression);
                    }
                    HashMap<String, String> hashMap = variableExpressionMap;
                    return hashMap;
                }
            }
        }
        return null;
    }

    TraceExpressionExplorerSpecWriter(List<String> expressions) {
        super(true);
        int count = 1;
        for (String expression : expressions) {
            String key = EXPRESSION_VARIABLE_NAME_PREFIX + count;
            this.variableExpressionMap.put(key, expression);
            this.tlaBuffer.append(EXPRESSION_COMMENT_LINE_PREFIX).append(key).append(" = ");
            this.tlaBuffer.append(expression).append("\n");
            ++count;
        }
        this.addPrimer("TE", "SpecTE");
        this.declareExpressionVariables();
        this.createInitNextWithExpressions();
        this.tlaBuffer.append((CharSequence)SpecWriterUtilities.getGeneratedTimeStampCommentLine()).append("\n");
    }

    StringBuilder getConfigBuffer() {
        return this.cfgBuffer;
    }

    private void declareExpressionVariables() {
        this.tlaBuffer.append("VARIABLES ");
        boolean notFirst = false;
        for (String variable : this.variableExpressionMap.keySet()) {
            if (notFirst) {
                this.tlaBuffer.append(", ");
            } else {
                notFirst = true;
            }
            this.tlaBuffer.append(variable);
        }
        this.tlaBuffer.append("\n").append("\n");
    }

    private void createInitNextWithExpressions() {
        StringBuilder initConjunction = new StringBuilder("    /\\ ");
        initConjunction.append("_SpecTEInit").append("\n");
        this.addExpressionsToBuffer(initConjunction, false);
        List<String[]> initContent = SpecWriterUtilities.createSourceContent(initConjunction.toString(), TE_INIT_ID, false);
        this.addFormulaList(initContent, "INIT", TE_INIT_ATTRIBUTE_NAME);
        StringBuilder nextConjunction = new StringBuilder("    /\\ ");
        nextConjunction.append("_SpecTENext").append("\n");
        this.addExpressionsToBuffer(nextConjunction, true);
        List<String[]> nextContent = SpecWriterUtilities.createSourceContent(nextConjunction.toString(), TE_NEXT_ID, false);
        this.addFormulaList(nextContent, "NEXT", TE_NEXT_ATTRIBUTE_NAME);
    }

    private void addExpressionsToBuffer(StringBuilder buffer, boolean primed) {
        for (Map.Entry<String, String> me : this.variableExpressionMap.entrySet()) {
            buffer.append("    /\\ ").append(me.getKey());
            if (primed) {
                buffer.append("'");
            }
            buffer.append(" = ");
            buffer.append("(").append(me.getValue()).append(")");
            buffer.append("\n");
        }
    }
}

