/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.prettyprint;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAddExpression;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssertionSubstitution;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.ABoolSetExpression;
import de.be4.classicalb.core.parser.node.ABooleanFalseExpression;
import de.be4.classicalb.core.parser.node.ABooleanTrueExpression;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.ACartesianProductExpression;
import de.be4.classicalb.core.parser.node.AChoiceSubstitution;
import de.be4.classicalb.core.parser.node.AClosureExpression;
import de.be4.classicalb.core.parser.node.ACompositionExpression;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AConcatExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConvertBoolExpression;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADirectProductExpression;
import de.be4.classicalb.core.parser.node.ADisjunctPredicate;
import de.be4.classicalb.core.parser.node.ADivExpression;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.ADomainRestrictionExpression;
import de.be4.classicalb.core.parser.node.ADomainSubtractionExpression;
import de.be4.classicalb.core.parser.node.AEmptySequenceExpression;
import de.be4.classicalb.core.parser.node.AEmptySetExpression;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AEquivalencePredicate;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AFin1SubsetExpression;
import de.be4.classicalb.core.parser.node.AFinSubsetExpression;
import de.be4.classicalb.core.parser.node.AFirstExpression;
import de.be4.classicalb.core.parser.node.AFirstProjectionExpression;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AFrontExpression;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AGeneralConcatExpression;
import de.be4.classicalb.core.parser.node.AGeneralIntersectionExpression;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AGeneralUnionExpression;
import de.be4.classicalb.core.parser.node.AGreaterEqualPredicate;
import de.be4.classicalb.core.parser.node.AGreaterPredicate;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIdentityExpression;
import de.be4.classicalb.core.parser.node.AIfElsifExprExpression;
import de.be4.classicalb.core.parser.node.AIfElsifSubstitution;
import de.be4.classicalb.core.parser.node.AIfSubstitution;
import de.be4.classicalb.core.parser.node.AIfThenElseExpression;
import de.be4.classicalb.core.parser.node.AImageExpression;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.AInsertFrontExpression;
import de.be4.classicalb.core.parser.node.AInsertTailExpression;
import de.be4.classicalb.core.parser.node.AIntSetExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AIntegerSetExpression;
import de.be4.classicalb.core.parser.node.AIntersectionExpression;
import de.be4.classicalb.core.parser.node.AIntervalExpression;
import de.be4.classicalb.core.parser.node.AIseq1Expression;
import de.be4.classicalb.core.parser.node.AIseqExpression;
import de.be4.classicalb.core.parser.node.AIterationExpression;
import de.be4.classicalb.core.parser.node.ALabelPredicate;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.ALastExpression;
import de.be4.classicalb.core.parser.node.ALessEqualPredicate;
import de.be4.classicalb.core.parser.node.ALessPredicate;
import de.be4.classicalb.core.parser.node.ALetExpressionExpression;
import de.be4.classicalb.core.parser.node.ALetPredicatePredicate;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.AMachineHeader;
import de.be4.classicalb.core.parser.node.AMaxExpression;
import de.be4.classicalb.core.parser.node.AMaxIntExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.AMinExpression;
import de.be4.classicalb.core.parser.node.AMinIntExpression;
import de.be4.classicalb.core.parser.node.AMinusOrSetSubtractExpression;
import de.be4.classicalb.core.parser.node.AModuloExpression;
import de.be4.classicalb.core.parser.node.AMultOrCartExpression;
import de.be4.classicalb.core.parser.node.ANat1SetExpression;
import de.be4.classicalb.core.parser.node.ANatSetExpression;
import de.be4.classicalb.core.parser.node.ANatural1SetExpression;
import de.be4.classicalb.core.parser.node.ANaturalSetExpression;
import de.be4.classicalb.core.parser.node.ANegationPredicate;
import de.be4.classicalb.core.parser.node.ANotEqualPredicate;
import de.be4.classicalb.core.parser.node.ANotMemberPredicate;
import de.be4.classicalb.core.parser.node.ANotSubsetPredicate;
import de.be4.classicalb.core.parser.node.ANotSubsetStrictPredicate;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.AOverwriteExpression;
import de.be4.classicalb.core.parser.node.AParallelProductExpression;
import de.be4.classicalb.core.parser.node.AParallelSubstitution;
import de.be4.classicalb.core.parser.node.APartialBijectionExpression;
import de.be4.classicalb.core.parser.node.APartialFunctionExpression;
import de.be4.classicalb.core.parser.node.APartialInjectionExpression;
import de.be4.classicalb.core.parser.node.APartialSurjectionExpression;
import de.be4.classicalb.core.parser.node.APermExpression;
import de.be4.classicalb.core.parser.node.APow1SubsetExpression;
import de.be4.classicalb.core.parser.node.APowSubsetExpression;
import de.be4.classicalb.core.parser.node.APowerOfExpression;
import de.be4.classicalb.core.parser.node.APreconditionSubstitution;
import de.be4.classicalb.core.parser.node.APredecessorExpression;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APrimedIdentifierExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ARangeExpression;
import de.be4.classicalb.core.parser.node.ARangeRestrictionExpression;
import de.be4.classicalb.core.parser.node.ARangeSubtractionExpression;
import de.be4.classicalb.core.parser.node.ARecEntry;
import de.be4.classicalb.core.parser.node.ARecExpression;
import de.be4.classicalb.core.parser.node.ARecordFieldExpression;
import de.be4.classicalb.core.parser.node.AReflexiveClosureExpression;
import de.be4.classicalb.core.parser.node.ARelationsExpression;
import de.be4.classicalb.core.parser.node.ARestrictFrontExpression;
import de.be4.classicalb.core.parser.node.ARestrictTailExpression;
import de.be4.classicalb.core.parser.node.ARevExpression;
import de.be4.classicalb.core.parser.node.AReverseExpression;
import de.be4.classicalb.core.parser.node.ASecondProjectionExpression;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASelectWhenSubstitution;
import de.be4.classicalb.core.parser.node.ASeq1Expression;
import de.be4.classicalb.core.parser.node.ASeqExpression;
import de.be4.classicalb.core.parser.node.ASequenceExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetSubtractionExpression;
import de.be4.classicalb.core.parser.node.ASizeExpression;
import de.be4.classicalb.core.parser.node.ASkipSubstitution;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.AStringSetExpression;
import de.be4.classicalb.core.parser.node.AStructExpression;
import de.be4.classicalb.core.parser.node.ASubsetPredicate;
import de.be4.classicalb.core.parser.node.ASubsetStrictPredicate;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASuccessorExpression;
import de.be4.classicalb.core.parser.node.ATailExpression;
import de.be4.classicalb.core.parser.node.ATotalBijectionExpression;
import de.be4.classicalb.core.parser.node.ATotalFunctionExpression;
import de.be4.classicalb.core.parser.node.ATotalInjectionExpression;
import de.be4.classicalb.core.parser.node.ATotalSurjectionExpression;
import de.be4.classicalb.core.parser.node.ATransFunctionExpression;
import de.be4.classicalb.core.parser.node.ATransRelationExpression;
import de.be4.classicalb.core.parser.node.AUnaryMinusExpression;
import de.be4.classicalb.core.parser.node.AUnionExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.POperation;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PRecEntry;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.util.Utils;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.PrecedenceCollector;
import de.tlc4b.analysis.PrimedNodesMarker;
import de.tlc4b.analysis.Renamer;
import de.tlc4b.analysis.StandardModules;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.analysis.UsedStandardModules;
import de.tlc4b.analysis.typerestriction.TypeRestrictor;
import de.tlc4b.analysis.unchangedvariables.InvariantPreservationAnalysis;
import de.tlc4b.analysis.unchangedvariables.UnchangedVariablesFinder;
import de.tlc4b.btypes.BType;
import de.tlc4b.btypes.FunctionType;
import de.tlc4b.btypes.IntegerType;
import de.tlc4b.btypes.PairType;
import de.tlc4b.btypes.SetType;
import de.tlc4b.btypes.StructType;
import de.tlc4b.btypes.UntypedType;
import de.tlc4b.exceptions.NotSupportedException;
import de.tlc4b.exceptions.TranslationException;
import de.tlc4b.ltl.LTLFormulaVisitor;
import de.tlc4b.tla.ConfigFile;
import de.tlc4b.tla.TLADefinition;
import de.tlc4b.tla.TLAModule;
import de.tlc4b.tla.config.ConfigFileAssignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TLAPrinter
extends DepthFirstAdapter {
    private final StringBuilder tlaModuleString;
    private final StringBuilder configFileString;
    private final MachineContext machineContext;
    private final Typechecker typechecker;
    private final UnchangedVariablesFinder missingVariableFinder;
    private final PrecedenceCollector precedenceCollector;
    private final UsedStandardModules usedStandardModules;
    private final TypeRestrictor typeRestrictor;
    private final TLAModule tlaModule;
    private final ConfigFile configFile;
    private final PrimedNodesMarker primedNodesMarker;
    private final Renamer renamer;
    private final InvariantPreservationAnalysis invariantPreservationAnalysis;
    private boolean disablePrimedNodes = false;
    private static boolean assertionMode = false;
    private static final String assertionName = null;
    private static Integer parameterCounter = 0;

    public StringBuilder getConfigString() {
        return this.configFileString;
    }

    public StringBuilder getStringbuilder() {
        return this.tlaModuleString;
    }

    public TLAPrinter(MachineContext machineContext, Typechecker typechecker, UnchangedVariablesFinder unchangedVariablesFinder, PrecedenceCollector precedenceCollector, UsedStandardModules usedStandardModules, TypeRestrictor typeRestrictor, TLAModule tlaModule, ConfigFile configFile, PrimedNodesMarker primedNodesMarker, Renamer renamer, InvariantPreservationAnalysis invariantPreservationAnalysis) {
        this.typechecker = typechecker;
        this.machineContext = machineContext;
        this.missingVariableFinder = unchangedVariablesFinder;
        this.precedenceCollector = precedenceCollector;
        this.usedStandardModules = usedStandardModules;
        this.typeRestrictor = typeRestrictor;
        this.tlaModule = tlaModule;
        this.configFile = configFile;
        this.primedNodesMarker = primedNodesMarker;
        this.renamer = renamer;
        this.invariantPreservationAnalysis = invariantPreservationAnalysis;
        this.tlaModuleString = new StringBuilder();
        this.configFileString = new StringBuilder();
    }

    public void start() {
        this.printHeader();
        this.printExtendedModules();
        this.printConstants();
        this.printVariables();
        this.printDefinitions();
        this.printAssume();
        this.printInvariant();
        this.printAssertions();
        this.printInit();
        this.printOperations();
        this.printSpecFormula();
        this.printLTLFormulas();
        this.printSymmetry();
        this.moduleStringAppend("====");
        this.printConfig();
    }

    private void printSymmetry() {
        if (TLC4BGlobals.useSymmetry() && !this.machineContext.getDeferredSets().isEmpty()) {
            this.moduleStringAppend("Symmetry == ");
            Collection<Node> values = this.machineContext.getDeferredSets().values();
            ArrayList<Node> array = new ArrayList<Node>(values);
            for (int i = 0; i < array.size(); ++i) {
                Node node = array.get(i);
                this.moduleStringAppend("Permutations(");
                node.apply(this);
                this.moduleStringAppend(")");
                if (i >= array.size() - 1) continue;
                this.moduleStringAppend(" \\cup ");
            }
            this.moduleStringAppend("\n");
        }
    }

    private void printSpecFormula() {
        if (this.configFile.isSpec()) {
            this.moduleStringAppend("vars == ");
            this.printVarsAsTuple();
            this.moduleStringAppend("\n");
            this.moduleStringAppend("VWF == ");
            this.printWeakFairness("Next");
            this.moduleStringAppend("\n");
            this.moduleStringAppend("Spec == Init /\\ [][Next]_vars /\\ VWF\n");
        }
    }

    public void printStrongFairness(String s) {
        this.moduleStringAppend(String.format("([]<><<%s>>_vars \\/ <>[]~ENABLED(%s) \\/ []<>ENABLED(%s /\\ ", s, s, s));
        this.printVarsStuttering();
        this.moduleStringAppend("))");
    }

    public void printWeakFairness(String s) {
        this.moduleStringAppend(String.format("([]<><<%s>>_vars \\/ []<>~ENABLED(%s) \\/ []<>ENABLED(%s /\\ ", s, s, s));
        this.printVarsStuttering();
        this.moduleStringAppend("))");
    }

    public void printWeakFairnessWithParameter(String s) {
        Node operation = this.machineContext.getOperations().get(s.trim());
        this.moduleStringAppend("([]<><<");
        this.printOperationCall(operation);
        this.moduleStringAppend(">>_vars \\/ []<>~ENABLED(");
        this.printOperationCall(operation);
        this.moduleStringAppend(") \\/ []<>ENABLED(");
        this.printOperationCall(operation);
        this.moduleStringAppend(" /\\ ");
        this.printVarsStuttering();
        this.moduleStringAppend("))");
    }

    private void printVarsStuttering() {
        ArrayList<Node> vars = this.tlaModule.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            vars.get(i).apply(this);
            this.moduleStringAppend("' = ");
            vars.get(i).apply(this);
            if (i >= vars.size() - 1) continue;
            this.moduleStringAppend(" /\\ ");
        }
    }

    private void printVarsAsTuple() {
        ArrayList<Node> vars = this.tlaModule.getVariables();
        if (vars.isEmpty()) {
            return;
        }
        this.moduleStringAppend("<<");
        for (int i = 0; i < vars.size(); ++i) {
            vars.get(i).apply(this);
            if (i >= vars.size() - 1) continue;
            this.moduleStringAppend(",");
        }
        this.moduleStringAppend(">>");
    }

    private void printLTLFormulas() {
        ArrayList<LTLFormulaVisitor> visitors = this.machineContext.getLTLFormulas();
        if (TLC4BGlobals.isCheckLTL()) {
            for (LTLFormulaVisitor visitor : visitors) {
                this.moduleStringAppend(visitor.getName() + " == ");
                visitor.printLTLFormula(this, this.typeRestrictor);
                this.moduleStringAppend("\n");
            }
        }
    }

    private void printConfig() {
        List<ConfigFileAssignment> assignments;
        int i;
        if (this.configFile.isSpec()) {
            this.configFileString.append("SPECIFICATION Spec\n");
        } else {
            if (this.configFile.isInit()) {
                this.configFileString.append("INIT Init\n");
            }
            if (this.configFile.isInit()) {
                this.configFileString.append("NEXT Next\n");
            }
        }
        if (TLC4BGlobals.isInvariant()) {
            for (i = 0; i < this.configFile.getInvariantNumber(); ++i) {
                this.configFileString.append("INVARIANT Invariant").append(i + 1).append("\n");
            }
        }
        if (this.configFile.isGoal()) {
            this.configFileString.append("INVARIANT NotGoal\n");
        }
        if (TLC4BGlobals.isAssertion() && this.tlaModule.hasInitPredicate()) {
            for (i = 0; i < this.configFile.getAssertionSize(); ++i) {
                this.configFileString.append("INVARIANT Assertion").append(i + 1).append("\n");
            }
        }
        if (TLC4BGlobals.isCheckLTL()) {
            for (i = 0; i < this.machineContext.getLTLFormulas().size(); ++i) {
                LTLFormulaVisitor ltlVisitor = this.machineContext.getLTLFormulas().get(i);
                this.configFileString.append("PROPERTIES ").append(ltlVisitor.getName()).append("\n");
            }
        }
        if (!(assignments = this.configFile.getAssignments()).isEmpty()) {
            this.configFileString.append("CONSTANTS\n");
            for (ConfigFileAssignment assignment : assignments) {
                this.configFileString.append(assignment.getString(this.renamer));
            }
        }
        if (TLC4BGlobals.useSymmetry() && !this.machineContext.getDeferredSets().isEmpty()) {
            this.configFileString.append("SYMMETRY Symmetry\n");
        }
        if (TLC4BGlobals.isPartialInvariantEvaluation()) {
            this.configFileString.append("CONSTANTS\n");
            this.configFileString.append("Init_action = Init_action\n");
            ArrayList<POperation> operations = this.tlaModule.getOperations();
            for (POperation operation : operations) {
                AOperation node = (AOperation)operation;
                String name = this.renamer.getNameOfRef(node);
                String actionName = name + "actions";
                this.configFileString.append(actionName).append(" = ").append(actionName).append("\n");
            }
            this.configFileString.append("\n");
            this.configFileString.append("VIEW myView");
        }
    }

    public void moduleStringAppend(String str) {
        this.tlaModuleString.append(str);
    }

    private void printHeader() {
        this.moduleStringAppend("---- MODULE ");
        this.moduleStringAppend(this.tlaModule.getModuleName());
        this.moduleStringAppend(" ----\n");
    }

    private void printExtendedModules() {
        List<String> extendedModules = this.usedStandardModules.getExtendedModules();
        if (!extendedModules.isEmpty()) {
            this.moduleStringAppend("EXTENDS ");
            this.moduleStringAppend(String.join((CharSequence)", ", extendedModules));
            this.moduleStringAppend("\n");
        }
    }

    private void printDefinitions() {
        ArrayList<TLADefinition> definitions = this.tlaModule.getTLADefinitions();
        for (TLADefinition def : definitions) {
            if (def.getDefName() instanceof AEnumeratedSetSet) {
                def.getDefName().apply(this);
                continue;
            }
            def.getDefName().apply(this);
            this.moduleStringAppend(" == ");
            Node e = def.getDefinition();
            if (e == null) {
                this.moduleStringAppend(def.getInt().toString());
            } else {
                e.apply(this);
            }
            this.moduleStringAppend("\n");
        }
        ArrayList<PDefinition> bDefinitions = this.tlaModule.getAllDefinitions();
        if (null == bDefinitions) {
            return;
        }
        for (PDefinition node : bDefinitions) {
            node.apply(this);
        }
        if (this.configFile.isGoal()) {
            this.moduleStringAppend("NotGoal == ~GOAL\n");
        }
    }

    private void printConstants() {
        ArrayList<Node> list;
        int i;
        if (TLC4BGlobals.isPartialInvariantEvaluation()) {
            ArrayList<POperation> operations = this.tlaModule.getOperations();
            this.moduleStringAppend("CONSTANTS Init_action, ");
            for (i = 0; i < operations.size(); ++i) {
                AOperation node = (AOperation)operations.get(i);
                String name = this.renamer.getNameOfRef(node);
                this.moduleStringAppend(name + "_action");
                if (i >= operations.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend("\n");
        }
        if ((list = this.tlaModule.getConstants()).isEmpty()) {
            return;
        }
        this.moduleStringAppend("CONSTANTS ");
        for (i = 0; i < list.size(); ++i) {
            Node con = list.get(i);
            con.apply(this);
            if (i >= list.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend("\n");
    }

    private void printAssume() {
        ArrayList<Node> list = this.tlaModule.getAssume();
        if (list.isEmpty()) {
            return;
        }
        for (Node node : list) {
            if (this.typeRestrictor.isARemovedNode(node)) continue;
            this.moduleStringAppend("ASSUME ");
            node.apply(this);
            this.moduleStringAppend("\n");
        }
    }

    private void printVariables() {
        int i;
        ArrayList<Node> vars = this.tlaModule.getVariables();
        if (vars.isEmpty()) {
            return;
        }
        this.moduleStringAppend("VARIABLES ");
        for (i = 0; i < vars.size(); ++i) {
            vars.get(i).apply(this);
            if (i >= vars.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        if (TLC4BGlobals.isPartialInvariantEvaluation()) {
            this.moduleStringAppend(", last_action");
        }
        this.moduleStringAppend("\n");
        if (TLC4BGlobals.isPartialInvariantEvaluation()) {
            this.moduleStringAppend("myView == <<");
            for (i = 0; i < vars.size(); ++i) {
                vars.get(i).apply(this);
                if (i >= vars.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend(">>\n");
        }
    }

    private void printInvariant() {
        ArrayList<Node> invariants = this.tlaModule.getInvariantList();
        for (int i = 0; i < invariants.size(); ++i) {
            List<Node> operations;
            Node inv = invariants.get(i);
            this.moduleStringAppend("Invariant" + (i + 1) + " == ");
            if (TLC4BGlobals.isPartialInvariantEvaluation() && !(operations = this.invariantPreservationAnalysis.getPreservingOperations(inv)).isEmpty()) {
                this.moduleStringAppend("last_action \\in {");
                for (int j = 0; j < operations.size(); ++j) {
                    Node op = operations.get(j);
                    String name = this.renamer.getNameOfRef(op);
                    this.moduleStringAppend(name);
                    this.moduleStringAppend("_action");
                    if (j >= operations.size() - 1) continue;
                    this.moduleStringAppend(", ");
                }
                this.moduleStringAppend("} \\/ ");
            }
            inv.apply(this);
            this.moduleStringAppend("\n");
        }
    }

    private void printAssertions() {
        if (TLC4BGlobals.isAssertion()) {
            ArrayList<Node> assertions = this.tlaModule.getAssertions();
            if (assertions.isEmpty()) {
                return;
            }
            for (int i = 0; i < assertions.size(); ++i) {
                Node assertion = assertions.get(i);
                String name = null;
                if (assertion instanceof ALabelPredicate) {
                    ALabelPredicate label = (ALabelPredicate)assertion;
                    name = label.getName().getText();
                }
                if (name == null) {
                    name = "Assertion" + (i + 1);
                }
                if (!this.tlaModule.hasInitPredicate()) {
                    this.moduleStringAppend("ASSUME ");
                }
                this.moduleStringAppend(name);
                this.moduleStringAppend(" == ");
                assertion.apply(this);
                this.moduleStringAppend("\n");
            }
        }
    }

    private void printInit() {
        ArrayList<Node> inits = this.tlaModule.getInitPredicates();
        if (inits.isEmpty()) {
            return;
        }
        this.moduleStringAppend("Init == ");
        if (inits.size() > 1) {
            this.moduleStringAppend("\n\t/\\ ");
        }
        for (int i = 0; i < inits.size(); ++i) {
            Node init = inits.get(i);
            if (init instanceof ADisjunctPredicate) {
                this.moduleStringAppend("(");
            }
            init.apply(this);
            if (init instanceof ADisjunctPredicate) {
                this.moduleStringAppend(")");
            }
            if (TLC4BGlobals.isPartialInvariantEvaluation()) {
                this.moduleStringAppend(" /\\ last_action = Init_action");
            }
            if (i >= inits.size() - 1) continue;
            this.moduleStringAppend("\n\t/\\ ");
        }
        this.moduleStringAppend("\n\n");
    }

    private void printOperations() {
        ArrayList<POperation> ops = this.tlaModule.getOperations();
        if (ops.isEmpty()) {
            ArrayList<Node> vars = this.tlaModule.getVariables();
            if (!vars.isEmpty()) {
                this.moduleStringAppend("Next == 1 = 2 /\\ UNCHANGED <<");
                for (int i = 0; i < vars.size(); ++i) {
                    vars.get(i).apply(this);
                    if (i >= vars.size() - 1) continue;
                    this.moduleStringAppend(", ");
                }
                this.moduleStringAppend(">>\n");
            }
            return;
        }
        for (POperation op : ops) {
            op.apply(this);
        }
        this.moduleStringAppend("Next == \\/ ");
        Iterator<Node> itr = this.machineContext.getOperations().values().iterator();
        while (itr.hasNext()) {
            Node operation = itr.next();
            this.printOperationCall(operation);
            if (!itr.hasNext()) continue;
            this.moduleStringAppend("\n\t\\/ ");
        }
        this.moduleStringAppend("\n");
    }

    public void printOperationCall(Node operation) {
        AOperation op = (AOperation)operation;
        ArrayList<PExpression> newList = new ArrayList<PExpression>(op.getParameters());
        if (!newList.isEmpty()) {
            this.moduleStringAppend("\\E ");
            for (int i = 0; i < newList.size(); ++i) {
                PExpression e = (PExpression)newList.get(i);
                e.apply(this);
                this.moduleStringAppend(" \\in ");
                this.typeRestrictor.getRestrictedNode(e).apply(this);
                if (i >= newList.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend(" : ");
        }
        String opName = this.renamer.getNameOfRef(op);
        this.moduleStringAppend(opName);
        if (!newList.isEmpty()) {
            this.moduleStringAppend("(");
            for (int i = 0; i < newList.size(); ++i) {
                ((PExpression)newList.get(i)).apply(this);
                if (i >= newList.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend(")");
        }
    }

    @Override
    public void defaultIn(Node node) {
        if (this.precedenceCollector.getBrackets().contains(node)) {
            this.moduleStringAppend("(");
        }
    }

    @Override
    public void defaultOut(Node node) {
        if (this.precedenceCollector.getBrackets().contains(node)) {
            this.moduleStringAppend(")");
        }
    }

    @Override
    public void caseAMachineHeader(AMachineHeader node) {
        this.inAMachineHeader(node);
        this.moduleStringAppend(node.toString());
        ArrayList<Node> copy = new ArrayList<TIdentifierLiteral>(node.getName());
        for (Node e : copy) {
            ((TIdentifierLiteral)e).apply(this);
        }
        copy = new ArrayList<PExpression>(node.getParameters());
        for (Node e : copy) {
            e.apply(this);
        }
        this.outAMachineHeader(node);
    }

    @Override
    public void caseAEnumeratedSetSet(AEnumeratedSetSet node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getElements());
        this.moduleStringAppend(this.renamer.getNameOfRef(node) + " == {");
        for (int i = 0; i < copy.size(); ++i) {
            ((PExpression)copy.get(i)).apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend("}\n");
    }

    @Override
    public void caseADeferredSetSet(ADeferredSetSet node) {
        String name = this.renamer.getName(node);
        this.moduleStringAppend(name);
    }

    @Override
    public void caseABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (int i = 0; i < copy.size(); ++i) {
            if (i != 0) {
                this.moduleStringAppend(" /\\ ");
            }
            ((PExpression)copy.get(i)).apply(this);
            this.moduleStringAppend(" \\in ");
            node.getSet().apply(this);
        }
        this.printUnchangedVariables(node, true);
    }

    @Override
    public void caseABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        this.inABecomesSuchSubstitution(node);
        if (node.getPredicate() instanceof AExistsPredicate) {
            node.getPredicate().apply(this);
        } else {
            ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
            for (int i = 0; i < copy.size(); ++i) {
                PExpression e = (PExpression)copy.get(i);
                e.apply(this);
                this.moduleStringAppend(" \\in ");
                this.typeRestrictor.getRestrictedNode(e).apply(this);
                if (i >= copy.size() - 1) continue;
                this.moduleStringAppend(" /\\ ");
            }
            if (!this.typeRestrictor.isARemovedNode(node.getPredicate())) {
                this.moduleStringAppend(" /\\ ");
                node.getPredicate().apply(this);
            }
        }
        this.printUnchangedVariables(node, true);
        this.outABecomesSuchSubstitution(node);
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getLhsExpression());
        ArrayList<PExpression> copy2 = new ArrayList<PExpression>(node.getRhsExpressions());
        for (int i = 0; i < copy.size(); ++i) {
            PExpression left = (PExpression)copy.get(i);
            PExpression right = (PExpression)copy2.get(i);
            AIdentifierExpression assigned = this.getAssignedIdentifier(left);
            if (this.machineContext.getVariables().containsKey(Utils.getAIdentifierAsString(assigned))) {
                assigned.apply(this);
                this.moduleStringAppend(" = ");
                this.printAssignmentRhs(assigned, right);
            } else {
                this.moduleStringAppend("TRUE");
            }
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(" /\\ ");
        }
        this.printUnchangedVariables(node, true);
    }

    private AIdentifierExpression getAssignedIdentifier(PExpression left) {
        if (left instanceof AIdentifierExpression) {
            return (AIdentifierExpression)left;
        }
        if (left instanceof AFunctionExpression) {
            return this.getAssignedIdentifier(((AFunctionExpression)left).getIdentifier());
        }
        if (left instanceof ARecordFieldExpression) {
            return this.getAssignedIdentifier(((ARecordFieldExpression)left).getRecord());
        }
        throw new NotSupportedException("Unsupported assignment lhs: " + left);
    }

    private void printAssignmentRhs(Node left, PExpression right) {
        if (left instanceof AAssignSubstitution) {
            right.apply(this);
            return;
        }
        Node parent = left.parent();
        if (left instanceof AIdentifierExpression) {
            this.printAssignmentRhs(parent, right);
        } else if (left instanceof AFunctionExpression) {
            AFunctionExpression func = (AFunctionExpression)left;
            PExpression ident = func.getIdentifier();
            LinkedList<PExpression> params = func.getParameters();
            BType type = this.typechecker.getType(ident);
            if (type instanceof FunctionType) {
                this.moduleStringAppend("FuncAssign");
                this.moduleStringAppend("(");
                this.printAssignmentFunctionalOverrideBase(ident);
                this.moduleStringAppend(", ");
                if (params.size() > 1) {
                    this.moduleStringAppend("<<");
                }
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    PExpression pExpression = (PExpression)iterator.next();
                    pExpression.apply(this);
                    if (!iterator.hasNext()) continue;
                    this.moduleStringAppend(", ");
                }
                if (params.size() > 1) {
                    this.moduleStringAppend(">>");
                }
                this.moduleStringAppend(", ");
                this.printAssignmentRhs(parent, right);
                this.moduleStringAppend(")");
            } else {
                this.moduleStringAppend("RelOverride(");
                this.printAssignmentFunctionalOverrideBase(ident);
                this.moduleStringAppend(", {<<");
                if (params.size() > 1) {
                    this.moduleStringAppend("<<");
                    Iterator iterator = params.iterator();
                    while (iterator.hasNext()) {
                        PExpression pExpression = (PExpression)iterator.next();
                        pExpression.apply(this);
                        if (!iterator.hasNext()) continue;
                        this.moduleStringAppend(", ");
                    }
                    this.moduleStringAppend(">>");
                } else {
                    ((PExpression)params.get(0)).apply(this);
                }
                this.moduleStringAppend(", ");
                this.printAssignmentRhs(parent, right);
                this.moduleStringAppend(">>})");
            }
        } else {
            throw new NotSupportedException("Unsupported assignment lhs: " + left);
        }
    }

    private void printAssignmentFunctionalOverrideBase(PExpression e) {
        if (e instanceof AIdentifierExpression) {
            this.disablePrimedNodes = true;
            e.apply(this);
            this.disablePrimedNodes = false;
        } else if (e instanceof AFunctionExpression) {
            Iterator it;
            AFunctionExpression func = (AFunctionExpression)e;
            PExpression ident = func.getIdentifier();
            LinkedList<PExpression> params = func.getParameters();
            this.moduleStringAppend("(IF ");
            BType identType = this.typechecker.getType(ident);
            BType valueType = this.typechecker.getType(e);
            if (identType instanceof FunctionType) {
                if (params.size() > 1) {
                    this.moduleStringAppend("<<");
                }
                it = params.iterator();
                while (it.hasNext()) {
                    ((PExpression)it.next()).apply(this);
                    if (!it.hasNext()) continue;
                    this.moduleStringAppend(", ");
                }
                if (params.size() > 1) {
                    this.moduleStringAppend(">>");
                }
                this.moduleStringAppend(" \\in ");
                this.moduleStringAppend("DOMAIN ");
                this.printAssignmentFunctionalOverrideBase(ident);
            } else {
                if (params.size() > 1) {
                    this.moduleStringAppend("<<");
                    it = params.iterator();
                    while (it.hasNext()) {
                        ((PExpression)it.next()).apply(this);
                        if (!it.hasNext()) continue;
                        this.moduleStringAppend(", ");
                    }
                    this.moduleStringAppend(">>");
                } else {
                    params.get(0).apply(this);
                }
                this.moduleStringAppend(" \\in ");
                this.moduleStringAppend("RelDomain");
                this.moduleStringAppend("(");
                this.printAssignmentFunctionalOverrideBase(ident);
                this.moduleStringAppend(")");
            }
            this.moduleStringAppend(" THEN ");
            if (identType instanceof FunctionType) {
                this.printAssignmentFunctionalOverrideBase(ident);
                this.moduleStringAppend("[");
                if (params.size() > 1) {
                    this.moduleStringAppend("<<");
                }
                it = params.iterator();
                while (it.hasNext()) {
                    ((PExpression)it.next()).apply(this);
                    if (!it.hasNext()) continue;
                    this.moduleStringAppend(", ");
                }
                if (params.size() > 1) {
                    this.moduleStringAppend(">>");
                }
                this.moduleStringAppend("]");
            } else {
                if (TLC4BGlobals.checkWelldefinedness()) {
                    this.moduleStringAppend("RelCall");
                } else {
                    this.moduleStringAppend("RelCallWithoutWDCheck");
                }
                this.moduleStringAppend("(");
                this.printAssignmentFunctionalOverrideBase(ident);
                this.moduleStringAppend(", ");
                if (params.size() > 1) {
                    this.moduleStringAppend("<<");
                    it = params.iterator();
                    while (it.hasNext()) {
                        ((PExpression)it.next()).apply(this);
                        if (!it.hasNext()) continue;
                        this.moduleStringAppend(", ");
                    }
                    this.moduleStringAppend(">>");
                } else {
                    params.get(0).apply(this);
                }
                this.moduleStringAppend(")");
            }
            this.moduleStringAppend(" ELSE ");
            if (valueType instanceof FunctionType) {
                this.moduleStringAppend("<<>>");
            } else {
                this.moduleStringAppend("{}");
            }
            this.moduleStringAppend(")");
        } else {
            throw new NotSupportedException("Unsupported assignment lhs: " + e);
        }
    }

    public void printUnchangedVariables(Node node, boolean printAnd) {
        HashSet<Node> unchangedVariablesSet = this.missingVariableFinder.getUnchangedVariables(node);
        if (null != unchangedVariablesSet) {
            ArrayList<Node> unchangedVariables = new ArrayList<Node>(unchangedVariablesSet);
            if (!unchangedVariables.isEmpty()) {
                if (printAnd) {
                    this.moduleStringAppend(" /\\");
                }
                this.moduleStringAppend(" UNCHANGED <<");
                for (int i = 0; i < unchangedVariables.size(); ++i) {
                    unchangedVariables.get(i).apply(this);
                    if (i >= unchangedVariables.size() - 1) continue;
                    this.moduleStringAppend(", ");
                }
                this.moduleStringAppend(">>");
            } else if (!printAnd) {
                this.moduleStringAppend("TRUE");
            }
        }
    }

    @Override
    public void caseAChoiceSubstitution(AChoiceSubstitution node) {
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getSubstitutions());
        this.moduleStringAppend("(");
        for (int i = 0; i < copy.size(); ++i) {
            this.moduleStringAppend("(");
            ((PSubstitution)copy.get(i)).apply(this);
            this.moduleStringAppend(")");
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(" \\/ ");
        }
        this.moduleStringAppend(")");
        this.printUnchangedVariables(node, true);
    }

    @Override
    public void caseASkipSubstitution(ASkipSubstitution node) {
        this.printUnchangedVariables(node, false);
    }

    @Override
    public void caseAIfSubstitution(AIfSubstitution node) {
        if (!node.getElsifSubstitutions().isEmpty()) {
            this.printElseIFSubstitution(node);
            return;
        }
        this.moduleStringAppend("(IF ");
        node.getCondition().apply(this);
        this.moduleStringAppend(" THEN ");
        node.getThen().apply(this);
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getElsifSubstitutions());
        for (PSubstitution e : copy) {
            e.apply(this);
        }
        this.moduleStringAppend(" ELSE ");
        if (node.getElse() != null) {
            node.getElse().apply(this);
        } else {
            this.printUnchangedVariablesNull(node, false);
        }
        this.moduleStringAppend(")");
        this.printUnchangedVariables(node, true);
    }

    private void printElseIFSubstitution(AIfSubstitution node) {
        this.moduleStringAppend("(CASE ");
        node.getCondition().apply(this);
        this.moduleStringAppend(" -> ");
        node.getThen().apply(this);
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getElsifSubstitutions());
        for (PSubstitution e : copy) {
            this.moduleStringAppend(" [] ");
            e.apply(this);
        }
        this.moduleStringAppend(" [] OTHER -> ");
        if (node.getElse() != null) {
            node.getElse().apply(this);
        } else {
            this.printUnchangedVariablesNull(node, false);
        }
        this.moduleStringAppend(")");
        this.printUnchangedVariables(node, true);
    }

    @Override
    public void caseAIfElsifSubstitution(AIfElsifSubstitution node) {
        node.getCondition().apply(this);
        this.moduleStringAppend(" -> ");
        node.getThenSubstitution().apply(this);
        this.printUnchangedVariables(node, true);
    }

    public void printUnchangedVariablesNull(Node node, boolean printAnd) {
        ArrayList<Node> unchangedVariables;
        HashSet<Node> unchangedVariablesSet = this.missingVariableFinder.getUnchangedVariablesNull(node);
        if (null != unchangedVariablesSet && !(unchangedVariables = new ArrayList<Node>(unchangedVariablesSet)).isEmpty()) {
            if (printAnd) {
                this.moduleStringAppend(" /\\");
            }
            this.moduleStringAppend(" UNCHANGED <<");
            for (int i = 0; i < unchangedVariables.size(); ++i) {
                unchangedVariables.get(i).apply(this);
                if (i >= unchangedVariables.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend(">>");
        }
    }

    @Override
    public void caseAParallelSubstitution(AParallelSubstitution node) {
        this.inAParallelSubstitution(node);
        Iterator itr = node.getSubstitutions().iterator();
        while (itr.hasNext()) {
            PSubstitution e = (PSubstitution)itr.next();
            e.apply(this);
            if (!itr.hasNext()) continue;
            this.moduleStringAppend(" /\\ ");
        }
        this.printUnchangedVariables(node, true);
        this.outAParallelSubstitution(node);
    }

    @Override
    public void caseAPreconditionSubstitution(APreconditionSubstitution node) {
        this.inAPreconditionSubstitution(node);
        if (!this.typeRestrictor.isARemovedNode(node.getPredicate())) {
            node.getPredicate().apply(this);
            this.moduleStringAppend("\n\t/\\ ");
        }
        node.getSubstitution().apply(this);
        this.outAPreconditionSubstitution(node);
    }

    @Override
    public void caseAAssertionSubstitution(AAssertionSubstitution node) {
        this.inAAssertionSubstitution(node);
        node.getPredicate().apply(this);
        this.moduleStringAppend("\n\t/\\ ");
        node.getSubstitution().apply(this);
        this.outAAssertionSubstitution(node);
    }

    @Override
    public void caseASelectSubstitution(ASelectSubstitution node) {
        this.inASelectSubstitution(node);
        this.moduleStringAppend("(");
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getWhenSubstitutions());
        if (this.missingVariableFinder.hasUnchangedVariables(node) && (!copy.isEmpty() || node.getElse() != null)) {
            this.moduleStringAppend("(");
        }
        if (!this.typeRestrictor.isARemovedNode(node.getCondition())) {
            if (!copy.isEmpty() || node.getElse() != null) {
                this.moduleStringAppend("(");
            }
            node.getCondition().apply(this);
            this.moduleStringAppend(" /\\ ");
        }
        node.getThen().apply(this);
        if (!(this.typeRestrictor.isARemovedNode(node.getCondition()) || copy.isEmpty() && node.getElse() == null)) {
            this.moduleStringAppend(")");
        }
        for (PSubstitution e : copy) {
            this.moduleStringAppend(" \\/ ");
            e.apply(this);
        }
        if (node.getElse() != null) {
            this.moduleStringAppend(" \\/ (");
            this.moduleStringAppend("~(");
            for (PSubstitution e : copy) {
                ASelectWhenSubstitution w = (ASelectWhenSubstitution)e;
                this.moduleStringAppend(" \\/ ");
                w.getCondition().apply(this);
            }
            this.moduleStringAppend(")");
            this.moduleStringAppend(" /\\ ");
            node.getElse().apply(this);
            this.moduleStringAppend(")");
        }
        if (this.missingVariableFinder.hasUnchangedVariables(node) && (!copy.isEmpty() || node.getElse() != null)) {
            this.moduleStringAppend(")");
        }
        this.moduleStringAppend(")");
        this.printUnchangedVariables(node, true);
        this.outASelectSubstitution(node);
    }

    @Override
    public void caseASelectWhenSubstitution(ASelectWhenSubstitution node) {
        this.inASelectWhenSubstitution(node);
        node.getCondition().apply(this);
        this.moduleStringAppend(" /\\ ");
        node.getSubstitution().apply(this);
        this.outASelectWhenSubstitution(node);
    }

    @Override
    public void caseAAnySubstitution(AAnySubstitution node) {
        this.inAAnySubstitution(node);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        if (!copy.isEmpty()) {
            this.moduleStringAppend("\\E ");
            for (int i = 0; i < copy.size(); ++i) {
                PExpression e = (PExpression)copy.get(i);
                e.apply(this);
                this.moduleStringAppend(" \\in ");
                this.typeRestrictor.getRestrictedNode(e).apply(this);
                if (i >= copy.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend(" : ");
        }
        if (!this.typeRestrictor.isARemovedNode(node.getWhere())) {
            node.getWhere().apply(this);
            this.moduleStringAppend(" /\\ ");
        }
        node.getThen().apply(this);
        this.printUnchangedVariables(node, true);
        this.outAAnySubstitution(node);
    }

    @Override
    public void caseALetSubstitution(ALetSubstitution node) {
        this.inALetSubstitution(node);
        this.moduleStringAppend("\\E ");
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (int i = 0; i < copy.size(); ++i) {
            PExpression e = (PExpression)copy.get(i);
            e.apply(this);
            this.moduleStringAppend(" \\in ");
            this.typeRestrictor.getRestrictedNode(e).apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend(" : ");
        if (this.typeRestrictor.isARemovedNode(node.getPredicate())) {
            this.moduleStringAppend("TRUE");
        } else {
            node.getPredicate().apply(this);
        }
        this.moduleStringAppend(" /\\ ");
        node.getSubstitution().apply(this);
        this.printUnchangedVariables(node, true);
        this.outALetSubstitution(node);
    }

    @Override
    public void caseALetPredicatePredicate(ALetPredicatePredicate node) {
        this.inALetPredicatePredicate(node);
        this.moduleStringAppend("\\E ");
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (int i = 0; i < copy.size(); ++i) {
            PExpression e = (PExpression)copy.get(i);
            e.apply(this);
            this.moduleStringAppend(" \\in ");
            this.typeRestrictor.getRestrictedNode(e).apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend(" : ");
        if (this.typeRestrictor.isARemovedNode(node.getAssignment())) {
            this.moduleStringAppend("TRUE");
        } else {
            node.getAssignment().apply(this);
        }
        this.moduleStringAppend(" /\\ ");
        node.getPred().apply(this);
        this.outALetPredicatePredicate(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, PExpression> getValuesFromEqualPredicates(PPredicate p, Map<String, PExpression> values) {
        if (p instanceof AEqualPredicate) {
            AEqualPredicate eq = (AEqualPredicate)p;
            PExpression left = eq.getLeft();
            if (!(left instanceof AIdentifierExpression)) throw new TranslationException("invalid predicate in LET expr: " + p);
            String s = Utils.getAIdentifierAsString((AIdentifierExpression)left);
            if (values.containsKey(s)) {
                throw new TranslationException("invalid predicate in LET expr: " + p);
            }
            values.put(s, eq.getRight());
            return values;
        } else {
            if (!(p instanceof AConjunctPredicate)) throw new TranslationException("invalid predicate in LET expr: " + p);
            AConjunctPredicate conj = (AConjunctPredicate)p;
            TLAPrinter.getValuesFromEqualPredicates(conj.getLeft(), values);
            TLAPrinter.getValuesFromEqualPredicates(conj.getRight(), values);
        }
        return values;
    }

    @Override
    public void caseALetExpressionExpression(ALetExpressionExpression node) {
        this.inALetExpressionExpression(node);
        this.moduleStringAppend("LET ");
        Map<String, PExpression> values = TLAPrinter.getValuesFromEqualPredicates(node.getAssignment(), new HashMap<String, PExpression>());
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (int i = 0; i < copy.size(); ++i) {
            PExpression e = (PExpression)copy.get(i);
            e.apply(this);
            this.moduleStringAppend(" == ");
            String identifier = Utils.getAIdentifierAsString((AIdentifierExpression)e);
            PExpression value = values.get(identifier);
            if (value == null) {
                throw new TranslationException("no equals predicate for identifier " + identifier + " in LET expr");
            }
            value.apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend(" IN ");
        node.getExpr().apply(this);
        this.outALetExpressionExpression(node);
    }

    @Override
    public void caseAOperation(AOperation node) {
        String name = this.renamer.getNameOfRef(node);
        this.moduleStringAppend(name);
        ArrayList<PExpression> params = new ArrayList<PExpression>(node.getParameters());
        ArrayList<PExpression> newList = new ArrayList<PExpression>(params);
        if (!newList.isEmpty()) {
            this.moduleStringAppend("(");
            for (int i = 0; i < newList.size(); ++i) {
                if (i != 0) {
                    this.moduleStringAppend(", ");
                }
                ((PExpression)newList.get(i)).apply(this);
            }
            this.moduleStringAppend(")");
        }
        this.moduleStringAppend(" == ");
        if (node.getOperationBody() != null) {
            node.getOperationBody().apply(this);
        }
        this.printUnchangedConstants();
        if (TLC4BGlobals.isPartialInvariantEvaluation()) {
            this.moduleStringAppend(" /\\ last_action' = ");
            this.moduleStringAppend(name);
            this.moduleStringAppend("_action");
        }
        this.moduleStringAppend("\n\n");
    }

    private void printUnchangedConstants() {
        ArrayList<Node> vars = new ArrayList<Node>(this.tlaModule.getVariables());
        vars.removeAll(this.machineContext.getVariables().values());
        if (!vars.isEmpty()) {
            this.moduleStringAppend(" /\\ UNCHANGED <<");
            for (int i = 0; i < vars.size(); ++i) {
                if (i != 0) {
                    this.moduleStringAppend(", ");
                }
                vars.get(i).apply(this);
            }
            this.moduleStringAppend(">>");
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        this.inAIdentifierExpression(node);
        String name = this.renamer.getNameOfRef(node);
        if (name == null) {
            name = Utils.getTIdentifierListAsString(node.getIdentifier());
        }
        if (StandardModules.isAbstractConstant(name)) {
            this.moduleStringAppend("{}");
            return;
        }
        this.moduleStringAppend(name);
        if (!this.disablePrimedNodes && this.primedNodesMarker.isPrimed(node)) {
            this.moduleStringAppend("'");
        }
        this.outAIdentifierExpression(node);
    }

    @Override
    public void caseAPrimedIdentifierExpression(APrimedIdentifierExpression node) {
        String name = this.renamer.getNameOfRef(node);
        if (name == null) {
            name = Utils.getTIdentifierListAsString(node.getIdentifier());
        }
        this.moduleStringAppend(name);
    }

    @Override
    public void caseAStringExpression(AStringExpression node) {
        this.inAStringExpression(node);
        this.moduleStringAppend("\"");
        this.moduleStringAppend(node.getContent().getText());
        this.moduleStringAppend("\"");
        this.outAStringExpression(node);
    }

    @Override
    public void caseAStringSetExpression(AStringSetExpression node) {
        this.moduleStringAppend("STRING");
    }

    @Override
    public void caseAEqualPredicate(AEqualPredicate node) {
        this.inAEqualPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" = ");
        node.getRight().apply(this);
        this.outAEqualPredicate(node);
    }

    @Override
    public void caseANotEqualPredicate(ANotEqualPredicate node) {
        this.inANotEqualPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" # ");
        node.getRight().apply(this);
        this.outANotEqualPredicate(node);
    }

    @Override
    public void caseAIfThenElseExpression(AIfThenElseExpression node) {
        if (node.getElsifs().isEmpty()) {
            this.moduleStringAppend("(IF ");
            node.getCondition().apply(this);
            this.moduleStringAppend(" THEN ");
            node.getThen().apply(this);
            this.moduleStringAppend(" ELSE ");
            node.getElse().apply(this);
            this.moduleStringAppend(")");
        } else {
            this.moduleStringAppend("(CASE ");
            node.getCondition().apply(this);
            this.moduleStringAppend(" -> ");
            node.getThen().apply(this);
            node.getElsifs().forEach(n -> {
                this.moduleStringAppend(" [] ");
                n.apply(this);
            });
            this.moduleStringAppend(" [] OTHER -> ");
            node.getElse().apply(this);
            this.moduleStringAppend(")");
        }
    }

    @Override
    public void caseAIfElsifExprExpression(AIfElsifExprExpression node) {
        node.getCondition().apply(this);
        this.moduleStringAppend(" -> ");
        node.getThen().apply(this);
    }

    @Override
    public void caseAConjunctPredicate(AConjunctPredicate node) {
        boolean left = this.typeRestrictor.isARemovedNode(node.getLeft());
        boolean right = this.typeRestrictor.isARemovedNode(node.getRight());
        if (left && right) {
            this.moduleStringAppend("TRUE");
        } else if (left) {
            node.getRight().apply(this);
        } else if (right) {
            node.getLeft().apply(this);
        } else {
            this.inAConjunctPredicate(node);
            node.getLeft().apply(this);
            this.moduleStringAppend(" /\\ ");
            node.getRight().apply(this);
            this.outAConjunctPredicate(node);
        }
    }

    @Override
    public void caseADisjunctPredicate(ADisjunctPredicate node) {
        this.inADisjunctPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\/ ");
        node.getRight().apply(this);
        this.outADisjunctPredicate(node);
    }

    @Override
    public void caseAImplicationPredicate(AImplicationPredicate node) {
        this.inAImplicationPredicate(node);
        if (!this.typeRestrictor.isARemovedNode(node.getLeft())) {
            node.getLeft().apply(this);
            this.moduleStringAppend(" => ");
        }
        node.getRight().apply(this);
        this.outAImplicationPredicate(node);
    }

    @Override
    public void caseAEquivalencePredicate(AEquivalencePredicate node) {
        this.inAEquivalencePredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" <=> ");
        node.getRight().apply(this);
        this.outAEquivalencePredicate(node);
    }

    @Override
    public void caseABoolSetExpression(ABoolSetExpression node) {
        this.moduleStringAppend("BOOLEAN");
    }

    @Override
    public void caseABooleanTrueExpression(ABooleanTrueExpression node) {
        this.inABooleanTrueExpression(node);
        this.moduleStringAppend("TRUE");
        this.outABooleanTrueExpression(node);
    }

    @Override
    public void caseABooleanFalseExpression(ABooleanFalseExpression node) {
        this.inABooleanFalseExpression(node);
        this.moduleStringAppend("FALSE");
        this.outABooleanFalseExpression(node);
    }

    @Override
    public void caseAForallPredicate(AForallPredicate node) {
        PExpression e;
        int i;
        this.inAForallPredicate(node);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        int start = parameterCounter;
        int end = parameterCounter + copy.size();
        parameterCounter = end + 1;
        if (assertionMode) {
            this.moduleStringAppend("(");
            this.moduleStringAppend("TLCSet(");
            this.moduleStringAppend("" + start);
            this.moduleStringAppend(", TRUE) /\\ ");
            for (i = start; i < end; ++i) {
                this.moduleStringAppend("TLCSet(");
                this.moduleStringAppend("" + (i + 1));
                this.moduleStringAppend(", \"NULL\")");
                this.moduleStringAppend(" /\\ ");
            }
        }
        this.moduleStringAppend("\\A ");
        for (i = 0; i < copy.size(); ++i) {
            e = (PExpression)copy.get(i);
            e.apply(this);
            this.moduleStringAppend(" \\in ");
            this.typeRestrictor.getRestrictedNode(e).apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend(" : ");
        if (assertionMode) {
            for (i = 0; i < copy.size(); ++i) {
                e = (PExpression)copy.get(i);
                this.moduleStringAppend("TLCSet(");
                this.moduleStringAppend("" + (i + 1));
                this.moduleStringAppend(", ");
                e.apply(this);
                this.moduleStringAppend(")");
                this.moduleStringAppend(" /\\ ");
            }
            assertionMode = false;
            this.moduleStringAppend(" IF ");
            node.getImplication().apply(this);
            this.moduleStringAppend(" THEN TRUE ");
            this.moduleStringAppend(" ELSE SaveValue(<< \"");
            this.moduleStringAppend(assertionName);
            this.moduleStringAppend("\", ");
            for (i = start; i < end; ++i) {
                this.moduleStringAppend("TLCGet(");
                this.moduleStringAppend("" + (i + 1));
                this.moduleStringAppend(")");
                if (i >= copy.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend(" >>) ");
            this.moduleStringAppend("/\\ TLCSet(");
            this.moduleStringAppend("" + start);
            this.moduleStringAppend(", FALSE)");
            this.moduleStringAppend(")");
            this.moduleStringAppend(" /\\ TLCGet(");
            this.moduleStringAppend("" + start);
            this.moduleStringAppend(")");
        } else {
            node.getImplication().apply(this);
        }
        this.outAForallPredicate(node);
    }

    @Override
    public void caseAExistsPredicate(AExistsPredicate node) {
        this.inAExistsPredicate(node);
        this.moduleStringAppend("\\E ");
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        for (int i = 0; i < copy.size(); ++i) {
            PExpression e = (PExpression)copy.get(i);
            e.apply(this);
            this.moduleStringAppend(" \\in ");
            this.typeRestrictor.getRestrictedNode(e).apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend(" : ");
        if (this.typeRestrictor.isARemovedNode(node.getPredicate())) {
            this.moduleStringAppend("TRUE");
        } else {
            node.getPredicate().apply(this);
        }
        this.outAExistsPredicate(node);
    }

    @Override
    public void caseANegationPredicate(ANegationPredicate node) {
        this.inANegationPredicate(node);
        this.moduleStringAppend("\\neg(");
        node.getPredicate().apply(this);
        this.moduleStringAppend(")");
        this.outANegationPredicate(node);
    }

    @Override
    public void caseAIntegerExpression(AIntegerExpression node) {
        this.inAIntegerExpression(node);
        if (node.getLiteral() != null) {
            this.moduleStringAppend(node.getLiteral().getText());
        }
        this.outAIntegerExpression(node);
    }

    @Override
    public void caseAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        String name = this.renamer.getNameOfRef(node);
        if (null == name) {
            name = node.getName().getText().trim();
        }
        this.printBDefinition(name, node.getParameters(), node.getRhs());
    }

    @Override
    public void caseAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        String oldName = node.getName().getText().trim();
        if (StandardModules.isKeywordInModuleExternalFunctions(oldName)) {
            return;
        }
        String name = this.renamer.getName(node);
        if (null == name) {
            name = node.getName().getText().trim();
        }
        this.moduleStringAppend(name);
        LinkedList<PExpression> args = node.getParameters();
        if (!args.isEmpty()) {
            this.moduleStringAppend("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    this.moduleStringAppend(", ");
                }
                ((PExpression)args.get(i)).apply(this);
            }
            this.moduleStringAppend(")");
        }
        this.moduleStringAppend(" == ");
        if (TLC4BGlobals.isForceTLCToEvalConstants()) {
            this.moduleStringAppend("TLCEval(");
        }
        node.getRhs().apply(this);
        if (TLC4BGlobals.isForceTLCToEvalConstants()) {
            this.moduleStringAppend(")");
        }
        this.moduleStringAppend("\n");
    }

    @Override
    public void caseASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        String name = this.renamer.getNameOfRef(node);
        if (null == name) {
            name = node.getName().getText().trim();
        }
        this.printBDefinition(name, node.getParameters(), node.getRhs());
    }

    private void printBDefinition(String name, List<PExpression> args, Node rightSide) {
        if (StandardModules.isKeywordInModuleExternalFunctions(name)) {
            return;
        }
        this.moduleStringAppend(name);
        if (!args.isEmpty()) {
            this.moduleStringAppend("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    this.moduleStringAppend(", ");
                }
                args.get(i).apply(this);
            }
            this.moduleStringAppend(")");
        }
        this.moduleStringAppend(" == ");
        rightSide.apply(this);
        this.moduleStringAppend("\n");
    }

    @Override
    public void caseADefinitionExpression(ADefinitionExpression node) {
        String name = this.renamer.getNameOfRef(node);
        if (null == name) {
            name = node.getDefLiteral().getText().trim();
        }
        this.printBDefinitionCall(name, node.getParameters());
    }

    @Override
    public void caseADefinitionPredicate(ADefinitionPredicate node) {
        String name = this.renamer.getNameOfRef(node);
        if (null == name) {
            name = node.getDefLiteral().getText().trim();
        }
        this.printBDefinitionCall(name, node.getParameters());
    }

    @Override
    public void caseADefinitionSubstitution(ADefinitionSubstitution node) {
        String name = this.renamer.getNameOfRef(node);
        if (null == name) {
            name = node.getDefLiteral().getText().trim();
        }
        this.printBDefinitionCall(name, node.getParameters());
    }

    public void printBDefinitionCall(String name, List<PExpression> args) {
        this.moduleStringAppend(name);
        if (!args.isEmpty()) {
            this.moduleStringAppend("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    this.moduleStringAppend(", ");
                }
                args.get(i).apply(this);
            }
            this.moduleStringAppend(")");
        }
    }

    @Override
    public void caseAIntegerSetExpression(AIntegerSetExpression node) {
        this.inAIntegerSetExpression(node);
        this.moduleStringAppend("Int");
        this.outAIntegerSetExpression(node);
    }

    @Override
    public void caseANaturalSetExpression(ANaturalSetExpression node) {
        this.inANaturalSetExpression(node);
        this.moduleStringAppend("Nat");
        this.outANaturalSetExpression(node);
    }

    @Override
    public void caseANatural1SetExpression(ANatural1SetExpression node) {
        this.inANatural1SetExpression(node);
        this.moduleStringAppend("(Nat \\ {0})");
        this.outANatural1SetExpression(node);
    }

    @Override
    public void caseAIntSetExpression(AIntSetExpression node) {
        this.inAIntSetExpression(node);
        this.moduleStringAppend("(" + TLC4BGlobals.getMIN_INT() + ".." + TLC4BGlobals.getMAX_INT() + ")");
        this.outAIntSetExpression(node);
    }

    @Override
    public void caseANatSetExpression(ANatSetExpression node) {
        this.inANatSetExpression(node);
        this.moduleStringAppend("(0.." + TLC4BGlobals.getMAX_INT() + ")");
        this.outANatSetExpression(node);
    }

    @Override
    public void caseANat1SetExpression(ANat1SetExpression node) {
        this.inANat1SetExpression(node);
        this.moduleStringAppend("(1.." + TLC4BGlobals.getMAX_INT() + ")");
        this.outANat1SetExpression(node);
    }

    @Override
    public void caseAIntervalExpression(AIntervalExpression node) {
        this.inAIntervalExpression(node);
        this.moduleStringAppend("(");
        node.getLeftBorder().apply(this);
        this.moduleStringAppend(" .. ");
        node.getRightBorder().apply(this);
        this.moduleStringAppend(")");
        this.outAIntervalExpression(node);
    }

    @Override
    public void caseAGreaterPredicate(AGreaterPredicate node) {
        this.inAGreaterPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" > ");
        node.getRight().apply(this);
        this.outAGreaterPredicate(node);
    }

    @Override
    public void caseALessPredicate(ALessPredicate node) {
        this.inALessPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" < ");
        node.getRight().apply(this);
        this.outALessPredicate(node);
    }

    @Override
    public void caseAGreaterEqualPredicate(AGreaterEqualPredicate node) {
        this.inAGreaterEqualPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" >= ");
        node.getRight().apply(this);
        this.outAGreaterEqualPredicate(node);
    }

    @Override
    public void caseALessEqualPredicate(ALessEqualPredicate node) {
        this.inALessEqualPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" =< ");
        node.getRight().apply(this);
        this.outALessEqualPredicate(node);
    }

    @Override
    public void caseAMinExpression(AMinExpression node) {
        this.moduleStringAppend("Min");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAMaxExpression(AMaxExpression node) {
        this.moduleStringAppend("Max");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAUnaryMinusExpression(AUnaryMinusExpression node) {
        this.inAUnaryMinusExpression(node);
        this.moduleStringAppend("-");
        node.getExpression().apply(this);
        this.outAUnaryMinusExpression(node);
    }

    @Override
    public void caseAAddExpression(AAddExpression node) {
        this.inAAddExpression(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" + ");
        node.getRight().apply(this);
        this.outAAddExpression(node);
    }

    @Override
    public void caseADivExpression(ADivExpression node) {
        this.inADivExpression(node);
        this.moduleStringAppend("BDivision");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
        this.outADivExpression(node);
    }

    @Override
    public void caseAPowerOfExpression(APowerOfExpression node) {
        this.moduleStringAppend("BPowerOf");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAModuloExpression(AModuloExpression node) {
        this.inAModuloExpression(node);
        this.moduleStringAppend("BModulo");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
        this.outAModuloExpression(node);
    }

    @Override
    public void caseAGeneralProductExpression(AGeneralProductExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        this.moduleStringAppend("Pi(");
        this.moduleStringAppend("{");
        this.moduleStringAppend("<<");
        this.moduleStringAppend("<<");
        this.printIdentifierList(copy);
        this.moduleStringAppend(">>");
        this.moduleStringAppend(", ");
        node.getExpression().apply(this);
        this.moduleStringAppend(">>");
        this.moduleStringAppend(" : ");
        this.printIdentifierList(copy);
        this.moduleStringAppend(" \\in ");
        if (this.typeRestrictor.isARemovedNode(node.getPredicates())) {
            this.printTypesOfIdentifierList(copy);
        } else {
            this.moduleStringAppend("{");
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            this.printTypesOfIdentifierList(copy);
            this.moduleStringAppend(" : ");
            node.getPredicates().apply(this);
            this.moduleStringAppend("}");
        }
        this.moduleStringAppend("}");
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAGeneralSumExpression(AGeneralSumExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        this.moduleStringAppend("Sigma(");
        this.moduleStringAppend("{");
        this.moduleStringAppend("<<");
        this.moduleStringAppend("<<");
        this.printIdentifierList(copy);
        this.moduleStringAppend(">>");
        this.moduleStringAppend(", ");
        node.getExpression().apply(this);
        this.moduleStringAppend(">>");
        this.moduleStringAppend(" : ");
        this.printIdentifierList(copy);
        this.moduleStringAppend(" \\in ");
        if (this.typeRestrictor.isARemovedNode(node.getPredicates())) {
            this.printTypesOfIdentifierList(copy);
        } else {
            this.moduleStringAppend("{");
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            this.printTypesOfIdentifierList(copy);
            this.moduleStringAppend(" : ");
            node.getPredicates().apply(this);
            this.moduleStringAppend("}");
        }
        this.moduleStringAppend("}");
        this.moduleStringAppend(")");
    }

    @Override
    public void caseASuccessorExpression(ASuccessorExpression node) {
        this.inASuccessorExpression(node);
        this.moduleStringAppend("succ");
        this.outASuccessorExpression(node);
    }

    @Override
    public void caseAPredecessorExpression(APredecessorExpression node) {
        this.inAPredecessorExpression(node);
        this.moduleStringAppend("pred");
        this.outAPredecessorExpression(node);
    }

    @Override
    public void caseAMaxIntExpression(AMaxIntExpression node) {
        this.moduleStringAppend(String.valueOf(TLC4BGlobals.getMAX_INT()));
    }

    @Override
    public void caseAMinIntExpression(AMinIntExpression node) {
        this.moduleStringAppend(String.valueOf(TLC4BGlobals.getMIN_INT()));
    }

    private void printIdentifierList(List<PExpression> copy) {
        if (copy.size() == 1) {
            copy.get(0).apply(this);
            return;
        }
        this.moduleStringAppend("<<");
        for (int i = 0; i < copy.size(); ++i) {
            if (i != 0) {
                this.moduleStringAppend(", ");
            }
            copy.get(i).apply(this);
        }
        this.moduleStringAppend(">>");
    }

    private void printTypesOfIdentifierList(List<PExpression> copy) {
        if (copy.size() > 1) {
            this.moduleStringAppend("(");
        }
        for (int i = 0; i < copy.size(); ++i) {
            this.moduleStringAppend("(");
            this.typeRestrictor.getRestrictedNode(copy.get(i)).apply(this);
            this.moduleStringAppend(")");
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(" \\times ");
        }
        if (copy.size() > 1) {
            this.moduleStringAppend(")");
        }
    }

    @Override
    public void caseALambdaExpression(ALambdaExpression node) {
        this.inALambdaExpression(node);
        if (this.typechecker.getType(node) instanceof SetType) {
            this.moduleStringAppend("{<<");
            ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
            this.printIdentifierList(copy);
            this.moduleStringAppend(", ");
            node.getExpression().apply(this);
            this.moduleStringAppend(">> : ");
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            if (this.typeRestrictor.isARemovedNode(node.getPredicate())) {
                this.printTypesOfIdentifierList(copy);
            } else {
                this.moduleStringAppend("{");
                this.printIdentifierList(copy);
                this.moduleStringAppend(" \\in ");
                this.printTypesOfIdentifierList(copy);
                this.moduleStringAppend(" : ");
                node.getPredicate().apply(this);
                this.moduleStringAppend("}");
            }
            this.moduleStringAppend("}");
        } else {
            this.moduleStringAppend("[");
            ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            if (this.typeRestrictor.isARemovedNode(node.getPredicate())) {
                this.printTypesOfIdentifierList(copy);
            } else {
                this.moduleStringAppend("{");
                this.printIdentifierList(copy);
                this.moduleStringAppend(" \\in ");
                this.printTypesOfIdentifierList(copy);
                this.moduleStringAppend(" : ");
                node.getPredicate().apply(this);
                this.moduleStringAppend("}");
            }
            this.moduleStringAppend(" |-> ");
            node.getExpression().apply(this);
            this.moduleStringAppend("]");
        }
        this.outALambdaExpression(node);
    }

    @Override
    public void caseAFunctionExpression(AFunctionExpression node) {
        ArrayList<PExpression> copy;
        AIdentifierExpression id;
        String name;
        this.inAFunctionExpression(node);
        if (node.getIdentifier() instanceof AIdentifierExpression && StandardModules.isAbstractConstant(name = Utils.getTIdentifierListAsString((id = (AIdentifierExpression)node.getIdentifier()).getIdentifier()))) {
            this.moduleStringAppend(name);
            this.moduleStringAppend("(");
            ArrayList<PExpression> copy2 = new ArrayList<PExpression>(node.getParameters());
            ((PExpression)copy2.get(0)).apply(this);
            this.moduleStringAppend(")");
            return;
        }
        BType type = this.typechecker.getType(node.getIdentifier());
        if (type instanceof FunctionType) {
            node.getIdentifier().apply(this);
            this.moduleStringAppend("[");
            copy = new ArrayList<PExpression>(node.getParameters());
            for (int i = 0; i < copy.size(); ++i) {
                if (i != 0) {
                    this.moduleStringAppend(", ");
                }
                ((PExpression)copy.get(i)).apply(this);
            }
            this.moduleStringAppend("]");
        } else {
            if (TLC4BGlobals.checkWelldefinedness()) {
                this.moduleStringAppend("RelCall");
            } else {
                this.moduleStringAppend("RelCallWithoutWDCheck");
            }
            this.moduleStringAppend("(");
            node.getIdentifier().apply(this);
            this.moduleStringAppend(", ");
            copy = new ArrayList<PExpression>(node.getParameters());
            if (copy.size() > 1) {
                this.moduleStringAppend("<<");
            }
            for (int i = 0; i < copy.size(); ++i) {
                if (i != 0) {
                    this.moduleStringAppend(", ");
                }
                ((PExpression)copy.get(i)).apply(this);
            }
            if (copy.size() > 1) {
                this.moduleStringAppend(">>");
            }
            this.moduleStringAppend(")");
        }
        this.outAFunctionExpression(node);
    }

    @Override
    public void caseARangeExpression(ARangeExpression node) {
        if (this.typechecker.getType(node.getExpression()) instanceof FunctionType) {
            this.moduleStringAppend("Range");
        } else {
            this.moduleStringAppend("RelRange");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAImageExpression(AImageExpression node) {
        if (this.typechecker.getType(node.getLeft()) instanceof FunctionType) {
            this.moduleStringAppend("Image");
        } else {
            this.moduleStringAppend("RelImage");
        }
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseATotalFunctionExpression(ATotalFunctionExpression node) {
        BType type = this.typechecker.getType(node);
        BType subtype = ((SetType)type).getSubtype();
        if (subtype instanceof FunctionType) {
            this.moduleStringAppend("[");
            node.getLeft().apply(this);
            this.moduleStringAppend(" -> ");
            node.getRight().apply(this);
            this.moduleStringAppend("]");
        } else {
            if (node.parent() instanceof AMemberPredicate && !this.typeRestrictor.isARemovedNode(node.parent()) && !this.tlaModule.getInitPredicates().contains(node.parent())) {
                this.moduleStringAppend("RelTotalFuncEleOf");
            } else {
                this.moduleStringAppend("RelTotalFunc");
            }
            this.moduleStringAppend("(");
            node.getLeft().apply(this);
            this.moduleStringAppend(", ");
            node.getRight().apply(this);
            this.moduleStringAppend(")");
        }
    }

    private boolean recursiveIsElementOfTest(Node node) {
        Node parent = node.parent();
        if (parent instanceof AMemberPredicate && !this.typeRestrictor.isARemovedNode(parent) && !this.tlaModule.getInitPredicates().contains(parent)) {
            return true;
        }
        String clazz = parent.getClass().getName();
        if (clazz.contains("Total") || clazz.contains("Partial")) {
            return this.recursiveIsElementOfTest(node.parent());
        }
        return false;
    }

    private void setOfFunctions(Node node, String funcName, String relName, String relEleOfName, Node left, Node right) {
        BType type = this.typechecker.getType(node);
        BType subtype = ((SetType)type).getSubtype();
        if (subtype instanceof FunctionType) {
            this.moduleStringAppend(funcName);
        } else if (this.recursiveIsElementOfTest(node)) {
            this.moduleStringAppend(relEleOfName);
        } else {
            this.moduleStringAppend(relName);
        }
        this.moduleStringAppend("(");
        left.apply(this);
        this.moduleStringAppend(", ");
        right.apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseATotalInjectionExpression(ATotalInjectionExpression node) {
        this.setOfFunctions(node, "TotalInjFunc", "RelTotalInjFunc", "RelTotalInjFuncEleOf", node.getLeft(), node.getRight());
    }

    @Override
    public void caseATotalSurjectionExpression(ATotalSurjectionExpression node) {
        this.setOfFunctions(node, "TotalSurFunc", "RelTotalSurFunc", "RelTotalSurFuncEleOf", node.getLeft(), node.getRight());
    }

    @Override
    public void caseATotalBijectionExpression(ATotalBijectionExpression node) {
        this.setOfFunctions(node, "TotalBijFunc", "RelTotalBijFunc", "RelTotalBijFuncEleOf", node.getLeft(), node.getRight());
    }

    private void setOfPartialFunctions(Node node, String funcName, String funcEleOfName, String relName, String relEleOfName, Node left, Node right) {
        BType type = this.typechecker.getType(node);
        BType subtype = ((SetType)type).getSubtype();
        if (subtype instanceof FunctionType) {
            Node parent = node.parent();
            if (parent instanceof AMemberPredicate && !this.typeRestrictor.isARemovedNode(parent)) {
                this.moduleStringAppend(funcEleOfName);
                this.moduleStringAppend("(");
                ((AMemberPredicate)parent).getLeft().apply(this);
                this.moduleStringAppend(", ");
                left.apply(this);
                this.moduleStringAppend(", ");
                right.apply(this);
                this.moduleStringAppend(")");
                return;
            }
            this.moduleStringAppend(funcName);
        } else if (this.recursiveIsElementOfTest(node)) {
            this.moduleStringAppend(relEleOfName);
        } else {
            this.moduleStringAppend(relName);
        }
        this.moduleStringAppend("(");
        left.apply(this);
        this.moduleStringAppend(", ");
        right.apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAPartialFunctionExpression(APartialFunctionExpression node) {
        this.setOfPartialFunctions(node, "ParFunc", "ParFuncEleOf", "RelParFunc", "RelParFuncEleOf", node.getLeft(), node.getRight());
    }

    @Override
    public void caseAPartialInjectionExpression(APartialInjectionExpression node) {
        this.setOfPartialFunctions(node, "ParInjFunc", "ParInjFuncEleOf", "RelParInjFunc", "RelParInjFuncEleOf", node.getLeft(), node.getRight());
    }

    @Override
    public void caseAPartialSurjectionExpression(APartialSurjectionExpression node) {
        this.setOfPartialFunctions(node, "ParSurFunc", "ParSurFuncEleOf", "RelParSurFunc", "RelParSurFuncEleOf", node.getLeft(), node.getRight());
    }

    @Override
    public void caseAPartialBijectionExpression(APartialBijectionExpression node) {
        this.setOfPartialFunctions(node, "ParBijFunc", "ParBijFuncEleOf", "RelParBijFunc", "RelParBijFuncEleOf", node.getLeft(), node.getRight());
    }

    @Override
    public void caseASetExtensionExpression(ASetExtensionExpression node) {
        if (this.typechecker.getType(node) instanceof FunctionType) {
            this.moduleStringAppend("(");
            for (int i = 0; i < node.getExpressions().size(); ++i) {
                ACoupleExpression couple = (ACoupleExpression)node.getExpressions().get(i);
                Node left = couple.getList().get(0);
                Node right = couple.getList().get(1);
                left.apply(this);
                this.moduleStringAppend(":>");
                right.apply(this);
                if (i >= node.getExpressions().size() - 1) continue;
                this.moduleStringAppend(" @@ ");
            }
            this.moduleStringAppend(")");
            return;
        }
        this.moduleStringAppend("{");
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getExpressions());
        for (int i = 0; i < copy.size(); ++i) {
            if (i != 0) {
                this.moduleStringAppend(", ");
            }
            ((PExpression)copy.get(i)).apply(this);
        }
        this.moduleStringAppend("}");
    }

    @Override
    public void caseAEmptySetExpression(AEmptySetExpression node) {
        this.evalEmptyFunctionOrRelation(node);
    }

    @Override
    public void caseAMemberPredicate(AMemberPredicate node) {
        this.inAMemberPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\in ");
        node.getRight().apply(this);
        this.outAMemberPredicate(node);
    }

    @Override
    public void caseANotMemberPredicate(ANotMemberPredicate node) {
        this.inANotMemberPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\notin ");
        node.getRight().apply(this);
        this.outANotMemberPredicate(node);
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        this.inAComprehensionSetExpression(node);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        if (copy.size() < 3) {
            this.moduleStringAppend("{");
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            this.printTypesOfIdentifierList(copy);
            this.moduleStringAppend(": ");
            if (this.typeRestrictor.isARemovedNode(node.getPredicates())) {
                this.moduleStringAppend("TRUE");
            } else {
                node.getPredicates().apply(this);
            }
            this.moduleStringAppend("}");
        } else {
            this.moduleStringAppend("{");
            this.printAuxiliaryVariables(copy.size());
            this.moduleStringAppend(": t_ \\in ");
            this.moduleStringAppend("{");
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            for (int i = 0; i < copy.size(); ++i) {
                this.moduleStringAppend("(");
                this.typeRestrictor.getRestrictedNode((Node)copy.get(i)).apply(this);
                this.moduleStringAppend(")");
                if (i >= copy.size() - 1) continue;
                this.moduleStringAppend(" \\times ");
            }
            this.moduleStringAppend(": ");
            if (this.typeRestrictor.isARemovedNode(node.getPredicates())) {
                this.moduleStringAppend("TRUE");
            } else {
                node.getPredicates().apply(this);
            }
            this.moduleStringAppend("}");
            this.moduleStringAppend("}");
        }
        this.outAComprehensionSetExpression(node);
    }

    @Override
    public void caseAEventBComprehensionSetExpression(AEventBComprehensionSetExpression node) {
        this.inAEventBComprehensionSetExpression(node);
        this.moduleStringAppend("{");
        node.getExpression().apply(this);
        this.moduleStringAppend(": ");
        node.getPredicates().apply(this);
        this.moduleStringAppend("}");
        this.outAEventBComprehensionSetExpression(node);
    }

    private void printAuxiliaryVariables(int size) {
        int i;
        for (i = 0; i < size - 1; ++i) {
            this.moduleStringAppend("<<");
        }
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend("t_[" + (i + 1) + "]");
            if (i == 0) continue;
            this.moduleStringAppend(">>");
        }
    }

    @Override
    public void caseAUnionExpression(AUnionExpression node) {
        this.inAUnionExpression(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\cup ");
        node.getRight().apply(this);
        this.outAUnionExpression(node);
    }

    @Override
    public void caseAIntersectionExpression(AIntersectionExpression node) {
        this.inAIntersectionExpression(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\cap ");
        node.getRight().apply(this);
        this.outAIntersectionExpression(node);
    }

    @Override
    public void caseASetSubtractionExpression(ASetSubtractionExpression node) {
        this.inASetSubtractionExpression(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\ ");
        node.getRight().apply(this);
        this.outASetSubtractionExpression(node);
    }

    @Override
    public void caseAPowSubsetExpression(APowSubsetExpression node) {
        this.inAPowSubsetExpression(node);
        this.moduleStringAppend("SUBSET(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
        this.outAPowSubsetExpression(node);
    }

    @Override
    public void caseAPow1SubsetExpression(APow1SubsetExpression node) {
        this.moduleStringAppend("Pow1");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAFinSubsetExpression(AFinSubsetExpression node) {
        this.moduleStringAppend("Fin");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAFin1SubsetExpression(AFin1SubsetExpression node) {
        this.moduleStringAppend("Fin1");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseACardExpression(ACardExpression node) {
        BType type = this.typechecker.getType(node.getExpression());
        if (type instanceof FunctionType) {
            this.moduleStringAppend("Cardinality(DOMAIN(");
            node.getExpression().apply(this);
            this.moduleStringAppend("))");
        } else {
            this.moduleStringAppend("Cardinality(");
            node.getExpression().apply(this);
            this.moduleStringAppend(")");
        }
    }

    @Override
    public void caseASubsetPredicate(ASubsetPredicate node) {
        this.inASubsetPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\subseteq ");
        node.getRight().apply(this);
        this.outASubsetPredicate(node);
    }

    @Override
    public void caseASubsetStrictPredicate(ASubsetStrictPredicate node) {
        this.inASubsetStrictPredicate(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\in (SUBSET(");
        node.getRight().apply(this);
        this.moduleStringAppend(") \\ {");
        node.getRight().apply(this);
        this.moduleStringAppend("})");
        this.outASubsetStrictPredicate(node);
    }

    @Override
    public void caseANotSubsetPredicate(ANotSubsetPredicate node) {
        this.moduleStringAppend("NotSubset");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseANotSubsetStrictPredicate(ANotSubsetStrictPredicate node) {
        this.moduleStringAppend("NotStrictSubset");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAGeneralUnionExpression(AGeneralUnionExpression node) {
        this.inAGeneralUnionExpression(node);
        this.moduleStringAppend("UNION(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
        this.outAGeneralUnionExpression(node);
    }

    @Override
    public void caseAGeneralIntersectionExpression(AGeneralIntersectionExpression node) {
        this.inAGeneralIntersectionExpression(node);
        this.moduleStringAppend("Inter(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
        this.outAGeneralIntersectionExpression(node);
    }

    @Override
    public void caseAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        this.moduleStringAppend("UNION({");
        node.getExpression().apply(this);
        this.moduleStringAppend(": ");
        this.printIdentifierList(copy);
        if (this.typeRestrictor.isARemovedNode(node.getPredicates())) {
            this.moduleStringAppend(" \\in ");
            this.printTypesOfIdentifierList(copy);
            this.moduleStringAppend("})");
        } else {
            this.moduleStringAppend(" \\in {");
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            this.printTypesOfIdentifierList(copy);
            this.moduleStringAppend(": ");
            node.getPredicates().apply(this);
            this.moduleStringAppend("}");
            this.moduleStringAppend("})");
        }
    }

    @Override
    public void caseAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        this.moduleStringAppend("Inter({");
        node.getExpression().apply(this);
        this.moduleStringAppend(": ");
        this.printIdentifierList(copy);
        if (this.typeRestrictor.isARemovedNode(node.getPredicates())) {
            this.moduleStringAppend(" \\in ");
            this.printTypesOfIdentifierList(copy);
            this.moduleStringAppend("})");
        } else {
            this.moduleStringAppend(" \\in {");
            this.printIdentifierList(copy);
            this.moduleStringAppend(" \\in ");
            this.printTypesOfIdentifierList(copy);
            this.moduleStringAppend(": ");
            node.getPredicates().apply(this);
            this.moduleStringAppend("}");
            this.moduleStringAppend("})");
        }
    }

    @Override
    public void caseACoupleExpression(ACoupleExpression node) {
        int i;
        this.inACoupleExpression(node);
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getList());
        for (i = 0; i < copy.size() - 1; ++i) {
            this.moduleStringAppend("<<");
        }
        for (i = 0; i < copy.size(); ++i) {
            if (i != 0) {
                this.moduleStringAppend(", ");
            }
            ((PExpression)copy.get(i)).apply(this);
            if (i == 0) continue;
            this.moduleStringAppend(">>");
        }
        this.outACoupleExpression(node);
    }

    @Override
    public void caseARelationsExpression(ARelationsExpression node) {
        this.moduleStringAppend("Relations(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseADomainExpression(ADomainExpression node) {
        this.inADomainExpression(node);
        if (this.typechecker.getType(node.getExpression()) instanceof FunctionType) {
            this.moduleStringAppend("DOMAIN ");
            node.getExpression().apply(this);
        } else {
            this.moduleStringAppend("RelDomain(");
            node.getExpression().apply(this);
            this.moduleStringAppend(")");
        }
        this.outADomainExpression(node);
    }

    @Override
    public void caseAIdentityExpression(AIdentityExpression node) {
        this.inAIdentityExpression(node);
        if (this.typechecker.getType(node) instanceof FunctionType) {
            this.moduleStringAppend("Id");
        } else {
            this.moduleStringAppend("RelId");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
        this.outAIdentityExpression(node);
    }

    @Override
    public void caseADomainRestrictionExpression(ADomainRestrictionExpression node) {
        if (this.typechecker.getType(node) instanceof FunctionType) {
            this.moduleStringAppend("DomRes");
        } else {
            this.moduleStringAppend("RelDomRes");
        }
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseADomainSubtractionExpression(ADomainSubtractionExpression node) {
        if (this.typechecker.getType(node) instanceof FunctionType) {
            this.moduleStringAppend("DomSub");
        } else {
            this.moduleStringAppend("RelDomSub");
        }
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseARangeRestrictionExpression(ARangeRestrictionExpression node) {
        if (this.typechecker.getType(node) instanceof FunctionType) {
            this.moduleStringAppend("RanRes");
        } else {
            this.moduleStringAppend("RelRanRes");
        }
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseARangeSubtractionExpression(ARangeSubtractionExpression node) {
        if (this.typechecker.getType(node) instanceof FunctionType) {
            this.moduleStringAppend("RanSub");
        } else {
            this.moduleStringAppend("RelRanSub");
        }
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAReverseExpression(AReverseExpression node) {
        if (this.typechecker.getType(node.getExpression()) instanceof FunctionType) {
            this.moduleStringAppend("Inverse");
        } else {
            this.moduleStringAppend("RelInverse");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAOverwriteExpression(AOverwriteExpression node) {
        if (this.typechecker.getType(node) instanceof FunctionType) {
            this.moduleStringAppend("Override");
        } else {
            this.moduleStringAppend("RelOverride");
        }
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseADirectProductExpression(ADirectProductExpression node) {
        this.moduleStringAppend("RelDirectProduct");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAParallelProductExpression(AParallelProductExpression node) {
        this.moduleStringAppend("RelParallelProduct");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseACompositionExpression(ACompositionExpression node) {
        this.moduleStringAppend("RelComposition");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAFirstProjectionExpression(AFirstProjectionExpression node) {
        this.moduleStringAppend("RelPrj1");
        this.moduleStringAppend("(");
        node.getExp1().apply(this);
        this.moduleStringAppend(", ");
        node.getExp2().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseASecondProjectionExpression(ASecondProjectionExpression node) {
        this.moduleStringAppend("RelPrj2");
        this.moduleStringAppend("(");
        node.getExp1().apply(this);
        this.moduleStringAppend(", ");
        node.getExp2().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAIterationExpression(AIterationExpression node) {
        this.moduleStringAppend("RelIterate");
        this.moduleStringAppend("(");
        node.getLeft().apply(this);
        this.moduleStringAppend(", ");
        node.getRight().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAClosureExpression(AClosureExpression node) {
        this.moduleStringAppend("RelClosure1");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAReflexiveClosureExpression(AReflexiveClosureExpression node) {
        this.moduleStringAppend("RelClosure");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseATransFunctionExpression(ATransFunctionExpression node) {
        this.moduleStringAppend("RelFnc");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseATransRelationExpression(ATransRelationExpression node) {
        this.moduleStringAppend("RelRel");
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseASequenceExtensionExpression(ASequenceExtensionExpression node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getExpression());
        BType type = this.typechecker.getType(node);
        if (type instanceof FunctionType) {
            this.moduleStringAppend("<<");
            for (int i = 0; i < copy.size(); ++i) {
                ((PExpression)copy.get(i)).apply(this);
                if (i >= copy.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend(">>");
        } else {
            this.moduleStringAppend("{");
            for (int i = 0; i < copy.size(); ++i) {
                this.moduleStringAppend("<<");
                this.moduleStringAppend(String.valueOf(i + 1));
                this.moduleStringAppend(", ");
                ((PExpression)copy.get(i)).apply(this);
                this.moduleStringAppend(">>");
                if (i >= copy.size() - 1) continue;
                this.moduleStringAppend(", ");
            }
            this.moduleStringAppend("}");
        }
    }

    private void evalEmptyFunctionOrRelation(Node node) {
        this.moduleStringAppend(this.typechecker.getType(node) instanceof FunctionType ? "<<>>" : "{}");
    }

    @Override
    public void caseAEmptySequenceExpression(AEmptySequenceExpression node) {
        this.evalEmptyFunctionOrRelation(node);
    }

    @Override
    public void caseASeqExpression(ASeqExpression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof SetType) {
            this.moduleStringAppend("RelSeq");
        } else {
            this.moduleStringAppend("Seq");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseASizeExpression(ASizeExpression node) {
        this.printSequenceOrRelation(node.getExpression(), "Len", "RelSeqSize", node.getExpression(), null);
    }

    @Override
    public void caseAConcatExpression(AConcatExpression node) {
        BType type = this.typechecker.getType(node);
        if (type instanceof SetType) {
            this.moduleStringAppend("RelSeqConcat");
            this.moduleStringAppend("(");
            node.getLeft().apply(this);
            this.moduleStringAppend(", ");
            node.getRight().apply(this);
            this.moduleStringAppend(")");
        } else {
            this.inAConcatExpression(node);
            node.getLeft().apply(this);
            this.moduleStringAppend(" \\o ");
            node.getRight().apply(this);
            this.outAConcatExpression(node);
        }
    }

    @Override
    public void caseAInsertTailExpression(AInsertTailExpression node) {
        this.printSequenceOrRelation(node, "Append", "RelSeqAppend", node.getLeft(), node.getRight());
    }

    private void printSequenceOrRelation(Node node, String sequence, String relation, Node left, Node right) {
        BType type = this.typechecker.getType(node);
        if (type instanceof SetType) {
            this.moduleStringAppend(relation);
        } else {
            this.moduleStringAppend(sequence);
        }
        this.moduleStringAppend("(");
        left.apply(this);
        if (right != null) {
            this.moduleStringAppend(",");
            right.apply(this);
        }
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAFirstExpression(AFirstExpression node) {
        this.printSequenceOrRelation(node.getExpression(), "Head", "RelSeqFirst", node.getExpression(), null);
    }

    @Override
    public void caseATailExpression(ATailExpression node) {
        this.printSequenceOrRelation(node.getExpression(), "Tail", "RelSeqTail", node.getExpression(), null);
    }

    @Override
    public void caseAIseqExpression(AIseqExpression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof SetType) {
            if (this.recursiveIsElementOfTest(node.parent()) && !this.typeRestrictor.isARemovedNode(node.parent())) {
                this.moduleStringAppend("RelISeqEleOf");
            } else {
                this.moduleStringAppend("RelISeq");
            }
        } else if (node.parent() instanceof AMemberPredicate && !this.typeRestrictor.isARemovedNode(node.parent())) {
            this.moduleStringAppend("ISeqEleOf");
        } else {
            this.moduleStringAppend("ISeq");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseAIseq1Expression(AIseq1Expression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof SetType) {
            if (this.recursiveIsElementOfTest(node)) {
                this.moduleStringAppend("RelISeq1EleOf");
            } else {
                this.moduleStringAppend("RelISeq1");
            }
        } else if (this.recursiveIsElementOfTest(node)) {
            this.moduleStringAppend("ISeq1EleOf");
        } else {
            this.moduleStringAppend("ISeq1");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseASeq1Expression(ASeq1Expression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof SetType) {
            this.moduleStringAppend("RelSeq1");
        } else {
            this.moduleStringAppend("Seq1");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseALastExpression(ALastExpression node) {
        this.printSequenceOrRelation(node.getExpression(), "Last", "RelSeqLast", node.getExpression(), null);
    }

    @Override
    public void caseAInsertFrontExpression(AInsertFrontExpression node) {
        this.printSequenceOrRelation(node.getRight(), "Prepend", "RelSeqPrepend", node.getLeft(), node.getRight());
    }

    @Override
    public void caseAPermExpression(APermExpression node) {
        SetType set = (SetType)this.typechecker.getType(node);
        if (set.getSubtype() instanceof SetType) {
            this.moduleStringAppend("RelSeqPerm");
        } else {
            this.moduleStringAppend("Perm");
        }
        this.moduleStringAppend("(");
        node.getExpression().apply(this);
        this.moduleStringAppend(")");
    }

    @Override
    public void caseARevExpression(ARevExpression node) {
        this.printSequenceOrRelation(node, "Reverse", "RelSeqReverse", node.getExpression(), null);
    }

    @Override
    public void caseAFrontExpression(AFrontExpression node) {
        this.printSequenceOrRelation(node.getExpression(), "Front", "RelSeqFront", node.getExpression(), null);
    }

    @Override
    public void caseAGeneralConcatExpression(AGeneralConcatExpression node) {
        BType result = this.typechecker.getType(node.getExpression());
        if (!(result instanceof FunctionType) || !(((FunctionType)result).getRange() instanceof FunctionType)) {
            SetType expected2 = new SetType(new PairType(IntegerType.getInstance(), new SetType(new PairType(IntegerType.getInstance(), new UntypedType()))));
            this.typechecker.unify(expected2, result, node);
        }
        this.printSequenceOrRelation(node, "Conc", "RelSeqConc", node.getExpression(), null);
    }

    @Override
    public void caseARestrictFrontExpression(ARestrictFrontExpression node) {
        this.printSequenceOrRelation(node, "TakeFirstElements", "RelSeqTakeFirstElements", node.getLeft(), node.getRight());
    }

    @Override
    public void caseARestrictTailExpression(ARestrictTailExpression node) {
        this.printSequenceOrRelation(node, "DropFirstElements", "RelSeqDropFirstElements", node.getLeft(), node.getRight());
    }

    @Override
    public void caseAMinusOrSetSubtractExpression(AMinusOrSetSubtractExpression node) {
        this.inAMinusOrSetSubtractExpression(node);
        node.getLeft().apply(this);
        BType leftType = this.typechecker.getType(node.getLeft());
        if (leftType instanceof IntegerType) {
            this.moduleStringAppend(" - ");
        } else {
            this.moduleStringAppend(" \\ ");
        }
        node.getRight().apply(this);
        this.outAMinusOrSetSubtractExpression(node);
    }

    @Override
    public void caseAMultOrCartExpression(AMultOrCartExpression node) {
        this.inAMultOrCartExpression(node);
        node.getLeft().apply(this);
        BType leftType = this.typechecker.getType(node.getLeft());
        if (leftType instanceof IntegerType) {
            this.moduleStringAppend(" * ");
        } else {
            this.moduleStringAppend(" \\times ");
        }
        node.getRight().apply(this);
        this.outAMultOrCartExpression(node);
    }

    @Override
    public void caseACartesianProductExpression(ACartesianProductExpression node) {
        this.inACartesianProductExpression(node);
        node.getLeft().apply(this);
        this.moduleStringAppend(" \\times ");
        node.getRight().apply(this);
        this.outACartesianProductExpression(node);
    }

    @Override
    public void caseAConvertBoolExpression(AConvertBoolExpression node) {
        this.inAConvertBoolExpression(node);
        this.moduleStringAppend("(");
        if (node.getPredicate() != null) {
            node.getPredicate().apply(this);
        }
        this.moduleStringAppend(")");
        this.outAConvertBoolExpression(node);
    }

    @Override
    public void caseARecExpression(ARecExpression node) {
        this.moduleStringAppend("[");
        ArrayList<PRecEntry> copy = new ArrayList<PRecEntry>(node.getEntries());
        for (int i = 0; i < copy.size(); ++i) {
            ((PRecEntry)copy.get(i)).apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend("]");
    }

    @Override
    public void caseARecEntry(ARecEntry node) {
        this.moduleStringAppend(node.getIdentifier().getText());
        if (this.typechecker.getType(node.parent()) instanceof StructType) {
            this.moduleStringAppend(" |-> ");
        } else {
            this.moduleStringAppend(" : ");
        }
        node.getValue().apply(this);
    }

    @Override
    public void caseARecordFieldExpression(ARecordFieldExpression node) {
        this.inARecordFieldExpression(node);
        node.getRecord().apply(this);
        this.moduleStringAppend(".");
        this.moduleStringAppend(node.getIdentifier().getText());
        this.outARecordFieldExpression(node);
    }

    @Override
    public void caseAStructExpression(AStructExpression node) {
        this.moduleStringAppend("[");
        ArrayList<PRecEntry> copy = new ArrayList<PRecEntry>(node.getEntries());
        for (int i = 0; i < copy.size(); ++i) {
            ((PRecEntry)copy.get(i)).apply(this);
            if (i >= copy.size() - 1) continue;
            this.moduleStringAppend(", ");
        }
        this.moduleStringAppend("]");
    }

    public TLAModule getTLAModule() {
        return this.tlaModule;
    }
}

