/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.unchangedvariables;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.ABlockSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceOrSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIfElsifSubstitution;
import de.be4.classicalb.core.parser.node.AIfSubstitution;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.AParallelSubstitution;
import de.be4.classicalb.core.parser.node.ARecordFieldExpression;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASelectWhenSubstitution;
import de.be4.classicalb.core.parser.node.ASkipSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.exceptions.NotSupportedException;
import de.tlc4b.exceptions.SubstitutionException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class AssignedVariablesFinder
extends DepthFirstAdapter {
    protected final Hashtable<Node, HashSet<Node>> assignedVariablesTable = new Hashtable();
    private final MachineContext machineContext;

    public AssignedVariablesFinder(MachineContext machineContext) {
        this.machineContext = machineContext;
        machineContext.getStartNode().apply(this);
    }

    protected Hashtable<Node, HashSet<Node>> getAssignedVariablesTable() {
        return this.assignedVariablesTable;
    }

    private HashSet<Node> getVariableList(Node node) {
        return this.assignedVariablesTable.get(node);
    }

    @Override
    public void defaultOut(Node node) {
        HashSet<Node> assignedVariables = this.assignedVariablesTable.get(node);
        if (null != assignedVariables) {
            this.assignedVariablesTable.put(node.parent(), assignedVariables);
        }
    }

    @Override
    public void caseABlockSubstitution(ABlockSubstitution node) {
        this.inABlockSubstitution(node);
        if (node.getSubstitution() != null) {
            node.getSubstitution().apply(this);
        }
        this.outABlockSubstitution(node);
    }

    @Override
    public void caseAOperation(AOperation node) {
        node.getOperationBody().apply(this);
        this.assignedVariablesTable.put(node, this.getVariableList(node.getOperationBody()));
    }

    @Override
    public void caseAInitialisationMachineClause(AInitialisationMachineClause node) {
        node.getSubstitutions().apply(this);
        this.assignedVariablesTable.put(node, this.getVariableList(node.getSubstitutions()));
        HashSet<Node> allVariables = new HashSet<Node>(this.machineContext.getVariables().values());
        HashSet<Node> foundVariables = new HashSet<Node>(this.getVariableList(node.getSubstitutions()));
        if (allVariables.retainAll(foundVariables)) {
            HashSet<Node> missingVariables = new HashSet<Node>(this.machineContext.getVariables().values());
            missingVariables.removeAll(allVariables);
            throw new SubstitutionException("Initialisation Error: Missing assignment for variable(s): " + missingVariables);
        }
    }

    @Override
    public void caseABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>();
        for (PExpression e : copy) {
            Node identifier = this.machineContext.getReferenceNode(e);
            list.add(identifier);
        }
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getLhsExpression());
        HashSet<Node> list = new HashSet<Node>();
        for (PExpression e : copy) {
            PExpression assigned = this.getAssignedVariable(e);
            Node identifier = this.machineContext.getReferenceNode(assigned);
            list.add(identifier);
        }
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    private PExpression getAssignedVariable(PExpression e) {
        if (e instanceof AIdentifierExpression) {
            return e;
        }
        if (e instanceof AFunctionExpression) {
            return this.getAssignedVariable(((AFunctionExpression)e).getIdentifier());
        }
        if (e instanceof ARecordFieldExpression) {
            return this.getAssignedVariable(((ARecordFieldExpression)e).getRecord());
        }
        throw new NotSupportedException("Unknown assignment lhs: " + e);
    }

    @Override
    public void caseABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        HashSet<Node> list = new HashSet<Node>();
        for (PExpression e : copy) {
            Node identifier = this.machineContext.getReferenceNode(e);
            list.add(identifier);
        }
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    @Override
    public void caseAChoiceSubstitution(AChoiceSubstitution node) {
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getSubstitutions());
        HashSet<Node> list = new HashSet<Node>();
        for (PSubstitution e : copy) {
            e.apply(this);
            list.addAll(this.getVariableList(e));
        }
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    @Override
    public void caseAChoiceOrSubstitution(AChoiceOrSubstitution node) {
        node.getSubstitution().apply(this);
        this.assignedVariablesTable.put(node, this.getVariableList(node.getSubstitution()));
        this.defaultOut(node);
    }

    @Override
    public void caseAIfSubstitution(AIfSubstitution node) {
        node.getThen().apply(this);
        HashSet<Node> list = new HashSet<Node>(this.getVariableList(node.getThen()));
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getElsifSubstitutions());
        for (PSubstitution e : copy) {
            e.apply(this);
            list.addAll(this.getVariableList(e));
        }
        if (node.getElse() != null) {
            node.getElse().apply(this);
            list.addAll(this.getVariableList(node.getElse()));
        }
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    @Override
    public void caseAIfElsifSubstitution(AIfElsifSubstitution node) {
        node.getThenSubstitution().apply(this);
        HashSet<Node> list = new HashSet<Node>(this.getVariableList(node.getThenSubstitution()));
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    @Override
    public void caseAParallelSubstitution(AParallelSubstitution node) {
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getSubstitutions());
        for (PSubstitution e : copy) {
            e.apply(this);
        }
        HashSet<Node> list = new HashSet<Node>();
        for (PSubstitution e : copy) {
            HashSet<Node> listOfe = this.getVariableList(e);
            HashSet temp = new HashSet(list);
            temp.retainAll(listOfe);
            if (!temp.isEmpty()) {
                throw new SubstitutionException("The variable(s) " + temp + " are assigned twice");
            }
            list.addAll(listOfe);
        }
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    @Override
    public void caseASelectSubstitution(ASelectSubstitution node) {
        node.getThen().apply(this);
        HashSet<Node> list = new HashSet<Node>(this.getVariableList(node.getThen()));
        ArrayList<PSubstitution> copy = new ArrayList<PSubstitution>(node.getWhenSubstitutions());
        for (PSubstitution e : copy) {
            e.apply(this);
            list.addAll(this.getVariableList(e));
        }
        if (node.getElse() != null) {
            node.getElse().apply(this);
            list.addAll(this.getVariableList(node.getElse()));
        }
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }

    @Override
    public void caseASelectWhenSubstitution(ASelectWhenSubstitution node) {
        node.getSubstitution().apply(this);
        this.assignedVariablesTable.put(node, this.getVariableList(node.getSubstitution()));
        this.assignedVariablesTable.put(node.parent(), this.getVariableList(node.getSubstitution()));
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
        ArrayList<PDefinition> copy = new ArrayList<PDefinition>(node.getDefinitions());
        for (PDefinition e : copy) {
            e.apply(this);
        }
    }

    @Override
    public void caseADefinitionSubstitution(ADefinitionSubstitution node) {
        Node refNode = this.machineContext.getReferenceNode(node);
        HashSet<Node> assignedVariables = this.assignedVariablesTable.get(refNode);
        this.assignedVariablesTable.put(node, assignedVariables);
        this.assignedVariablesTable.put(node.parent(), assignedVariables);
    }

    @Override
    public void caseASkipSubstitution(ASkipSubstitution node) {
        HashSet list = new HashSet();
        this.assignedVariablesTable.put(node, list);
        this.defaultOut(node);
    }
}

