/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.typerestriction;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.tlc4b.analysis.MachineContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IdentifierDependencies
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final Map<Node, Set<Node>> usedIdentifier;

    public IdentifierDependencies(MachineContext machineContext) {
        this.machineContext = machineContext;
        this.usedIdentifier = new HashMap<Node, Set<Node>>();
    }

    public boolean containsIdentifier(Node node, Set<Node> set) {
        node.apply(this);
        return set.stream().anyMatch(this.usedIdentifier.get(node)::contains);
    }

    @Override
    public void defaultOut(Node node) {
        this.setSetToNode(node, this.usedIdentifier.get(node));
        this.setSetToNode(node.parent(), this.usedIdentifier.get(node));
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        Node refNode = this.machineContext.getReferenceNode(node);
        if (refNode == null) {
            refNode = node;
        }
        this.setSetToNode(node, Collections.singleton(refNode));
        this.defaultOut(node);
    }

    private void setSetToNode(Node node, Set<Node> set) {
        Set oldSet = this.usedIdentifier.computeIfAbsent(node, k -> new HashSet());
        if (set != null) {
            oldSet.addAll(set);
        }
        this.usedIdentifier.put(node, oldSet);
    }
}

