/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.tlc4b.analysis.MachineContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefinitionsSorter
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final Map<Node, Set<Node>> dependenciesMap;
    private Set<Node> current;
    private final List<PDefinition> allDefinitions;

    public List<PDefinition> getAllDefinitions() {
        return this.allDefinitions;
    }

    public DefinitionsSorter(MachineContext machineContext, List<PDefinition> allDefinitions) {
        this.machineContext = machineContext;
        this.dependenciesMap = new HashMap<Node, Set<Node>>();
        allDefinitions.forEach(def -> def.apply(this));
        this.allDefinitions = this.sort(new ArrayList<PDefinition>(allDefinitions));
    }

    private List<PDefinition> sort(List<PDefinition> list) {
        ArrayList<PDefinition> result = new ArrayList<PDefinition>();
        boolean newRun = true;
        block0: while (newRun) {
            newRun = false;
            for (PDefinition def : list) {
                Set<Node> set;
                if (result.contains(def) || !(set = this.dependenciesMap.get(def)).isEmpty()) continue;
                newRun = true;
                result.add(def);
                Node defRef = this.machineContext.getReferences().get(def);
                if (null != defRef) {
                    this.removeDef(defRef);
                    continue block0;
                }
                this.removeDef(def);
                continue block0;
            }
        }
        if (result.size() != list.size()) {
            throw new RuntimeException("Found cyclic Definitions.");
        }
        return result;
    }

    private void removeDef(Node def) {
        this.dependenciesMap.values().forEach(nodes -> nodes.remove(def));
    }

    private void startDefinition() {
        this.current = new HashSet<Node>();
    }

    private void endDefinition(Node def) {
        this.dependenciesMap.put(def, this.current);
        this.current = null;
    }

    @Override
    public void inAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.startDefinition();
    }

    @Override
    public void outAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.endDefinition(node);
    }

    @Override
    public void inAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.startDefinition();
    }

    @Override
    public void outAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.endDefinition(node);
    }

    @Override
    public void inASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.startDefinition();
    }

    @Override
    public void outASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.endDefinition(node);
    }

    @Override
    public void inADefinitionExpression(ADefinitionExpression node) {
        Node refNode = this.machineContext.getReferences().get(node);
        if (null != refNode) {
            this.current.add(refNode);
        }
    }

    @Override
    public void inAIdentifierExpression(AIdentifierExpression node) {
        Node identifierRef = this.machineContext.getReferences().get(node);
        if (identifierRef == null) {
            return;
        }
        if (this.machineContext.getConstants().containsValue(identifierRef)) {
            return;
        }
        if (this.machineContext.getReferences().get(identifierRef) instanceof PDefinition) {
            this.current.add(identifierRef);
        }
    }
}

