/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AGreaterPredicate;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.ALessEqualPredicate;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.tlc4b.analysis.MachineContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ConstantsEliminator
extends DepthFirstAdapter {
    private final Hashtable<Node, HashSet<Node>> dependsOnIdentifierTable = new Hashtable();
    private final MachineContext machineContext;
    private ValuesOfIdentifierFinder valuesOfConstantsFinder;
    private final HashMap<Node, Integer> integerValueTable = new HashMap();
    private LinkedHashMap<Node, Node> valueOfIdentifier;

    public Node getValueOfConstant(Node con) {
        return this.valueOfIdentifier.get(con);
    }

    public LinkedHashMap<Node, Node> getValueOfIdentifierMap() {
        return this.valueOfIdentifier;
    }

    public Integer getIntValue(Node node) {
        return this.integerValueTable.get(node);
    }

    public ConstantsEliminator(MachineContext machineContext) {
        this.machineContext = machineContext;
    }

    public void start() {
        AConstraintsMachineClause constraints;
        ConstantsInTreeFinder constantInTreeFinder = new ConstantsInTreeFinder();
        APropertiesMachineClause properties = this.machineContext.getPropertiesMachineClause();
        if (null != properties) {
            properties.apply(constantInTreeFinder);
        }
        if (null != (constraints = this.machineContext.getConstraintMachineClause())) {
            constraints.apply(constantInTreeFinder);
        }
        this.valuesOfConstantsFinder = new ValuesOfIdentifierFinder();
        this.valueOfIdentifier = new LinkedHashMap();
        LinkedList<Node> oldConstants = new LinkedList<Node>(this.machineContext.getConstantArrayList());
        if (!oldConstants.isEmpty()) {
            this.evalIdentifier(oldConstants);
        }
    }

    private void evalIdentifier(Collection<Node> ids) {
        LinkedList<PDefinition> defsList = new LinkedList<PDefinition>();
        boolean newRun = true;
        while (newRun) {
            newRun = false;
            block1: for (Node node : ids) {
                AIdentifierExpression id = (AIdentifierExpression)node;
                if (this.valueOfIdentifier.containsKey(id)) continue;
                HashSet idValues = (HashSet)this.valuesOfConstantsFinder.valuesOfIdentifierTable.get(id);
                for (Node val : idValues) {
                    HashSet<Node> idsInVal = this.dependsOnIdentifierTable.get(val);
                    if (!idsInVal.isEmpty()) continue;
                    this.removeAssignmentInPropertiesClause(val);
                    this.removeConstant(id);
                    AExpressionDefinitionDefinition def = new AExpressionDefinitionDefinition(id.getIdentifier().get(0).clone(), new LinkedList<PExpression>(), (PExpression)val);
                    this.machineContext.getReferences().put(def, id);
                    this.machineContext.getReferences().put(id, def);
                    defsList.add(def);
                    this.valueOfIdentifier.put(id, val);
                    this.removeIdentifier(ids, id);
                    newRun = true;
                    continue block1;
                }
            }
        }
        if (!defsList.isEmpty()) {
            ADefinitionsMachineClause clause = this.machineContext.getDefinitionMachineClause();
            if (null == clause) {
                clause = new ADefinitionsMachineClause(defsList);
                this.machineContext.getAbstractMachineParseUnit().getMachineClauses().add(clause);
                this.machineContext.setDefinitionsMachineClause(clause);
            } else {
                clause.getDefinitions().addAll(defsList);
            }
        }
    }

    private void removeConstant(AIdentifierExpression id) {
        LinkedHashMap<String, Node> constants = this.machineContext.getConstants();
        for (Map.Entry entry : ((HashMap)constants).entrySet()) {
            if (entry.getValue() != id) continue;
            constants.remove(entry.getKey());
            break;
        }
    }

    private void removeAssignmentInPropertiesClause(Node val) {
        AEqualPredicate equal = (AEqualPredicate)val.parent();
        Node parent = equal.parent();
        if (parent instanceof AConjunctPredicate) {
            AConjunctPredicate conjunction = (AConjunctPredicate)parent;
            PPredicate other = conjunction.getLeft() == equal ? conjunction.getRight() : conjunction.getLeft();
            Node parentParent = conjunction.parent();
            if (parentParent instanceof APropertiesMachineClause) {
                ((APropertiesMachineClause)parentParent).setPredicates(other);
            } else if (parentParent instanceof AConjunctPredicate) {
                if (((AConjunctPredicate)parentParent).getLeft() == parent) {
                    ((AConjunctPredicate)parentParent).setLeft(other);
                } else {
                    ((AConjunctPredicate)parentParent).setRight(other);
                }
            }
        } else if (parent instanceof APropertiesMachineClause) {
            this.machineContext.setPropertiesMachineClaus(null);
            this.machineContext.getAbstractMachineParseUnit().getMachineClauses().remove(parent);
        }
    }

    private void removeIdentifier(Collection<Node> collection, Node identifierToRemove) {
        for (Node id : collection) {
            HashSet idValues = (HashSet)this.valuesOfConstantsFinder.valuesOfIdentifierTable.get(id);
            for (Node val : idValues) {
                HashSet<Node> idsInVal = this.dependsOnIdentifierTable.get(val);
                idsInVal.remove(identifierToRemove);
            }
        }
    }

    class ValuesOfIdentifierFinder
    extends DepthFirstAdapter {
        private final Hashtable<Node, HashSet<Node>> valuesOfIdentifierTable = new Hashtable();
        private final HashSet<Node> identifiers = new HashSet();

        public ValuesOfIdentifierFinder() {
            APropertiesMachineClause properties;
            this.identifiers.addAll(ConstantsEliminator.this.machineContext.getConstants().values());
            this.identifiers.addAll(ConstantsEliminator.this.machineContext.getScalarParameter().values());
            for (Node id : this.identifiers) {
                this.valuesOfIdentifierTable.put(id, new HashSet());
            }
            AConstraintsMachineClause constraints = ConstantsEliminator.this.machineContext.getConstraintMachineClause();
            if (constraints != null) {
                this.analysePredicate(constraints.getPredicates());
            }
            if ((properties = ConstantsEliminator.this.machineContext.getPropertiesMachineClause()) != null) {
                this.analysePredicate(properties.getPredicates());
            }
        }

        private void analysePredicate(Node n) {
            if (n instanceof AEqualPredicate) {
                this.analyseEqualsPredicate((AEqualPredicate)n);
            } else if (!(n instanceof AGreaterPredicate) && !(n instanceof ALessEqualPredicate) && n instanceof AConjunctPredicate) {
                this.analysePredicate(((AConjunctPredicate)n).getLeft());
                this.analysePredicate(((AConjunctPredicate)n).getRight());
            }
        }

        private void analyseEqualsPredicate(AEqualPredicate node) {
            int size;
            AIntegerExpression intExpr2;
            Node ref;
            PExpression left = node.getLeft();
            Node left_ref = ConstantsEliminator.this.machineContext.getReferences().get(left);
            PExpression right = node.getRight();
            Node right_ref = ConstantsEliminator.this.machineContext.getReferences().get(right);
            if (left instanceof ACardExpression) {
                ref = ConstantsEliminator.this.machineContext.getReferences().get(((ACardExpression)left).getExpression());
                try {
                    intExpr2 = (AIntegerExpression)right;
                    size = Integer.parseInt(intExpr2.getLiteral().getText());
                    ConstantsEliminator.this.integerValueTable.put(ref, size);
                }
                catch (ClassCastException intExpr2) {
                    // empty catch block
                }
            }
            if (right instanceof ACardExpression) {
                ref = ConstantsEliminator.this.machineContext.getReferences().get(((ACardExpression)right).getExpression());
                try {
                    intExpr2 = (AIntegerExpression)left;
                    size = Integer.parseInt(intExpr2.getLiteral().getText());
                    ConstantsEliminator.this.integerValueTable.put(ref, size);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (this.identifiers.contains(left_ref)) {
                this.valuesOfIdentifierTable.get(left_ref).add(right);
            }
            if (this.identifiers.contains(right_ref)) {
                this.valuesOfIdentifierTable.get(right_ref).add(left);
            }
        }
    }

    class ConstantsInTreeFinder
    extends DepthFirstAdapter {
        ConstantsInTreeFinder() {
        }

        @Override
        public void defaultIn(Node node) {
            ConstantsEliminator.this.dependsOnIdentifierTable.put(node, new HashSet());
        }

        @Override
        public void defaultOut(Node node) {
            HashSet set = (HashSet)ConstantsEliminator.this.dependsOnIdentifierTable.get(node);
            HashSet parentSet = (HashSet)ConstantsEliminator.this.dependsOnIdentifierTable.get(node.parent());
            parentSet.addAll(set);
        }

        @Override
        public void caseAPropertiesMachineClause(APropertiesMachineClause node) {
            this.defaultIn(node);
            node.getPredicates().apply(this);
        }

        @Override
        public void caseAConstraintsMachineClause(AConstraintsMachineClause node) {
            this.defaultIn(node);
            node.getPredicates().apply(this);
        }

        @Override
        public void caseAIdentifierExpression(AIdentifierExpression node) {
            this.defaultIn(node);
            Node refNode = ConstantsEliminator.this.machineContext.getReferences().get(node);
            if (ConstantsEliminator.this.machineContext.getConstants().containsValue(refNode)) {
                HashSet set = (HashSet)ConstantsEliminator.this.dependsOnIdentifierTable.get(node);
                set.add(refNode);
            }
            this.defaultOut(node);
        }
    }
}

