/*
 * Decompiled with CFR 0.152.
 */
package de.be4.ltl.core.ctlparser.lexer;

import de.be4.ltl.core.ctlparser.lexer.LexerException;
import de.be4.ltl.core.ctlparser.node.EOF;
import de.be4.ltl.core.ctlparser.node.TActionBegin;
import de.be4.ltl.core.ctlparser.node.TActionEnd;
import de.be4.ltl.core.ctlparser.node.TAnd;
import de.be4.ltl.core.ctlparser.node.TApChar;
import de.be4.ltl.core.ctlparser.node.TAtomicPropositionBegin;
import de.be4.ltl.core.ctlparser.node.TAtomicPropositionEnd;
import de.be4.ltl.core.ctlparser.node.TCurrent;
import de.be4.ltl.core.ctlparser.node.TDeadlock;
import de.be4.ltl.core.ctlparser.node.TDetOutput;
import de.be4.ltl.core.ctlparser.node.TEnabled;
import de.be4.ltl.core.ctlparser.node.TExists;
import de.be4.ltl.core.ctlparser.node.TFalse;
import de.be4.ltl.core.ctlparser.node.TFinally;
import de.be4.ltl.core.ctlparser.node.TForall;
import de.be4.ltl.core.ctlparser.node.TGlobally;
import de.be4.ltl.core.ctlparser.node.TGoal;
import de.be4.ltl.core.ctlparser.node.TImplies;
import de.be4.ltl.core.ctlparser.node.TLPar;
import de.be4.ltl.core.ctlparser.node.TLSq;
import de.be4.ltl.core.ctlparser.node.TNext;
import de.be4.ltl.core.ctlparser.node.TNonDet;
import de.be4.ltl.core.ctlparser.node.TNot;
import de.be4.ltl.core.ctlparser.node.TOr;
import de.be4.ltl.core.ctlparser.node.TRPar;
import de.be4.ltl.core.ctlparser.node.TSink;
import de.be4.ltl.core.ctlparser.node.TStateError;
import de.be4.ltl.core.ctlparser.node.TTpChar;
import de.be4.ltl.core.ctlparser.node.TTrue;
import de.be4.ltl.core.ctlparser.node.TUntil;
import de.be4.ltl.core.ctlparser.node.TWhiteSpace;
import de.be4.ltl.core.ctlparser.node.Token;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;

public class Lexer {
    protected Token token;
    protected State state = State.CTL;
    private final PushbackReader in;
    protected int line;
    protected int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuilder text = new StringBuilder();
    private static final int[][][][] gotoTable;
    private static final int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        Token tok;
        int dfaState = 0;
        int startPos = this.pos;
        int startLine = this.line;
        int acceptToken = -1;
        int acceptLength = -1;
        int acceptPos = -1;
        int acceptLine = -1;
        boolean acceptCr = false;
        int[][][] gotoTableSub = gotoTable[this.state.ordinal()];
        int[] acceptSub = accept[this.state.ordinal()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    case 8232: 
                    case 8233: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = false;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block48: do {
                    int oldState = dfaState < -1 ? -2 - dfaState : dfaState;
                    dfaState = -1;
                    int[][] tmp1 = gotoTableSub[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = low + high >>> 1;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfaState = tmp2[2];
                        continue block48;
                    }
                } while (dfaState < -1);
            } else {
                dfaState = -1;
            }
            if (dfaState < 0) break;
            if (acceptSub[dfaState] == -1) continue;
            acceptToken = acceptSub[dfaState];
            acceptLength = this.text.length();
            acceptPos = this.pos;
            acceptLine = this.line;
            acceptCr = this.cr;
        }
        switch (acceptToken) {
            case -1: {
                if (this.text.length() > 0) {
                    throw new LexerException(startLine + 1, startPos + 1, "Unknown token: " + this.text);
                }
                return new EOF(startLine + 1, startPos + 1);
            }
            case 0: {
                tok = new TTrue(startLine + 1, startPos + 1);
                break;
            }
            case 1: {
                tok = new TFalse(startLine + 1, startPos + 1);
                break;
            }
            case 2: {
                tok = new TSink(startLine + 1, startPos + 1);
                break;
            }
            case 3: {
                tok = new TGoal(startLine + 1, startPos + 1);
                break;
            }
            case 4: {
                tok = new TDetOutput(startLine + 1, startPos + 1);
                break;
            }
            case 5: {
                tok = new TNonDet(startLine + 1, startPos + 1);
                break;
            }
            case 6: {
                tok = new TStateError(startLine + 1, startPos + 1);
                break;
            }
            case 7: {
                tok = new TDeadlock(startLine + 1, startPos + 1);
                break;
            }
            case 8: {
                tok = new TCurrent(startLine + 1, startPos + 1);
                break;
            }
            case 9: {
                tok = new TLPar(startLine + 1, startPos + 1);
                break;
            }
            case 10: {
                tok = new TRPar(startLine + 1, startPos + 1);
                break;
            }
            case 11: {
                tok = new TLSq(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 0: {
                        this.state = State.ACTION;
                    }
                }
                break;
            }
            case 12: {
                tok = new TEnabled(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 0: {
                        this.state = State.ACTION;
                    }
                }
                break;
            }
            case 13: {
                tok = new TAtomicPropositionBegin(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 0: {
                        this.state = State.ATOMIC;
                    }
                }
                break;
            }
            case 14: {
                tok = new TAtomicPropositionEnd(startLine + 1, startPos + 1);
                break;
            }
            case 15: {
                tok = new TApChar(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 16: {
                tok = new TActionEnd(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 17: {
                tok = new TActionBegin(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 18: {
                tok = new TTpChar(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 19: {
                tok = new TImplies(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 20: {
                tok = new TAnd(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 21: {
                tok = new TOr(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 22: {
                tok = new TNot(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 23: {
                tok = new TExists(startLine + 1, startPos + 1);
                break;
            }
            case 24: {
                tok = new TForall(startLine + 1, startPos + 1);
                break;
            }
            case 25: {
                tok = new TUntil(startLine + 1, startPos + 1);
                break;
            }
            case 26: {
                tok = new TGlobally(startLine + 1, startPos + 1);
                break;
            }
            case 27: {
                tok = new TFinally(startLine + 1, startPos + 1);
                break;
            }
            case 28: {
                tok = new TNext(startLine + 1, startPos + 1);
                break;
            }
            case 29: {
                tok = new TWhiteSpace(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            default: {
                throw new LexerException(startLine + 1, startPos + 1, "Internal lexer error: invalid accept table entry " + acceptToken + ", current text: " + this.text);
            }
        }
        this.pushBack(acceptLength);
        this.pos = acceptPos;
        this.line = acceptLine;
        this.cr = acceptCr;
        return tok;
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        for (int i = length - 1; i >= acceptLength; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token tok) throws IOException {
        String tokenText = tok.getText();
        int length = tokenText.length();
        for (int i = length - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(tokenText.charAt(i));
        }
        this.pos = tok.getPos() - 1;
        this.line = tok.getLine() - 1;
    }

    private String getText(int acceptLength) {
        return this.text.substring(0, acceptLength);
    }

    static {
        try {
            InputStream resStream = Lexer.class.getResourceAsStream("lexer.dat");
            if (resStream == null) {
                throw new RuntimeException("The file \"lexer.dat\" is missing.");
            }
            DataInputStream s = new DataInputStream(new BufferedInputStream(resStream));
            int gotoTableLength1 = s.readInt();
            gotoTable = new int[gotoTableLength1][][][];
            for (int i = 0; i < gotoTableLength1; ++i) {
                int gotoTableLength2 = s.readInt();
                Lexer.gotoTable[i] = new int[gotoTableLength2][][];
                for (int j = 0; j < gotoTableLength2; ++j) {
                    int gotoTableLength3 = s.readInt();
                    Lexer.gotoTable[i][j] = new int[gotoTableLength3][3];
                    for (int k = 0; k < gotoTableLength3; ++k) {
                        for (int l = 0; l < 3; ++l) {
                            Lexer.gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }
            int acceptLength1 = s.readInt();
            accept = new int[acceptLength1][];
            for (int i = 0; i < acceptLength1; ++i) {
                int acceptLength2 = s.readInt();
                Lexer.accept[i] = new int[acceptLength2];
                for (int j = 0; j < acceptLength2; ++j) {
                    Lexer.accept[i][j] = s.readInt();
                }
            }
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.", e);
        }
    }

    public static enum State {
        CTL,
        ATOMIC,
        ACTION;


        public int id() {
            return this.ordinal();
        }
    }
}

