/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.util;

import de.be4.classicalb.core.parser.analysis.AnalysisAdapter;
import de.be4.classicalb.core.parser.node.AAbstractConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AAddExpression;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AArityExpression;
import de.be4.classicalb.core.parser.node.AAssertionSubstitution;
import de.be4.classicalb.core.parser.node.AAssertionsMachineClause;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.ABinExpression;
import de.be4.classicalb.core.parser.node.ABlockSubstitution;
import de.be4.classicalb.core.parser.node.ABoolSetExpression;
import de.be4.classicalb.core.parser.node.ABooleanFalseExpression;
import de.be4.classicalb.core.parser.node.ABooleanTrueExpression;
import de.be4.classicalb.core.parser.node.ABtreeExpression;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.ACartesianProductExpression;
import de.be4.classicalb.core.parser.node.ACaseOrSubstitution;
import de.be4.classicalb.core.parser.node.ACaseSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceOrSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceSubstitution;
import de.be4.classicalb.core.parser.node.AClosureExpression;
import de.be4.classicalb.core.parser.node.ACompositionExpression;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AComputationOperation;
import de.be4.classicalb.core.parser.node.AConcatExpression;
import de.be4.classicalb.core.parser.node.AConcreteVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConstExpression;
import de.be4.classicalb.core.parser.node.AConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.AConstructorFreetypeConstructor;
import de.be4.classicalb.core.parser.node.AConvertBoolExpression;
import de.be4.classicalb.core.parser.node.AConvertIntCeilingExpression;
import de.be4.classicalb.core.parser.node.AConvertIntFloorExpression;
import de.be4.classicalb.core.parser.node.AConvertRealExpression;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADefArgpattern;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.ADefineSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionFileParseUnit;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.ADescriptionExpression;
import de.be4.classicalb.core.parser.node.ADescriptionOperation;
import de.be4.classicalb.core.parser.node.ADescriptionPragma;
import de.be4.classicalb.core.parser.node.ADescriptionPredicate;
import de.be4.classicalb.core.parser.node.ADescriptionSet;
import de.be4.classicalb.core.parser.node.ADirectProductExpression;
import de.be4.classicalb.core.parser.node.ADisjunctPredicate;
import de.be4.classicalb.core.parser.node.ADivExpression;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.ADomainRestrictionExpression;
import de.be4.classicalb.core.parser.node.ADomainSubtractionExpression;
import de.be4.classicalb.core.parser.node.AElementFreetypeConstructor;
import de.be4.classicalb.core.parser.node.AEmptySequenceExpression;
import de.be4.classicalb.core.parser.node.AEmptySetExpression;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AEnumeratedSetViaDefSet;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AEquivalencePredicate;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AEventBFirstProjectionExpression;
import de.be4.classicalb.core.parser.node.AEventBFirstProjectionV2Expression;
import de.be4.classicalb.core.parser.node.AEventBSecondProjectionExpression;
import de.be4.classicalb.core.parser.node.AEventBSecondProjectionV2Expression;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinition;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.AExpressionsMachineClause;
import de.be4.classicalb.core.parser.node.AExtendsMachineClause;
import de.be4.classicalb.core.parser.node.AFalsityPredicate;
import de.be4.classicalb.core.parser.node.AFatherExpression;
import de.be4.classicalb.core.parser.node.AFileDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AFileMachineReference;
import de.be4.classicalb.core.parser.node.AFileMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.AFin1SubsetExpression;
import de.be4.classicalb.core.parser.node.AFinSubsetExpression;
import de.be4.classicalb.core.parser.node.AFinitePredicate;
import de.be4.classicalb.core.parser.node.AFirstExpression;
import de.be4.classicalb.core.parser.node.AFirstProjectionExpression;
import de.be4.classicalb.core.parser.node.AFloatSetExpression;
import de.be4.classicalb.core.parser.node.AFlooredDivExpression;
import de.be4.classicalb.core.parser.node.AForLoopSubstitution;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AForallSubMessageSubstitution;
import de.be4.classicalb.core.parser.node.AFreetype;
import de.be4.classicalb.core.parser.node.AFreetypesMachineClause;
import de.be4.classicalb.core.parser.node.AFrontExpression;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AFunctionOperation;
import de.be4.classicalb.core.parser.node.AGeneralConcatExpression;
import de.be4.classicalb.core.parser.node.AGeneralIntersectionExpression;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AGeneralUnionExpression;
import de.be4.classicalb.core.parser.node.AGeneratedParseUnit;
import de.be4.classicalb.core.parser.node.AGreaterEqualPredicate;
import de.be4.classicalb.core.parser.node.AGreaterPredicate;
import de.be4.classicalb.core.parser.node.AHexIntegerExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIdentityExpression;
import de.be4.classicalb.core.parser.node.AIfElsifExprExpression;
import de.be4.classicalb.core.parser.node.AIfElsifPredicatePredicate;
import de.be4.classicalb.core.parser.node.AIfElsifSubstitution;
import de.be4.classicalb.core.parser.node.AIfPredicatePredicate;
import de.be4.classicalb.core.parser.node.AIfSubstitution;
import de.be4.classicalb.core.parser.node.AIfThenElseExpression;
import de.be4.classicalb.core.parser.node.AImageExpression;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.AImportPackage;
import de.be4.classicalb.core.parser.node.AImportsMachineClause;
import de.be4.classicalb.core.parser.node.AIncludesMachineClause;
import de.be4.classicalb.core.parser.node.AInfixExpression;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AInsertFrontExpression;
import de.be4.classicalb.core.parser.node.AInsertTailExpression;
import de.be4.classicalb.core.parser.node.AIntSetExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AIntegerSetExpression;
import de.be4.classicalb.core.parser.node.AIntersectionExpression;
import de.be4.classicalb.core.parser.node.AIntervalExpression;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.AIseq1Expression;
import de.be4.classicalb.core.parser.node.AIseqExpression;
import de.be4.classicalb.core.parser.node.AIterationExpression;
import de.be4.classicalb.core.parser.node.ALabelPredicate;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.ALastExpression;
import de.be4.classicalb.core.parser.node.ALeftExpression;
import de.be4.classicalb.core.parser.node.ALessEqualPredicate;
import de.be4.classicalb.core.parser.node.ALessPredicate;
import de.be4.classicalb.core.parser.node.ALetExpressionExpression;
import de.be4.classicalb.core.parser.node.ALetPredicatePredicate;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.ALocalOperationsMachineClause;
import de.be4.classicalb.core.parser.node.AMachineClauseParseUnit;
import de.be4.classicalb.core.parser.node.AMachineHeader;
import de.be4.classicalb.core.parser.node.AMachineMachineVariant;
import de.be4.classicalb.core.parser.node.AMachineReference;
import de.be4.classicalb.core.parser.node.AMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.AMaxExpression;
import de.be4.classicalb.core.parser.node.AMaxIntExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.AMinExpression;
import de.be4.classicalb.core.parser.node.AMinIntExpression;
import de.be4.classicalb.core.parser.node.AMinusOrSetSubtractExpression;
import de.be4.classicalb.core.parser.node.AMirrorExpression;
import de.be4.classicalb.core.parser.node.AModelMachineVariant;
import de.be4.classicalb.core.parser.node.AModuloExpression;
import de.be4.classicalb.core.parser.node.AMultOrCartExpression;
import de.be4.classicalb.core.parser.node.AMultilineStringExpression;
import de.be4.classicalb.core.parser.node.AMultiplicationExpression;
import de.be4.classicalb.core.parser.node.ANat1SetExpression;
import de.be4.classicalb.core.parser.node.ANatSetExpression;
import de.be4.classicalb.core.parser.node.ANatural1SetExpression;
import de.be4.classicalb.core.parser.node.ANaturalSetExpression;
import de.be4.classicalb.core.parser.node.ANegationPredicate;
import de.be4.classicalb.core.parser.node.ANotEqualPredicate;
import de.be4.classicalb.core.parser.node.ANotMemberPredicate;
import de.be4.classicalb.core.parser.node.ANotSubsetPredicate;
import de.be4.classicalb.core.parser.node.ANotSubsetStrictPredicate;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.AOperationAttribute;
import de.be4.classicalb.core.parser.node.AOperationCallSubstitution;
import de.be4.classicalb.core.parser.node.AOperationOrDefinitionCallSubstitution;
import de.be4.classicalb.core.parser.node.AOperationReference;
import de.be4.classicalb.core.parser.node.AOperationsMachineClause;
import de.be4.classicalb.core.parser.node.AOperatorExpression;
import de.be4.classicalb.core.parser.node.AOperatorPredicate;
import de.be4.classicalb.core.parser.node.AOperatorSubstitution;
import de.be4.classicalb.core.parser.node.AOppatternParseUnit;
import de.be4.classicalb.core.parser.node.AOverwriteExpression;
import de.be4.classicalb.core.parser.node.APackageParseUnit;
import de.be4.classicalb.core.parser.node.AParallelProductExpression;
import de.be4.classicalb.core.parser.node.AParallelSubstitution;
import de.be4.classicalb.core.parser.node.APartialBijectionExpression;
import de.be4.classicalb.core.parser.node.APartialFunctionExpression;
import de.be4.classicalb.core.parser.node.APartialInjectionExpression;
import de.be4.classicalb.core.parser.node.APartialSurjectionExpression;
import de.be4.classicalb.core.parser.node.APartitionPredicate;
import de.be4.classicalb.core.parser.node.APermExpression;
import de.be4.classicalb.core.parser.node.APostfixExpression;
import de.be4.classicalb.core.parser.node.APow1SubsetExpression;
import de.be4.classicalb.core.parser.node.APowSubsetExpression;
import de.be4.classicalb.core.parser.node.APowerOfExpression;
import de.be4.classicalb.core.parser.node.APreconditionSubstitution;
import de.be4.classicalb.core.parser.node.APredecessorExpression;
import de.be4.classicalb.core.parser.node.APredicateAttributeOperationAttribute;
import de.be4.classicalb.core.parser.node.APredicateDefinition;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.APredicatesMachineClause;
import de.be4.classicalb.core.parser.node.APrefixExpression;
import de.be4.classicalb.core.parser.node.APrimedIdentifierExpression;
import de.be4.classicalb.core.parser.node.APromotesMachineClause;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ARangeExpression;
import de.be4.classicalb.core.parser.node.ARangeRestrictionExpression;
import de.be4.classicalb.core.parser.node.ARangeSubtractionExpression;
import de.be4.classicalb.core.parser.node.ARankExpression;
import de.be4.classicalb.core.parser.node.ARealExpression;
import de.be4.classicalb.core.parser.node.ARealSetExpression;
import de.be4.classicalb.core.parser.node.ARecEntry;
import de.be4.classicalb.core.parser.node.ARecExpression;
import de.be4.classicalb.core.parser.node.ARecordFieldExpression;
import de.be4.classicalb.core.parser.node.AReferencesMachineClause;
import de.be4.classicalb.core.parser.node.ARefinedOperation;
import de.be4.classicalb.core.parser.node.ARefinementMachineParseUnit;
import de.be4.classicalb.core.parser.node.AReflexiveClosureExpression;
import de.be4.classicalb.core.parser.node.ARelationsExpression;
import de.be4.classicalb.core.parser.node.ARestrictFrontExpression;
import de.be4.classicalb.core.parser.node.ARestrictTailExpression;
import de.be4.classicalb.core.parser.node.ARevExpression;
import de.be4.classicalb.core.parser.node.AReverseExpression;
import de.be4.classicalb.core.parser.node.ARightExpression;
import de.be4.classicalb.core.parser.node.ARingExpression;
import de.be4.classicalb.core.parser.node.ARuleFailSubSubstitution;
import de.be4.classicalb.core.parser.node.ARuleOperation;
import de.be4.classicalb.core.parser.node.ASecondProjectionExpression;
import de.be4.classicalb.core.parser.node.ASeesMachineClause;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASelectWhenSubstitution;
import de.be4.classicalb.core.parser.node.ASeq1Expression;
import de.be4.classicalb.core.parser.node.ASeqExpression;
import de.be4.classicalb.core.parser.node.ASequenceExtensionExpression;
import de.be4.classicalb.core.parser.node.ASequenceSubstitution;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetSubtractionExpression;
import de.be4.classicalb.core.parser.node.ASetsMachineClause;
import de.be4.classicalb.core.parser.node.ASizeExpression;
import de.be4.classicalb.core.parser.node.ASizetExpression;
import de.be4.classicalb.core.parser.node.ASkipSubstitution;
import de.be4.classicalb.core.parser.node.ASonExpression;
import de.be4.classicalb.core.parser.node.ASonsExpression;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.AStringSetExpression;
import de.be4.classicalb.core.parser.node.AStructExpression;
import de.be4.classicalb.core.parser.node.ASubsetPredicate;
import de.be4.classicalb.core.parser.node.ASubsetStrictPredicate;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionParseUnit;
import de.be4.classicalb.core.parser.node.ASubstitutionPredicate;
import de.be4.classicalb.core.parser.node.ASubtreeExpression;
import de.be4.classicalb.core.parser.node.ASuccessorExpression;
import de.be4.classicalb.core.parser.node.ASurjectionRelationExpression;
import de.be4.classicalb.core.parser.node.ASymbolicCompositionExpression;
import de.be4.classicalb.core.parser.node.ASymbolicComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicLambdaExpression;
import de.be4.classicalb.core.parser.node.ASymbolicQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ASystemMachineVariant;
import de.be4.classicalb.core.parser.node.ATailExpression;
import de.be4.classicalb.core.parser.node.ATopExpression;
import de.be4.classicalb.core.parser.node.ATotalBijectionExpression;
import de.be4.classicalb.core.parser.node.ATotalFunctionExpression;
import de.be4.classicalb.core.parser.node.ATotalInjectionExpression;
import de.be4.classicalb.core.parser.node.ATotalRelationExpression;
import de.be4.classicalb.core.parser.node.ATotalSurjectionExpression;
import de.be4.classicalb.core.parser.node.ATotalSurjectionRelationExpression;
import de.be4.classicalb.core.parser.node.ATransFunctionExpression;
import de.be4.classicalb.core.parser.node.ATransRelationExpression;
import de.be4.classicalb.core.parser.node.ATreeExpression;
import de.be4.classicalb.core.parser.node.ATruthPredicate;
import de.be4.classicalb.core.parser.node.ATypeofExpression;
import de.be4.classicalb.core.parser.node.AUnaryMinusExpression;
import de.be4.classicalb.core.parser.node.AUndefArgpattern;
import de.be4.classicalb.core.parser.node.AUnionExpression;
import de.be4.classicalb.core.parser.node.AUsesMachineClause;
import de.be4.classicalb.core.parser.node.AValuesEntry;
import de.be4.classicalb.core.parser.node.AValuesMachineClause;
import de.be4.classicalb.core.parser.node.AVarSubstitution;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AWhileSubstitution;
import de.be4.classicalb.core.parser.node.AWitnessThenSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TDefLiteralPredicate;
import de.be4.classicalb.core.parser.node.TDefLiteralSubstitution;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TKwAttributeIdentifier;
import de.be4.classicalb.core.parser.node.TKwExpressionOperator;
import de.be4.classicalb.core.parser.node.TKwPredicateAttribute;
import de.be4.classicalb.core.parser.node.TKwPredicateOperator;
import de.be4.classicalb.core.parser.node.TKwSubstitutionOperator;
import de.be4.classicalb.core.parser.node.TPragmaFreeText;
import de.be4.classicalb.core.parser.node.TPragmaIdOrString;
import de.be4.classicalb.core.parser.util.IIdentifierRenaming;
import de.be4.classicalb.core.parser.util.Utils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BasePrettyPrinter
extends AnalysisAdapter {
    private static final String DEFAULT_INDENT = "    ";
    private static final Map<Class<? extends Node>, Integer> OPERATOR_PRIORITIES;
    private static final int ENUMERATED_MULTILINE_THRESHOLD = 20;
    private static final int PARAMETER_MULTILINE_THRESHOLD = 10;
    private final Writer writer;
    private String indent;
    private IIdentifierRenaming renaming;
    private int indentLevel;
    private boolean hasWrittenSomething;
    private boolean identifierList;

    public BasePrettyPrinter(Writer writer) {
        this.writer = writer;
        this.indent = null;
        this.renaming = IIdentifierRenaming.QUOTE_INVALID;
        this.indentLevel = 0;
        this.hasWrittenSomething = false;
        this.identifierList = false;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isUseIndentation() {
        return this.indent != null && !this.indent.isEmpty();
    }

    public void setUseIndentation(boolean useIndentation) {
        this.setIndent(useIndentation ? DEFAULT_INDENT : null);
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public IIdentifierRenaming getRenaming() {
        return this.renaming;
    }

    public void setRenaming(IIdentifierRenaming renaming) {
        this.renaming = Objects.requireNonNull(renaming, "renaming");
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    private void indent() {
        ++this.indentLevel;
    }

    private void dedent() {
        if (this.indentLevel > 0) {
            --this.indentLevel;
        }
    }

    private void writeInternal(String s) {
        if (s.isEmpty()) {
            return;
        }
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.hasWrittenSomething = true;
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void print(String s) {
        if (s.isEmpty()) {
            return;
        }
        if (this.indentLevel > 0 && !this.hasWrittenSomething) {
            this.printIndent();
        }
        this.writeInternal(s);
    }

    private void printIndent() {
        if (this.isUseIndentation()) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writeInternal(this.indent);
            }
        }
    }

    private void println() {
        this.print("\n");
        this.printIndent();
    }

    private void printlnOpt() {
        if (this.isUseIndentation()) {
            this.print("\n");
        } else {
            this.print(" ");
        }
        this.printIndent();
    }

    private void println(String s) {
        this.print(s);
        this.println();
    }

    private void printlnOpt(String s) {
        this.print(s);
        this.printlnOpt();
    }

    private void printListImpl(Iterable<? extends Node> iterable, String separator, boolean trailing, boolean opt) {
        String[] lines = separator.split("\n", -1);
        Iterator<? extends Node> it = iterable.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            node.apply(this);
            if (!trailing && !it.hasNext()) continue;
            for (int i = 0; i < lines.length; ++i) {
                this.print(lines[i]);
                if (i >= lines.length - 1) continue;
                if (opt) {
                    this.printlnOpt();
                    continue;
                }
                this.println();
            }
        }
    }

    private void printList(Iterable<? extends Node> iterable, String separator) {
        this.printListImpl(iterable, separator, false, false);
    }

    private void printListTrailing(Iterable<? extends Node> iterable, String separator) {
        this.printListImpl(iterable, separator, true, false);
    }

    private void printListOpt(Iterable<? extends Node> iterable, String separator) {
        this.printListImpl(iterable, separator, false, true);
    }

    private void printListOptTrailing(Iterable<? extends Node> iterable, String separator) {
        this.printListImpl(iterable, separator, true, true);
    }

    private void printList(Iterable<? extends Node> iterable) {
        this.printListOpt(iterable, "\n");
    }

    private void printListTrailing(Iterable<? extends Node> iterable) {
        this.printListOptTrailing(iterable, "\n");
    }

    private void printListMultiLine(Iterable<? extends Node> iterable) {
        this.printList(iterable, "\n");
    }

    private void printListMultiLineTrailing(Iterable<? extends Node> iterable) {
        this.printListTrailing(iterable, "\n");
    }

    private void printDottedList(Iterable<? extends Node> iterable) {
        this.printListOpt(iterable, ".");
    }

    private void printCommaList(Iterable<? extends Node> iterable) {
        this.printListOpt(iterable, ",\n");
    }

    private void printCommaListSingleLine(Iterable<? extends Node> iterable) {
        this.printListOpt(iterable, ", ");
    }

    private void printCommaListMultiLine(Iterable<? extends Node> iterable) {
        this.printList(iterable, ",\n");
    }

    private void printCommaListCompact(Iterable<? extends Node> iterable) {
        this.printListOpt(iterable, ",");
    }

    private void printSemicolonList(Iterable<? extends Node> iterable) {
        this.printListOpt(iterable, ";\n");
    }

    private void printSemicolonListMultiLine(Iterable<? extends Node> iterable) {
        this.printList(iterable, ";\n");
    }

    private void printParameterListOpt(Collection<? extends Node> iterable) {
        if (!iterable.isEmpty()) {
            this.printDelimitedCommaList(iterable, "(", ")", 10);
        }
    }

    private void printParameterList(Collection<? extends Node> iterable) {
        this.printDelimitedCommaList(iterable, "(", ")", 10);
    }

    private void printDelimitedCommaList(Collection<? extends Node> iterable, String prefix, String suffix, int threshold) {
        this.indent();
        if (prefix != null) {
            this.print(prefix);
        }
        if (iterable.size() >= threshold) {
            if (prefix == null || this.isUseIndentation()) {
                this.printlnOpt();
            }
            this.printCommaList(iterable);
            this.dedent();
            if (suffix != null && this.isUseIndentation()) {
                this.println();
            }
        } else {
            if (prefix == null) {
                this.print(" ");
            }
            this.printCommaListSingleLine(iterable);
            this.dedent();
        }
        if (suffix != null) {
            this.print(suffix);
        }
    }

    private void leftParAssoc(Node node, Node right) {
        Integer priorityNode = OPERATOR_PRIORITIES.get(node.getClass());
        Integer priorityRight = OPERATOR_PRIORITIES.get(right.getClass());
        if (priorityNode != null && priorityRight != null && priorityRight < priorityNode) {
            this.print("(");
        }
    }

    private void rightParAssoc(Node node, Node right) {
        Integer priorityNode = OPERATOR_PRIORITIES.get(node.getClass());
        Integer priorityRight = OPERATOR_PRIORITIES.get(right.getClass());
        if (priorityNode != null && priorityRight != null && priorityRight < priorityNode) {
            this.print(")");
        }
    }

    private void leftPar(Node node, Node right) {
        Integer priorityNode = OPERATOR_PRIORITIES.get(node.getClass());
        Integer priorityRight = OPERATOR_PRIORITIES.get(right.getClass());
        if (priorityNode != null && priorityRight != null && priorityRight <= priorityNode) {
            this.print("(");
        }
    }

    private void rightPar(Node node, Node right) {
        Integer priorityNode = OPERATOR_PRIORITIES.get(node.getClass());
        Integer priorityRight = OPERATOR_PRIORITIES.get(right.getClass());
        if (priorityNode != null && priorityRight != null && priorityRight <= priorityNode) {
            this.print(")");
        }
    }

    private void applyLeftAssociative(Node left, Node node, Node right, String operatorStr) {
        String[] lines = operatorStr.split("\n", -1);
        this.leftParAssoc(node, left);
        left.apply(this);
        this.rightParAssoc(node, left);
        for (int i = 0; i < lines.length; ++i) {
            this.print(lines[i]);
            if (i >= lines.length - 1) continue;
            this.printlnOpt();
        }
        this.leftPar(node, right);
        right.apply(this);
        this.rightPar(node, right);
    }

    private void applyRightAssociative(Node left, Node node, Node right, String operatorStr) {
        String[] lines = operatorStr.split("\n", -1);
        this.leftPar(node, left);
        left.apply(this);
        this.rightPar(node, left);
        for (int i = 0; i < lines.length; ++i) {
            this.print(lines[i]);
            if (i >= lines.length - 1) continue;
            this.printlnOpt();
        }
        this.leftParAssoc(node, right);
        right.apply(this);
        this.rightParAssoc(node, right);
    }

    private void openIdentifierList() {
        if (this.identifierList) {
            throw new IllegalStateException();
        }
        this.identifierList = true;
    }

    private void closeIdentifierList() {
        this.identifierList = false;
    }

    private void printTopLevelSubstitution(PSubstitution node) {
        if (node instanceof ASequenceSubstitution) {
            this.printSubstitutionInBlock(node);
        } else {
            node.apply(this);
        }
    }

    private void printSubstitutionInBlock(PSubstitution node) {
        this.indent();
        this.printlnOpt("BEGIN");
        node.apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseStart(Start node) {
        node.getPParseUnit().apply(this);
    }

    @Override
    public void caseAGeneratedParseUnit(AGeneratedParseUnit node) {
        this.println("/*@generated*/");
        node.getParseUnit().apply(this);
    }

    @Override
    public void caseAPackageParseUnit(APackageParseUnit node) {
        this.print("/*@package ");
        node.getPackage().apply(this);
        this.println(" */");
        this.printListMultiLineTrailing(node.getImports());
        node.getParseUnit().apply(this);
    }

    @Override
    public void caseAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        node.getVariant().apply(this);
        this.print(" ");
        node.getHeader().apply(this);
        if (!node.getMachineClauses().isEmpty()) {
            this.indent();
            this.println();
            this.printListMultiLine(node.getMachineClauses());
            this.dedent();
        }
        this.println();
        this.print("END");
    }

    @Override
    public void caseARefinementMachineParseUnit(ARefinementMachineParseUnit node) {
        this.print("REFINEMENT ");
        node.getHeader().apply(this);
        this.println();
        this.print("REFINES ");
        node.getRefMachine().apply(this);
        if (!node.getMachineClauses().isEmpty()) {
            this.indent();
            this.println();
            this.printListMultiLine(node.getMachineClauses());
            this.dedent();
        }
        this.println();
        this.print("END");
    }

    @Override
    public void caseAImplementationMachineParseUnit(AImplementationMachineParseUnit node) {
        this.print("IMPLEMENTATION ");
        node.getHeader().apply(this);
        this.println();
        this.print("REFINES ");
        node.getRefMachine().apply(this);
        if (!node.getMachineClauses().isEmpty()) {
            this.indent();
            this.println();
            this.printListMultiLine(node.getMachineClauses());
            this.dedent();
        }
        this.println();
        this.print("END");
    }

    @Override
    public void caseADefinitionFileParseUnit(ADefinitionFileParseUnit node) {
        node.getDefinitionsClauses().apply(this);
    }

    @Override
    public void caseAPredicateParseUnit(APredicateParseUnit node) {
        node.getPredicate().apply(this);
    }

    @Override
    public void caseAExpressionParseUnit(AExpressionParseUnit node) {
        node.getExpression().apply(this);
    }

    @Override
    public void caseASubstitutionParseUnit(ASubstitutionParseUnit node) {
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseAMachineClauseParseUnit(AMachineClauseParseUnit node) {
        node.getMachineClause().apply(this);
    }

    @Override
    public void caseAOppatternParseUnit(AOppatternParseUnit node) {
        this.printDottedList(node.getName());
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseAImportPackage(AImportPackage node) {
        this.print("/*@import-package ");
        node.getPackage().apply(this);
        this.print(" */");
    }

    @Override
    public void caseAUndefArgpattern(AUndefArgpattern node) {
        this.print("_");
    }

    @Override
    public void caseADefArgpattern(ADefArgpattern node) {
        node.getExpression().apply(this);
    }

    @Override
    public void caseAMachineMachineVariant(AMachineMachineVariant node) {
        this.print("MACHINE");
    }

    @Override
    public void caseAModelMachineVariant(AModelMachineVariant node) {
        this.print("MODEL");
    }

    @Override
    public void caseASystemMachineVariant(ASystemMachineVariant node) {
        this.print("SYSTEM");
    }

    @Override
    public void caseAMachineHeader(AMachineHeader node) {
        this.printDottedList(node.getName());
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
        this.indent();
        this.println("DEFINITIONS");
        this.printSemicolonListMultiLine(node.getDefinitions());
        this.dedent();
    }

    @Override
    public void caseASeesMachineClause(ASeesMachineClause node) {
        this.print("SEES ");
        this.printCommaListSingleLine(node.getMachineNames());
    }

    @Override
    public void caseAPromotesMachineClause(APromotesMachineClause node) {
        this.print("PROMOTES ");
        this.printCommaListSingleLine(node.getOperationNames());
    }

    @Override
    public void caseAUsesMachineClause(AUsesMachineClause node) {
        this.print("USES ");
        this.printCommaListSingleLine(node.getMachineNames());
    }

    @Override
    public void caseAIncludesMachineClause(AIncludesMachineClause node) {
        this.print("INCLUDES ");
        this.printCommaListSingleLine(node.getMachineReferences());
    }

    @Override
    public void caseAExtendsMachineClause(AExtendsMachineClause node) {
        this.print("EXTENDS ");
        this.printCommaListSingleLine(node.getMachineReferences());
    }

    @Override
    public void caseAImportsMachineClause(AImportsMachineClause node) {
        this.print("IMPORTS ");
        this.printCommaListSingleLine(node.getMachineReferences());
    }

    @Override
    public void caseASetsMachineClause(ASetsMachineClause node) {
        this.indent();
        this.printlnOpt("SETS");
        this.printSemicolonList(node.getSetDefinitions());
        this.dedent();
    }

    @Override
    public void caseAFreetypesMachineClause(AFreetypesMachineClause node) {
        this.indent();
        this.printlnOpt("FREETYPES");
        this.printSemicolonList(node.getFreetypes());
        this.dedent();
    }

    @Override
    public void caseAVariablesMachineClause(AVariablesMachineClause node) {
        this.indent();
        this.printlnOpt("VARIABLES");
        this.openIdentifierList();
        this.printCommaList(node.getIdentifiers());
        this.closeIdentifierList();
        this.dedent();
    }

    @Override
    public void caseAConcreteVariablesMachineClause(AConcreteVariablesMachineClause node) {
        this.indent();
        this.printlnOpt("CONCRETE_VARIABLES");
        this.openIdentifierList();
        this.printCommaList(node.getIdentifiers());
        this.closeIdentifierList();
        this.dedent();
    }

    @Override
    public void caseAAbstractConstantsMachineClause(AAbstractConstantsMachineClause node) {
        this.indent();
        this.printlnOpt("ABSTRACT_CONSTANTS");
        this.openIdentifierList();
        this.printCommaList(node.getIdentifiers());
        this.closeIdentifierList();
        this.dedent();
    }

    @Override
    public void caseAConstantsMachineClause(AConstantsMachineClause node) {
        this.indent();
        this.printlnOpt("CONSTANTS");
        this.openIdentifierList();
        this.printCommaList(node.getIdentifiers());
        this.closeIdentifierList();
        this.dedent();
    }

    @Override
    public void caseAPropertiesMachineClause(APropertiesMachineClause node) {
        this.indent();
        this.printlnOpt("PROPERTIES");
        node.getPredicates().apply(this);
        this.dedent();
    }

    @Override
    public void caseAConstraintsMachineClause(AConstraintsMachineClause node) {
        this.indent();
        this.printlnOpt("CONSTRAINTS");
        node.getPredicates().apply(this);
        this.dedent();
    }

    @Override
    public void caseAInitialisationMachineClause(AInitialisationMachineClause node) {
        this.indent();
        this.printlnOpt("INITIALISATION");
        node.getSubstitutions().apply(this);
        this.dedent();
    }

    @Override
    public void caseAInvariantMachineClause(AInvariantMachineClause node) {
        this.indent();
        this.printlnOpt("INVARIANT");
        node.getPredicates().apply(this);
        this.dedent();
    }

    @Override
    public void caseAAssertionsMachineClause(AAssertionsMachineClause node) {
        this.indent();
        this.printlnOpt("ASSERTIONS");
        this.printSemicolonList(node.getPredicates());
        this.dedent();
    }

    @Override
    public void caseAValuesMachineClause(AValuesMachineClause node) {
        this.indent();
        this.printlnOpt("VALUES");
        this.printSemicolonList(node.getEntries());
        this.dedent();
    }

    @Override
    public void caseALocalOperationsMachineClause(ALocalOperationsMachineClause node) {
        this.indent();
        this.println("LOCAL_OPERATIONS");
        this.printSemicolonListMultiLine(node.getOperations());
        this.dedent();
    }

    @Override
    public void caseAOperationsMachineClause(AOperationsMachineClause node) {
        this.indent();
        this.println("OPERATIONS");
        this.printSemicolonListMultiLine(node.getOperations());
        this.dedent();
    }

    @Override
    public void caseAReferencesMachineClause(AReferencesMachineClause node) {
        this.print("REFERENCES ");
        this.printCommaListSingleLine(node.getMachineReferences());
    }

    @Override
    public void caseAExpressionsMachineClause(AExpressionsMachineClause node) {
        this.indent();
        this.printlnOpt("EXPRESSIONS");
        this.printSemicolonList(node.getExpressions());
        this.dedent();
    }

    @Override
    public void caseAPredicatesMachineClause(APredicatesMachineClause node) {
        this.indent();
        this.printlnOpt("PREDICATES");
        this.printSemicolonList(node.getPredicates());
        this.dedent();
    }

    @Override
    public void caseAMachineReference(AMachineReference node) {
        this.printDottedList(node.getMachineName());
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseAFileMachineReference(AFileMachineReference node) {
        node.getReference().apply(this);
        this.print(" /*@file ");
        node.getFile().apply(this);
        this.print(" */");
    }

    @Override
    public void caseAMachineReferenceNoParams(AMachineReferenceNoParams node) {
        this.printDottedList(node.getMachineName());
    }

    @Override
    public void caseAFileMachineReferenceNoParams(AFileMachineReferenceNoParams node) {
        node.getReference().apply(this);
        this.print(" /*@file ");
        node.getFile().apply(this);
        this.print(" */");
    }

    @Override
    public void caseAOperationReference(AOperationReference node) {
        this.printDottedList(node.getOperationName());
    }

    @Override
    public void caseADescriptionPragma(ADescriptionPragma node) {
        this.print(" /*@desc ");
        for (TPragmaFreeText part : node.getParts()) {
            this.print(part.getText());
        }
        this.print(" */");
    }

    @Override
    public void caseAExpressionDefinition(AExpressionDefinition node) {
        node.getName().apply(this);
        this.printParameterListOpt(node.getParameters());
        this.print(" == ");
        this.indent();
        node.getRhs().apply(this);
        this.dedent();
    }

    @Override
    public void caseAPredicateDefinition(APredicateDefinition node) {
        node.getName().apply(this);
        this.printParameterListOpt(node.getParameters());
        this.print(" == ");
        this.indent();
        node.getRhs().apply(this);
        this.dedent();
    }

    @Override
    public void caseAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        node.getName().apply(this);
        this.openIdentifierList();
        this.printParameterListOpt(node.getParameters());
        this.closeIdentifierList();
        this.print(" == ");
        this.indent();
        node.getRhs().apply(this);
        this.dedent();
    }

    @Override
    public void caseASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        node.getName().apply(this);
        this.openIdentifierList();
        this.printParameterListOpt(node.getParameters());
        this.closeIdentifierList();
        this.print(" == ");
        this.indent();
        this.printTopLevelSubstitution(node.getRhs());
        this.dedent();
    }

    @Override
    public void caseAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        node.getName().apply(this);
        this.openIdentifierList();
        this.printParameterListOpt(node.getParameters());
        this.closeIdentifierList();
        this.print(" == ");
        this.indent();
        node.getRhs().apply(this);
        this.dedent();
    }

    @Override
    public void caseAFileDefinitionDefinition(AFileDefinitionDefinition node) {
        this.print("\"");
        this.print(Utils.escapeStringContents(node.getFilename().getText()));
        this.print("\"");
    }

    @Override
    public void caseADescriptionSet(ADescriptionSet node) {
        node.getSet().apply(this);
        node.getDescription().apply(this);
    }

    @Override
    public void caseADeferredSetSet(ADeferredSetSet node) {
        this.printDottedList(node.getIdentifier());
    }

    @Override
    public void caseAEnumeratedSetSet(AEnumeratedSetSet node) {
        this.printDottedList(node.getIdentifier());
        this.print(" = ");
        this.openIdentifierList();
        this.printDelimitedCommaList(node.getElements(), "{", "}", 20);
        this.closeIdentifierList();
    }

    @Override
    public void caseAEnumeratedSetViaDefSet(AEnumeratedSetViaDefSet node) {
        this.printDottedList(node.getIdentifier());
        this.print(" = ");
        this.printDottedList(node.getElementsDef());
    }

    @Override
    public void caseAFreetype(AFreetype node) {
        node.getName().apply(this);
        this.printParameterListOpt(node.getParameters());
        this.print(" =");
        this.printDelimitedCommaList(node.getConstructors(), null, null, 20);
    }

    @Override
    public void caseAConstructorFreetypeConstructor(AConstructorFreetypeConstructor node) {
        node.getName().apply(this);
        this.printParameterList(Collections.singletonList(node.getArgument()));
    }

    @Override
    public void caseAElementFreetypeConstructor(AElementFreetypeConstructor node) {
        node.getName().apply(this);
    }

    @Override
    public void caseAValuesEntry(AValuesEntry node) {
        this.printDottedList(node.getIdentifier());
        this.print(" = ");
        node.getValue().apply(this);
    }

    @Override
    public void caseAOperation(AOperation node) {
        if (!node.getReturnValues().isEmpty()) {
            this.openIdentifierList();
            this.printCommaListCompact(node.getReturnValues());
            this.closeIdentifierList();
            this.print(" <-- ");
        }
        this.printDottedList(node.getOpName());
        this.printParameterListOpt(node.getParameters());
        this.indent();
        this.printlnOpt(" =");
        this.printTopLevelSubstitution(node.getOperationBody());
        this.dedent();
    }

    @Override
    public void caseARefinedOperation(ARefinedOperation node) {
        if (!node.getReturnValues().isEmpty()) {
            this.openIdentifierList();
            this.printCommaListCompact(node.getReturnValues());
            this.closeIdentifierList();
            this.print(" <-- ");
        }
        this.printDottedList(node.getOpName());
        this.printParameterListOpt(node.getParameters());
        this.print(" ");
        node.getRefKw().apply(this);
        this.print(" ");
        node.getAbOpName().apply(this);
        this.indent();
        this.printlnOpt(" =");
        this.printTopLevelSubstitution(node.getOperationBody());
        this.dedent();
    }

    @Override
    public void caseADescriptionOperation(ADescriptionOperation node) {
        node.getOperation().apply(this);
        node.getDescription().apply(this);
    }

    @Override
    public void caseARuleOperation(ARuleOperation node) {
        this.print("RULE ");
        node.getRuleName().apply(this);
        this.indent();
        this.printlnOpt();
        this.printListTrailing(node.getAttributes());
        this.indent();
        this.printlnOpt("BODY");
        node.getRuleBody().apply(this);
        this.dedent();
        this.dedent();
        this.print("END");
    }

    @Override
    public void caseAComputationOperation(AComputationOperation node) {
        this.print("COMPUTATION ");
        node.getName().apply(this);
        this.indent();
        this.printlnOpt();
        this.printListTrailing(node.getAttributes());
        this.indent();
        this.printlnOpt("BODY");
        node.getBody().apply(this);
        this.dedent();
        this.dedent();
        this.print("END");
    }

    @Override
    public void caseAFunctionOperation(AFunctionOperation node) {
        this.print("FUNCTION ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getReturnValues());
        this.closeIdentifierList();
        this.print(" <-- ");
        node.getName().apply(this);
        this.printParameterListOpt(node.getParameters());
        this.indent();
        this.printlnOpt();
        this.printListTrailing(node.getAttributes());
        this.indent();
        this.printlnOpt("BODY");
        node.getBody().apply(this);
        this.dedent();
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAOperationAttribute(AOperationAttribute node) {
        node.getName().apply(this);
        this.print(" ");
        this.printCommaListSingleLine(node.getArguments());
    }

    @Override
    public void caseAPredicateAttributeOperationAttribute(APredicateAttributeOperationAttribute node) {
        node.getName().apply(this);
        this.print(" ");
        node.getPredicate().apply(this);
    }

    @Override
    public void caseADescriptionPredicate(ADescriptionPredicate node) {
        node.getPredicate().apply(this);
        node.getDescription().apply(this);
    }

    @Override
    public void caseALabelPredicate(ALabelPredicate node) {
        this.print("/*@label ");
        node.getName().apply(this);
        this.print(" */ ");
        node.getPredicate().apply(this);
    }

    @Override
    public void caseASubstitutionPredicate(ASubstitutionPredicate node) {
        this.print("[");
        node.getSubstitution().apply(this);
        this.print("] ");
        node.getPredicate().apply(this);
    }

    @Override
    public void caseAConjunctPredicate(AConjunctPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), " &\n");
    }

    @Override
    public void caseANegationPredicate(ANegationPredicate node) {
        this.print("not");
        this.printParameterList(Collections.singletonList(node.getPredicate()));
    }

    @Override
    public void caseADisjunctPredicate(ADisjunctPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), " or\n");
    }

    @Override
    public void caseAImplicationPredicate(AImplicationPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), " => ");
    }

    @Override
    public void caseAEquivalencePredicate(AEquivalencePredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), " <=> ");
    }

    @Override
    public void caseAForallPredicate(AForallPredicate node) {
        this.print("!(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getImplication().apply(this);
        this.print(")");
    }

    @Override
    public void caseAExistsPredicate(AExistsPredicate node) {
        this.print("#(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicate().apply(this);
        this.print(")");
    }

    @Override
    public void caseAEqualPredicate(AEqualPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "=");
    }

    @Override
    public void caseANotEqualPredicate(ANotEqualPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "/=");
    }

    @Override
    public void caseAMemberPredicate(AMemberPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), ":");
    }

    @Override
    public void caseANotMemberPredicate(ANotMemberPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "/:");
    }

    @Override
    public void caseASubsetPredicate(ASubsetPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<:");
    }

    @Override
    public void caseASubsetStrictPredicate(ASubsetStrictPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<<:");
    }

    @Override
    public void caseANotSubsetPredicate(ANotSubsetPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "/<:");
    }

    @Override
    public void caseANotSubsetStrictPredicate(ANotSubsetStrictPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "/<<:");
    }

    @Override
    public void caseALessEqualPredicate(ALessEqualPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<=");
    }

    @Override
    public void caseALessPredicate(ALessPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), " < ");
    }

    @Override
    public void caseAGreaterEqualPredicate(AGreaterEqualPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), ">=");
    }

    @Override
    public void caseAGreaterPredicate(AGreaterPredicate node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), ">");
    }

    @Override
    public void caseATruthPredicate(ATruthPredicate node) {
        this.print("btrue");
    }

    @Override
    public void caseAFalsityPredicate(AFalsityPredicate node) {
        this.print("bfalse");
    }

    @Override
    public void caseAFinitePredicate(AFinitePredicate node) {
        this.print("@finite");
        this.printParameterList(Collections.singletonList(node.getSet()));
    }

    @Override
    public void caseAPartitionPredicate(APartitionPredicate node) {
        this.print("@partition");
        this.printParameterList(Stream.concat(Stream.of(node.getSet()), node.getElements().stream()).collect(Collectors.toList()));
    }

    @Override
    public void caseADefinitionPredicate(ADefinitionPredicate node) {
        node.getDefLiteral().apply(this);
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseALetPredicatePredicate(ALetPredicatePredicate node) {
        this.print("LET ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt(" BE");
        node.getAssignment().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("IN");
        node.getPred().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAIfPredicatePredicate(AIfPredicatePredicate node) {
        this.print("IF ");
        this.indent();
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getThen().apply(this);
        this.dedent();
        this.printlnOpt();
        this.printListTrailing(node.getElsifs());
        this.indent();
        this.printlnOpt("ELSE");
        node.getElse().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAIfElsifPredicatePredicate(AIfElsifPredicatePredicate node) {
        this.print("ELSIF ");
        this.indent();
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getThen().apply(this);
        this.dedent();
    }

    @Override
    public void caseAOperatorPredicate(AOperatorPredicate node) {
        node.getName().apply(this);
        this.printParameterListOpt(node.getIdentifiers());
    }

    @Override
    public void caseADescriptionExpression(ADescriptionExpression node) {
        if (!this.identifierList) {
            this.print("(");
        }
        node.getExpression().apply(this);
        node.getDescription().apply(this);
        if (!this.identifierList) {
            this.print(")");
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        this.printDottedList(node.getIdentifier());
    }

    @Override
    public void caseAPrimedIdentifierExpression(APrimedIdentifierExpression node) {
        this.printDottedList(node.getIdentifier());
        this.print("$0");
    }

    @Override
    public void caseAStringExpression(AStringExpression node) {
        this.print("\"");
        this.print(Utils.escapeStringContents(node.getContent().getText()));
        this.print("\"");
    }

    @Override
    public void caseAMultilineStringExpression(AMultilineStringExpression node) {
        this.print("'''");
        String text = Arrays.stream(node.getContent().getText().split("\n")).map(Utils::escapeStringContents).collect(Collectors.joining("\n"));
        this.print(text);
        this.print("'''");
    }

    @Override
    public void caseABooleanTrueExpression(ABooleanTrueExpression node) {
        this.print("TRUE");
    }

    @Override
    public void caseABooleanFalseExpression(ABooleanFalseExpression node) {
        this.print("FALSE");
    }

    @Override
    public void caseAIntegerExpression(AIntegerExpression node) {
        this.print(node.getLiteral().getText());
    }

    @Override
    public void caseARealExpression(ARealExpression node) {
        this.print(node.getLiteral().getText());
    }

    @Override
    public void caseAHexIntegerExpression(AHexIntegerExpression node) {
        this.print(node.getLiteral().getText());
    }

    @Override
    public void caseAMaxIntExpression(AMaxIntExpression node) {
        this.print("MAXINT");
    }

    @Override
    public void caseAMinIntExpression(AMinIntExpression node) {
        this.print("MININT");
    }

    @Override
    public void caseAEmptySetExpression(AEmptySetExpression node) {
        this.print("{}");
    }

    @Override
    public void caseAIntegerSetExpression(AIntegerSetExpression node) {
        this.print("INTEGER");
    }

    @Override
    public void caseARealSetExpression(ARealSetExpression node) {
        this.print("REAL");
    }

    @Override
    public void caseAFloatSetExpression(AFloatSetExpression node) {
        this.print("FLOAT");
    }

    @Override
    public void caseANaturalSetExpression(ANaturalSetExpression node) {
        this.print("NATURAL");
    }

    @Override
    public void caseANatural1SetExpression(ANatural1SetExpression node) {
        this.print("NATURAL1");
    }

    @Override
    public void caseANatSetExpression(ANatSetExpression node) {
        this.print("NAT");
    }

    @Override
    public void caseANat1SetExpression(ANat1SetExpression node) {
        this.print("NAT1");
    }

    @Override
    public void caseAIntSetExpression(AIntSetExpression node) {
        this.print("INT");
    }

    @Override
    public void caseABoolSetExpression(ABoolSetExpression node) {
        this.print("BOOL");
    }

    @Override
    public void caseAStringSetExpression(AStringSetExpression node) {
        this.print("STRING");
    }

    @Override
    public void caseAConvertBoolExpression(AConvertBoolExpression node) {
        this.print("bool");
        this.printParameterList(Collections.singletonList(node.getPredicate()));
    }

    @Override
    public void caseAAddExpression(AAddExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "+");
    }

    @Override
    public void caseAMinusOrSetSubtractExpression(AMinusOrSetSubtractExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "-");
    }

    @Override
    public void caseAUnaryMinusExpression(AUnaryMinusExpression node) {
        this.print("-");
        this.leftPar(node, node.getExpression());
        node.getExpression().apply(this);
        this.rightPar(node, node.getExpression());
    }

    @Override
    public void caseACartesianProductExpression(ACartesianProductExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "\u00d7");
    }

    @Override
    public void caseAMultOrCartExpression(AMultOrCartExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "*");
    }

    @Override
    public void caseADivExpression(ADivExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "/");
    }

    @Override
    public void caseAFlooredDivExpression(AFlooredDivExpression node) {
        this.print("FDIV");
        this.printParameterList(Arrays.asList(node.getLeft(), node.getRight()));
    }

    @Override
    public void caseAIfThenElseExpression(AIfThenElseExpression node) {
        this.print("IF ");
        this.indent();
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getThen().apply(this);
        this.dedent();
        this.printlnOpt();
        this.printListTrailing(node.getElsifs());
        this.indent();
        this.printlnOpt("ELSE");
        node.getElse().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAIfElsifExprExpression(AIfElsifExprExpression node) {
        this.print("ELSIF ");
        this.indent();
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getThen().apply(this);
        this.dedent();
    }

    @Override
    public void caseALetExpressionExpression(ALetExpressionExpression node) {
        this.print("LET ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt(" BE");
        node.getAssignment().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("IN");
        node.getExpr().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAModuloExpression(AModuloExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), " mod ");
    }

    @Override
    public void caseAPowerOfExpression(APowerOfExpression node) {
        this.applyRightAssociative(node.getLeft(), node, node.getRight(), "**");
    }

    @Override
    public void caseASuccessorExpression(ASuccessorExpression node) {
        this.print("succ");
    }

    @Override
    public void caseAPredecessorExpression(APredecessorExpression node) {
        this.print("pred");
    }

    @Override
    public void caseAMaxExpression(AMaxExpression node) {
        this.print("max");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAMinExpression(AMinExpression node) {
        this.print("min");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseACardExpression(ACardExpression node) {
        this.print("card");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAConvertIntFloorExpression(AConvertIntFloorExpression node) {
        this.print("floor");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAConvertIntCeilingExpression(AConvertIntCeilingExpression node) {
        this.print("ceiling");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAConvertRealExpression(AConvertRealExpression node) {
        this.print("real");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAGeneralSumExpression(AGeneralSumExpression node) {
        this.print("SIGMA(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicates().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print(")");
    }

    @Override
    public void caseAGeneralProductExpression(AGeneralProductExpression node) {
        this.print("PI(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicates().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print(")");
    }

    @Override
    public void caseACoupleExpression(ACoupleExpression node) {
        this.printParameterList(node.getList());
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        this.print("{");
        this.printCommaListCompact(node.getIdentifiers());
        this.print("|");
        node.getPredicates().apply(this);
        this.print("}");
    }

    @Override
    public void caseASymbolicComprehensionSetExpression(ASymbolicComprehensionSetExpression node) {
        this.print("/*@symbolic*/ ");
        this.print("{");
        this.printCommaListCompact(node.getIdentifiers());
        this.print("|");
        node.getPredicates().apply(this);
        this.print("}");
    }

    @Override
    public void caseAEventBComprehensionSetExpression(AEventBComprehensionSetExpression node) {
        this.print("{(");
        this.printCommaListCompact(node.getIdentifiers());
        this.print(").");
        node.getPredicates().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print("}");
    }

    @Override
    public void caseASymbolicEventBComprehensionSetExpression(ASymbolicEventBComprehensionSetExpression node) {
        this.print("/*@symbolic*/ ");
        this.print("{(");
        this.printCommaListCompact(node.getIdentifiers());
        this.print(").");
        node.getPredicates().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print("}");
    }

    @Override
    public void caseAPowSubsetExpression(APowSubsetExpression node) {
        this.print("POW");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAPow1SubsetExpression(APow1SubsetExpression node) {
        this.print("POW1");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAFinSubsetExpression(AFinSubsetExpression node) {
        this.print("FIN");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAFin1SubsetExpression(AFin1SubsetExpression node) {
        this.print("FIN1");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseASetExtensionExpression(ASetExtensionExpression node) {
        this.printDelimitedCommaList(node.getExpressions(), "{", "}", 20);
    }

    @Override
    public void caseAIntervalExpression(AIntervalExpression node) {
        this.applyLeftAssociative(node.getLeftBorder(), node, node.getRightBorder(), "..");
    }

    @Override
    public void caseAUnionExpression(AUnionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "\\/");
    }

    @Override
    public void caseAIntersectionExpression(AIntersectionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "/\\");
    }

    @Override
    public void caseASetSubtractionExpression(ASetSubtractionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "\\");
    }

    @Override
    public void caseAGeneralUnionExpression(AGeneralUnionExpression node) {
        this.print("union");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAGeneralIntersectionExpression(AGeneralIntersectionExpression node) {
        this.print("inter");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
        this.print("UNION(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicates().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print(")");
    }

    @Override
    public void caseASymbolicQuantifiedUnionExpression(ASymbolicQuantifiedUnionExpression node) {
        this.print("/*@symbolic*/ ");
        this.print("UNION(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicates().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print(")");
    }

    @Override
    public void caseAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        this.print("INTER(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicates().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print(")");
    }

    @Override
    public void caseARelationsExpression(ARelationsExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<->");
    }

    @Override
    public void caseAIdentityExpression(AIdentityExpression node) {
        this.print("id");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAReverseExpression(AReverseExpression node) {
        this.leftPar(node, node.getExpression());
        node.getExpression().apply(this);
        this.rightPar(node, node.getExpression());
        this.print("~");
    }

    @Override
    public void caseAFirstProjectionExpression(AFirstProjectionExpression node) {
        this.print("prj1");
        this.printParameterList(Arrays.asList(node.getExp1(), node.getExp2()));
    }

    @Override
    public void caseAEventBFirstProjectionExpression(AEventBFirstProjectionExpression node) {
        this.print("prj1");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAEventBFirstProjectionV2Expression(AEventBFirstProjectionV2Expression node) {
        this.print("@prj1");
    }

    @Override
    public void caseASecondProjectionExpression(ASecondProjectionExpression node) {
        this.print("prj2");
        this.printParameterList(Arrays.asList(node.getExp1(), node.getExp2()));
    }

    @Override
    public void caseAEventBSecondProjectionExpression(AEventBSecondProjectionExpression node) {
        this.print("prj2");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAEventBSecondProjectionV2Expression(AEventBSecondProjectionV2Expression node) {
        this.print("@prj2");
    }

    @Override
    public void caseACompositionExpression(ACompositionExpression node) {
        this.print("(");
        node.getLeft().apply(this);
        this.print(";");
        node.getRight().apply(this);
        this.print(")");
    }

    @Override
    public void caseASymbolicCompositionExpression(ASymbolicCompositionExpression node) {
        this.print("(");
        node.getLeft().apply(this);
        this.print(" /*@symbolic*/ ");
        this.print(";");
        node.getRight().apply(this);
        this.print(")");
    }

    @Override
    public void caseARingExpression(ARingExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "\u2218");
    }

    @Override
    public void caseADirectProductExpression(ADirectProductExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "><");
    }

    @Override
    public void caseAParallelProductExpression(AParallelProductExpression node) {
        this.print("(");
        node.getLeft().apply(this);
        this.print("||");
        node.getRight().apply(this);
        this.print(")");
    }

    @Override
    public void caseAIterationExpression(AIterationExpression node) {
        this.print("iterate");
        this.printParameterList(Arrays.asList(node.getLeft(), node.getRight()));
    }

    @Override
    public void caseAReflexiveClosureExpression(AReflexiveClosureExpression node) {
        this.print("closure");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAClosureExpression(AClosureExpression node) {
        this.print("closure1");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseADomainExpression(ADomainExpression node) {
        this.print("dom");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseARangeExpression(ARangeExpression node) {
        this.print("ran");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAImageExpression(AImageExpression node) {
        this.leftParAssoc(node, node.getLeft());
        node.getLeft().apply(this);
        this.rightParAssoc(node, node.getLeft());
        this.print("[");
        node.getRight().apply(this);
        this.print("]");
    }

    @Override
    public void caseADomainRestrictionExpression(ADomainRestrictionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<|");
    }

    @Override
    public void caseADomainSubtractionExpression(ADomainSubtractionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<<|");
    }

    @Override
    public void caseARangeRestrictionExpression(ARangeRestrictionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "|>");
    }

    @Override
    public void caseARangeSubtractionExpression(ARangeSubtractionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "|>>");
    }

    @Override
    public void caseAOverwriteExpression(AOverwriteExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<+");
    }

    @Override
    public void caseAPartialFunctionExpression(APartialFunctionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "+->");
    }

    @Override
    public void caseATotalFunctionExpression(ATotalFunctionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "-->");
    }

    @Override
    public void caseAPartialInjectionExpression(APartialInjectionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), ">+>");
    }

    @Override
    public void caseATotalInjectionExpression(ATotalInjectionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), ">->");
    }

    @Override
    public void caseAPartialSurjectionExpression(APartialSurjectionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "+->>");
    }

    @Override
    public void caseATotalSurjectionExpression(ATotalSurjectionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "-->>");
    }

    @Override
    public void caseAPartialBijectionExpression(APartialBijectionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), ">+>>");
    }

    @Override
    public void caseATotalBijectionExpression(ATotalBijectionExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), ">->>");
    }

    @Override
    public void caseATotalRelationExpression(ATotalRelationExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<<->");
    }

    @Override
    public void caseASurjectionRelationExpression(ASurjectionRelationExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<->>");
    }

    @Override
    public void caseATotalSurjectionRelationExpression(ATotalSurjectionRelationExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "<<->>");
    }

    @Override
    public void caseALambdaExpression(ALambdaExpression node) {
        this.print("%(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicate().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print(")");
    }

    @Override
    public void caseASymbolicLambdaExpression(ASymbolicLambdaExpression node) {
        this.print("/*@symbolic*/ %(");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.print(").(");
        node.getPredicate().apply(this);
        this.print("|");
        node.getExpression().apply(this);
        this.print(")");
    }

    @Override
    public void caseATransFunctionExpression(ATransFunctionExpression node) {
        this.print("fnc");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseATransRelationExpression(ATransRelationExpression node) {
        this.print("rel");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseASeqExpression(ASeqExpression node) {
        this.print("seq");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseASeq1Expression(ASeq1Expression node) {
        this.print("seq1");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAIseqExpression(AIseqExpression node) {
        this.print("iseq");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAIseq1Expression(AIseq1Expression node) {
        this.print("iseq1");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAPermExpression(APermExpression node) {
        this.print("perm");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAEmptySequenceExpression(AEmptySequenceExpression node) {
        this.print("[]");
    }

    @Override
    public void caseASequenceExtensionExpression(ASequenceExtensionExpression node) {
        this.printDelimitedCommaList(node.getExpression(), "[", "]", 20);
    }

    @Override
    public void caseASizeExpression(ASizeExpression node) {
        this.print("size");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAFirstExpression(AFirstExpression node) {
        this.print("first");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseALastExpression(ALastExpression node) {
        this.print("last");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAFrontExpression(AFrontExpression node) {
        this.print("front");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseATailExpression(ATailExpression node) {
        this.print("tail");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseARevExpression(ARevExpression node) {
        this.print("rev");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAConcatExpression(AConcatExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "^");
    }

    @Override
    public void caseAInsertFrontExpression(AInsertFrontExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "->");
    }

    @Override
    public void caseAInsertTailExpression(AInsertTailExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), " <- ");
    }

    @Override
    public void caseARestrictFrontExpression(ARestrictFrontExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "/|\\");
    }

    @Override
    public void caseARestrictTailExpression(ARestrictTailExpression node) {
        this.applyLeftAssociative(node.getLeft(), node, node.getRight(), "\\|/");
    }

    @Override
    public void caseAGeneralConcatExpression(AGeneralConcatExpression node) {
        this.print("conc");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseADefinitionExpression(ADefinitionExpression node) {
        node.getDefLiteral().apply(this);
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseAFunctionExpression(AFunctionExpression node) {
        this.leftParAssoc(node, node.getIdentifier());
        node.getIdentifier().apply(this);
        this.rightParAssoc(node, node.getIdentifier());
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseATreeExpression(ATreeExpression node) {
        this.print("tree");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseABtreeExpression(ABtreeExpression node) {
        this.print("btree");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAConstExpression(AConstExpression node) {
        this.print("const");
        this.printParameterList(Arrays.asList(node.getExpression1(), node.getExpression2()));
    }

    @Override
    public void caseATopExpression(ATopExpression node) {
        this.print("top");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseASonsExpression(ASonsExpression node) {
        this.print("sons");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAPrefixExpression(APrefixExpression node) {
        this.print("prefix");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAPostfixExpression(APostfixExpression node) {
        this.print("postfix");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseASizetExpression(ASizetExpression node) {
        this.print("sizet");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAMirrorExpression(AMirrorExpression node) {
        this.print("mirror");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseARankExpression(ARankExpression node) {
        this.print("rank");
        this.printParameterList(Arrays.asList(node.getExpression1(), node.getExpression2()));
    }

    @Override
    public void caseAFatherExpression(AFatherExpression node) {
        this.print("father");
        this.printParameterList(Arrays.asList(node.getExpression1(), node.getExpression2()));
    }

    @Override
    public void caseASonExpression(ASonExpression node) {
        this.print("son");
        this.printParameterList(Arrays.asList(node.getExpression1(), node.getExpression2(), node.getExpression3()));
    }

    @Override
    public void caseASubtreeExpression(ASubtreeExpression node) {
        this.print("subtree");
        this.printParameterList(Arrays.asList(node.getExpression1(), node.getExpression2()));
    }

    @Override
    public void caseAArityExpression(AArityExpression node) {
        this.print("arity");
        this.printParameterList(Arrays.asList(node.getExpression1(), node.getExpression2()));
    }

    @Override
    public void caseABinExpression(ABinExpression node) {
        this.print("bin");
        this.printParameterList(Stream.of(node.getExpression1(), node.getExpression2(), node.getExpression3()).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public void caseALeftExpression(ALeftExpression node) {
        this.print("left");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseARightExpression(ARightExpression node) {
        this.print("right");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAInfixExpression(AInfixExpression node) {
        this.print("infix");
        this.printParameterList(Collections.singletonList(node.getExpression()));
    }

    @Override
    public void caseAStructExpression(AStructExpression node) {
        this.print("struct");
        this.printParameterList(node.getEntries());
    }

    @Override
    public void caseARecExpression(ARecExpression node) {
        this.print("rec");
        this.printParameterList(node.getEntries());
    }

    @Override
    public void caseARecordFieldExpression(ARecordFieldExpression node) {
        this.applyLeftAssociative(node.getRecord(), node, node.getIdentifier(), "'");
    }

    @Override
    public void caseATypeofExpression(ATypeofExpression node) {
        this.applyRightAssociative(node.getExpression(), node, node.getType(), "\u2982");
    }

    @Override
    public void caseAOperatorExpression(AOperatorExpression node) {
        node.getName().apply(this);
        this.printParameterListOpt(node.getIdentifiers());
    }

    @Override
    public void caseARecEntry(ARecEntry node) {
        node.getIdentifier().apply(this);
        this.print(": ");
        node.getValue().apply(this);
    }

    @Override
    public void caseABlockSubstitution(ABlockSubstitution node) {
        this.printSubstitutionInBlock(node.getSubstitution());
    }

    @Override
    public void caseASkipSubstitution(ASkipSubstitution node) {
        this.print("skip");
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        this.printCommaListCompact(node.getLhsExpression());
        this.print(" := ");
        this.printCommaListCompact(node.getRhsExpressions());
    }

    @Override
    public void caseAPreconditionSubstitution(APreconditionSubstitution node) {
        this.indent();
        this.printlnOpt("PRE");
        node.getPredicate().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("THEN");
        node.getSubstitution().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAAssertionSubstitution(AAssertionSubstitution node) {
        this.indent();
        this.printlnOpt("ASSERT");
        node.getPredicate().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("THEN");
        node.getSubstitution().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAChoiceSubstitution(AChoiceSubstitution node) {
        this.indent();
        this.printlnOpt("CHOICE");
        this.printList(node.getSubstitutions());
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAChoiceOrSubstitution(AChoiceOrSubstitution node) {
        this.print("OR ");
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseAIfSubstitution(AIfSubstitution node) {
        this.print("IF ");
        this.indent();
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getThen().apply(this);
        this.dedent();
        this.printlnOpt();
        this.printListTrailing(node.getElsifSubstitutions());
        if (node.getElse() != null) {
            this.indent();
            this.printlnOpt("ELSE");
            node.getElse().apply(this);
            this.dedent();
            this.printlnOpt();
        }
        this.print("END");
    }

    @Override
    public void caseAIfElsifSubstitution(AIfElsifSubstitution node) {
        this.print("ELSIF ");
        this.indent();
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getThenSubstitution().apply(this);
        this.dedent();
    }

    @Override
    public void caseASelectSubstitution(ASelectSubstitution node) {
        this.print("SELECT ");
        this.indent();
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getThen().apply(this);
        this.dedent();
        this.printlnOpt();
        this.printListTrailing(node.getWhenSubstitutions());
        if (node.getElse() != null) {
            this.indent();
            this.printlnOpt("ELSE");
            node.getElse().apply(this);
            this.dedent();
            this.printlnOpt();
        }
        this.print("END");
    }

    @Override
    public void caseASelectWhenSubstitution(ASelectWhenSubstitution node) {
        this.indent();
        this.print("WHEN ");
        node.getCondition().apply(this);
        this.printlnOpt(" THEN");
        node.getSubstitution().apply(this);
        this.dedent();
    }

    @Override
    public void caseACaseSubstitution(ACaseSubstitution node) {
        this.print("CASE ");
        this.indent();
        node.getExpression().apply(this);
        this.printlnOpt(" OF");
        this.print("EITHER ");
        this.indent();
        this.printCommaListSingleLine(node.getEitherExpr());
        this.printlnOpt(" THEN");
        node.getEitherSubst().apply(this);
        this.dedent();
        this.printlnOpt();
        this.printListTrailing(node.getOrSubstitutions());
        if (node.getElse() != null) {
            this.indent();
            this.printlnOpt("ELSE");
            node.getElse().apply(this);
            this.dedent();
            this.printlnOpt();
        }
        this.dedent();
        this.printlnOpt("END");
        this.print("END");
    }

    @Override
    public void caseACaseOrSubstitution(ACaseOrSubstitution node) {
        this.print("OR ");
        this.indent();
        this.printCommaListSingleLine(node.getExpressions());
        this.printlnOpt(" THEN");
        node.getSubstitution().apply(this);
        this.dedent();
    }

    @Override
    public void caseAAnySubstitution(AAnySubstitution node) {
        this.print("ANY ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt(" WHERE");
        node.getWhere().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("THEN");
        node.getThen().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseALetSubstitution(ALetSubstitution node) {
        this.print("LET ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt(" BE");
        node.getPredicate().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("IN");
        node.getSubstitution().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        this.printCommaListCompact(node.getIdentifiers());
        this.print(" :: ");
        node.getSet().apply(this);
    }

    @Override
    public void caseABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        this.printCommaListCompact(node.getIdentifiers());
        this.print(" : (");
        node.getPredicate().apply(this);
        this.print(")");
    }

    @Override
    public void caseAVarSubstitution(AVarSubstitution node) {
        this.print("VAR ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt(" IN");
        node.getSubstitution().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseASequenceSubstitution(ASequenceSubstitution node) {
        this.printListOpt(node.getSubstitutions(), " ;\n");
    }

    @Override
    public void caseAOperationOrDefinitionCallSubstitution(AOperationOrDefinitionCallSubstitution node) {
        node.getExpression().apply(this);
    }

    @Override
    public void caseAOperationCallSubstitution(AOperationCallSubstitution node) {
        if (!node.getResultIdentifiers().isEmpty()) {
            this.printCommaListCompact(node.getResultIdentifiers());
            this.print(" <-- ");
        }
        this.printDottedList(node.getOperation());
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseAWhileSubstitution(AWhileSubstitution node) {
        this.indent();
        this.printlnOpt("WHILE");
        node.getCondition().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("DO");
        node.getDoSubst().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("INVARIANT");
        node.getInvariant().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("VARIANT");
        node.getVariant().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAParallelSubstitution(AParallelSubstitution node) {
        this.printListOpt(node.getSubstitutions(), " ||\n");
    }

    @Override
    public void caseADefinitionSubstitution(ADefinitionSubstitution node) {
        node.getDefLiteral().apply(this);
        this.printParameterListOpt(node.getParameters());
    }

    @Override
    public void caseAForallSubMessageSubstitution(AForallSubMessageSubstitution node) {
        this.print("RULE_FORALL ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("WHERE");
        node.getWhere().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("EXPECT");
        node.getExpect().apply(this);
        this.dedent();
        this.printlnOpt();
        if (node.getErrorType() != null) {
            this.print("ERROR_TYPE ");
            this.print(node.getErrorType().getText());
            this.printlnOpt();
        }
        this.indent();
        this.printlnOpt("COUNTEREXAMPLE");
        node.getMessage().apply(this);
        this.dedent();
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseARuleFailSubSubstitution(ARuleFailSubSubstitution node) {
        this.print("RULE_FAIL ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt();
        if (node.getWhen() != null) {
            this.indent();
            this.printlnOpt("WHEN");
            node.getWhen().apply(this);
            this.dedent();
            this.printlnOpt();
        }
        if (node.getErrorType() != null) {
            this.print("ERROR_TYPE ");
            this.print(node.getErrorType().getText());
            this.printlnOpt();
        }
        this.indent();
        this.printlnOpt("COUNTEREXAMPLE");
        node.getMessage().apply(this);
        this.dedent();
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAForLoopSubstitution(AForLoopSubstitution node) {
        this.print("FOR ");
        this.openIdentifierList();
        this.printCommaListCompact(node.getIdentifiers());
        this.closeIdentifierList();
        this.indent();
        this.printlnOpt(" IN");
        node.getSet().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("DO");
        node.getDoSubst().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAOperatorSubstitution(AOperatorSubstitution node) {
        node.getName().apply(this);
        this.printParameterListOpt(node.getArguments());
    }

    @Override
    public void caseADefineSubstitution(ADefineSubstitution node) {
        this.print("DEFINE ");
        node.getName().apply(this);
        this.indent();
        this.printlnOpt();
        this.indent();
        this.print("TYPE ");
        node.getType().apply(this);
        this.dedent();
        this.printlnOpt();
        if (node.getDummyValue() != null) {
            this.indent();
            this.print("DUMMY_VALUE ");
            node.getDummyValue().apply(this);
            this.dedent();
            this.printlnOpt();
        }
        this.indent();
        this.print("VALUE ");
        node.getValue().apply(this);
        this.dedent();
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseAWitnessThenSubstitution(AWitnessThenSubstitution node) {
        this.indent();
        this.printlnOpt("WITNESS");
        node.getPredicate().apply(this);
        this.dedent();
        this.printlnOpt();
        this.indent();
        this.printlnOpt("THEN");
        node.getSubstitution().apply(this);
        this.dedent();
        this.printlnOpt();
        this.print("END");
    }

    @Override
    public void caseTPragmaIdOrString(TPragmaIdOrString node) {
        this.print(node.getText());
    }

    @Override
    public void caseTIdentifierLiteral(TIdentifierLiteral node) {
        this.print(this.renaming.renameIdentifier(node.getText()));
    }

    @Override
    public void caseTDefLiteralSubstitution(TDefLiteralSubstitution node) {
        this.print(this.renaming.renameIdentifier(node.getText()));
    }

    @Override
    public void caseTDefLiteralPredicate(TDefLiteralPredicate node) {
        this.print(this.renaming.renameIdentifier(node.getText()));
    }

    @Override
    public void caseTKwSubstitutionOperator(TKwSubstitutionOperator node) {
        this.print(node.getText());
    }

    @Override
    public void caseTKwPredicateOperator(TKwPredicateOperator node) {
        this.print(node.getText());
    }

    @Override
    public void caseTKwExpressionOperator(TKwExpressionOperator node) {
        this.print(node.getText());
    }

    @Override
    public void caseTKwPredicateAttribute(TKwPredicateAttribute node) {
        this.print(node.getText());
    }

    @Override
    public void caseTKwAttributeIdentifier(TKwAttributeIdentifier node) {
        this.print(node.getText());
    }

    @Override
    public void defaultCase(Node node) {
        throw new IllegalArgumentException("Node type '" + node.getClass().getSimpleName() + "' not (yet) supported by PrettyPrinter: " + node);
    }

    static {
        HashMap<Class<AFunctionExpression>, Integer> prio = new HashMap<Class<AFunctionExpression>, Integer>();
        prio.put(AParallelProductExpression.class, 20);
        prio.put(AImplicationPredicate.class, 30);
        prio.put(ADisjunctPredicate.class, 40);
        prio.put(AConjunctPredicate.class, 40);
        prio.put(AEquivalencePredicate.class, 60);
        prio.put(ATypeofExpression.class, 120);
        prio.put(ARelationsExpression.class, 125);
        prio.put(APartialFunctionExpression.class, 125);
        prio.put(ATotalFunctionExpression.class, 125);
        prio.put(APartialInjectionExpression.class, 125);
        prio.put(ATotalInjectionExpression.class, 125);
        prio.put(APartialSurjectionExpression.class, 125);
        prio.put(ATotalSurjectionExpression.class, 125);
        prio.put(APartialBijectionExpression.class, 125);
        prio.put(ATotalBijectionExpression.class, 125);
        prio.put(ATotalRelationExpression.class, 125);
        prio.put(ATotalSurjectionRelationExpression.class, 125);
        prio.put(AOverwriteExpression.class, 160);
        prio.put(ARingExpression.class, 160);
        prio.put(ADirectProductExpression.class, 160);
        prio.put(AConcatExpression.class, 160);
        prio.put(ADomainRestrictionExpression.class, 160);
        prio.put(ADomainSubtractionExpression.class, 160);
        prio.put(ARangeRestrictionExpression.class, 160);
        prio.put(ARangeSubtractionExpression.class, 160);
        prio.put(AInsertFrontExpression.class, 160);
        prio.put(AInsertTailExpression.class, 160);
        prio.put(AUnionExpression.class, 160);
        prio.put(AIntersectionExpression.class, 160);
        prio.put(ARestrictFrontExpression.class, 160);
        prio.put(ARestrictTailExpression.class, 160);
        prio.put(ACoupleExpression.class, 160);
        prio.put(AIntervalExpression.class, 170);
        prio.put(AMinusOrSetSubtractExpression.class, 180);
        prio.put(AAddExpression.class, 180);
        prio.put(ASetSubtractionExpression.class, 180);
        prio.put(ACartesianProductExpression.class, 190);
        prio.put(AMultOrCartExpression.class, 190);
        prio.put(AMultiplicationExpression.class, 190);
        prio.put(ADivExpression.class, 190);
        prio.put(AModuloExpression.class, 190);
        prio.put(APowerOfExpression.class, 200);
        prio.put(AUnaryMinusExpression.class, 210);
        prio.put(AReverseExpression.class, 230);
        prio.put(AImageExpression.class, 231);
        prio.put(ARecordFieldExpression.class, 231);
        prio.put(AFunctionExpression.class, 231);
        OPERATOR_PRIORITIES = Collections.unmodifiableMap(prio);
    }
}

