/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.checking;

import de.be4.classicalb.core.parser.analysis.OptimizedTraversingAdapter;
import de.be4.classicalb.core.parser.analysis.checking.SemanticCheck;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.ASymbolicComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Start;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IdentListCheck
extends OptimizedTraversingAdapter
implements SemanticCheck {
    private final Set<Node> nonIdentifiers = new HashSet<Node>();
    private final List<CheckException> exceptions = new ArrayList<CheckException>();

    @Override
    public void runChecks(Start rootNode) {
        this.nonIdentifiers.clear();
        rootNode.apply(this);
        if (!this.nonIdentifiers.isEmpty()) {
            this.exceptions.add(new CheckException("Identifier expected", new ArrayList<Node>(this.nonIdentifiers)));
        }
    }

    @Override
    public void inAComprehensionSetExpression(AComprehensionSetExpression node) {
        this.checkForNonIdentifiers(node.getIdentifiers());
    }

    @Override
    public void inASymbolicComprehensionSetExpression(ASymbolicComprehensionSetExpression node) {
        this.checkForNonIdentifiers(node.getIdentifiers());
    }

    @Override
    public void inAEventBComprehensionSetExpression(AEventBComprehensionSetExpression node) {
        this.checkForNonIdentifiers(node.getIdentifiers());
    }

    @Override
    public void inASymbolicEventBComprehensionSetExpression(ASymbolicEventBComprehensionSetExpression node) {
        this.checkForNonIdentifiers(node.getIdentifiers());
    }

    @Override
    public void inABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        this.checkForNonIdentifiers(node.getIdentifiers());
    }

    @Override
    public void inABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        this.checkForNonIdentifiers(node.getIdentifiers());
    }

    private void checkForNonIdentifiers(List<? extends Node> identifiers) {
        for (Node node : identifiers) {
            if (node instanceof AIdentifierExpression || node instanceof ADefinitionExpression) continue;
            this.nonIdentifiers.add(node);
        }
    }

    @Override
    public List<CheckException> getCheckExceptions() {
        return this.exceptions;
    }
}

