/*
 * Decompiled with CFR 0.152.
 */
package de.be4.ltl.core.parser.internal;

import de.be4.ltl.core.parser.LtlParseException;
import de.be4.ltl.core.parser.internal.LtlAdapterException;
import de.be4.ltl.core.parser.internal.PrologGenerator;
import de.be4.ltl.core.parser.internal.UniversalToken;
import de.be4.ltl.core.parser.node.ABeforeAfterLtl;
import de.be4.ltl.core.parser.node.AChangedLtl;
import de.be4.ltl.core.parser.node.ACtrlLtl;
import de.be4.ltl.core.parser.node.ADecreasingLtl;
import de.be4.ltl.core.parser.node.ADetLtl;
import de.be4.ltl.core.parser.node.ADlkLtl;
import de.be4.ltl.core.parser.node.AExistsLtl;
import de.be4.ltl.core.parser.node.AForallLtl;
import de.be4.ltl.core.parser.node.AIncreasingLtl;
import de.be4.ltl.core.parser.node.AUnchangedLtl;
import de.be4.ltl.core.parser.node.PActions;
import de.be4.ltl.core.parser.node.PLtl;
import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.output.IPrologTermOutput;
import java.util.Locale;

final class PrologGeneratorHelper {
    private final IPrologTermOutput pto;
    private final String currentStateID;
    private final ProBParserBase specParser;

    public PrologGeneratorHelper(IPrologTermOutput pto, String currentStateID, ProBParserBase specParser) {
        this.pto = pto;
        this.currentStateID = currentStateID;
        this.specParser = specParser;
    }

    public void defaultIn(Class<?> clazz) {
        String name = clazz.getSimpleName();
        if (clazz.getSuperclass() == null) {
            throw new IllegalArgumentException("Class has no superclass? " + clazz);
        }
        String superclassName = clazz.getSuperclass().getSimpleName();
        if (!superclassName.startsWith("P") || !name.startsWith("A")) {
            throw new IllegalArgumentException("Unexpected class name for a SableCC AST node: " + clazz + ", superclass " + clazz.getSuperclass());
        }
        String productionName = superclassName.substring(1);
        if (!name.endsWith(productionName)) {
            throw new IllegalArgumentException("Node class name doesn't match its superclass? " + clazz + ", superclass " + clazz.getSuperclass());
        }
        String term = name.substring(1, name.length() - productionName.length()).toLowerCase(Locale.ENGLISH);
        this.pto.openTerm(term);
    }

    public void defaultOut() {
        this.pto.closeTerm();
    }

    public void caseUnparsed(UniversalToken token) {
        this.pto.openTerm("ap");
        try {
            this.specParser.parsePredicate(this.pto, token.getText(), true, token.getLine(), token.getColumn());
        }
        catch (ProBParseException e) {
            throw this.createAdapterException(token, e);
        }
        catch (UnsupportedOperationException e) {
            throw this.createAdapterException(token, e);
        }
        this.pto.closeTerm();
    }

    public void caseUnparsedPredicate(UniversalToken token) {
        try {
            this.specParser.parsePredicate(this.pto, token.getText(), true, token.getLine(), token.getColumn());
        }
        catch (ProBParseException e) {
            throw this.createAdapterException(token, e);
        }
        catch (UnsupportedOperationException e) {
            throw this.createAdapterException(token, e);
        }
    }

    public void caseUnparsedExpression(UniversalToken token, boolean wrap) {
        try {
            this.specParser.parseExpression(this.pto, token.getText(), wrap, token.getLine(), token.getColumn());
        }
        catch (ProBParseException e) {
            throw this.createAdapterException(token, e);
        }
        catch (UnsupportedOperationException e) {
            throw this.createAdapterException(token, e);
        }
    }

    public void enabled(UniversalToken token) {
        this.pto.openTerm("ap");
        this.pto.openTerm("enabled");
        this.parseTransitionPredicate(token);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void available(UniversalToken token) {
        this.pto.openTerm("ap");
        this.pto.openTerm("available");
        this.parseTransitionPredicate(token);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void strongFair(UniversalToken token) {
        this.pto.openTerm("ap");
        this.pto.openTerm("strong_fair");
        this.parseTransitionPredicate(token);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void weakFair(UniversalToken token) {
        this.pto.openTerm("ap");
        this.pto.openTerm("weak_fair");
        this.parseTransitionPredicate(token);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void parseTransitionPredicate(UniversalToken token) {
        try {
            this.specParser.parseTransitionPredicate(this.pto, token.getText(), true, token.getLine(), token.getColumn());
        }
        catch (ProBParseException | UnsupportedOperationException e) {
            throw this.createAdapterException(token, e);
        }
    }

    public void sink() {
        this.pto.openTerm("ap");
        this.pto.printAtom("sink");
        this.pto.closeTerm();
    }

    public void goal() {
        this.pto.openTerm("ap");
        this.pto.printAtom("goal");
        this.pto.closeTerm();
    }

    public void detOutput() {
        this.pto.openTerm("ap");
        this.pto.printAtom("det_output");
        this.pto.closeTerm();
    }

    public void nonDet() {
        this.pto.openTerm("ap");
        this.pto.printAtom("non_det");
        this.pto.closeTerm();
    }

    public void stateError() {
        this.pto.openTerm("ap");
        this.pto.printAtom("state_error");
        this.pto.closeTerm();
    }

    public void deadlock() {
        this.pto.openTerm("ap");
        this.pto.printAtom("deadlock");
        this.pto.closeTerm();
    }

    public void current() {
        this.pto.openTerm("ap");
        if (this.currentStateID != null) {
            this.pto.openTerm("stateid");
            this.pto.printAtomOrNumber(this.currentStateID);
            this.pto.closeTerm();
        } else {
            this.pto.printAtom("current");
        }
        this.pto.closeTerm();
    }

    private LtlAdapterException createAdapterException(UniversalToken token, Throwable orig) {
        LtlParseException ex = new LtlParseException(token, orig);
        return new LtlAdapterException(ex);
    }

    public void existsTerm(AExistsLtl node, PrologGenerator gen) {
        this.pto.openTerm("exists");
        String identifier = node.getExistsIdentifier().getText();
        this.pto.printAtom(identifier);
        UniversalToken token = UniversalToken.createToken(node.getPredicate());
        this.caseUnparsed(token);
        node.getLtl().apply(gen);
        this.pto.closeTerm();
    }

    public void forallTerm(AForallLtl node, PrologGenerator gen) {
        this.pto.openTerm("forall");
        String identifier = node.getForallIdentifier().getText();
        this.pto.printAtom(identifier);
        UniversalToken token = UniversalToken.createToken(node.getPredicate());
        this.caseUnparsed(token);
        node.getLtl().apply(gen);
        this.pto.closeTerm();
    }

    public void unchangedTerm(AUnchangedLtl node, PrologGenerator gen) {
        this.pto.openTerm("action");
        this.pto.openTerm("change_expr");
        this.pto.printAtom("eq");
        UniversalToken token = UniversalToken.createToken(node.getExpression());
        this.caseUnparsedExpression(token, true);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void changedTerm(AChangedLtl node, PrologGenerator gen) {
        this.pto.openTerm("action");
        this.pto.openTerm("change_expr");
        this.pto.printAtom("neq");
        UniversalToken token = UniversalToken.createToken(node.getExpression());
        this.caseUnparsedExpression(token, true);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void decreasingTerm(ADecreasingLtl node, PrologGenerator gen) {
        this.pto.openTerm("action");
        this.pto.openTerm("change_expr");
        this.pto.printAtom("gt");
        UniversalToken token = UniversalToken.createToken(node.getExpression());
        this.caseUnparsedExpression(token, true);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void increasingTerm(AIncreasingLtl node, PrologGenerator gen) {
        this.pto.openTerm("action");
        this.pto.openTerm("change_expr");
        this.pto.printAtom("lt");
        UniversalToken token = UniversalToken.createToken(node.getExpression());
        this.caseUnparsedExpression(token, true);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void beforeAfterTerm(ABeforeAfterLtl node, PrologGenerator gen) {
        this.pto.openTerm("action");
        this.pto.openTerm("before_after");
        UniversalToken token = UniversalToken.createToken(node.getPredicate());
        this.caseUnparsedPredicate(token);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void andFair1(PLtl leftNode, PLtl rightNode, PrologGenerator gen) {
        this.pto.openTerm("and");
        this.pto.openTerm("strongassumptions");
        leftNode.apply(gen);
        this.pto.closeTerm();
        this.pto.openTerm("weakassumptions");
        rightNode.apply(gen);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void andFair2(PLtl leftNode, PLtl rightNode, PrologGenerator gen) {
        this.pto.openTerm("and");
        this.pto.openTerm("weakassumptions");
        leftNode.apply(gen);
        this.pto.closeTerm();
        this.pto.openTerm("strongassumptions");
        rightNode.apply(gen);
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void weakFairAll() {
        this.pto.printAtom("all");
    }

    public void strongFairAll() {
        this.pto.printAtom("all");
    }

    public void dlk(ADlkLtl node, PrologGenerator gen) {
        this.pto.openTerm("ap");
        this.pto.openTerm("dlk");
        this.pto.openList();
        for (PActions pLtl : node.getArgs()) {
            pLtl.apply(gen);
        }
        this.pto.closeList();
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void det(ADetLtl node, PrologGenerator gen) {
        this.pto.openTerm("ap");
        this.pto.openTerm("det");
        this.pto.openList();
        for (PActions pLtl : node.getArgs()) {
            pLtl.apply(gen);
        }
        this.pto.closeList();
        this.pto.closeTerm();
        this.pto.closeTerm();
    }

    public void ctrl(ACtrlLtl node, PrologGenerator gen) {
        this.pto.openTerm("ap");
        this.pto.openTerm("ctrl");
        this.pto.openList();
        for (PActions pLtl : node.getArgs()) {
            pLtl.apply(gen);
        }
        this.pto.closeList();
        this.pto.closeTerm();
        this.pto.closeTerm();
    }
}

