/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ABooleanFalseExpression;
import de.be4.classicalb.core.parser.node.ABooleanTrueExpression;
import de.be4.classicalb.core.parser.node.AConstructorFreetypeConstructor;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADescriptionSet;
import de.be4.classicalb.core.parser.node.AElementFreetypeConstructor;
import de.be4.classicalb.core.parser.node.AEmptySequenceExpression;
import de.be4.classicalb.core.parser.node.AEmptySetExpression;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.AFreetype;
import de.be4.classicalb.core.parser.node.AFreetypesMachineClause;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.ARealExpression;
import de.be4.classicalb.core.parser.node.ARecEntry;
import de.be4.classicalb.core.parser.node.ARecExpression;
import de.be4.classicalb.core.parser.node.ASequenceExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetsMachineClause;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.AUnaryMinusExpression;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PFreetype;
import de.be4.classicalb.core.parser.node.PFreetypeConstructor;
import de.be4.classicalb.core.parser.node.PRecEntry;
import de.be4.classicalb.core.parser.node.PSet;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import de.prob.prolog.output.IPrologTermOutput;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PrologDataPrinter
extends DepthFirstAdapter {
    private final IPrologTermOutput pout;
    private final Map<String, FDSet> sets = new HashMap<String, FDSet>();
    private final Map<String, String> freetypes = new HashMap<String, String>();
    private final Deque<SortedMap<String, PExpression>> currRecFields = new ArrayDeque<SortedMap<String, PExpression>>();

    public PrologDataPrinter(IPrologTermOutput pout) {
        this(pout, null, null);
    }

    public PrologDataPrinter(IPrologTermOutput pout, ASetsMachineClause sets, AFreetypesMachineClause freetypes) {
        this.pout = pout;
        if (sets != null) {
            for (PSet set : sets.getSetDefinitions()) {
                if (set instanceof ADescriptionSet) {
                    set = ((ADescriptionSet)set).getSet();
                }
                if (set instanceof AEnumeratedSetSet) {
                    AEnumeratedSetSet setSet = (AEnumeratedSetSet)set;
                    String setId = setSet.getIdentifier().getFirst().getText();
                    int count = 1;
                    for (PExpression element : setSet.getElements()) {
                        String id = Utils.getAIdentifierAsString((AIdentifierExpression)element);
                        this.sets.put(id, new FDSet(count, setId));
                        ++count;
                    }
                    continue;
                }
                throw new AssertionError((Object)"deferred sets are not supported");
            }
        }
        if (freetypes != null) {
            for (PFreetype freetype : freetypes.getFreetypes()) {
                AFreetype aFreetype = (AFreetype)freetype;
                String ftId = aFreetype.getName().getText();
                for (PFreetypeConstructor constructor : aFreetype.getConstructors()) {
                    if (constructor instanceof AConstructorFreetypeConstructor) {
                        AConstructorFreetypeConstructor constructorFreetype = (AConstructorFreetypeConstructor)constructor;
                        this.freetypes.put(constructorFreetype.getName().getText(), ftId);
                        continue;
                    }
                    if (constructor instanceof AElementFreetypeConstructor) {
                        AElementFreetypeConstructor elementFreetype = (AElementFreetypeConstructor)constructor;
                        this.freetypes.put(elementFreetype.getName().getText(), ftId);
                        continue;
                    }
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public void defaultIn(Node node) {
        throw new IllegalArgumentException("unsupported node type: " + node.getClass().getSimpleName());
    }

    @Override
    public void defaultCase(Node node) {
        throw new IllegalArgumentException("unsupported node type: " + node.getClass().getSimpleName());
    }

    @Override
    public void defaultOut(Node node) {
        throw new IllegalArgumentException("unsupported node type: " + node.getClass().getSimpleName());
    }

    @Override
    public void inStart(Start node) {
    }

    @Override
    public void outStart(Start node) {
    }

    @Override
    public void caseEOF(EOF node) {
    }

    @Override
    public void inAExpressionParseUnit(AExpressionParseUnit node) {
    }

    @Override
    public void outAExpressionParseUnit(AExpressionParseUnit node) {
    }

    @Override
    public void caseAStringExpression(AStringExpression node) {
        this.pout.openTerm("string");
        this.pout.printAtom(node.getContent().getText());
        this.pout.closeTerm();
    }

    @Override
    public void caseABooleanTrueExpression(ABooleanTrueExpression node) {
        this.pout.printAtom("pred_true");
    }

    @Override
    public void caseABooleanFalseExpression(ABooleanFalseExpression node) {
        this.pout.printAtom("pred_false");
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        String id = Utils.getAIdentifierAsString(node);
        if (this.sets.containsKey(id)) {
            FDSet fd = this.sets.get(id);
            this.pout.openTerm("fd").printNumber(fd.nr).printAtom(fd.set).closeTerm();
        } else if (this.freetypes.containsKey(id)) {
            this.pout.openTerm("freeval").printAtom(this.freetypes.get(id)).printAtom(id).openTerm("term").printAtom(id).closeTerm().closeTerm();
        } else {
            if (this.sets.isEmpty() && this.freetypes.isEmpty()) {
                throw new IllegalStateException("identifier expressions can only be translated if the sets or freetypes machine clause is provided and contains a suitable element");
            }
            throw new IllegalStateException("no enumerated set item or freetype element constructor found for identifier expression " + id);
        }
    }

    @Override
    public void caseAUnaryMinusExpression(AUnaryMinusExpression node) {
        PExpression expr = node.getExpression();
        if (expr instanceof AIntegerExpression) {
            this.printInteger((AIntegerExpression)expr, true);
        } else if (expr instanceof ARealExpression) {
            this.printReal((ARealExpression)expr, true);
        } else {
            throw new IllegalArgumentException("unary minus only supported for integers and reals");
        }
    }

    @Override
    public void caseAIntegerExpression(AIntegerExpression node) {
        this.printInteger(node, false);
    }

    private void printInteger(AIntegerExpression node, boolean negative) {
        this.pout.openTerm("int");
        String text = (negative ? "-" : "") + node.getLiteral().getText();
        if (text.length() <= 18) {
            this.pout.printNumber(Long.parseLong(text));
        } else {
            this.pout.printNumber(new BigInteger(text));
        }
        this.pout.closeTerm();
    }

    @Override
    public void caseARealExpression(ARealExpression node) {
        this.printReal(node, false);
    }

    private void printReal(ARealExpression node, boolean negative) {
        String text = (negative ? "-" : "") + node.getLiteral().getText();
        this.pout.openTerm("term").openTerm("floating");
        this.pout.printNumber(Double.parseDouble(text));
        this.pout.closeTerm().closeTerm();
    }

    @Override
    public void caseACoupleExpression(ACoupleExpression node) {
        LinkedList<PExpression> expressions = node.getList();
        int expressionCount = expressions.size();
        if (expressionCount < 2) {
            throw new IllegalArgumentException("couples need to have at least 2 elements, but got " + expressionCount);
        }
        for (int i = 1; i < expressionCount; ++i) {
            this.pout.openTerm(",");
        }
        boolean first = true;
        for (PExpression expression : expressions) {
            expression.apply(this);
            if (!first) {
                this.pout.closeTerm();
                continue;
            }
            first = false;
        }
    }

    @Override
    public void caseAEmptySetExpression(AEmptySetExpression node) {
        this.pout.emptyList();
    }

    @Override
    public void inASetExtensionExpression(ASetExtensionExpression node) {
        this.pout.openList();
    }

    @Override
    public void outASetExtensionExpression(ASetExtensionExpression node) {
        this.pout.closeList();
    }

    @Override
    public void caseAEmptySequenceExpression(AEmptySequenceExpression node) {
        this.pout.emptyList();
    }

    @Override
    public void caseASequenceExtensionExpression(ASequenceExtensionExpression node) {
        this.pout.openList();
        int index = 1;
        for (PExpression e : node.getExpression()) {
            this.pout.openTerm(",");
            this.pout.openTerm("int").printNumber(index).closeTerm();
            e.apply(this);
            this.pout.closeTerm();
            ++index;
        }
        this.pout.closeList();
    }

    @Override
    public void caseAFunctionExpression(AFunctionExpression node) {
        String id = Utils.getAIdentifierAsString((AIdentifierExpression)node.getIdentifier());
        if (this.freetypes.containsKey(id)) {
            this.pout.openTerm("freeval");
            this.pout.printAtom(this.freetypes.get(id));
            this.pout.printAtom(id);
            if (node.getParameters().size() != 1) {
                throw new IllegalArgumentException("expected exactly one parameter for freetype constructor " + id);
            }
        } else {
            if (this.freetypes.isEmpty()) {
                throw new IllegalStateException("function expressions are only available if the freetypes machine clause is provided and contains a suitable constructor");
            }
            throw new IllegalStateException("no freetype constructor found for function expression " + id);
        }
        node.getParameters().getFirst().apply(this);
        this.pout.closeTerm();
    }

    @Override
    public void caseARecExpression(ARecExpression node) {
        this.currRecFields.addFirst(new TreeMap());
        for (PRecEntry pRecEntry : node.getEntries()) {
            pRecEntry.apply(this);
        }
        this.pout.openTerm("rec");
        this.pout.openList();
        for (Map.Entry entry : this.currRecFields.removeFirst().entrySet()) {
            this.pout.openTerm("field");
            this.pout.printAtom((String)entry.getKey());
            ((PExpression)entry.getValue()).apply(this);
            this.pout.closeTerm();
        }
        this.pout.closeList();
        this.pout.closeTerm();
    }

    @Override
    public void caseARecEntry(ARecEntry node) {
        String id = node.getIdentifier().getText();
        if (this.currRecFields.getFirst().put(id, node.getValue()) != null) {
            throw new IllegalArgumentException("duplicated rec entry " + id);
        }
    }

    private static class FDSet {
        private final int nr;
        private final String set;

        public FDSet(int nr, String set) {
            this.nr = nr;
            this.set = set;
        }
    }
}

