/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Timer;
import java.util.TimerTask;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.OutputCollector;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.IWorker;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModelCreator;
import tlc2.tool.liveness.AddAndCheckLiveCheck;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.liveness.Liveness;
import tlc2.tool.liveness.NoOpLiveCheck;
import tlc2.util.IStateWriter;
import tlc2.util.IdThread;
import tlc2.util.statistics.ConcurrentBucketStatistics;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.value.IValue;
import util.DebugPrinter;

public abstract class AbstractChecker {
    public static boolean LIVENESS_TESTING_IMPLEMENTATION = Boolean.getBoolean(ILiveCheck.class.getName() + ".testing");
    protected static final boolean LIVENESS_STATS = Boolean.getBoolean(Liveness.class.getPackage().getName() + ".statistics");
    protected TLCState predErrState;
    protected TLCState errState;
    protected int errorCode;
    protected boolean done;
    protected boolean keepCallStack;
    protected final boolean checkDeadlock;
    protected final boolean checkLiveness;
    protected final String fromChkpt;
    public final String metadir;
    public final ITool tool;
    protected final IStateWriter allStateWriter;
    protected IWorker[] workers;
    protected final ILiveCheck liveCheck;
    protected final long startTime;

    public AbstractChecker(ITool tool, String metadir, IStateWriter stateWriter, boolean deadlock, String fromChkpt, long startTime) throws EvalException, IOException {
        this.tool = tool;
        this.checkDeadlock = deadlock;
        this.checkLiveness = !this.tool.livenessIsTrue();
        OutputCollector.setModuleNode(this.tool.getRootModule());
        this.metadir = metadir;
        this.errState = null;
        this.predErrState = null;
        this.done = false;
        this.errorCode = 0;
        this.keepCallStack = false;
        this.fromChkpt = fromChkpt;
        this.allStateWriter = stateWriter;
        this.startTime = startTime;
        if (TLCGlobals.isCoverageEnabled()) {
            CostModelCreator.create(this.tool);
        }
        if (this.checkLiveness) {
            if (tool.hasSymmetry()) {
                MP.printWarning(2279);
            }
            if (tool.hasStateOrActionConstraints()) {
                MP.printWarning(2284);
            }
            this.report("initializing liveness checking");
            IBucketStatistics stats = new DummyBucketStatistics();
            if (LIVENESS_STATS) {
                stats = new ConcurrentBucketStatistics("Histogram vertex out-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsOutDegree");
            }
            this.liveCheck = LIVENESS_TESTING_IMPLEMENTATION ? new AddAndCheckLiveCheck(this.tool, this.metadir, stats) : new LiveCheck(this.tool, this.metadir, stats, stateWriter);
            this.report("liveness checking initialized");
        } else {
            this.liveCheck = new NoOpLiveCheck(this.tool, this.metadir);
        }
        AbstractChecker.scheduleTermination(new TimerTask(){

            @Override
            public void run() {
                AbstractChecker.this.stop();
            }
        });
    }

    public final void setDone() {
        this.done = true;
    }

    public boolean setErrState(TLCState curState, TLCState succState, boolean keep, int errorCode) {
        assert (Thread.holdsLock(this)) : "Caller thread has to hold monitor!";
        if (!TLCGlobals.continuation && this.done) {
            return false;
        }
        IdThread.resetCurrentState();
        this.predErrState = curState;
        this.errState = succState == null ? curState : succState;
        this.errorCode = errorCode;
        this.done = true;
        this.keepCallStack = keep;
        return true;
    }

    protected void reportCoverage(IWorker[] workers) {
        if (TLCGlobals.isCoverageEnabled() && this.tool.getActions().length > 0) {
            CostModelCreator.report(this.tool, this.startTime);
        }
    }

    public static final double calculateOptimisticProbability(long numOfDistinctStates, long numOfGenStates) {
        return (double)numOfDistinctStates * ((double)(numOfGenStates - numOfDistinctStates) / Math.pow(2.0, 64.0));
    }

    public static final void reportSuccess(long numOfDistinctStates, long numOfGenStates) throws IOException {
        double optimisticProb = AbstractChecker.calculateOptimisticProbability(numOfDistinctStates, numOfGenStates);
        MP.printMessage(2193, new String[]{"val = " + AbstractChecker.ProbabilityToString(optimisticProb, 2)});
    }

    public static final void reportSuccess(long numOfDistinctStates, long actualDistance, long numOfGenStates) throws IOException {
        if (numOfDistinctStates == numOfGenStates && numOfGenStates == 0L) {
            MP.printMessage(2193, "val = 0.0", "val = 0.0");
            return;
        }
        String optimisticProbStr = "val = " + AbstractChecker.ProbabilityToString(AbstractChecker.calculateOptimisticProbability(numOfDistinctStates, numOfGenStates), 2);
        BigDecimal actualProb = BigDecimal.valueOf(1.0).divide(BigDecimal.valueOf(actualDistance), new MathContext(2));
        String actualProbStr = "val = " + AbstractChecker.ProbabilityToString(actualProb.doubleValue(), 2);
        MP.printMessage(2193, optimisticProbStr, actualProbStr);
    }

    private static final String ProbabilityToString(double val, int significantDigits) {
        int next;
        if (val == 0.0) {
            return "0.0";
        }
        String valString = Double.toString(val);
        int valStringLen = valString.length();
        String result = "";
        int significantDigitsFound = 0;
        for (next = 0; next < valStringLen && valString.charAt(next) == '0'; ++next) {
        }
        while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
            result = result + valString.charAt(next);
            ++significantDigitsFound;
            ++next;
        }
        if (next == valStringLen) {
            return result;
        }
        if (valString.charAt(next) != '.') {
            return valString;
        }
        if (significantDigitsFound >= significantDigits) {
            ++next;
            while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
                ++next;
            }
        } else {
            ++next;
            result = result + ".";
            if (significantDigitsFound == 0) {
                while (next < valStringLen && valString.charAt(next) == '0') {
                    ++next;
                    result = result + "0";
                }
            }
            while (next < valStringLen && Character.isDigit(valString.charAt(next)) && significantDigitsFound < significantDigits) {
                result = result + valString.charAt(next);
                ++next;
                ++significantDigitsFound;
            }
            if (next < valStringLen && Character.isDigit(valString.charAt(next)) && Character.digit(valString.charAt(next), 10) >= 5) {
                int prev = result.length() - 1;
                boolean done = false;
                while (!done) {
                    if (prev < 0) {
                        result = "1" + result;
                        done = true;
                    } else {
                        char prevChar = result.charAt(prev);
                        String front = result.substring(0, prev);
                        String back = result.substring(prev + 1);
                        if (Character.isDigit(prevChar)) {
                            if (prevChar == '9') {
                                result = front + '0' + back;
                            } else {
                                result = front + Character.forDigit(Character.digit(prevChar, 10) + 1, 10) + back;
                                done = true;
                            }
                        }
                    }
                    --prev;
                }
            }
            while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
                ++next;
            }
        }
        if (next >= valStringLen) {
            return result;
        }
        if (valString.charAt(next) == 'E') {
            ++next;
            result = result + "E";
            while (next < valStringLen) {
                result = result + valString.charAt(next);
                ++next;
            }
            return result;
        }
        return valString;
    }

    public abstract int doInit(boolean var1) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int runTLC(int depth) throws Exception {
        if (depth < 2) {
            return 0;
        }
        this.workers = this.startWorkers(this, depth);
        int count = TLCGlobals.coverageInterval / 60000;
        AbstractChecker abstractChecker = this;
        synchronized (abstractChecker) {
            if (!this.done) {
                this.wait(3000L);
            }
        }
        int result = 0;
        while (true) {
            if ((result = this.doPeriodicWork()) != 0) {
                return result;
            }
            AbstractChecker abstractChecker2 = this;
            synchronized (abstractChecker2) {
                if (!this.done) {
                    this.runTLCContinueDoing(count, depth);
                    count = count == 0 ? TLCGlobals.coverageInterval / 60000 : --count;
                }
                if (this.done) {
                    break;
                }
            }
        }
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].join();
        }
        return 0;
    }

    public final void setAllValues(int idx, IValue val) {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].setLocalValue(idx, val);
        }
    }

    public final IValue getValue(int i, int idx) {
        return this.workers[i].getLocalValue(idx);
    }

    protected void report(String message) {
        DebugPrinter.print(message);
    }

    protected abstract IWorker[] startWorkers(AbstractChecker var1, int var2);

    public abstract int doPeriodicWork() throws Exception;

    protected abstract void runTLCContinueDoing(int var1, int var2) throws Exception;

    public final int modelCheck() throws Exception {
        int result = this.modelCheckImpl();
        return result != 0 ? result : this.errorCode;
    }

    protected abstract int modelCheckImpl() throws Exception;

    public int getProgress() {
        return -1;
    }

    public void stop() {
        throw new UnsupportedOperationException("stop not implemented");
    }

    public void suspend() {
        throw new UnsupportedOperationException("suspend not implemented");
    }

    public void resume() {
        throw new UnsupportedOperationException("resume not implemented");
    }

    static void scheduleTermination(TimerTask tt) {
        long stopAfter = Long.getLong(TLC.class.getName() + ".stopAfter", -1L);
        if (stopAfter > 0L) {
            Timer stopTimer = new Timer("TLCStopAfterTimer");
            stopTimer.schedule(tt, stopAfter * 1000L);
        }
    }

    protected boolean isTimeBound() {
        return Long.getLong(TLC.class.getName() + ".stopAfter", -1L) != -1L;
    }

    public long getStateQueueSize() {
        return -1L;
    }

    public long getDistinctStatesGenerated() {
        return -1L;
    }
}

