/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.tla;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAssertionsMachineClause;
import de.be4.classicalb.core.parser.node.AConcreteVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.AOperationsMachineClause;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.POperation;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.ConstantsEvaluator;
import de.tlc4b.analysis.DefinitionsAnalyser;
import de.tlc4b.analysis.DefinitionsSorter;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.Typechecker;
import de.tlc4b.analysis.typerestriction.TypeRestrictor;
import de.tlc4b.tla.ConfigFile;
import de.tlc4b.tla.TLADefinition;
import de.tlc4b.tla.TLAModule;
import de.tlc4b.tla.config.ModelValueAssignment;
import de.tlc4b.tla.config.SetOfModelValuesAssignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Generator
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final TypeRestrictor typeRestrictor;
    private final ConstantsEvaluator constantsEvaluator;
    private final DefinitionsAnalyser deferredSetSizeCalculator;
    private final TLAModule tlaModule;
    private final ConfigFile configFile;

    public Generator(MachineContext machineContext, TypeRestrictor typeRestrictor, ConstantsEvaluator constantsEvaluator, DefinitionsAnalyser deferredSetSizeCalculator, Typechecker typechecker) {
        this.machineContext = machineContext;
        this.typeRestrictor = typeRestrictor;
        this.constantsEvaluator = constantsEvaluator;
        this.deferredSetSizeCalculator = deferredSetSizeCalculator;
        this.tlaModule = new TLAModule();
        this.configFile = new ConfigFile();
    }

    public void generate() {
        this.tlaModule.moduleName = this.machineContext.getMachineName();
        this.evalSetValuedParameter();
        this.evalScalarParameter();
        this.evalMachineSets();
        this.evalDefinitions();
        this.evalConstants();
        this.evalInvariant();
        this.evalOperations();
        this.evalGoal();
        this.machineContext.getStartNode().apply(this);
        this.evalSpec();
    }

    private void evalInvariant() {
        AInvariantMachineClause invariantClause = this.machineContext.getInvariantMachineClause();
        if (invariantClause != null) {
            this.tlaModule.invariants.addAll(this.constantsEvaluator.getInvariantList());
            this.configFile.setInvariantNumber(this.tlaModule.invariants.size());
        }
    }

    private void evalSpec() {
        if (this.configFile.isInit() && this.configFile.isNext() && TLC4BGlobals.isCheckLTL() && !this.machineContext.getLTLFormulas().isEmpty()) {
            this.configFile.setSpec();
        }
    }

    private void evalGoal() {
        if (TLC4BGlobals.isGOAL() && this.machineContext.getDefinitions().containsKey("GOAL")) {
            this.configFile.setGoal();
        }
    }

    private void evalSetValuedParameter() {
        for (String parameter : this.machineContext.getSetParameter().keySet()) {
            Node node = this.machineContext.getSetParameter().get(parameter);
            this.tlaModule.constants.add(node);
            this.configFile.addAssignment(new SetOfModelValuesAssignment(node, 3));
        }
    }

    private void evalScalarParameter() {
        Collection<Node> params = this.machineContext.getScalarParameter().values();
        if (params.isEmpty()) {
            return;
        }
        LinkedHashMap<Node, Node> idValueTable = this.constantsEvaluator.getValueOfIdentifierMap();
        Iterator<Node> itr = params.iterator();
        boolean init = false;
        while (itr.hasNext()) {
            Node param = itr.next();
            Node value = idValueTable.get(param);
            if (value != null) {
                this.tlaModule.addTLADefinition(new TLADefinition(param, value));
                continue;
            }
            Integer intValue = this.constantsEvaluator.getIntValue(param);
            if (intValue != null) {
                this.tlaModule.addTLADefinition(new TLADefinition(param, intValue));
                continue;
            }
            Node restrictedNode = this.typeRestrictor.getRestrictedNode(param);
            AMemberPredicate memberPredicate = new AMemberPredicate((PExpression)param, (PExpression)restrictedNode);
            this.tlaModule.addInit(memberPredicate);
            init = true;
            this.tlaModule.variables.add(param);
        }
        AConstraintsMachineClause clause = this.machineContext.getConstraintMachineClause();
        if (init) {
            this.configFile.setInit();
            if (!this.typeRestrictor.isARemovedNode(clause.getPredicates())) {
                this.tlaModule.addInit(clause.getPredicates());
            }
        } else if (!this.typeRestrictor.isARemovedNode(clause.getPredicates())) {
            this.tlaModule.addAssume(clause.getPredicates());
        }
    }

    private void evalMachineSets() {
        LinkedHashMap<String, Node> map = this.machineContext.getDeferredSets();
        for (Node d : map.values()) {
            this.tlaModule.constants.add(d);
            Integer size = this.deferredSetSizeCalculator.getSize(d);
            if (size == null) {
                size = this.constantsEvaluator.getIntValue(d);
            }
            this.configFile.addAssignment(new SetOfModelValuesAssignment(d, size));
        }
        LinkedHashMap<String, Node> map2 = this.machineContext.getEnumeratedSets();
        for (Node n : map2.values()) {
            AEnumeratedSetSet e = (AEnumeratedSetSet)n;
            TLADefinition def = new TLADefinition((Node)e, e);
            this.tlaModule.addTLADefinition(def);
            ArrayList<PExpression> copy = new ArrayList<PExpression>(e.getElements());
            for (PExpression element : copy) {
                this.tlaModule.constants.add(element);
                this.configFile.addAssignment(new ModelValueAssignment(element));
            }
        }
    }

    private void evalDefinitions() {
        ADefinitionsMachineClause node = this.machineContext.getDefinitionMachineClause();
        if (node != null) {
            ArrayList<PDefinition> bDefinitions = new ArrayList<PDefinition>(node.getDefinitions());
            DefinitionsSorter defOrder = new DefinitionsSorter(this.machineContext, bDefinitions);
            this.tlaModule.allDefinitions.addAll(defOrder.getAllDefinitions());
        }
    }

    private void evalOperations() {
        AOperationsMachineClause node = this.machineContext.getOperationMachineClause();
        if (null != node) {
            this.configFile.setNext();
            ArrayList<POperation> copy = new ArrayList<POperation>(node.getOperations());
            this.tlaModule.operations.addAll(copy);
        }
    }

    private void evalConstants() {
        if (this.machineContext.getPropertiesMachineClause() == null) {
            return;
        }
        LinkedHashMap<Node, Node> conValueTable = this.constantsEvaluator.getValueOfIdentifierMap();
        for (Map.Entry<Node, Node> entry : conValueTable.entrySet()) {
            AIdentifierExpression con = (AIdentifierExpression)entry.getKey();
            Node value = entry.getValue();
            AExpressionDefinitionDefinition exprDef = new AExpressionDefinitionDefinition(con.getIdentifier().get(0), new LinkedList<PExpression>(), (PExpression)value);
            this.machineContext.addReference(exprDef, con);
            this.tlaModule.addToAllDefinitions(exprDef);
        }
        ArrayList<Node> remainingConstants = new ArrayList<Node>(this.machineContext.getConstants().values());
        remainingConstants.removeAll(conValueTable.keySet());
        PPredicate propertiesPredicate = this.machineContext.getPropertiesMachineClause().getPredicates();
        if (!remainingConstants.isEmpty()) {
            boolean init = false;
            int numberOfIteratedConstants = 0;
            for (Node remainingConstant : remainingConstants) {
                init = true;
                this.tlaModule.variables.add(remainingConstant);
                ArrayList<PExpression> rangeList = this.constantsEvaluator.getRangeOfIdentifier(remainingConstant);
                if (!rangeList.isEmpty()) {
                    ++numberOfIteratedConstants;
                    ArrayList<PExpression> clone = new ArrayList<PExpression>();
                    for (PExpression pExpression : rangeList) {
                        clone.add(pExpression.clone());
                    }
                    ASetExtensionExpression set = new ASetExtensionExpression(clone);
                    AMemberPredicate member = new AMemberPredicate((AIdentifierExpression)remainingConstant, set);
                    this.tlaModule.addInit(member);
                    continue;
                }
                Node restrictedNode = this.typeRestrictor.getRestrictedNode(remainingConstant);
                AMemberPredicate memberPredicate = new AMemberPredicate((PExpression)remainingConstant, (PExpression)restrictedNode);
                this.tlaModule.addInit(memberPredicate);
            }
            if (numberOfIteratedConstants > 1) {
                this.tlaModule.addInit(this.machineContext.getConstantsSetup());
            }
            if (init) {
                this.configFile.setInit();
                if (!this.typeRestrictor.isARemovedNode(propertiesPredicate)) {
                    this.tlaModule.addInit(propertiesPredicate);
                }
            }
        } else {
            if (this.machineContext.getConstantsSetup() == null) {
                this.tlaModule.assumes.addAll(this.constantsEvaluator.getPropertiesList());
            }
            this.tlaModule.addAssume(propertiesPredicate);
        }
    }

    @Override
    public void inAPropertiesMachineClause(APropertiesMachineClause node) {
        if (!this.tlaModule.isInitPredicate(node.getPredicates())) {
            // empty if block
        }
    }

    @Override
    public void caseAVariablesMachineClause(AVariablesMachineClause node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        this.tlaModule.variables.addAll(copy);
    }

    @Override
    public void caseAConcreteVariablesMachineClause(AConcreteVariablesMachineClause node) {
        ArrayList<PExpression> copy = new ArrayList<PExpression>(node.getIdentifiers());
        this.tlaModule.variables.addAll(copy);
    }

    @Override
    public void inAAssertionsMachineClause(AAssertionsMachineClause node) {
        ArrayList<PPredicate> copy = new ArrayList<PPredicate>(node.getPredicates());
        for (PPredicate e : copy) {
            this.tlaModule.addAssertion(e);
        }
        this.configFile.setAssertionSize(copy.size());
    }

    @Override
    public void inAInitialisationMachineClause(AInitialisationMachineClause node) {
        this.configFile.setInit();
        this.tlaModule.addInit(node.getSubstitutions());
    }

    public TLAModule getTlaModule() {
        return this.tlaModule;
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }
}

