/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;

public final class FloatPrologTerm
extends PrologTerm {
    private final double value;

    public FloatPrologTerm(double value) {
        this.value = value;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public String getFunctor() {
        return Double.toString(this.value);
    }

    @Override
    public void toTermOutput(IPrologTermOutput pto) {
        pto.printNumber(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatPrologTerm)) {
            return false;
        }
        return Double.compare(this.value, ((FloatPrologTerm)obj).value) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }
}

