/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.Definitions;
import de.be4.classicalb.core.parser.ParsingBehaviour;
import de.be4.classicalb.core.parser.analysis.prolog.INodeIds;
import de.be4.classicalb.core.parser.analysis.prolog.MachineReference;
import de.be4.classicalb.core.parser.analysis.prolog.NodeFileNumbers;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.rules.AbstractOperation;
import de.be4.classicalb.core.parser.rules.BMachine;
import de.be4.classicalb.core.parser.rules.ComputationOperation;
import de.be4.classicalb.core.parser.rules.FunctionOperation;
import de.be4.classicalb.core.parser.rules.IModel;
import de.be4.classicalb.core.parser.rules.MachineInjector;
import de.be4.classicalb.core.parser.rules.RuleOperation;
import de.be4.classicalb.core.parser.rules.RulesMachineChecker;
import de.be4.classicalb.core.parser.rules.RulesMachineRunConfiguration;
import de.be4.classicalb.core.parser.rules.RulesParseUnit;
import de.be4.classicalb.core.parser.util.ASTBuilder;
import de.be4.classicalb.core.parser.util.Utils;
import de.prob.prolog.output.IPrologTermOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RulesProject {
    public static final String CTAGS_FILE_NAME = ".rules-tags1";
    static final String MAIN_MACHINE_NAME = "__RULES_MACHINE_Main";
    static final String COMPOSITION_MACHINE_NAME = "__RULES_MACHINE_Composition";
    private ParsingBehaviour parsingBehaviour = new ParsingBehaviour();
    private final List<BException> bExceptionList = new ArrayList<BException>();
    private final LinkedHashMap<String, AbstractOperation> allOperations = new LinkedHashMap();
    protected final List<IModel> bModels = new ArrayList<IModel>();
    protected final INodeIds nodeIdAssignment = new NodeFileNumbers();
    private final List<File> filesLoaded = new ArrayList<File>();
    private final Map<String, String> constantStringValues = new HashMap<String, String>();
    private RulesMachineRunConfiguration rulesMachineRunConfiguration;
    private final Map<String, String> operationReplacementMap = new HashMap<String, String>();

    public void parseRulesMachines(String mainMachineAsString, String ... referencedMachines) {
        RulesParseUnit mainMachine = RulesParseUnit.parse(mainMachineAsString);
        this.bModels.add(mainMachine);
        if (((IModel)mainMachine).hasError()) {
            this.bExceptionList.addAll(((IModel)mainMachine).getCompoundException().getBExceptions());
        }
        for (String referencedMachine : referencedMachines) {
            RulesParseUnit machine = RulesParseUnit.parse(referencedMachine);
            this.bModels.add(machine);
            if (!((IModel)machine).hasError()) continue;
            this.bExceptionList.addAll(((IModel)machine).getCompoundException().getBExceptions());
        }
    }

    public void parseProject(File mainFile) {
        RulesParseUnit mainModel = RulesParseUnit.parse(mainFile, this.parsingBehaviour);
        if (mainModel.hasError()) {
            BCompoundException compound = mainModel.getCompoundException();
            this.bExceptionList.addAll(compound.getBExceptions());
        }
        this.bModels.add(mainModel);
        LinkedList<MachineReference> fifo = new LinkedList<MachineReference>(mainModel.getMachineReferences());
        while (!fifo.isEmpty()) {
            MachineReference modelReference = (MachineReference)fifo.pollFirst();
            if (!this.isANewModel(modelReference)) continue;
            File file = new File(modelReference.getPath());
            RulesParseUnit bModel = RulesParseUnit.parse(file, this.parsingBehaviour);
            if (((IModel)bModel).hasError()) {
                this.bExceptionList.addAll(((IModel)bModel).getCompoundException().getBExceptions());
            }
            this.bModels.add(bModel);
            fifo.addAll(((IModel)bModel).getMachineReferences());
        }
    }

    public void checkAndTranslateProject() {
        this.checkProject();
        this.flattenProject();
    }

    public List<BException> getBExceptionList() {
        return this.bExceptionList;
    }

    public void setParsingBehaviour(ParsingBehaviour parsingBehaviour) {
        this.parsingBehaviour = parsingBehaviour;
    }

    public Map<String, AbstractOperation> getOperationsMap() {
        HashMap<String, AbstractOperation> result = new HashMap<String, AbstractOperation>();
        for (Map.Entry<String, AbstractOperation> entry : this.allOperations.entrySet()) {
            AbstractOperation op = entry.getValue();
            if (this.operationReplacementMap.containsValue(op.getOriginalName())) continue;
            result.put(op.getName(), op);
        }
        return result;
    }

    public Set<AbstractOperation> getOperationsWithNoSuccessor() {
        HashSet<AbstractOperation> values = new HashSet<AbstractOperation>(this.getOperationsMap().values());
        for (AbstractOperation op : this.getOperationsMap().values()) {
            values.removeAll(op.getTransitiveDependencies());
        }
        return values;
    }

    private void flattenProject() {
        if (!this.bExceptionList.isEmpty()) {
            return;
        }
        this.rulesMachineRunConfiguration = RulesMachineRunConfiguration.extractConfigurationOfMainModel(this.bModels.get(0), this.allOperations);
        BMachine compositionMachine = new BMachine(COMPOSITION_MACHINE_NAME);
        MachineInjector injector = new MachineInjector(compositionMachine.getStart());
        for (IModel model : this.bModels) {
            RulesParseUnit rulesParseUnit = (RulesParseUnit)model;
            rulesParseUnit.translate(this.allOperations);
            if (!rulesParseUnit.hasError()) {
                Start start = rulesParseUnit.getStart();
                this.filesLoaded.add(new File(rulesParseUnit.getPath()));
                this.nodeIdAssignment.assignIdentifiers(this.filesLoaded.size(), start);
                rulesParseUnit.getBParser().getDefinitions().assignIdsToNodes(this.nodeIdAssignment, this.filesLoaded);
            } else {
                this.bExceptionList.addAll(rulesParseUnit.getCompoundException().getBExceptions());
            }
            Start otherStart = rulesParseUnit.getStart();
            injector.injectMachine(otherStart);
        }
        compositionMachine.setParsingBehaviour(this.parsingBehaviour);
        this.bModels.add(compositionMachine);
        BMachine mainMachine = this.createMainMachine(injector.getMainMachineDefinitions());
        this.bModels.add(mainMachine);
    }

    private BMachine createMainMachine(List<PDefinition> mainDefinitions) {
        BMachine mainMachine = new BMachine(MAIN_MACHINE_NAME);
        mainMachine.setParsingBehaviour(this.parsingBehaviour);
        mainMachine.addIncludesClause(COMPOSITION_MACHINE_NAME);
        mainMachine.addPromotesClause(this.getPromotesList());
        mainMachine.addPropertiesPredicates(this.constantStringValues);
        Definitions iDefinitions = new Definitions();
        if (mainDefinitions != null) {
            for (PDefinition pDefinition : mainDefinitions) {
                iDefinitions.addDefinition(pDefinition);
            }
        }
        ASTBuilder.addToStringDefinition(iDefinitions);
        ASTBuilder.addSortDefinition(iDefinitions);
        ASTBuilder.addFormatToStringDefinition(iDefinitions);
        ASTBuilder.addChooseDefinition(iDefinitions);
        ASTBuilder.addBooleanPreferenceDefinition(iDefinitions, "ALLOW_LOCAL_OPERATION_CALLS", true);
        ASTBuilder.addBooleanPreferenceDefinition(iDefinitions, "ALLOW_OPERATION_CALLS_IN_EXPRESSIONS", true);
        mainMachine.replaceDefinition(iDefinitions);
        return mainMachine;
    }

    private List<String> getPromotesList() {
        ArrayList<String> promotesList = new ArrayList<String>();
        for (AbstractOperation abstractOperation : this.allOperations.values()) {
            if (!(abstractOperation instanceof ComputationOperation) && !(abstractOperation instanceof RuleOperation) || abstractOperation.replacesOperation()) continue;
            promotesList.add(abstractOperation.getOriginalName());
        }
        return promotesList;
    }

    private void checkProject() {
        this.collectAllOperations();
        this.checkDependencies();
        this.findImplicitDependenciesToComputations();
        this.checkIdentifiers();
        this.findTransitiveDependencies();
        this.checkReferencedRuleOperations();
        this.checkReplacements();
    }

    private void checkReplacements() {
        if (this.hasErrors()) {
            return;
        }
        for (Map.Entry<String, String> entry : this.operationReplacementMap.entrySet()) {
            Set<String> newVariables;
            String newOpName = entry.getKey();
            String replacedOperationName = entry.getValue();
            AbstractOperation newOp = this.allOperations.get(newOpName);
            AbstractOperation replacedOp = this.allOperations.get(replacedOperationName);
            if (newOp.getClass() != replacedOp.getClass()) {
                this.bExceptionList.add(new BException(newOp.getFileName(), new CheckException(String.format("Operation '%s' is an invalid replacement for operation '%s'.", newOpName, replacedOperationName), newOp.getNameLiteral())));
                continue;
            }
            if (!(replacedOp instanceof ComputationOperation)) continue;
            ComputationOperation oldComp = (ComputationOperation)replacedOp;
            ComputationOperation newComp = (ComputationOperation)newOp;
            Set<String> oldVariables = oldComp.getDefineVariables();
            if (oldVariables.containsAll(newVariables = newComp.getDefineVariables()) && newVariables.containsAll(oldVariables)) continue;
            this.bExceptionList.add(new BException(newOp.getFileName(), new CheckException(String.format("Operation '%s' is an invalid replacement for operation '%s'.", newOpName, replacedOperationName), newOp.getNameLiteral())));
        }
    }

    private void collectAllOperations() {
        for (IModel iModel : this.bModels) {
            RulesParseUnit unit = (RulesParseUnit)iModel;
            List<AbstractOperation> operations = unit.getOperations();
            for (AbstractOperation abstractOperation : operations) {
                String name = abstractOperation.getOriginalName();
                if (this.allOperations.containsKey(name)) {
                    this.bExceptionList.add(new BException(abstractOperation.getFileName(), new CheckException("Duplicate operation name: '" + name + "'.", abstractOperation.getNameLiteral())));
                }
                this.allOperations.put(name, abstractOperation);
                if (!abstractOperation.replacesOperation()) continue;
                String replacedOperationName = abstractOperation.getReplacedOperationName();
                if (this.operationReplacementMap.containsValue(replacedOperationName)) {
                    this.bExceptionList.add(new BException(abstractOperation.getFileName(), new CheckException("Operation '" + replacedOperationName + "' is replaced more than once.", abstractOperation.getNameLiteral())));
                    continue;
                }
                this.operationReplacementMap.put(name, replacedOperationName);
            }
        }
    }

    private void checkDependencies() {
        for (AbstractOperation operation : this.allOperations.values()) {
            this.checkDependsOnComputations(operation);
            this.checkDependsOnRules(operation);
            this.checkFunctionCalls(operation);
        }
    }

    private void checkFunctionCalls(AbstractOperation abstractOperation) {
        boolean errorOccurred = false;
        for (TIdentifierLiteral tIdentifierLiteral : abstractOperation.getFunctionCalls()) {
            String functionName = tIdentifierLiteral.getText();
            if (this.allOperations.containsKey(functionName) && this.allOperations.get(functionName) instanceof FunctionOperation) continue;
            this.bExceptionList.add(new BException(abstractOperation.getFileName(), new CheckException("Unknown FUNCTION name '" + functionName + "'", tIdentifierLiteral)));
            errorOccurred = true;
        }
        if (!errorOccurred) {
            this.checkVisibilityOfTIdentifierList(abstractOperation, abstractOperation.getFunctionCalls());
        }
    }

    private void checkDependsOnRules(AbstractOperation operation) {
        boolean errorOccurred = false;
        for (AIdentifierExpression aIdentifierExpression : operation.getDependsOnRulesList()) {
            String name = aIdentifierExpression.getIdentifier().get(0).getText();
            if (this.allOperations.containsKey(name)) {
                AbstractOperation abstractOperation = this.allOperations.get(name);
                if (abstractOperation instanceof RuleOperation) continue;
                this.bExceptionList.add(new BException(operation.getFileName(), new CheckException("Operation '" + name + "' is not a RULE operation.", aIdentifierExpression)));
                errorOccurred = true;
                continue;
            }
            errorOccurred = true;
            this.bExceptionList.add(new BException(operation.getFileName(), new CheckException("Unknown operation: '" + name + "'.", aIdentifierExpression)));
        }
        if (!errorOccurred) {
            this.checkVisibilityOfAIdentifierList(operation, operation.getDependsOnRulesList());
        }
    }

    private void checkDependsOnComputations(AbstractOperation operation) {
        boolean errorOccurred = false;
        for (AIdentifierExpression aIdentifierExpression : operation.getDependsOnComputationList()) {
            String name = aIdentifierExpression.getIdentifier().get(0).getText();
            if (this.allOperations.containsKey(name)) {
                AbstractOperation abstractOperation = this.allOperations.get(name);
                if (abstractOperation instanceof ComputationOperation) continue;
                this.bExceptionList.add(new BException(operation.getFileName(), new CheckException("Identifier '" + name + "' is not a COMPUTATION.", aIdentifierExpression)));
                errorOccurred = true;
                continue;
            }
            errorOccurred = true;
            this.bExceptionList.add(new BException(operation.getFileName(), new CheckException("Unknown operation: '" + name + "'.", aIdentifierExpression)));
        }
        if (!errorOccurred) {
            this.checkVisibilityOfAIdentifierList(operation, operation.getDependsOnComputationList());
        }
    }

    private void checkVisibilityOfAIdentifierList(AbstractOperation operation, List<AIdentifierExpression> dependencyList) {
        ArrayList<TIdentifierLiteral> tidentifierList = new ArrayList<TIdentifierLiteral>();
        for (AIdentifierExpression aIdentifier : dependencyList) {
            tidentifierList.add(aIdentifier.getIdentifier().get(0));
        }
        this.checkVisibilityOfTIdentifierList(operation, tidentifierList);
    }

    private void checkVisibilityOfTIdentifierList(AbstractOperation operation, List<TIdentifierLiteral> dependencyList) {
        List<String> machineReferences = operation.getMachineReferencesAsString();
        machineReferences.add(operation.getMachineName());
        for (TIdentifierLiteral tIdentifierLiteral : dependencyList) {
            AbstractOperation abstractOperation;
            String otherMachineName;
            String otherOpName = tIdentifierLiteral.getText();
            if (!this.allOperations.containsKey(otherOpName) || machineReferences.contains(otherMachineName = (abstractOperation = this.allOperations.get(otherOpName)).getMachineName())) continue;
            this.bExceptionList.add(new BException(operation.getFileName(), new CheckException("Operation '" + otherOpName + "' is not visible in RULES_MACHINE '" + operation.getMachineName() + "'.", tIdentifierLiteral)));
        }
    }

    public List<AbstractOperation> sortOperations(Collection<AbstractOperation> values) {
        HashMap<AbstractOperation, HashSet<AbstractOperation>> dependenciesMap = new HashMap<AbstractOperation, HashSet<AbstractOperation>>();
        for (AbstractOperation abstractOperation : values) {
            if (abstractOperation instanceof FunctionOperation) continue;
            dependenciesMap.put(abstractOperation, new HashSet<AbstractOperation>(abstractOperation.getTransitiveDependencies()));
        }
        ArrayList<AbstractOperation> resultList = new ArrayList<AbstractOperation>();
        ArrayList todoList = new ArrayList(dependenciesMap.keySet());
        while (!todoList.isEmpty()) {
            for (AbstractOperation abstractOperation : new ArrayList(todoList)) {
                Set deps = (Set)dependenciesMap.get(abstractOperation);
                resultList.forEach(deps::remove);
                if (!deps.isEmpty()) continue;
                resultList.add(abstractOperation);
                todoList.remove(abstractOperation);
            }
        }
        return resultList;
    }

    private void findImplicitDependenciesToComputations() {
        HashMap<String, ComputationOperation> variableToComputation = new HashMap<String, ComputationOperation>();
        for (AbstractOperation operation : this.allOperations.values()) {
            if (!(operation instanceof ComputationOperation) || operation.replacesOperation()) continue;
            ComputationOperation comp = (ComputationOperation)operation;
            for (String string : comp.getDefineVariables()) {
                variableToComputation.put(string, comp);
            }
        }
        for (AbstractOperation operation : this.allOperations.values()) {
            Set<String> readVariables = operation.getReadVariables();
            readVariables.retainAll(variableToComputation.keySet());
            HashSet<String> variablesInScope = new HashSet<String>();
            if (operation instanceof ComputationOperation) {
                variablesInScope.addAll(((ComputationOperation)operation).getDefineVariables());
            }
            for (AIdentifierExpression aIdentifier : operation.getDependsOnComputationList()) {
                String opName = aIdentifier.getIdentifier().get(0).getText();
                AbstractOperation abstractOperation = this.allOperations.get(opName);
                if (!(abstractOperation instanceof ComputationOperation)) continue;
                variablesInScope.addAll(((ComputationOperation)abstractOperation).getDefineVariables());
            }
            readVariables.removeAll(variablesInScope);
            if (!readVariables.isEmpty()) {
                ArrayList<ComputationOperation> arrayList = new ArrayList<ComputationOperation>();
                for (String varName : readVariables) {
                    ComputationOperation computationOperation = (ComputationOperation)variableToComputation.get(varName);
                    arrayList.add(computationOperation);
                    List<String> machineReferences = operation.getMachineReferencesAsString();
                    machineReferences.add(operation.getMachineName());
                    if (!machineReferences.contains(computationOperation.getMachineName())) {
                        this.bExceptionList.add(new BException(operation.getFileName(), new CheckException("Missing reference to RULES_MACHINE '" + computationOperation.getMachineName() + "' in order to use variable '" + varName + "'.", operation.getVariableReadByName(varName))));
                    }
                    operation.setImplicitComputationDependencies(arrayList);
                }
                continue;
            }
            operation.setImplicitComputationDependencies(Collections.emptyList());
        }
    }

    private void checkIdentifiers() {
        RulesParseUnit parseUnit;
        if (this.hasErrors()) {
            return;
        }
        HashMap<String, RulesParseUnit> map = new HashMap<String, RulesParseUnit>();
        for (IModel model : this.bModels) {
            parseUnit = (RulesParseUnit)model;
            map.put(parseUnit.getMachineName(), parseUnit);
        }
        HashSet<String> knownIdentifiers = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        parseUnit = (RulesParseUnit)this.bModels.get(0);
        visited.add(parseUnit.getMachineName());
        for (IModel model : this.bModels) {
            knownIdentifiers.addAll(this.checkIdentifiers((RulesParseUnit)model, map, visited));
            visited.clear();
        }
        RulesMachineChecker checker = parseUnit.getRulesMachineChecker();
        Map<String, Set<Node>> unknownIdentifierMap = checker.getUnknownIdentifier();
        HashSet<String> unknownIdentifiers = new HashSet<String>(unknownIdentifierMap.keySet());
        unknownIdentifiers.removeAll(knownIdentifiers);
        for (String name : unknownIdentifiers) {
            Set<Node> hashSet = unknownIdentifierMap.get(name);
            Node node = hashSet.iterator().next();
            this.bExceptionList.add(new BException(parseUnit.getPath(), new CheckException("Unknown identifier '" + name + "'.", node)));
        }
    }

    private Set<String> checkIdentifiers(RulesParseUnit parseUnit, Map<String, RulesParseUnit> map, Set<String> visited) {
        HashSet<String> knownIdentifiers = new HashSet<String>();
        List<MachineReference> machineReferences = parseUnit.getMachineReferences();
        for (MachineReference rulesMachineReference : machineReferences) {
            RulesParseUnit rulesParseUnit = map.get(rulesMachineReference.getName());
            if (visited.contains(rulesParseUnit.getMachineName())) continue;
            visited.add(rulesParseUnit.getMachineName());
            knownIdentifiers.addAll(this.checkIdentifiers(rulesParseUnit, map, visited));
            RulesMachineChecker checker = rulesParseUnit.getRulesMachineChecker();
            knownIdentifiers.addAll(checker.getGlobalIdentifierNames());
            knownIdentifiers.addAll(checker.getFunctionOperationNames());
            knownIdentifiers.addAll(checker.getDefinitionNames());
        }
        return knownIdentifiers;
    }

    public void checkReferencedRuleOperations() {
        if (this.hasErrors()) {
            return;
        }
        HashMap<String, RulesParseUnit> map = new HashMap<String, RulesParseUnit>();
        for (IModel model : this.bModels) {
            RulesParseUnit parseUnit = (RulesParseUnit)model;
            map.put(parseUnit.getMachineName(), parseUnit);
        }
        for (IModel model : this.bModels) {
            if (!(model instanceof RulesParseUnit)) continue;
            RulesParseUnit rulesParseUnit = (RulesParseUnit)model;
            Set<AIdentifierExpression> referencedRuleOperations = rulesParseUnit.getRulesMachineChecker().getReferencedRuleOperations();
            HashSet<String> knownRules = new HashSet<String>();
            for (RuleOperation ruleOperation : rulesParseUnit.getRulesMachineChecker().getRuleOperations()) {
                knownRules.add(ruleOperation.getOriginalName());
            }
            for (MachineReference rulesMachineReference : rulesParseUnit.getMachineReferences()) {
                String referenceName = rulesMachineReference.getName();
                RulesParseUnit otherParseUnit = (RulesParseUnit)map.get(referenceName);
                for (RuleOperation ruleOperation : otherParseUnit.getRulesMachineChecker().getRuleOperations()) {
                    knownRules.add(ruleOperation.getOriginalName());
                }
            }
            for (AIdentifierExpression aIdentifierExpression : referencedRuleOperations) {
                String ruleName = Utils.getAIdentifierAsString(aIdentifierExpression);
                if (knownRules.contains(ruleName)) continue;
                this.bExceptionList.add(new BException(rulesParseUnit.getPath(), new CheckException("Unknown rule '" + ruleName + "'.", aIdentifierExpression)));
            }
        }
    }

    private void findTransitiveDependencies() {
        if (this.hasErrors()) {
            return;
        }
        LinkedList<AbstractOperation> todoList = new LinkedList<AbstractOperation>(this.allOperations.values());
        while (!todoList.isEmpty()) {
            AbstractOperation operation = (AbstractOperation)todoList.poll();
            if (operation.getTransitiveDependencies() != null) continue;
            this.findTransitiveDependencies(operation, new ArrayList<AbstractOperation>());
        }
    }

    private Set<AbstractOperation> findTransitiveDependencies(AbstractOperation operation, List<AbstractOperation> ancestors) {
        ancestors.add(operation);
        ArrayList<TIdentifierLiteral> directDependencies = new ArrayList<TIdentifierLiteral>();
        directDependencies.addAll(this.convertAIdentifierListToTIdentifierLiteralList(operation.getDependsOnComputationList()));
        directDependencies.addAll(this.convertAIdentifierListToTIdentifierLiteralList(operation.getDependsOnRulesList()));
        directDependencies.addAll(operation.getImplicitDependenciesToComputations());
        directDependencies.addAll(operation.getFunctionCalls());
        HashSet<AbstractOperation> transitiveDependenciesFound = new HashSet<AbstractOperation>();
        boolean cycleDetected = this.checkForCycles(operation, directDependencies, ancestors);
        if (cycleDetected) {
            operation.setTransitiveDependencies(transitiveDependenciesFound);
            return transitiveDependenciesFound;
        }
        for (TIdentifierLiteral tIdentifierLiteral : directDependencies) {
            String opName = tIdentifierLiteral.getText();
            AbstractOperation nextOperation = this.allOperations.get(opName);
            transitiveDependenciesFound.add(nextOperation);
            if (nextOperation.getTransitiveDependencies() != null) {
                transitiveDependenciesFound.addAll(nextOperation.getTransitiveDependencies());
                continue;
            }
            transitiveDependenciesFound.addAll(this.findTransitiveDependencies(nextOperation, new ArrayList<AbstractOperation>(ancestors)));
        }
        operation.setTransitiveDependencies(transitiveDependenciesFound);
        return new HashSet<AbstractOperation>(transitiveDependenciesFound);
    }

    private List<TIdentifierLiteral> convertAIdentifierListToTIdentifierLiteralList(List<AIdentifierExpression> list) {
        ArrayList<TIdentifierLiteral> result = new ArrayList<TIdentifierLiteral>();
        for (AIdentifierExpression aIdentifier : list) {
            result.add(aIdentifier.getIdentifier().get(0));
        }
        return result;
    }

    private boolean checkForCycles(AbstractOperation operation, List<TIdentifierLiteral> directDependencies, List<AbstractOperation> ancestors) {
        String opName;
        ArrayList<String> ancestorsNames = new ArrayList<String>();
        for (AbstractOperation op : ancestors) {
            opName = op.getOriginalName();
            ancestorsNames.add(opName);
        }
        for (TIdentifierLiteral id : directDependencies) {
            opName = id.getText();
            if (!ancestorsNames.contains(opName)) continue;
            StringBuilder sb = new StringBuilder();
            for (int index = ancestorsNames.indexOf(opName); index < ancestors.size(); ++index) {
                String name = ancestors.get(index).getOriginalName();
                sb.append(name);
                sb.append(" -> ");
            }
            sb.append(opName);
            this.bExceptionList.add(new BException(operation.getFileName(), new CheckException("Cyclic dependencies between operations: " + sb, id)));
            return true;
        }
        return false;
    }

    public RulesMachineRunConfiguration getRulesMachineRunConfiguration() {
        return this.rulesMachineRunConfiguration;
    }

    protected boolean isANewModel(MachineReference reference) {
        for (IModel iModel : this.bModels) {
            if (!iModel.getMachineName().equals(reference.getName())) continue;
            return false;
        }
        return true;
    }

    public List<IModel> getBModels() {
        return this.bModels;
    }

    public boolean hasErrors() {
        return !this.bExceptionList.isEmpty();
    }

    public void printProjectAsPrologTerm(IPrologTermOutput pout) {
        this.printAsPrologTermWithFullstops(pout, true);
    }

    public void printProjectAsPrologTermDirect(IPrologTermOutput pout) {
        this.printAsPrologTermWithFullstops(pout, false);
    }

    public void printAsPrologTermWithFullstops(IPrologTermOutput pout, boolean withFullstops) {
        pout.openTerm("parser_version");
        pout.printAtom(BParser.getGitSha());
        pout.closeTerm();
        if (withFullstops) {
            pout.fullstop();
        }
        pout.openTerm("classical_b");
        pout.printAtom(MAIN_MACHINE_NAME);
        pout.openList();
        for (File file : this.filesLoaded) {
            pout.printAtom(file.getAbsolutePath());
        }
        pout.closeList();
        pout.closeTerm();
        if (withFullstops) {
            pout.fullstop();
        }
        for (IModel iModel : this.bModels) {
            iModel.printAsPrologWithFullstops(pout, this.nodeIdAssignment, withFullstops);
        }
    }

    public void addConstantValue(String constant, String value) {
        this.constantStringValues.put(constant, value);
    }
}

