/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import de.be4.classicalb.core.parser.BLexer;
import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.DefinitionTypes;
import de.be4.classicalb.core.parser.Definitions;
import de.be4.classicalb.core.parser.IDefinitionFileProvider;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.IFileContentProvider;
import de.be4.classicalb.core.parser.ParseOptions;
import de.be4.classicalb.core.parser.PreLexer;
import de.be4.classicalb.core.parser.PreParserIdentifierTypeVisitor;
import de.be4.classicalb.core.parser.analysis.checking.DefinitionPreCollector;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.BLexerException;
import de.be4.classicalb.core.parser.exceptions.PreParseException;
import de.be4.classicalb.core.parser.lexer.LexerException;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PParseUnit;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.Token;
import de.be4.classicalb.core.parser.parser.Parser;
import de.be4.classicalb.core.parser.parser.ParserException;
import de.be4.classicalb.core.parser.util.Utils;
import de.be4.classicalb.core.preparser.node.PPreParseUnit;
import de.be4.classicalb.core.preparser.node.TPreParserDefinitions;
import de.be4.classicalb.core.preparser.node.TPreParserIdentifier;
import de.be4.classicalb.core.preparser.node.TPreParserString;
import de.be4.classicalb.core.preparser.node.TRhsBody;
import java.io.File;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PreParser {
    private final PushbackReader pushbackReader;
    private final File machineFile;
    private final DefinitionTypes definitionTypes;
    private final IDefinitions defFileDefinitions;
    private final ParseOptions parseOptions;
    private final IFileContentProvider contentProvider;
    private final List<String> definitionFileIncludeStack;
    private int startLine;
    private int startColumn;

    public PreParser(PushbackReader pushbackReader, File machineFile, IFileContentProvider contentProvider, List<String> definitionFileIncludeStack, ParseOptions parseOptions, IDefinitions definitions) {
        this.pushbackReader = pushbackReader;
        this.machineFile = machineFile;
        this.contentProvider = contentProvider;
        this.definitionFileIncludeStack = definitionFileIncludeStack;
        this.parseOptions = parseOptions;
        this.defFileDefinitions = definitions;
        this.definitionTypes = new DefinitionTypes();
        this.definitionTypes.addAll(definitions.getTypes());
        this.startLine = 1;
        this.startColumn = 1;
    }

    public void setStartPosition(int line, int column) {
        this.startLine = line;
        this.startColumn = column;
    }

    public void parse() throws PreParseException, IOException, BCompoundException {
        PPreParseUnit preParseUnit;
        PreLexer preLexer = new PreLexer(this.pushbackReader);
        preLexer.setPosition(this.startLine, this.startColumn);
        de.be4.classicalb.core.preparser.parser.Parser preParser = new de.be4.classicalb.core.preparser.parser.Parser(preLexer);
        try {
            preParseUnit = preParser.parse().getPPreParseUnit();
        }
        catch (de.be4.classicalb.core.preparser.parser.ParserException e) {
            String message = e.getToken() instanceof TPreParserDefinitions ? "Clause 'DEFINITIONS' is used more than once" : e.getRealMsg();
            throw new PreParseException(e.getToken(), message, (Throwable)e);
        }
        catch (de.be4.classicalb.core.preparser.lexer.LexerException e) {
            throw new PreParseException(e.getLine(), e.getPos(), e.getRealMsg(), e);
        }
        DefinitionPreCollector collector = new DefinitionPreCollector();
        preParseUnit.apply(collector);
        HashMap<TPreParserIdentifier, TRhsBody> definitions = new HashMap<TPreParserIdentifier, TRhsBody>(collector.getDefinitions());
        for (TPreParserIdentifier nameToken : definitions.keySet()) {
            String name = nameToken.getText();
            if (!Utils.isQuoted(name, '`')) continue;
            try {
                nameToken.setText(Utils.unquoteIdentifier(name));
            }
            catch (IllegalArgumentException exc) {
                throw new PreParseException(nameToken, exc.getMessage(), (Throwable)exc);
            }
        }
        this.evaluateDefinitionFiles(collector.getFileDefinitions());
        List<TPreParserIdentifier> sortedDefinitionList = this.sortDefinitionsByTopologicalOrderAndCheckForCycles(definitions);
        this.evaluateTypes(sortedDefinitionList, definitions);
    }

    private void evaluateDefinitionFiles(List<TPreParserString> list) throws PreParseException, BCompoundException {
        IDefinitionFileProvider cache = null;
        if (this.contentProvider instanceof IDefinitionFileProvider) {
            cache = (IDefinitionFileProvider)this.contentProvider;
        }
        for (TPreParserString fileNameString : list) {
            String quotedFilename = fileNameString.getText();
            String fileName = Utils.unescapeStringContents(Utils.removeSurroundingQuotes(quotedFilename, '\"'));
            try {
                IDefinitions definitions;
                if (this.definitionFileIncludeStack.contains(fileName)) {
                    StringBuilder sb = new StringBuilder();
                    for (String string : this.definitionFileIncludeStack) {
                        sb.append(string).append(" -> ");
                    }
                    sb.append(fileName);
                    throw new PreParseException(fileNameString, "Cyclic references in definition files: " + sb);
                }
                if (cache != null && cache.getDefinitions(fileName) != null) {
                    definitions = cache.getDefinitions(fileName);
                } else {
                    File directory = this.machineFile == null ? null : this.machineFile.getParentFile();
                    String content = this.contentProvider.getFileContent(directory, fileName);
                    File file = this.contentProvider.getFile(directory, fileName);
                    BParser parser = new BParser(fileName, this.parseOptions);
                    parser.setContentProvider(this.contentProvider);
                    parser.getDefinitionFileIncludeStack().addAll(this.definitionFileIncludeStack);
                    parser.getDefinitionFileIncludeStack().add(fileName);
                    parser.setDefinitions(new Definitions(file));
                    parser.parseMachine(content, file);
                    definitions = parser.getDefinitions();
                    if (cache != null) {
                        cache.storeDefinition(fileName, definitions);
                    }
                }
                this.defFileDefinitions.addDefinitions(definitions);
                this.definitionTypes.addAll(definitions.getTypes());
            }
            catch (IOException e) {
                throw new PreParseException(fileNameString, "Definition file cannot be read: " + e, (Throwable)e);
            }
            catch (BCompoundException e) {
                throw e.withMissingLocations(BException.Location.locationsFromNodes(fileName, Collections.singletonList(fileNameString)));
            }
        }
    }

    private void evaluateTypes(List<TPreParserIdentifier> sortedDefinitionList, Map<TPreParserIdentifier, TRhsBody> definitions) throws PreParseException {
        TRhsBody defRhs;
        TPreParserIdentifier definition;
        LinkedList<TPreParserIdentifier> remainingDefinitions = new LinkedList<TPreParserIdentifier>(sortedDefinitionList);
        LinkedList<TPreParserIdentifier> currentlyUnparseableDefinitions = new LinkedList<TPreParserIdentifier>();
        HashSet<String> todoDefs = new HashSet<String>();
        for (TPreParserIdentifier token : remainingDefinitions) {
            todoDefs.add(token.getText());
        }
        boolean oneParsed = true;
        while (oneParsed) {
            oneParsed = false;
            while (!remainingDefinitions.isEmpty()) {
                definition = (TPreParserIdentifier)remainingDefinitions.pop();
                defRhs = definitions.get(definition);
                DefinitionType definitionType = this.determineType(definition, defRhs, todoDefs);
                IDefinitions.Type type = definitionType.type;
                if (type != null) {
                    todoDefs.remove(definition.getText());
                    oneParsed = true;
                    this.definitionTypes.addTyping(definition.getText(), type);
                    continue;
                }
                currentlyUnparseableDefinitions.push(definition);
            }
            remainingDefinitions.addAll(currentlyUnparseableDefinitions);
            currentlyUnparseableDefinitions.clear();
        }
        if (!remainingDefinitions.isEmpty()) {
            definition = (TPreParserIdentifier)remainingDefinitions.pop();
            defRhs = definitions.get(definition);
            DefinitionType definitionType = this.determineType(definition, defRhs, todoDefs);
            if (definitionType.errorMessage != null) {
                String message = definitionType.errorMessage;
                if (this.machineFile != null) {
                    message = message + " in file: " + this.machineFile;
                }
                throw new PreParseException(definitionType.errorToken.getLine(), definitionType.errorToken.getPos(), message);
            }
            throw new PreParseException(definition, "expecting wellformed expression, predicate or substitution as DEFINITION body (DEFINITION arguments assumed to be expressions)");
        }
    }

    private List<TPreParserIdentifier> sortDefinitionsByTopologicalOrderAndCheckForCycles(Map<TPreParserIdentifier, TRhsBody> definitions) throws PreParseException {
        HashSet<String> definitionNames = new HashSet<String>();
        HashMap<String, TPreParserIdentifier> definitionMap = new HashMap<String, TPreParserIdentifier>();
        for (TPreParserIdentifier token : definitions.keySet()) {
            String definitionName = token.getText();
            definitionNames.add(definitionName);
            definitionMap.put(definitionName, token);
        }
        Map<String, Set<String>> dependencies = this.determineDependencies(definitionNames, definitions);
        List<String> sortedDefinitionNames = Utils.sortByTopologicalOrder(dependencies);
        if (sortedDefinitionNames.size() < definitionNames.size()) {
            HashSet<String> remaining = new HashSet<String>(definitionNames);
            remaining.removeAll(sortedDefinitionNames);
            List<String> cycle = Utils.determineCycle(remaining, dependencies);
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = cycle.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(" -> ");
            }
            TPreParserIdentifier firstDefinitionToken = (TPreParserIdentifier)definitionMap.get(cycle.get(0));
            throw new PreParseException(firstDefinitionToken, "Cyclic references in definitions: " + sb);
        }
        ArrayList<TPreParserIdentifier> sortedDefinitionTokens = new ArrayList<TPreParserIdentifier>();
        for (String name : sortedDefinitionNames) {
            sortedDefinitionTokens.add((TPreParserIdentifier)definitionMap.get(name));
        }
        return sortedDefinitionTokens;
    }

    private Map<String, Set<String>> determineDependencies(Set<String> definitionNames, Map<TPreParserIdentifier, TRhsBody> definitions) throws PreParseException {
        HashMap<String, Set<String>> dependencies = new HashMap<String, Set<String>>();
        for (Map.Entry<TPreParserIdentifier, TRhsBody> entry : definitions.entrySet()) {
            TPreParserIdentifier nameToken = entry.getKey();
            TRhsBody rhsToken = entry.getValue();
            StringReader reader = new StringReader("#FORMULA\n" + rhsToken.getText());
            BLexer lexer = new BLexer(new PushbackReader(reader, 99), new DefinitionTypes());
            lexer.setParseOptions(this.parseOptions);
            HashSet<String> set = new HashSet<String>();
            try {
                Token next = lexer.next();
                while (!(next instanceof EOF)) {
                    if (next instanceof TIdentifierLiteral) {
                        String name;
                        TIdentifierLiteral id = (TIdentifierLiteral)next;
                        try {
                            name = Utils.unquoteIdentifier(id.getText());
                        }
                        catch (IllegalArgumentException exc) {
                            throw new PreParseException(rhsToken, exc.getMessage(), (Throwable)exc);
                        }
                        if (definitionNames.contains(name)) {
                            set.add(name);
                        }
                    }
                    next = lexer.next();
                }
            }
            catch (IOException e) {
                throw new PreParseException("Error while parsing", e);
            }
            catch (BLexerException e) {
                Token errorToken = e.getLastToken();
                PreParser.correctErrorTokenPosition(nameToken, rhsToken, errorToken);
                throw new PreParseException(errorToken.getLine(), errorToken.getPos(), PreParser.adjustErrorMessage(e.getRealMsg()), e);
            }
            catch (LexerException e) {
                throw PreParser.wrapLexerExceptionAndCorrectPosition(nameToken, rhsToken, e, e);
            }
            dependencies.put(nameToken.getText(), set);
        }
        return dependencies;
    }

    public static IDefinitions.Type getExpressionDefinitionRhsType(PExpression rhs) {
        if (rhs instanceof AIdentifierExpression || rhs instanceof AFunctionExpression || rhs instanceof ADefinitionExpression) {
            return IDefinitions.Type.ExprOrSubst;
        }
        return IDefinitions.Type.Expression;
    }

    private DefinitionType determineType(TPreParserIdentifier definition, TRhsBody rhsToken, Set<String> untypedDefinitions) throws PreParseException {
        String definitionRhs = rhsToken.getText();
        try {
            PParseUnit parseunit = this.tryParsing("#FORMULA", definitionRhs);
            if (parseunit instanceof APredicateParseUnit) {
                return new DefinitionType(IDefinitions.Type.Predicate);
            }
            AExpressionParseUnit expressionParseUnit = (AExpressionParseUnit)parseunit;
            PreParserIdentifierTypeVisitor visitor = new PreParserIdentifierTypeVisitor(untypedDefinitions);
            expressionParseUnit.apply(visitor);
            if (visitor.isUntypedDefinitionUsed()) {
                return new DefinitionType();
            }
            return new DefinitionType(PreParser.getExpressionDefinitionRhsType(expressionParseUnit.getExpression()));
        }
        catch (ParserException e) {
            Token errorToken = e.getToken();
            try {
                this.tryParsing("#SUBSTITUTION", definitionRhs);
                return new DefinitionType(IDefinitions.Type.Substitution, errorToken);
            }
            catch (ParserException ex) {
                Token errorToken2 = ex.getToken();
                if (errorToken.getLine() > errorToken2.getLine() || errorToken.getLine() == errorToken2.getLine() && errorToken.getPos() >= errorToken2.getPos()) {
                    PreParser.correctErrorTokenPosition(definition, rhsToken, errorToken);
                    return new DefinitionType(PreParser.adjustErrorMessage(e.getRealMsg()), errorToken);
                }
                PreParser.correctErrorTokenPosition(definition, rhsToken, errorToken2);
                return new DefinitionType(PreParser.adjustErrorMessage(ex.getRealMsg()), errorToken2);
            }
            catch (BLexerException e1) {
                errorToken = e1.getLastToken();
                PreParser.correctErrorTokenPosition(definition, rhsToken, errorToken);
                throw new PreParseException(errorToken.getLine(), errorToken.getPos(), PreParser.adjustErrorMessage(e.getRealMsg()), e);
            }
            catch (LexerException e3) {
                throw PreParser.wrapLexerExceptionAndCorrectPosition(definition, rhsToken, e3, e);
            }
            catch (IOException e1) {
                throw new PreParseException(e.toString(), e);
            }
        }
        catch (BLexerException e) {
            Token errorToken = e.getLastToken();
            PreParser.correctErrorTokenPosition(definition, rhsToken, errorToken);
            throw new PreParseException(errorToken.getLine(), errorToken.getPos(), PreParser.adjustErrorMessage(e.getRealMsg()), e);
        }
        catch (LexerException e) {
            throw PreParser.wrapLexerExceptionAndCorrectPosition(definition, rhsToken, e, e);
        }
        catch (IOException e) {
            throw new PreParseException(e.toString(), e);
        }
    }

    private static void correctErrorTokenPosition(TPreParserIdentifier definition, TRhsBody rhsToken, Token errorToken) {
        int line = errorToken.getLine();
        int pos = errorToken.getPos();
        pos = line == 2 ? rhsToken.getPos() + pos - 1 : pos;
        line = definition.getLine() + line - 2;
        errorToken.setLine(line);
        errorToken.setPos(pos);
    }

    private static String adjustErrorMessage(String message) {
        if (message.contains("expecting: EOF")) {
            return "expecting end of definition";
        }
        return message.replace("the end of file", "the end of definition");
    }

    private static PreParseException wrapLexerExceptionAndCorrectPosition(TPreParserIdentifier definition, TRhsBody rhsToken, LexerException exc, Throwable cause) {
        int line = exc.getLine();
        int pos = exc.getPos();
        pos = line == 2 ? rhsToken.getPos() + pos - 1 : pos;
        line = definition.getLine() + line - 2;
        return new PreParseException(line, pos, exc.getRealMsg(), cause);
    }

    private PParseUnit tryParsing(String prefix, String definitionRhs) throws LexerException, ParserException, IOException {
        StringReader reader = new StringReader(prefix + "\n" + definitionRhs);
        BLexer lexer = new BLexer(new PushbackReader(reader, 99), this.definitionTypes);
        lexer.setParseOptions(this.parseOptions);
        Parser parser = new Parser(lexer);
        return parser.parse().getPParseUnit();
    }

    public IDefinitions getDefFileDefinitions() {
        return this.defFileDefinitions;
    }

    public DefinitionTypes getDefinitionTypes() {
        return this.definitionTypes;
    }

    static class DefinitionType {
        IDefinitions.Type type;
        String errorMessage;
        Token errorToken;

        DefinitionType() {
        }

        DefinitionType(IDefinitions.Type t, Token n) {
            this.type = t;
            this.errorToken = n;
        }

        DefinitionType(IDefinitions.Type t) {
            this.type = t;
        }

        DefinitionType(String errorMessage, Token t) {
            this.errorMessage = errorMessage;
            this.errorToken = t;
        }
    }
}

