/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser;

import de.be4.classicalb.core.parser.BLexer;
import de.be4.classicalb.core.parser.CachingDefinitionFileProvider;
import de.be4.classicalb.core.parser.DefinitionTypes;
import de.be4.classicalb.core.parser.Definitions;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.IFileContentProvider;
import de.be4.classicalb.core.parser.NoContentProvider;
import de.be4.classicalb.core.parser.ParseOptions;
import de.be4.classicalb.core.parser.PreParser;
import de.be4.classicalb.core.parser.analysis.checking.ClausesCheck;
import de.be4.classicalb.core.parser.analysis.checking.DefinitionCollector;
import de.be4.classicalb.core.parser.analysis.checking.DefinitionUsageCheck;
import de.be4.classicalb.core.parser.analysis.checking.IdentListCheck;
import de.be4.classicalb.core.parser.analysis.checking.RefinedOperationCheck;
import de.be4.classicalb.core.parser.analysis.checking.SemanticCheck;
import de.be4.classicalb.core.parser.analysis.checking.SemicolonCheck;
import de.be4.classicalb.core.parser.analysis.transforming.CoupleToIdentifierTransformation;
import de.be4.classicalb.core.parser.analysis.transforming.OpSubstitutions;
import de.be4.classicalb.core.parser.analysis.transforming.SyntaxExtensionTranslator;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.exceptions.BLexerException;
import de.be4.classicalb.core.parser.exceptions.BParseException;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.exceptions.PreParseException;
import de.be4.classicalb.core.parser.exceptions.VisitorException;
import de.be4.classicalb.core.parser.lexer.LexerException;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.Token;
import de.be4.classicalb.core.parser.parser.Parser;
import de.be4.classicalb.core.parser.parser.ParserException;
import de.be4.classicalb.core.parser.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class BParser {
    public static final String EXPRESSION_PREFIX = "#EXPRESSION";
    public static final String PREDICATE_PREFIX = "#PREDICATE";
    public static final String FORMULA_PREFIX = "#FORMULA";
    public static final String SUBSTITUTION_PREFIX = "#SUBSTITUTION";
    public static final String OPERATION_PATTERN_PREFIX = "#OPPATTERN";
    public static final String MACHINE_CLAUSE_PREFIX = "#MACHINECLAUSE";
    private static final Properties buildProperties = new Properties();
    private IDefinitions definitions = new Definitions();
    private ParseOptions parseOptions;
    private final List<String> definitionFileIncludeStack = new ArrayList<String>();
    private final String fileName;
    private int startLine;
    private int startColumn;
    private IFileContentProvider contentProvider;

    public static String getVersion() {
        return buildProperties.getProperty("version");
    }

    public static String getGitSha() {
        return buildProperties.getProperty("git");
    }

    public BParser() {
        this(null);
    }

    public BParser(String fileName) {
        this(fileName, new ParseOptions());
    }

    public BParser(String fileName, ParseOptions parseOptions) {
        this.fileName = fileName;
        this.parseOptions = parseOptions;
        this.startLine = 1;
        this.startColumn = 1;
    }

    public void setStartPosition(int line, int column) {
        this.startLine = line;
        this.startColumn = column;
    }

    public IFileContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IFileContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public Start parseFile(File machineFile) throws BCompoundException {
        String content;
        try {
            content = Utils.readFile(machineFile);
        }
        catch (IOException e) {
            throw new BCompoundException(new BException(machineFile.getPath(), e));
        }
        return this.parseMachine(content, machineFile);
    }

    @Deprecated
    public Start parseFile(File machineFile, boolean verbose) throws IOException, BCompoundException {
        this.contentProvider = new CachingDefinitionFileProvider();
        return this.parseFile(machineFile, verbose, this.contentProvider);
    }

    @Deprecated
    public Start parseFile(File machineFile, boolean verbose, IFileContentProvider contentProvider) throws IOException, BCompoundException {
        if (verbose) {
            System.out.println("*** Debug: Parsing file '" + machineFile.getCanonicalPath() + "'");
        }
        String content = Utils.readFile(machineFile);
        return this.parseWithPreParsing(new StringReader(content), machineFile, contentProvider);
    }

    public static Start parse(String input) throws BCompoundException {
        BParser parser = new BParser("String Input");
        return parser.parseMachine(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Start parseWithKindPrefix(String input, String prefix, boolean withPreParsing) throws BCompoundException {
        String theFormula = prefix + " " + input;
        int oldStartColumn = this.startColumn;
        try {
            this.startColumn -= prefix.length() + 1;
            if (withPreParsing) {
                Start start = this.parseMachine(theFormula);
                return start;
            }
            Start start = this.parseWithoutPreParsing(new StringReader(theFormula));
            return start;
        }
        finally {
            this.startColumn = oldStartColumn;
        }
    }

    public Start parseFormula(String input) throws BCompoundException {
        return this.parseWithKindPrefix(input, FORMULA_PREFIX, false);
    }

    public Start parseExpression(String input) throws BCompoundException {
        return this.parseWithKindPrefix(input, EXPRESSION_PREFIX, false);
    }

    public Start parseSubstitution(String input) throws BCompoundException {
        return this.parseWithKindPrefix(input, SUBSTITUTION_PREFIX, false);
    }

    public Start parseTransition(String input) throws BCompoundException {
        return this.parseWithKindPrefix(input, OPERATION_PATTERN_PREFIX, false);
    }

    public Start parsePredicate(String input) throws BCompoundException {
        return this.parseWithKindPrefix(input, PREDICATE_PREFIX, false);
    }

    public Start parseMachineClause(String input) throws BCompoundException {
        return this.parseWithKindPrefix(input, MACHINE_CLAUSE_PREFIX, true);
    }

    @Deprecated
    public Start parse(String input, boolean debugOutput) throws BCompoundException {
        return this.parse(input, debugOutput, new NoContentProvider());
    }

    @Deprecated
    public Start parse(String input, boolean debugOutput, IFileContentProvider contentProvider) throws BCompoundException {
        return this.parseWithPreParsing(new StringReader(input), this.getMachineFile(), contentProvider);
    }

    private Start parseInternal(Reader reader, File machineFile, DefinitionTypes defTypes) throws BCompoundException {
        List<CheckException> checkExceptions;
        Start rootNode;
        String machineFilePath = machineFile == null ? null : machineFile.getPath();
        try {
            BLexer lexer = new BLexer(new PushbackReader(reader, 99), defTypes);
            lexer.setPosition(this.startLine, this.startColumn);
            lexer.setParseOptions(this.parseOptions);
            Parser parser = new Parser(lexer);
            rootNode = parser.parse();
        }
        catch (BLexerException e) {
            throw new BCompoundException(new BException(machineFilePath, e));
        }
        catch (IOException e) {
            throw new BCompoundException(new BException(machineFilePath, e));
        }
        catch (ParserException e) {
            Token token = e.getToken();
            String msg = e.getMessage();
            String realMsg = e.getRealMsg();
            throw new BCompoundException(new BException(machineFilePath, new BParseException(token, msg, realMsg, e)));
        }
        catch (LexerException e) {
            throw new BCompoundException(new BException(machineFilePath, e));
        }
        if (this.parseOptions.isApplyASTTransformations() && !(checkExceptions = this.applyAstTransformations(rootNode)).isEmpty()) {
            throw new BCompoundException(checkExceptions.stream().map(checkException -> new BException(machineFilePath, (CheckException)checkException)).collect(Collectors.toList()));
        }
        return rootNode;
    }

    private Start parseWithPreParsing(Reader reader, File machineFile, IFileContentProvider provider) throws BCompoundException {
        DefinitionTypes defTypes;
        String machineFilePath = machineFile == null ? null : machineFile.getPath();
        try {
            defTypes = this.preParsing(reader, machineFile, provider);
        }
        catch (IOException e) {
            throw new BCompoundException(new BException(machineFilePath, e));
        }
        catch (PreParseException e) {
            throw new BCompoundException(new BException(machineFilePath, e));
        }
        return this.parseInternal(reader, machineFile, defTypes);
    }

    private Start parseWithoutPreParsing(Reader reader) throws BCompoundException {
        return this.parseInternal(reader, null, new DefinitionTypes(this.definitions.getTypes()));
    }

    Start parseMachine(String input, File machineFile) throws BCompoundException {
        if (this.contentProvider == null) {
            this.contentProvider = new CachingDefinitionFileProvider();
        }
        return this.parseWithPreParsing(new StringReader(input), machineFile, this.contentProvider);
    }

    public Start parseMachine(String input) throws BCompoundException {
        return this.parseMachine(input, this.getMachineFile());
    }

    private File getMachineFile() {
        if (this.fileName == null) {
            return null;
        }
        return new File(this.fileName);
    }

    public String getFileName() {
        if (this.fileName == null) {
            return null;
        }
        File f = new File(this.fileName);
        if (f.exists()) {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                return this.fileName;
            }
        }
        return this.fileName;
    }

    private DefinitionTypes preParsing(Reader reader, File machineFile, IFileContentProvider contentProvider) throws IOException, PreParseException, BCompoundException {
        PreParser preParser = new PreParser(new PushbackReader(reader, 99), machineFile, contentProvider, this.definitionFileIncludeStack, this.parseOptions, this.definitions);
        preParser.setStartPosition(this.startLine, this.startColumn);
        preParser.parse();
        reader.reset();
        return preParser.getDefinitionTypes();
    }

    private List<CheckException> applyAstTransformations(Start rootNode) {
        SemanticCheck[] checks;
        ArrayList<CheckException> checkExceptions = new ArrayList<CheckException>();
        rootNode.apply(new CoupleToIdentifierTransformation());
        try {
            rootNode.apply(new SyntaxExtensionTranslator());
        }
        catch (VisitorException e) {
            checkExceptions.add(e.getException());
        }
        DefinitionCollector collector = new DefinitionCollector(this.definitions);
        collector.collectDefinitions(rootNode);
        checkExceptions.addAll(collector.getExceptions());
        try {
            OpSubstitutions.transform(rootNode, this.getDefinitions());
        }
        catch (CheckException e) {
            checkExceptions.add(e);
        }
        for (SemanticCheck check : checks = new SemanticCheck[]{new ClausesCheck(), new SemicolonCheck(), new IdentListCheck(), new DefinitionUsageCheck(this.getDefinitions()), new RefinedOperationCheck()}) {
            check.runChecks(rootNode);
            checkExceptions.addAll(check.getCheckExceptions());
        }
        return checkExceptions;
    }

    public IDefinitions getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(IDefinitions definitions) {
        this.definitions = definitions;
    }

    List<String> getDefinitionFileIncludeStack() {
        return this.definitionFileIncludeStack;
    }

    public ParseOptions getOptions() {
        return this.parseOptions;
    }

    public void setParseOptions(ParseOptions options) {
        this.parseOptions = options;
    }

    static {
        InputStream is = BParser.class.getResourceAsStream("build.properties");
        if (is == null) {
            throw new IllegalStateException("Build properties not found, this should never happen!");
        }
        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
            buildProperties.load(r);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while loading build properties, this should never happen!", e);
        }
    }
}

