/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.Map;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IFcnRcdValue;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueInputStream;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.UndefValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.UniqueString;

public class FcnRcdValue
extends Value
implements Applicable,
IFcnRcdValue {
    public final Value[] domain;
    public final IntervalValue intv;
    public final Value[] values;
    private boolean isNorm;
    public static final Value EmptyFcn = new FcnRcdValue(new Value[0], new Value[0], true);

    public FcnRcdValue(Value[] domain, Value[] values, boolean isNorm) {
        this.domain = domain;
        this.values = values;
        this.intv = null;
        this.isNorm = isNorm;
    }

    public FcnRcdValue(IntervalValue intv, Value[] values) {
        this.intv = intv;
        this.values = values;
        this.domain = null;
        this.isNorm = true;
    }

    public FcnRcdValue(IntervalValue intv, Value[] values, CostModel cm) {
        this(intv, values);
        this.cm = cm;
    }

    private FcnRcdValue(FcnRcdValue fcn, Value[] values) {
        this.domain = fcn.domain;
        this.intv = fcn.intv;
        this.values = values;
        this.isNorm = fcn.isNorm;
    }

    public FcnRcdValue(ValueVec elems, Value[] values, boolean isNorm) {
        this(elems.toArray(), values, isNorm);
    }

    public FcnRcdValue(ValueVec elems, Value[] values, boolean isNorm, CostModel cm) {
        this(elems, values, isNorm);
        this.cm = cm;
    }

    public FcnRcdValue(Value[] domain, Value[] values, boolean isNorm, CostModel cm) {
        this(domain, values, isNorm);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 9;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            FcnRcdValue fcn;
            FcnRcdValue fcnRcdValue = fcn = obj instanceof Value ? (FcnRcdValue)((Value)obj).toFcnRcd() : null;
            if (fcn == null) {
                if (obj instanceof ModelValue) {
                    return 1;
                }
                Assert.fail("Attempted to compare the function " + Values.ppr(this.toString()) + " with the value:\n" + Values.ppr(obj.toString()));
            }
            this.normalize();
            fcn.normalize();
            int result = this.values.length - fcn.values.length;
            if (result != 0) {
                return result;
            }
            if (this.intv != null) {
                return this.compareToInterval(fcn);
            }
            return this.compareOtherInterval(fcn);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final int compareOtherInterval(FcnRcdValue fcn) {
        if (fcn.intv != null) {
            for (int i = 0; i < this.domain.length; ++i) {
                int result;
                Value dElem = this.domain[i];
                if (!(dElem instanceof IntValue)) {
                    Assert.fail("Attempted to compare integer with non-integer\n" + Values.ppr(dElem.toString()) + ".");
                }
                if ((result = ((IntValue)dElem).val - (fcn.intv.low + i)) != 0) {
                    return result;
                }
                result = this.values[i].compareTo(fcn.values[i]);
                if (result == 0) continue;
                return result;
            }
        } else {
            for (int i = 0; i < this.domain.length; ++i) {
                int result = this.domain[i].compareTo(fcn.domain[i]);
                if (result != 0) {
                    return result;
                }
                result = this.values[i].compareTo(fcn.values[i]);
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }

    private final int compareToInterval(FcnRcdValue fcn) {
        if (fcn.intv != null) {
            int result = this.intv.low - fcn.intv.low;
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < this.values.length; ++i) {
                result = this.values[i].compareTo(fcn.values[i]);
                if (result == 0) continue;
                return result;
            }
        } else {
            for (int i = 0; i < fcn.domain.length; ++i) {
                int result;
                Value dElem = fcn.domain[i];
                if (!(dElem instanceof IntValue)) {
                    Assert.fail("Attempted to compare integer with non-integer:\n" + Values.ppr(dElem.toString()) + ".");
                }
                if ((result = this.intv.low + i - ((IntValue)dElem).val) != 0) {
                    return result;
                }
                result = this.values[i].compareTo(fcn.values[i]);
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        try {
            FcnRcdValue fcn;
            FcnRcdValue fcnRcdValue = fcn = obj instanceof Value ? (FcnRcdValue)((Value)obj).toFcnRcd() : null;
            if (fcn == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueEquals(this);
                }
                Assert.fail("Attempted to check equality of the function " + Values.ppr(this.toString()) + " with the value:\n" + Values.ppr(obj.toString()));
            }
            this.normalize();
            fcn.normalize();
            if (this.intv != null) {
                if (fcn.intv != null) {
                    if (!this.intv.equals(fcn.intv)) {
                        return false;
                    }
                    for (int i = 0; i < this.values.length; ++i) {
                        if (this.values[i].equals(fcn.values[i])) continue;
                        return false;
                    }
                } else {
                    if (fcn.domain.length != this.intv.size()) {
                        return false;
                    }
                    for (int i = 0; i < fcn.domain.length; ++i) {
                        Value dElem = fcn.domain[i];
                        if (!(dElem instanceof IntValue)) {
                            Assert.fail("Attempted to compare an integer with non-integer:\n" + Values.ppr(dElem.toString()) + ".");
                        }
                        if (((IntValue)dElem).val == this.intv.low + i && this.values[i].equals(fcn.values[i])) continue;
                        return false;
                    }
                }
            } else {
                if (this.values.length != fcn.values.length) {
                    return false;
                }
                if (fcn.intv != null) {
                    for (int i = 0; i < this.domain.length; ++i) {
                        Value dElem = this.domain[i];
                        if (!(dElem instanceof IntValue)) {
                            Assert.fail("Attempted to compare an integer with non-integer:\n" + Values.ppr(dElem.toString()) + ".");
                        }
                        if (((IntValue)dElem).val == fcn.intv.low + i && this.values[i].equals(fcn.values[i])) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < this.domain.length; ++i) {
                        if (this.domain[i].equals(fcn.domain[i]) && this.values[i].equals(fcn.values[i])) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the function " + Values.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            Value result = this.select(arg);
            if (result == null) {
                Assert.fail("Attempted to apply function:\n" + Values.ppr(this.toString()) + "\nto argument " + Values.ppr(arg.toString()) + ", which is not in the domain of the function.");
            }
            return result;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            return this.apply(new TupleValue(args), 0);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            if (this.intv != null) {
                int idx;
                if (!(arg instanceof IntValue)) {
                    Assert.fail("Attempted to apply function with integer domain to the non-integer argument " + Values.ppr(arg.toString()));
                }
                if ((idx = ((IntValue)arg).val) >= this.intv.low && idx <= this.intv.high) {
                    return this.values[idx - this.intv.low];
                }
            } else {
                int len = this.domain.length;
                for (int i = 0; i < len; ++i) {
                    if (!this.domain[i].equals(arg)) continue;
                    return this.values[i];
                }
            }
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean assign(Value[] args, Value val) {
        try {
            if (this.intv != null) {
                int idx;
                if (args.length != 1) {
                    Assert.fail("Wrong number of function arguments.");
                }
                if (args[0] instanceof IntValue && (idx = ((IntValue)args[0]).val) >= this.intv.low && idx <= this.intv.high) {
                    int vIdx = idx - this.intv.low;
                    if (this.values[vIdx] == UndefValue.ValUndef || this.values[vIdx].equals(val)) {
                        this.values[vIdx] = val;
                        return true;
                    }
                    return false;
                }
            } else {
                TupleValue argv = new TupleValue(args);
                int len = this.domain.length;
                for (int i = 0; i < len; ++i) {
                    if (!this.domain[i].equals(argv)) continue;
                    if (this.values[i] == UndefValue.ValUndef || this.values[i].equals(val)) {
                        this.values[i] = val;
                        return true;
                    }
                    return false;
                }
            }
            Assert.fail("Function initialization out of domain.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx >= ex.path.length) {
                return ex.value;
            }
            int flen = this.values.length;
            Value[] newValues = new Value[flen];
            for (int i = 0; i < flen; ++i) {
                newValues[i] = this.values[i];
            }
            Value arg = ex.path[ex.idx];
            if (this.intv != null) {
                if (arg instanceof IntValue) {
                    int idx = ((IntValue)arg).val;
                    if (idx >= this.intv.low && idx <= this.intv.high) {
                        int vidx = idx - this.intv.low;
                        ++ex.idx;
                        newValues[idx] = this.values[vidx].takeExcept(ex);
                    }
                    return new FcnRcdValue(this.intv, newValues);
                }
            } else {
                for (int i = 0; i < flen; ++i) {
                    if (!arg.equals(this.domain[i])) continue;
                    ++ex.idx;
                    newValues[i] = newValues[i].takeExcept(ex);
                    Value[] newDomain = this.domain;
                    if (!this.isNorm) {
                        newDomain = new Value[flen];
                        for (int j = 0; j < flen; ++j) {
                            newDomain[j] = this.domain[j];
                        }
                    }
                    return new FcnRcdValue(newDomain, newValues, this.isNorm);
                }
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Value res = this;
            for (int i = 0; i < exs.length; ++i) {
                res = ((Value)res).takeExcept(exs[i]);
            }
            return res;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            if (this.intv != null) {
                return this.intv;
            }
            this.normalize();
            return new SetEnumValue(this.domain, true);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final Value[] getDomainAsValues() {
        if (this.intv != null) {
            return this.intv.asValues();
        }
        return this.domain;
    }

    @Override
    public final int size() {
        try {
            this.normalize();
            return this.values.length;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public int nonNormalizedSize() {
        return this.values.length;
    }

    @Override
    public final Value toTuple() {
        if (this.intv != null) {
            if (this.intv.low != 1) {
                return null;
            }
            return new TupleValue(this.values);
        }
        int len = this.values.length;
        Value[] elems = new Value[len];
        for (int i = 0; i < len; ++i) {
            if (!(this.domain[i] instanceof IntValue)) {
                return null;
            }
            int idx = ((IntValue)this.domain[i]).val;
            if (0 < idx && idx <= len) {
                if (elems[idx - 1] != null) {
                    return null;
                }
            } else {
                return null;
            }
            elems[idx - 1] = this.values[i];
        }
        if (coverage) {
            this.cm.incSecondary(elems.length);
        }
        return new TupleValue(elems, this.cm);
    }

    @Override
    public final Value toRcd() {
        if (this.domain == null) {
            return null;
        }
        this.normalize();
        UniqueString[] vars = new UniqueString[this.domain.length];
        for (int i = 0; i < this.domain.length; ++i) {
            if (!(this.domain[i] instanceof StringValue)) {
                return null;
            }
            vars[i] = ((StringValue)this.domain[i]).getVal();
        }
        if (coverage) {
            this.cm.incSecondary(this.values.length);
        }
        return new RecordValue(vars, this.values, this.isNormalized(), this.cm);
    }

    @Override
    public final Value toFcnRcd() {
        return this;
    }

    @Override
    public final boolean isNormalized() {
        return this.isNorm;
    }

    @Override
    public final Value normalize() {
        try {
            if (!this.isNorm) {
                int i;
                int dlen = this.domain.length;
                for (i = 1; i < dlen; ++i) {
                    int cmp = this.domain[0].compareTo(this.domain[i]);
                    if (cmp == 0) {
                        Assert.fail("The value\n" + this.domain[i] + "\noccurs multiple times in the function domain.");
                        continue;
                    }
                    if (cmp <= 0) continue;
                    Value tv = this.domain[0];
                    this.domain[0] = this.domain[i];
                    this.domain[i] = tv;
                    tv = this.values[0];
                    this.values[0] = this.values[i];
                    this.values[i] = tv;
                }
                for (i = 2; i < dlen; ++i) {
                    int cmp;
                    Value d = this.domain[i];
                    Value v = this.values[i];
                    int j = i;
                    while ((cmp = d.compareTo(this.domain[j - 1])) < 0) {
                        this.domain[j] = this.domain[j - 1];
                        this.values[j] = this.values[j - 1];
                        --j;
                    }
                    if (cmp == 0) {
                        Assert.fail("The value\n" + this.domain[i] + "\noccurs multiple times in the function domain.");
                    }
                    this.domain[j] = d;
                    this.values[j] = v;
                }
                this.isNorm = true;
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].deepNormalize();
            }
            this.normalize();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            int i;
            boolean defined = true;
            if (this.intv == null) {
                for (i = 0; i < this.values.length; ++i) {
                    defined = defined && this.domain[i].isDefined();
                }
            }
            for (i = 0; i < this.values.length; ++i) {
                defined = defined && this.values[i].isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        try {
            Value[] vals = new Value[this.values.length];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = (Value)this.values[i].deepCopy();
            }
            return new FcnRcdValue(this, vals);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            boolean canAssign;
            boolean bl = canAssign = val instanceof FcnRcdValue && this.values.length == ((FcnRcdValue)val).values.length;
            if (!canAssign) {
                return false;
            }
            FcnRcdValue fcn = (FcnRcdValue)val;
            for (int i = 0; i < this.values.length; ++i) {
                canAssign = canAssign && this.domain[i].equals(fcn.domain[i]) && this.values[i].assignable(fcn.values[i]);
            }
            return canAssign;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        int index = vos.put(this);
        if (index == -1) {
            vos.writeByte((byte)9);
            int len = this.values.length;
            vos.writeNat(len);
            if (this.intv != null) {
                vos.writeByte((byte)0);
                vos.writeInt(this.intv.low);
                vos.writeInt(this.intv.high);
                for (int i = 0; i < len; ++i) {
                    this.values[i].write(vos);
                }
            } else {
                vos.writeByte(this.isNormalized() ? (byte)1 : 2);
                for (int i = 0; i < len; ++i) {
                    this.domain[i].write(vos);
                    this.values[i].write(vos);
                }
            }
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.normalize();
            int flen = this.values.length;
            fp = FP64.Extend(fp, (byte)9);
            fp = FP64.Extend(fp, flen);
            if (this.intv == null) {
                for (int i = 0; i < flen; ++i) {
                    fp = this.domain[i].fingerPrint(fp);
                    fp = this.values[i].fingerPrint(fp);
                }
            } else {
                for (int i = 0; i < flen; ++i) {
                    fp = FP64.Extend(fp, (byte)1);
                    fp = FP64.Extend(fp, i + this.intv.low);
                    fp = this.values[i].fingerPrint(fp);
                }
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.normalize();
            int flen = this.domain.length;
            Value[] vals = new Value[flen];
            boolean vchanged = false;
            for (int i = 0; i < flen; ++i) {
                vals[i] = (Value)this.values[i].permute(perm);
                vchanged = vchanged || vals[i] != this.values[i];
            }
            if (this.intv == null) {
                Value[] dom = new Value[flen];
                boolean dchanged = false;
                for (int i = 0; i < flen; ++i) {
                    dom[i] = (Value)this.domain[i].permute(perm);
                    dchanged = dchanged || dom[i] != this.domain[i];
                }
                if (dchanged) {
                    return new FcnRcdValue(dom, vals, false);
                }
                if (vchanged) {
                    return new FcnRcdValue(this.domain, vals, true);
                }
            } else if (vchanged) {
                return new FcnRcdValue(this.intv, vals);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private static final boolean isName(String name) {
        int len = name.length();
        boolean hasLetter = false;
        for (int idx = 0; idx < len; ++idx) {
            char ch = name.charAt(idx);
            if (ch == '_') continue;
            if (!Character.isLetterOrDigit(ch)) {
                return false;
            }
            hasLetter = hasLetter || Character.isLetter(ch);
        }
        return hasLetter && (len < 4 || !name.startsWith("WF_") && !name.startsWith("SF_"));
    }

    private final boolean isRcd() {
        if (this.intv != null) {
            return false;
        }
        for (int i = 0; i < this.domain.length; ++i) {
            boolean isName;
            Value dval = this.domain[i];
            boolean bl = isName = dval instanceof StringValue && FcnRcdValue.isName(((StringValue)dval).val.toString());
            if (isName) continue;
            return false;
        }
        return true;
    }

    private final boolean isTuple() {
        int i;
        if (this.intv != null) {
            return this.intv.low == 1;
        }
        for (i = 0; i < this.domain.length; ++i) {
            if (this.domain[i] instanceof IntValue) continue;
            return false;
        }
        this.normalize();
        for (i = 0; i < this.domain.length; ++i) {
            if (((IntValue)this.domain[i]).val == i + 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            int len = this.values.length;
            if (len == 0) {
                sb.append("<< >>");
            } else if (this.isRcd()) {
                sb.append("[");
                sb.append(((StringValue)this.domain[0]).val + " |-> ");
                sb = this.values[0].toString(sb, offset, swallow);
                for (int i = 1; i < len; ++i) {
                    sb.append(", ");
                    sb.append(((StringValue)this.domain[i]).val + " |-> ");
                    sb = this.values[i].toString(sb, offset, swallow);
                }
                sb.append("]");
            } else if (this.isTuple()) {
                sb = sb.append("<<");
                sb = this.values[0].toString(sb, offset, swallow);
                for (int i = 1; i < len; ++i) {
                    sb.append(", ");
                    sb = this.values[i].toString(sb, offset, swallow);
                }
                sb.append(">>");
            } else {
                sb = sb.append("(");
                sb = this.domain[0].toString(sb, offset, swallow);
                sb.append(" :> ");
                sb = this.values[0].toString(sb, offset, swallow);
                for (int i = 1; i < len; ++i) {
                    sb.append(" @@ ");
                    sb = this.domain[i].toString(sb, offset, swallow);
                    sb.append(" :> ");
                    sb = this.values[i].toString(sb, offset, swallow);
                }
                sb.append(")");
            }
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static IValue createFrom(IValueInputStream vos) throws IOException {
        FcnRcdValue res;
        int index = vos.getIndex();
        int len = vos.readNat();
        byte info = vos.readByte();
        Value[] rvals = new Value[len];
        if (info == 0) {
            int low = vos.readInt();
            int high = vos.readInt();
            for (int i = 0; i < len; ++i) {
                rvals[i] = (Value)vos.read();
            }
            IntervalValue intv = new IntervalValue(low, high);
            res = new FcnRcdValue(intv, rvals);
        } else {
            Value[] dvals = new Value[len];
            for (int i = 0; i < len; ++i) {
                dvals[i] = (Value)vos.read();
                rvals[i] = (Value)vos.read();
            }
            res = new FcnRcdValue(dvals, rvals, info == 1);
        }
        vos.assign(res, index);
        return res;
    }

    public static IValue createFrom(ValueInputStream vos, Map<String, UniqueString> tbl) throws IOException {
        FcnRcdValue res;
        int index = vos.getIndex();
        int len = vos.readNat();
        byte info = vos.readByte();
        Value[] rvals = new Value[len];
        if (info == 0) {
            int low = vos.readInt();
            int high = vos.readInt();
            for (int i = 0; i < len; ++i) {
                rvals[i] = (Value)vos.read(tbl);
            }
            IntervalValue intv = new IntervalValue(low, high);
            res = new FcnRcdValue(intv, rvals);
        } else {
            Value[] dvals = new Value[len];
            for (int i = 0; i < len; ++i) {
                dvals[i] = (Value)vos.read(tbl);
                rvals[i] = (Value)vos.read(tbl);
            }
            res = new FcnRcdValue(dvals, rvals, info == 1);
        }
        vos.assign(res, index);
        return res;
    }
}

