/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.global.BBuiltInOPs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.BuiltInOPs;

public class SymbolRenamer
extends BuiltInOPs {
    private static final Set<String> KEYWORDS = new HashSet<String>();
    private static final Map<String, String> INFIX_OPERATOR;
    private static final Map<String, String> BBUILTIN_OPERATOR;
    private final ModuleNode moduleNode;
    private final Set<OpDefNode> usedDefinitions;
    private final Set<String> globalNames = new HashSet<String>();
    private final Map<OpDefNode, Set<String>> usedNamesTable = new HashMap<OpDefNode, Set<String>>();

    private SymbolRenamer(ModuleNode moduleNode, SpecAnalyser specAnalyser) {
        this.moduleNode = moduleNode;
        this.usedDefinitions = specAnalyser.getUsedDefinitions();
    }

    private SymbolRenamer(ModuleNode moduleNode) {
        this.moduleNode = moduleNode;
        this.usedDefinitions = new HashSet<OpDefNode>();
        OpDefNode[] defs = moduleNode.getOpDefs();
        this.usedDefinitions.add(defs[defs.length - 1]);
    }

    public static void run(ModuleNode moduleNode, SpecAnalyser specAnalyser) {
        new SymbolRenamer(moduleNode, specAnalyser).start();
    }

    public static void run(ModuleNode moduleNode) {
        new SymbolRenamer(moduleNode).start();
    }

    private void start() {
        String newName;
        for (OpDeclNode opDeclNode : this.moduleNode.getVariableDecls()) {
            newName = this.incName(opDeclNode.getName().toString());
            this.globalNames.add(newName);
            opDeclNode.setToolObject(20, newName);
        }
        for (OpDeclNode opDeclNode : this.moduleNode.getConstantDecls()) {
            newName = this.incName(opDeclNode.getName().toString());
            this.globalNames.add(newName);
            opDeclNode.setToolObject(20, newName);
        }
        for (OpDefOrDeclNode opDefOrDeclNode : this.moduleNode.getOpDefs()) {
            newName = this.getOperatorName((OpDefNode)opDefOrDeclNode);
            this.globalNames.add(newName);
            opDefOrDeclNode.setToolObject(20, newName);
            this.usedNamesTable.put((OpDefNode)opDefOrDeclNode, new HashSet());
        }
        for (LevelNode levelNode : this.moduleNode.getAssumptions()) {
            this.visitNode(((AssumeNode)levelNode).getAssume(), new HashSet<String>());
        }
        for (int i = this.moduleNode.getOpDefs().length - 1; i >= 0; --i) {
            OpDefNode def = this.moduleNode.getOpDefs()[i];
            Set<String> usedNames = this.usedNamesTable.get(def);
            for (FormalParamNode node : def.getParams()) {
                node.setToolObject(20, this.incName(node.getName().toString()));
            }
            this.visitNode(def.getBody(), usedNames);
        }
    }

    private void visitNode(SemanticNode n, Set<String> usedNames) {
        switch (n.getKind()) {
            case 10: {
                OpDefNode[] defs;
                LetInNode letInNode = (LetInNode)n;
                for (OpDefNode def : defs = letInNode.getLets()) {
                    String newName = this.getOperatorName(def);
                    this.globalNames.add(newName);
                    def.setToolObject(20, newName);
                    this.usedNamesTable.put(def, new HashSet<String>(usedNames));
                }
                this.visitNode(letInNode.getBody(), usedNames);
                for (int i = defs.length - 1; i >= 0; --i) {
                    OpDefNode def = defs[i];
                    Set<String> usedNamesOfDef = this.usedNamesTable.get(def);
                    for (FormalParamNode node : def.getParams()) {
                        node.setToolObject(20, this.incName(node.getName().toString()));
                    }
                    this.visitNode(def.getBody(), usedNamesOfDef);
                }
                return;
            }
            case 9: {
                OpApplNode opApplNode = (OpApplNode)n;
                switch (opApplNode.getOperator().getKind()) {
                    case 7: {
                        this.visitBuiltinNode(opApplNode, usedNames);
                        return;
                    }
                    case 5: {
                        OpDefNode def = (OpDefNode)opApplNode.getOperator();
                        if (BBuiltInOPs.contains(def.getName())) break;
                        Set<String> set = this.usedNamesTable.get(def);
                        if (set != null) {
                            this.usedNamesTable.get(def).addAll(usedNames);
                        }
                        for (SemanticNode node : n.getChildren()) {
                            this.visitNode(node, usedNames);
                        }
                        return;
                    }
                }
                for (ExprOrOpArgNode node : opApplNode.getArgs()) {
                    this.visitNode(node, usedNames);
                }
                return;
            }
        }
        if (n.getChildren() != null) {
            for (SemanticNode node : n.getChildren()) {
                this.visitNode(node, usedNames);
            }
        }
    }

    private void visitBuiltinNode(OpApplNode opApplNode, Set<String> usedNames) {
        switch (SymbolRenamer.getOpCode(opApplNode.getOperator().getName())) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 19: 
            case 22: {
                FormalParamNode[][] params = opApplNode.getBdedQuantSymbolLists();
                HashSet<String> newUsedNames = new HashSet<String>(usedNames);
                FormalParamNode[][] formalParamNodeArray = params;
                int n = formalParamNodeArray.length;
                for (int i = 0; i < n; ++i) {
                    FormalParamNode[] formalParamNodeArray2;
                    for (FormalParamNode param : formalParamNodeArray2 = formalParamNodeArray[i]) {
                        String newName = this.incName(param.getName().toString(), usedNames);
                        param.setToolObject(20, newName);
                        newUsedNames.add(newName);
                    }
                }
                for (FormalParamNode[] formalParamNodeArray3 : opApplNode.getBdedQuantBounds()) {
                    this.visitNode((SemanticNode)formalParamNodeArray3, usedNames);
                }
                this.visitNode(opApplNode.getArgs()[0], newUsedNames);
                return;
            }
        }
        for (ExprOrOpArgNode node : opApplNode.getArgs()) {
            if (node == null) continue;
            this.visitNode(node, usedNames);
        }
    }

    private String getOperatorName(OpDefNode def) {
        String newName = def.getName().toString();
        if (BBUILTIN_OPERATOR.containsKey(newName) && !BBuiltInOPs.isBBuiltInOp(def)) {
            return this.incName(BBUILTIN_OPERATOR.get(newName));
        }
        for (String e : INFIX_OPERATOR.keySet()) {
            if (!newName.contains(e)) continue;
            newName = newName.replace(e, INFIX_OPERATOR.get(e));
        }
        if (newName.contains("!")) {
            newName = newName.replace('!', '_');
        }
        if (newName.contains("\\")) {
            newName = newName.replace("\\", "");
        }
        return this.incName(newName);
    }

    private Boolean existingName(String name) {
        return this.globalNames.contains(name) || KEYWORDS.contains(name);
    }

    private String incName(String name) {
        String res = name;
        int i = 1;
        while (this.existingName(res).booleanValue()) {
            res = name + "_" + i;
            ++i;
        }
        return res;
    }

    private String incName(String name, Set<String> tempSet) {
        String res = name;
        int i = 1;
        while (this.existingName(res).booleanValue() || tempSet.contains(res)) {
            res = name + "_" + i;
            ++i;
        }
        return res;
    }

    static {
        KEYWORDS.add("seq");
        KEYWORDS.add("left");
        KEYWORDS.add("right");
        KEYWORDS.add("max");
        KEYWORDS.add("min");
        KEYWORDS.add("succ");
        KEYWORDS.add("pred");
        KEYWORDS.add("dom");
        KEYWORDS.add("ran");
        KEYWORDS.add("fnc");
        KEYWORDS.add("rel");
        KEYWORDS.add("id");
        KEYWORDS.add("card");
        KEYWORDS.add("POW");
        KEYWORDS.add("POW1");
        KEYWORDS.add("FIN");
        KEYWORDS.add("FIN1");
        KEYWORDS.add("size");
        KEYWORDS.add("rev");
        KEYWORDS.add("first");
        KEYWORDS.add("last");
        KEYWORDS.add("front");
        KEYWORDS.add("tail");
        KEYWORDS.add("conc");
        KEYWORDS.add("struct");
        KEYWORDS.add("rec");
        KEYWORDS.add("tree");
        KEYWORDS.add("btree");
        KEYWORDS.add("skip");
        KEYWORDS.add("ANY");
        KEYWORDS.add("WHERE");
        KEYWORDS.add("END");
        KEYWORDS.add("BE");
        KEYWORDS.add("VAR");
        KEYWORDS.add("ASSERT");
        KEYWORDS.add("CHOICE");
        KEYWORDS.add("OR");
        KEYWORDS.add("SELECT");
        KEYWORDS.add("EITHER");
        KEYWORDS.add("WHEN");
        KEYWORDS.add("BEGIN");
        KEYWORDS.add("MACHINE");
        KEYWORDS.add("REFINEMENT");
        KEYWORDS.add("IMPLEMENTATION");
        KEYWORDS.add("SETS");
        KEYWORDS.add("CONSTRAINTS");
        KEYWORDS.add("MODEL");
        KEYWORDS.add("SYSTEM");
        KEYWORDS.add("EVENTS");
        KEYWORDS.add("OPERATIONS");
        INFIX_OPERATOR = new HashMap<String, String>();
        INFIX_OPERATOR.put("!!", "exclamationmark2");
        INFIX_OPERATOR.put("??", "questionmark2");
        INFIX_OPERATOR.put("&", "ampersand1");
        INFIX_OPERATOR.put("&&", "ampersand2");
        INFIX_OPERATOR.put("@@", "at2");
        INFIX_OPERATOR.put("++", "plus2");
        INFIX_OPERATOR.put("--", "minus2");
        INFIX_OPERATOR.put("^", "circumflex1");
        INFIX_OPERATOR.put("^^", "circumflex2");
        INFIX_OPERATOR.put("##", "hash2");
        INFIX_OPERATOR.put("%%", "percent2");
        INFIX_OPERATOR.put("$", "dollar1");
        INFIX_OPERATOR.put("$$", "dollar2");
        INFIX_OPERATOR.put("|", "pipe1");
        INFIX_OPERATOR.put("||", "pipe2");
        INFIX_OPERATOR.put("//", "slash2");
        INFIX_OPERATOR.put("**", "mult2");
        INFIX_OPERATOR.put("...", "dot3");
        BBUILTIN_OPERATOR = new HashMap<String, String>();
        BBUILTIN_OPERATOR.put("+", "plus");
        BBUILTIN_OPERATOR.put("-", "minus");
        BBUILTIN_OPERATOR.put("*", "mult");
        BBUILTIN_OPERATOR.put("^", "power");
        BBUILTIN_OPERATOR.put("<", "lt");
        BBUILTIN_OPERATOR.put(">", "gt");
        BBUILTIN_OPERATOR.put("\\leq", "leq");
        BBUILTIN_OPERATOR.put("\\geq", "geq");
        BBUILTIN_OPERATOR.put("%", "modulo");
        BBUILTIN_OPERATOR.put("\\div", "div");
        BBUILTIN_OPERATOR.put("/", "realdiv");
        BBUILTIN_OPERATOR.put("..", "dot2");
    }
}

