/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.match;

import de.prob.prolog.match.PrologMatch;
import de.prob.prolog.output.PrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import de.prob.prolog.term.VariablePrologTerm;
import java.util.Map;

public final class PrologVariableMatch
extends PrologMatch {
    private final String varName;

    private PrologVariableMatch(String name, String varName) {
        super(name);
        if (varName != null && !PrologTermOutput.isValidPrologVariable(varName)) {
            throw new IllegalArgumentException("varName");
        }
        this.varName = varName;
    }

    public static PrologVariableMatch anonVar() {
        return PrologVariableMatch.namedVar(null);
    }

    public static PrologVariableMatch anonVar(String varName) {
        return PrologVariableMatch.namedVar(null, varName);
    }

    public static PrologVariableMatch namedVar(String name) {
        return PrologVariableMatch.namedVar(name, null);
    }

    public static PrologVariableMatch namedVar(String name, String varName) {
        return new PrologVariableMatch(name, varName);
    }

    @Override
    protected boolean isMatch(PrologTerm term, Map<String, PrologTerm> hits) {
        boolean match = term instanceof VariablePrologTerm;
        if (match && this.varName != null) {
            match = this.varName.equals(((VariablePrologTerm)term).getName());
        }
        return match;
    }
}

