/*
 * Decompiled with CFR 0.152.
 */
package de.be4.ltl.core.parser;

import de.be4.ltl.core.parser.LtlParseException;
import de.be4.ltl.core.parser.TemporalLogicParser;
import de.be4.ltl.core.parser.internal.LtlLexer;
import de.be4.ltl.core.parser.internal.PrologGenerator;
import de.be4.ltl.core.parser.internal.UniversalToken;
import de.be4.ltl.core.parser.lexer.LexerException;
import de.be4.ltl.core.parser.node.Start;
import de.be4.ltl.core.parser.parser.Parser;
import de.be4.ltl.core.parser.parser.ParserException;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.output.IPrologTermOutput;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;

public class LtlParser
extends TemporalLogicParser<Start> {
    public LtlParser(ProBParserBase specParser) {
        super(specParser);
    }

    @Override
    protected Start parseFormula(String formula) throws LtlParseException {
        Start ast;
        StringReader reader = new StringReader(formula);
        PushbackReader r = new PushbackReader(reader, 99);
        LtlLexer l = new LtlLexer(r);
        Parser p = new Parser(l);
        try {
            ast = p.parse();
        }
        catch (ParserException e) {
            UniversalToken token = UniversalToken.createToken(e.getToken());
            throw new LtlParseException(token, (Throwable)e);
        }
        catch (LexerException | IOException e) {
            throw new LtlParseException(null, (Throwable)e);
        }
        return ast;
    }

    @Override
    protected void applyPrologGenerator(IPrologTermOutput pto, String stateID, Start ast) {
        PrologGenerator prologGenerator = new PrologGenerator(pto, stateID, this.getSpecParser());
        ast.apply(prologGenerator);
    }
}

