/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.rules.AbstractOperation;
import de.be4.classicalb.core.parser.rules.IModel;
import de.be4.classicalb.core.parser.rules.RulesParseUnit;
import de.be4.classicalb.core.parser.rules.RulesProject;
import de.hhu.stups.sablecc.patch.SourcePosition;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CTagsGenerator {
    private static final String TYPE_OPERATION = "operation";
    private static final String TYPE_IDENTIFIER = "identifier";
    private static final String TYPE_MACHINE = "machine";

    private CTagsGenerator() {
    }

    public static void generateCtagsFile(RulesProject project, File ctagsFile) {
        ArrayList<CTagsEntry> list = new ArrayList<CTagsEntry>();
        list.addAll(CTagsGenerator.createCTagsEntryFromOperations(project.getOperationsMap().values()));
        list.addAll(CTagsGenerator.createCTagsEntryFromConstants(project));
        list.addAll(CTagsGenerator.createCTagsFromMachines(project));
        try (FileWriter fw = new FileWriter(ctagsFile);){
            for (CTagsEntry cTagsEntry : list) {
                fw.write(cTagsEntry.toString());
                fw.write(System.lineSeparator());
            }
            fw.flush();
        }
        catch (IOException e) {
            throw new AssertionError("Unable to write to ctags file.", e);
        }
    }

    private static Collection<? extends CTagsEntry> createCTagsFromMachines(RulesProject project) {
        ArrayList<CTagsEntry> list = new ArrayList<CTagsEntry>();
        for (IModel model : project.bModels) {
            RulesParseUnit parseUnit;
            if (!(model instanceof RulesParseUnit) || null == (parseUnit = (RulesParseUnit)model).getRulesMachineChecker()) continue;
            TIdentifierLiteral literal = parseUnit.getRulesMachineChecker().getNameLiteral();
            list.add(new CTagsEntry(literal.getText(), parseUnit.getPath(), literal.getStartPos(), TYPE_MACHINE));
        }
        return list;
    }

    private static Collection<? extends CTagsEntry> createCTagsEntryFromConstants(RulesProject project) {
        ArrayList<CTagsEntry> list = new ArrayList<CTagsEntry>();
        for (IModel model : project.bModels) {
            RulesParseUnit parseUnit;
            if (!(model instanceof RulesParseUnit) || null == (parseUnit = (RulesParseUnit)model).getRulesMachineChecker()) continue;
            for (TIdentifierLiteral literal : parseUnit.getRulesMachineChecker().getGlobalIdentifiers()) {
                list.add(new CTagsEntry(literal.getText(), parseUnit.getPath(), literal.getStartPos(), TYPE_IDENTIFIER));
            }
        }
        return list;
    }

    private static List<CTagsEntry> createCTagsEntryFromOperations(Collection<AbstractOperation> values) {
        ArrayList<CTagsEntry> list = new ArrayList<CTagsEntry>();
        for (AbstractOperation operation : values) {
            list.add(new CTagsEntry(operation.getOriginalName(), operation.getFileName(), operation.getNameLiteral().getStartPos(), TYPE_OPERATION));
        }
        return list;
    }

    static class CTagsEntry {
        private final SourcePosition srcPos;
        private final String file;
        private final String name;
        private final String type;

        CTagsEntry(String name, String file, SourcePosition sourcePosition, String type) {
            this.name = name;
            this.file = file;
            this.srcPos = sourcePosition;
            this.type = type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append("\t");
            sb.append(this.file).append("\t");
            sb.append("/^");
            for (int i = 1; i < this.srcPos.getPos(); ++i) {
                sb.append(" ");
            }
            sb.append(this.name);
            sb.append("$/;\"\t");
            sb.append(this.type).append("\t");
            sb.append("line:").append(this.srcPos.getLine()).append("\t");
            sb.append("language:brules");
            return sb.toString();
        }
    }
}

