/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.analysis.prolog.ClassicalPositionPrinter;
import de.be4.classicalb.core.parser.analysis.prolog.NodeFileNumbers;
import de.be4.classicalb.core.parser.analysis.prolog.PositionPrinter;
import de.be4.classicalb.core.parser.node.AAbstractConstantsContextClause;
import de.be4.classicalb.core.parser.node.AAbstractConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AAnySubstitution;
import de.be4.classicalb.core.parser.node.AAssertionsMachineClause;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.AAxiomsContextClause;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.ABooleanTrueExpression;
import de.be4.classicalb.core.parser.node.ACaseOrSubstitution;
import de.be4.classicalb.core.parser.node.ACaseSubstitution;
import de.be4.classicalb.core.parser.node.AChoiceSubstitution;
import de.be4.classicalb.core.parser.node.AComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AConcreteVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConstantsContextClause;
import de.be4.classicalb.core.parser.node.AConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AConstructorFreetypeConstructor;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.ADescriptionPragma;
import de.be4.classicalb.core.parser.node.AElementFreetypeConstructor;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AEvent;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.AEventBModelParseUnit;
import de.be4.classicalb.core.parser.node.AEventsModelClause;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.AExtendedExprExpression;
import de.be4.classicalb.core.parser.node.AExtendedPredPredicate;
import de.be4.classicalb.core.parser.node.AExtendsContextClause;
import de.be4.classicalb.core.parser.node.AExtendsMachineClause;
import de.be4.classicalb.core.parser.node.AFileMachineReference;
import de.be4.classicalb.core.parser.node.AFileMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AFreetype;
import de.be4.classicalb.core.parser.node.AFreetypesMachineClause;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AGeneralProductExpression;
import de.be4.classicalb.core.parser.node.AGeneralSumExpression;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIfElsifExprExpression;
import de.be4.classicalb.core.parser.node.AIfSubstitution;
import de.be4.classicalb.core.parser.node.AIfThenElseExpression;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.AImportsMachineClause;
import de.be4.classicalb.core.parser.node.AIncludesMachineClause;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AInvariantModelClause;
import de.be4.classicalb.core.parser.node.ALambdaExpression;
import de.be4.classicalb.core.parser.node.ALetExpressionExpression;
import de.be4.classicalb.core.parser.node.ALetPredicatePredicate;
import de.be4.classicalb.core.parser.node.ALetSubstitution;
import de.be4.classicalb.core.parser.node.ALocalOperationsMachineClause;
import de.be4.classicalb.core.parser.node.AMachineClauseParseUnit;
import de.be4.classicalb.core.parser.node.AMachineHeader;
import de.be4.classicalb.core.parser.node.AMachineReference;
import de.be4.classicalb.core.parser.node.AMachineReferenceNoParams;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.AOperationCallExpression;
import de.be4.classicalb.core.parser.node.AOperationCallSubstitution;
import de.be4.classicalb.core.parser.node.AOperationReference;
import de.be4.classicalb.core.parser.node.AOperationsMachineClause;
import de.be4.classicalb.core.parser.node.AOppatternParseUnit;
import de.be4.classicalb.core.parser.node.AParallelSubstitution;
import de.be4.classicalb.core.parser.node.APartitionPredicate;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.APrimedIdentifierExpression;
import de.be4.classicalb.core.parser.node.APromotesMachineClause;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ARecEntry;
import de.be4.classicalb.core.parser.node.ARecExpression;
import de.be4.classicalb.core.parser.node.ARecordFieldExpression;
import de.be4.classicalb.core.parser.node.ARefinedOperation;
import de.be4.classicalb.core.parser.node.ARefinementMachineParseUnit;
import de.be4.classicalb.core.parser.node.ASeesMachineClause;
import de.be4.classicalb.core.parser.node.ASeesModelClause;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASequenceExtensionExpression;
import de.be4.classicalb.core.parser.node.ASequenceSubstitution;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetsContextClause;
import de.be4.classicalb.core.parser.node.ASetsMachineClause;
import de.be4.classicalb.core.parser.node.AStructExpression;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionParseUnit;
import de.be4.classicalb.core.parser.node.ASymbolicComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.ASymbolicLambdaExpression;
import de.be4.classicalb.core.parser.node.ASymbolicQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ATheoremsContextClause;
import de.be4.classicalb.core.parser.node.ATheoremsModelClause;
import de.be4.classicalb.core.parser.node.AUsesMachineClause;
import de.be4.classicalb.core.parser.node.AValuesMachineClause;
import de.be4.classicalb.core.parser.node.AVarSubstitution;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AVariablesModelClause;
import de.be4.classicalb.core.parser.node.AWitness;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PEventstatus;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.Token;
import de.be4.classicalb.core.parser.util.Utils;
import de.prob.prolog.output.IPrologTermOutput;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ASTProlog
extends DepthFirstAdapter {
    private static final List<String> SUM_TYPE = Collections.unmodifiableList(Arrays.asList("expression", "predicate", "machine_clause", "substitution", "parse_unit", "model_clause", "context_clause", "eventstatus", "argpattern", "set", "machine_variant", "definition", "freetype_constructor"));
    private static final List<String> ATOMIC_TYPE = Collections.unmodifiableList(Arrays.asList("description_event", "description_machine_clause", "description_operation", "description_pragma", "event", "freetype", "machine_header", "machine_reference", "operation", "refined_operation", "rec_entry", "values_entry", "witness", "unit"));
    private final Map<Class<? extends Node>, String> simpleFormats = new HashMap<Class<? extends Node>, String>();
    private final PositionPrinter positionPrinter;
    private final IPrologTermOutput pout;

    public static void printFormula(Start start, IPrologTermOutput pout) {
        ClassicalPositionPrinter pprinter = new ClassicalPositionPrinter(new NodeFileNumbers());
        pprinter.setPrintSourcePositions(true, false);
        ASTProlog printer = new ASTProlog(pout, pprinter);
        start.apply(printer);
    }

    public ASTProlog(IPrologTermOutput pout, PositionPrinter positionPrinter) {
        this.positionPrinter = positionPrinter;
        this.pout = pout;
        if (positionPrinter != null) {
            positionPrinter.setPrologTermOutput(pout);
        }
    }

    @Override
    public void inStart(Start node) {
    }

    @Override
    public void outStart(Start node) {
    }

    @Override
    public void defaultIn(Node node) {
        this.open(node);
    }

    @Override
    public void defaultOut(Node node) {
        this.close(node);
    }

    private void open(Node node) {
        this.pout.openTerm(this.simpleFormat(node));
        this.printPosition(node);
    }

    private void printPosition(Node node) {
        if (this.positionPrinter != null) {
            this.positionPrinter.printPosition(node);
        } else {
            this.pout.printAtom("none");
        }
    }

    private void printPositionRange(Node startNode, Node endNode) {
        if (this.positionPrinter != null) {
            this.positionPrinter.printPositionRange(startNode, endNode);
        } else {
            this.pout.printAtom("none");
        }
    }

    private void printPositionRange(List<? extends Node> nodes, Node fallback) {
        if (!nodes.isEmpty()) {
            this.printPositionRange(nodes.get(0), nodes.get(nodes.size() - 1));
        } else if (fallback != null) {
            this.printPosition(fallback);
        } else {
            this.pout.printAtom("none");
        }
    }

    private void close(Node node) {
        this.pout.closeTerm();
    }

    private void printAsList(List<? extends Node> nodes) {
        this.pout.openList();
        for (Node node : nodes) {
            node.apply(this);
        }
        this.pout.closeList();
    }

    private void printOCAsList(Node node, List<? extends Node> list) {
        this.open(node);
        this.printAsList(list);
        this.close(node);
    }

    @Override
    public void defaultCase(Node node) {
        assert (node instanceof Token);
        this.pout.printAtom(((Token)node).getText());
    }

    @Override
    public void caseEOF(EOF node) {
    }

    private String simpleFormat(Node node) {
        Class<?> clazz = node.getClass();
        String formatted = this.simpleFormats.get(clazz);
        if (formatted == null) {
            formatted = this.toFunctorName(clazz.getSimpleName());
            this.simpleFormats.put(clazz, formatted);
        }
        return formatted;
    }

    private String toFunctorName(String className) {
        String camelName = this.formatCamel(className.substring(1)).substring(1);
        if (className.startsWith("T")) {
            return camelName;
        }
        if (className.startsWith("A")) {
            if (ATOMIC_TYPE.contains(camelName)) {
                return camelName;
            }
            for (String checkend : SUM_TYPE) {
                if (!camelName.endsWith(checkend)) continue;
                return camelName.substring(0, camelName.length() - checkend.length() - 1);
            }
        }
        throw new AssertionError((Object)("cannot determine functor name: " + className));
    }

    private String formatCamel(String input) {
        char[] chars;
        StringWriter out = new StringWriter();
        for (char current : chars = input.toCharArray()) {
            if (Character.isUpperCase(current)) {
                out.append('_');
                out.append(Character.toLowerCase(current));
                continue;
            }
            out.append(current);
        }
        return out.toString();
    }

    private void printIdentifier(List<TIdentifierLiteral> list) {
        this.pout.printAtom(Utils.getTIdentifierListAsString(list));
    }

    private void printPositionedIdentifier(List<TIdentifierLiteral> identifierParts) {
        if (identifierParts.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one token in a dotted identifier list");
        }
        this.pout.openTerm("identifier");
        this.printPositionRange(identifierParts, null);
        this.printIdentifier(identifierParts);
        this.pout.closeTerm();
    }

    private void printPositionedIdentifier(TIdentifierLiteral identifier) {
        this.pout.openTerm("identifier");
        this.printPosition(identifier);
        this.pout.printAtom(identifier.getText());
        this.pout.closeTerm();
    }

    private void printNullSafeSubstitution(Node subst) {
        if (subst == null) {
            this.pout.openTerm("skip");
            this.pout.printAtom("none");
            this.pout.closeTerm();
        } else {
            subst.apply(this);
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        this.open(node);
        this.printIdentifier(node.getIdentifier());
        this.close(node);
    }

    @Override
    public void caseAPrimedIdentifierExpression(APrimedIdentifierExpression node) {
        this.open(node);
        this.printIdentifier(node.getIdentifier());
        this.pout.printNumber(0L);
        this.close(node);
    }

    @Override
    public void caseAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        this.open(node);
        node.getVariant().apply(this);
        node.getHeader().apply(this);
        this.printAsList(node.getMachineClauses());
        this.close(node);
    }

    @Override
    public void caseARefinementMachineParseUnit(ARefinementMachineParseUnit node) {
        this.open(node);
        node.getHeader().apply(this);
        node.getRefMachine().apply(this);
        this.printAsList(node.getMachineClauses());
        this.close(node);
    }

    @Override
    public void caseAImplementationMachineParseUnit(AImplementationMachineParseUnit node) {
        this.open(node);
        node.getHeader().apply(this);
        node.getRefMachine().apply(this);
        this.printAsList(node.getMachineClauses());
        this.close(node);
    }

    @Override
    public void caseAMachineHeader(AMachineHeader node) {
        this.open(node);
        this.printIdentifier(node.getName());
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseAExtendedExprExpression(AExtendedExprExpression node) {
        this.open(node);
        this.pout.printAtom(node.getIdentifier().getText());
        this.printAsList(node.getExpressions());
        this.printAsList(node.getPredicates());
        this.close(node);
    }

    @Override
    public void caseAExtendedPredPredicate(AExtendedPredPredicate node) {
        this.open(node);
        this.pout.printAtom(node.getIdentifier().getText());
        this.printAsList(node.getExpressions());
        this.printAsList(node.getPredicates());
        this.close(node);
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
        this.printOCAsList(node, node.getDefinitions());
    }

    @Override
    public void caseASeesMachineClause(ASeesMachineClause node) {
        this.printOCAsList(node, node.getMachineNames());
    }

    @Override
    public void caseAPromotesMachineClause(APromotesMachineClause node) {
        this.printOCAsList(node, node.getOperationNames());
    }

    @Override
    public void caseAUsesMachineClause(AUsesMachineClause node) {
        this.printOCAsList(node, node.getMachineNames());
    }

    @Override
    public void caseAIncludesMachineClause(AIncludesMachineClause node) {
        this.printOCAsList(node, node.getMachineReferences());
    }

    @Override
    public void caseAExtendsMachineClause(AExtendsMachineClause node) {
        this.printOCAsList(node, node.getMachineReferences());
    }

    @Override
    public void caseAImportsMachineClause(AImportsMachineClause node) {
        this.printOCAsList(node, node.getMachineReferences());
    }

    @Override
    public void caseASetsMachineClause(ASetsMachineClause node) {
        this.printOCAsList(node, node.getSetDefinitions());
    }

    @Override
    public void caseAVariablesMachineClause(AVariablesMachineClause node) {
        this.printOCAsList(node, node.getIdentifiers());
    }

    @Override
    public void caseAConcreteVariablesMachineClause(AConcreteVariablesMachineClause node) {
        this.printOCAsList(node, node.getIdentifiers());
    }

    @Override
    public void caseAAbstractConstantsMachineClause(AAbstractConstantsMachineClause node) {
        this.printOCAsList(node, node.getIdentifiers());
    }

    @Override
    public void caseAConstantsMachineClause(AConstantsMachineClause node) {
        this.printOCAsList(node, node.getIdentifiers());
    }

    @Override
    public void caseAAssertionsMachineClause(AAssertionsMachineClause node) {
        this.printOCAsList(node, node.getPredicates());
    }

    @Override
    public void caseAValuesMachineClause(AValuesMachineClause node) {
        this.printOCAsList(node, node.getEntries());
    }

    @Override
    public void caseALocalOperationsMachineClause(ALocalOperationsMachineClause node) {
        this.printOCAsList(node, node.getOperations());
    }

    @Override
    public void caseAOperationsMachineClause(AOperationsMachineClause node) {
        this.printOCAsList(node, node.getOperations());
    }

    @Override
    public void caseAMachineReferenceNoParams(AMachineReferenceNoParams node) {
        this.printPositionedIdentifier(node.getMachineName());
    }

    @Override
    public void caseAMachineReference(AMachineReference node) {
        this.open(node);
        this.printIdentifier(node.getMachineName());
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseAOperationReference(AOperationReference node) {
        this.printPositionedIdentifier(node.getOperationName());
    }

    @Override
    public void caseADescriptionPragma(ADescriptionPragma node) {
        this.pout.openTerm("description_text");
        this.printPositionRange(node.getParts(), (Node)node);
        this.pout.printAtom(node.getParts().stream().map(Token::getText).collect(Collectors.joining()));
        this.pout.closeTerm();
    }

    @Override
    public void caseAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.open(node);
        node.getName().apply(this);
        this.printAsList(node.getParameters());
        node.getRhs().apply(this);
        this.close(node);
    }

    @Override
    public void caseASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.open(node);
        node.getName().apply(this);
        this.printAsList(node.getParameters());
        node.getRhs().apply(this);
        this.close(node);
    }

    @Override
    public void caseAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.open(node);
        node.getName().apply(this);
        this.printAsList(node.getParameters());
        node.getRhs().apply(this);
        this.close(node);
    }

    @Override
    public void caseAEnumeratedSetSet(AEnumeratedSetSet node) {
        this.open(node);
        this.printIdentifier(node.getIdentifier());
        this.printAsList(node.getElements());
        this.close(node);
    }

    @Override
    public void caseAOperation(AOperation node) {
        this.open(node);
        this.printPositionedIdentifier(node.getOpName());
        this.printAsList(node.getReturnValues());
        this.printAsList(node.getParameters());
        node.getOperationBody().apply(this);
        this.close(node);
    }

    @Override
    public void caseARefinedOperation(ARefinedOperation node) {
        this.open(node);
        this.printPositionedIdentifier(node.getOpName());
        this.printAsList(node.getReturnValues());
        this.printAsList(node.getParameters());
        node.getAbOpName().apply(this);
        node.getOperationBody().apply(this);
        this.close(node);
    }

    @Override
    public void caseAConjunctPredicate(AConjunctPredicate node) {
        this.open(node);
        LinkedList<PPredicate> conjunctPreds = new LinkedList<PPredicate>();
        AConjunctPredicate currentNode = node;
        while (currentNode.getLeft() instanceof AConjunctPredicate) {
            conjunctPreds.addFirst(currentNode.getRight());
            currentNode = (AConjunctPredicate)currentNode.getLeft();
        }
        conjunctPreds.addFirst(currentNode.getRight());
        conjunctPreds.addFirst(currentNode.getLeft());
        this.pout.openList();
        for (PPredicate pred : conjunctPreds) {
            pred.apply(this);
        }
        this.pout.closeList();
        this.close(node);
    }

    @Override
    public void caseAForallPredicate(AForallPredicate node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getImplication().apply(this);
        this.close(node);
    }

    @Override
    public void caseAExistsPredicate(AExistsPredicate node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicate().apply(this);
        this.close(node);
    }

    @Override
    public void caseADefinitionPredicate(ADefinitionPredicate node) {
        this.open(node);
        node.getDefLiteral().apply(this);
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseALetPredicatePredicate(ALetPredicatePredicate node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getAssignment().apply(this);
        node.getPred().apply(this);
        this.close(node);
    }

    @Override
    public void caseALetExpressionExpression(ALetExpressionExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getAssignment().apply(this);
        node.getExpr().apply(this);
        this.close(node);
    }

    @Override
    public void caseAIfThenElseExpression(AIfThenElseExpression node) {
        this.open(node);
        node.getCondition().apply(this);
        node.getThen().apply(this);
        for (PExpression expr : node.getElsifs()) {
            AIfElsifExprExpression elsIf = (AIfElsifExprExpression)expr;
            this.pout.openTerm(this.simpleFormat(node));
            this.printPosition(elsIf);
            elsIf.getCondition().apply(this);
            elsIf.getThen().apply(this);
        }
        node.getElse().apply(this);
        for (PExpression ignored : node.getElsifs()) {
            this.pout.closeTerm();
        }
        this.close(node);
    }

    @Override
    public void caseAGeneralSumExpression(AGeneralSumExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.close(node);
    }

    @Override
    public void caseAGeneralProductExpression(AGeneralProductExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.close(node);
    }

    @Override
    public void caseACoupleExpression(ACoupleExpression node) {
        if (node.getList().size() < 2) {
            throw new IllegalArgumentException("ACoupleExpression must have at least 2 elements, but got " + node.getList().size());
        }
        this.printOCAsList(node, node.getList());
    }

    @Override
    public void caseAComprehensionSetExpression(AComprehensionSetExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicates().apply(this);
        this.close(node);
    }

    @Override
    public void caseASymbolicComprehensionSetExpression(ASymbolicComprehensionSetExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicates().apply(this);
        this.close(node);
    }

    @Override
    public void caseAEventBComprehensionSetExpression(AEventBComprehensionSetExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getExpression().apply(this);
        node.getPredicates().apply(this);
        this.close(node);
    }

    @Override
    public void caseASymbolicEventBComprehensionSetExpression(ASymbolicEventBComprehensionSetExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getExpression().apply(this);
        node.getPredicates().apply(this);
        this.close(node);
    }

    @Override
    public void caseASetExtensionExpression(ASetExtensionExpression node) {
        this.printOCAsList(node, node.getExpressions());
    }

    @Override
    public void caseAQuantifiedUnionExpression(AQuantifiedUnionExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.close(node);
    }

    @Override
    public void caseASymbolicQuantifiedUnionExpression(ASymbolicQuantifiedUnionExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.close(node);
    }

    @Override
    public void caseAQuantifiedIntersectionExpression(AQuantifiedIntersectionExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicates().apply(this);
        node.getExpression().apply(this);
        this.close(node);
    }

    @Override
    public void caseALambdaExpression(ALambdaExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicate().apply(this);
        node.getExpression().apply(this);
        this.close(node);
    }

    @Override
    public void caseASymbolicLambdaExpression(ASymbolicLambdaExpression node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicate().apply(this);
        node.getExpression().apply(this);
        this.close(node);
    }

    @Override
    public void caseASequenceExtensionExpression(ASequenceExtensionExpression node) {
        this.printOCAsList(node, node.getExpression());
    }

    @Override
    public void caseAFunctionExpression(AFunctionExpression node) {
        this.open(node);
        node.getIdentifier().apply(this);
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseARecExpression(ARecExpression node) {
        this.printOCAsList(node, node.getEntries());
    }

    @Override
    public void caseAStructExpression(AStructExpression node) {
        this.printOCAsList(node, node.getEntries());
    }

    @Override
    public void caseARecordFieldExpression(ARecordFieldExpression node) {
        this.open(node);
        node.getRecord().apply(this);
        this.printPositionedIdentifier(node.getIdentifier());
        this.close(node);
    }

    @Override
    public void caseAIntegerExpression(AIntegerExpression node) {
        this.open(node);
        String text = node.getLiteral().getText();
        if (text.length() <= 18) {
            this.pout.printNumber(Long.parseLong(text));
        } else {
            this.pout.printNumber(new BigInteger(text));
        }
        this.close(node);
    }

    @Override
    public void caseADefinitionExpression(ADefinitionExpression node) {
        this.open(node);
        node.getDefLiteral().apply(this);
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseARecEntry(ARecEntry node) {
        this.open(node);
        this.printPositionedIdentifier(node.getIdentifier());
        node.getValue().apply(this);
        this.close(node);
    }

    @Override
    public void caseAAssignSubstitution(AAssignSubstitution node) {
        this.open(node);
        this.printAsList(node.getLhsExpression());
        this.printAsList(node.getRhsExpressions());
        this.close(node);
    }

    @Override
    public void caseAChoiceSubstitution(AChoiceSubstitution node) {
        this.printOCAsList(node, node.getSubstitutions());
    }

    @Override
    public void caseAIfSubstitution(AIfSubstitution node) {
        this.open(node);
        node.getCondition().apply(this);
        node.getThen().apply(this);
        this.printAsList(node.getElsifSubstitutions());
        this.printNullSafeSubstitution(node.getElse());
        this.close(node);
    }

    @Override
    public void caseASelectSubstitution(ASelectSubstitution node) {
        this.open(node);
        node.getCondition().apply(this);
        node.getThen().apply(this);
        this.printAsList(node.getWhenSubstitutions());
        PSubstitution elsenode = node.getElse();
        if (elsenode != null) {
            elsenode.apply(this);
        }
        this.close(node);
    }

    @Override
    public void caseACaseSubstitution(ACaseSubstitution node) {
        this.open(node);
        node.getExpression().apply(this);
        this.printAsList(node.getEitherExpr());
        node.getEitherSubst().apply(this);
        this.printAsList(node.getOrSubstitutions());
        this.printNullSafeSubstitution(node.getElse());
        this.close(node);
    }

    @Override
    public void caseACaseOrSubstitution(ACaseOrSubstitution node) {
        this.open(node);
        this.printAsList(node.getExpressions());
        node.getSubstitution().apply(this);
        this.close(node);
    }

    @Override
    public void caseAAnySubstitution(AAnySubstitution node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getWhere().apply(this);
        node.getThen().apply(this);
        this.close(node);
    }

    @Override
    public void caseALetSubstitution(ALetSubstitution node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicate().apply(this);
        node.getSubstitution().apply(this);
        this.close(node);
    }

    @Override
    public void caseABecomesElementOfSubstitution(ABecomesElementOfSubstitution node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getSet().apply(this);
        this.close(node);
    }

    @Override
    public void caseABecomesSuchSubstitution(ABecomesSuchSubstitution node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getPredicate().apply(this);
        this.close(node);
    }

    @Override
    public void caseAVarSubstitution(AVarSubstitution node) {
        this.open(node);
        this.printAsList(node.getIdentifiers());
        node.getSubstitution().apply(this);
        this.close(node);
    }

    @Override
    public void caseASequenceSubstitution(ASequenceSubstitution node) {
        this.printOCAsList(node, node.getSubstitutions());
    }

    @Override
    public void caseAOperationCallSubstitution(AOperationCallSubstitution node) {
        this.open(node);
        this.printPositionedIdentifier(node.getOperation());
        this.printAsList(node.getResultIdentifiers());
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseAOperationCallExpression(AOperationCallExpression node) {
        this.open(node);
        this.printPositionedIdentifier(node.getOperation());
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseAParallelSubstitution(AParallelSubstitution node) {
        this.printOCAsList(node, node.getSubstitutions());
    }

    @Override
    public void caseADefinitionSubstitution(ADefinitionSubstitution node) {
        this.open(node);
        node.getDefLiteral().apply(this);
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseABooleanTrueExpression(ABooleanTrueExpression node) {
        this.pout.openTerm("boolean_true");
        this.printPosition(node);
        this.pout.closeTerm();
    }

    @Override
    public void caseAPartitionPredicate(APartitionPredicate node) {
        this.open(node);
        node.getSet().apply(this);
        this.printAsList(node.getElements());
        this.close(node);
    }

    @Override
    public void caseAExpressionParseUnit(AExpressionParseUnit node) {
        node.getExpression().apply(this);
    }

    @Override
    public void caseAMachineClauseParseUnit(AMachineClauseParseUnit node) {
        node.getMachineClause().apply(this);
    }

    @Override
    public void caseAPredicateParseUnit(APredicateParseUnit node) {
        node.getPredicate().apply(this);
    }

    @Override
    public void caseASubstitutionParseUnit(ASubstitutionParseUnit node) {
        node.getSubstitution().apply(this);
    }

    @Override
    public void caseAEventBModelParseUnit(AEventBModelParseUnit node) {
        this.open(node);
        node.getName().apply(this);
        this.printAsList(node.getModelClauses());
        this.close(node);
    }

    @Override
    public void caseAVariablesModelClause(AVariablesModelClause node) {
        this.printOCAsList(node, node.getIdentifiers());
    }

    @Override
    public void caseASeesModelClause(ASeesModelClause node) {
        this.printOCAsList(node, node.getSees());
    }

    @Override
    public void caseAInvariantModelClause(AInvariantModelClause node) {
        this.printOCAsList(node, node.getPredicates());
    }

    @Override
    public void caseATheoremsModelClause(ATheoremsModelClause node) {
        this.printOCAsList(node, node.getPredicates());
    }

    @Override
    public void caseAEventsModelClause(AEventsModelClause node) {
        this.printOCAsList(node, node.getEvent());
    }

    @Override
    public void caseAEvent(AEvent node) {
        this.open(node);
        node.getEventName().apply(this);
        PEventstatus status = node.getStatus();
        if (status != null) {
            status.apply(this);
        }
        this.printAsList(node.getRefines());
        this.printAsList(node.getVariables());
        this.printAsList(node.getGuards());
        this.printAsList(node.getTheorems());
        this.printAsList(node.getAssignments());
        this.printAsList(node.getWitness());
        this.close(node);
    }

    @Override
    public void caseAWitness(AWitness node) {
        this.open(node);
        this.printPositionedIdentifier(node.getName());
        node.getPredicate().apply(this);
        this.close(node);
    }

    @Override
    public void caseAEventBContextParseUnit(AEventBContextParseUnit node) {
        this.open(node);
        node.getName().apply(this);
        this.printAsList(node.getContextClauses());
        this.close(node);
    }

    @Override
    public void caseAExtendsContextClause(AExtendsContextClause node) {
        this.printOCAsList(node, node.getExtends());
    }

    @Override
    public void caseASetsContextClause(ASetsContextClause node) {
        this.printOCAsList(node, node.getSet());
    }

    @Override
    public void caseAConstantsContextClause(AConstantsContextClause node) {
        this.printOCAsList(node, node.getIdentifiers());
    }

    @Override
    public void caseAAbstractConstantsContextClause(AAbstractConstantsContextClause node) {
        this.printOCAsList(node, node.getIdentifiers());
    }

    @Override
    public void caseAAxiomsContextClause(AAxiomsContextClause node) {
        this.printOCAsList(node, node.getPredicates());
    }

    @Override
    public void caseATheoremsContextClause(ATheoremsContextClause node) {
        this.printOCAsList(node, node.getPredicates());
    }

    @Override
    public void caseAOppatternParseUnit(AOppatternParseUnit node) {
        this.open(node);
        this.printIdentifier(node.getName());
        this.printAsList(node.getParameters());
        this.close(node);
    }

    @Override
    public void caseAFreetypesMachineClause(AFreetypesMachineClause node) {
        this.printOCAsList(node, node.getFreetypes());
    }

    @Override
    public void caseAFreetype(AFreetype node) {
        this.open(node);
        this.pout.printAtom(node.getName().getText());
        this.printAsList(node.getParameters());
        this.printAsList(node.getConstructors());
        this.close(node);
    }

    @Override
    public void caseAConstructorFreetypeConstructor(AConstructorFreetypeConstructor node) {
        this.open(node);
        this.pout.printAtom(node.getName().getText());
        node.getArgument().apply(this);
        this.close(node);
    }

    @Override
    public void caseAElementFreetypeConstructor(AElementFreetypeConstructor node) {
        this.open(node);
        this.pout.printAtom(node.getName().getText());
        this.close(node);
    }

    @Override
    public void caseAFileMachineReferenceNoParams(AFileMachineReferenceNoParams node) {
        node.getReference().apply(this);
    }

    @Override
    public void caseAFileMachineReference(AFileMachineReference node) {
        node.getReference().apply(this);
    }
}

