/*
 * Decompiled with CFR 0.152.
 */
package de.tla2bAst;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.prolog.RecursiveMachineLoader;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.PreParseException;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.PrettyPrinter;
import de.hhu.stups.sablecc.patch.PositionedNode;
import de.prob.prolog.output.PrologTermOutput;
import de.tla2b.analysis.InstanceTransformation;
import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.analysis.SymbolRenamer;
import de.tla2b.analysis.SymbolSorter;
import de.tla2b.analysis.TypeChecker;
import de.tla2b.config.ConfigfileEvaluator;
import de.tla2b.config.ModuleOverrider;
import de.tla2b.exceptions.TLA2BException;
import de.tla2b.exceptions.TLA2BFrontEndException;
import de.tla2b.global.TranslationGlobals;
import de.tla2b.output.TlaTypePrinter;
import de.tla2b.types.TLAType;
import de.tla2b.util.FileUtils;
import de.tla2bAst.BAstCreator;
import de.tla2bAst.ExpressionTranslator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ModuleNode;
import tlc2.tool.impl.ModelConfig;
import util.ToolIO;

public class Translator {
    private static final String GENERATED_BY_TLA2B_HEADER_OLD = "/*@ generated by TLA2B ";
    private static final String GENERATED_BY_TLA2B_HEADER = "/* @generated by TLA2B ";
    private String parentPath;
    private File moduleFile;
    private File configFile;
    private List<File> moduleFiles = new ArrayList<File>();
    private BAstCreator bAstCreator;
    private ModuleNode moduleNode;
    private ModelConfig modelConfig;
    private SpecAnalyser specAnalyser;
    private TypeChecker typechecker;

    public Translator(String moduleFileName) throws TLA2BFrontEndException {
        this.moduleFile = new File(moduleFileName);
        if (!this.moduleFile.exists()) {
            throw new RuntimeException("Can not find module file: '" + moduleFileName + "'");
        }
        try {
            this.moduleFile = this.moduleFile.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Can not access module file: '" + moduleFileName + "'");
        }
        this.parentPath = this.moduleFile.getParent() == null ? "." : this.moduleFile.getParent();
        this.configFile = new File(FileUtils.removeExtension(this.moduleFile.getAbsolutePath()) + ".cfg");
        if (!this.configFile.exists()) {
            this.configFile = null;
        }
        this.parse();
    }

    public static String translateModuleString(String moduleName, String moduleString, String configString) throws TLA2BException {
        Translator translator = new Translator(moduleName, moduleString, configString);
        Start bAST = translator.getBAST();
        PrettyPrinter pp = new PrettyPrinter();
        bAST.apply(pp);
        return pp.getPrettyPrint();
    }

    public Translator(String moduleName, String moduleString, String configString) throws TLA2BException {
        this.createTLATempFile(moduleString, moduleName);
        this.createCfgFile(configString, moduleName);
        this.parse();
        this.translate();
    }

    public Translator(String moduleString, String configString) throws TLA2BFrontEndException {
        String moduleName = "Testing";
        this.createTLATempFile(moduleString, moduleName);
        this.createCfgFile(configString, moduleName);
        this.parse();
    }

    private void createTLATempFile(String moduleString, String moduleName) {
        File dir = new File("temp/");
        dir.mkdirs();
        dir.deleteOnExit();
        this.moduleFile = new File("temp/" + moduleName + ".tla");
        try (BufferedWriter out = Files.newBufferedWriter(this.moduleFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(moduleString);
        }
        catch (IOException e) {
            System.err.println("Error while writing file '" + this.moduleFile.getAbsolutePath() + "':\n" + e.getMessage());
        }
    }

    private void createCfgFile(String configString, String moduleName) {
        this.modelConfig = null;
        if (configString != null) {
            this.configFile = new File("temp/" + moduleName + ".cfg");
            try (BufferedWriter out = Files.newBufferedWriter(this.configFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                out.write(configString);
            }
            catch (IOException e) {
                System.err.println("Error while writing file '" + this.configFile.getAbsolutePath() + "':\n" + e.getMessage());
            }
        }
    }

    private void parse() throws TLA2BFrontEndException {
        this.moduleNode = this.parseModule();
        if (this.configFile != null) {
            this.modelConfig = new ModelConfig(this.configFile.getName(), null);
            this.modelConfig.parse();
        }
    }

    public ModuleNode parseModule() throws TLA2BFrontEndException {
        String fileName = this.moduleFile.getName();
        ToolIO.setUserDir(this.moduleFile.getParent());
        SpecObj spec = new SpecObj(fileName, null);
        try {
            SANY.frontEndMain(spec, fileName, ToolIO.out);
        }
        catch (FrontEndException e) {
            throw new RuntimeException("Could not parse module: '" + fileName + "'", e);
        }
        if (spec.getParseErrors().isFailure()) {
            throw new TLA2BFrontEndException(Translator.allMessagesToString(ToolIO.getAllMessages()) + spec.getParseErrors(), spec);
        }
        if (spec.getSemanticErrors().isFailure()) {
            throw new TLA2BFrontEndException(Translator.allMessagesToString(ToolIO.getAllMessages()) + spec.getSemanticErrors(), spec);
        }
        ModuleNode n = spec.getExternalModuleTable().getRootModule();
        if (spec.getInitErrors().isFailure()) {
            throw new TLA2BFrontEndException(spec.getInitErrors().toString(), spec);
        }
        if (n == null) {
            throw new TLA2BFrontEndException(Translator.allMessagesToString(ToolIO.getAllMessages()), spec);
        }
        return n;
    }

    public static String allMessagesToString(String[] allMessages) {
        return String.join((CharSequence)"\n", allMessages) + "\n";
    }

    public Start translate() throws TLA2BException {
        InstanceTransformation.run(this.moduleNode);
        SymbolSorter.sort(this.moduleNode);
        ConfigfileEvaluator conEval = null;
        if (this.modelConfig != null) {
            conEval = new ConfigfileEvaluator(this.modelConfig, this.moduleNode);
            ModuleOverrider.run(this.moduleNode, conEval);
            this.specAnalyser = SpecAnalyser.createSpecAnalyser(this.moduleNode, conEval);
        } else {
            this.specAnalyser = SpecAnalyser.createSpecAnalyser(this.moduleNode);
        }
        this.specAnalyser.start();
        this.typechecker = new TypeChecker(this.moduleNode, conEval, this.specAnalyser);
        this.typechecker.start();
        SymbolRenamer.run(this.moduleNode, this.specAnalyser);
        this.bAstCreator = new BAstCreator(this.moduleNode, conEval, this.specAnalyser);
        this.moduleFiles = this.bAstCreator.getFilesOrderedById().stream().map(file -> new File(this.parentPath, file + ".tla")).collect(Collectors.toList());
        return this.getBAST();
    }

    public void createProbFile() {
        File probFile = new File(FileUtils.removeExtension(this.moduleFile.getAbsolutePath()) + ".prob");
        BParser bParser = new BParser();
        try (BufferedWriter outWriter = Files.newBufferedWriter(probFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            bParser.getDefinitions().addDefinitions(this.getBDefinitions());
            RecursiveMachineLoader rml = this.parseAllMachines(this.getBAST(), this.getModuleFile(), bParser);
            rml.printAsProlog(new PrologTermOutput(outWriter, false));
            System.out.println(probFile.getAbsolutePath() + " created.");
        }
        catch (BCompoundException | PreParseException | IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    public void createMachineFile() {
        File machineFile = new File(FileUtils.removeExtension(this.moduleFile.getAbsolutePath()) + "_tla.txt");
        if (machineFile.exists()) {
            try (BufferedReader in = new BufferedReader(new FileReader(machineFile));){
                boolean generatedByTLA2B;
                String firstLine = in.readLine();
                boolean bl = generatedByTLA2B = firstLine != null && (firstLine.startsWith(GENERATED_BY_TLA2B_HEADER_OLD) || firstLine.startsWith(GENERATED_BY_TLA2B_HEADER));
                if (!generatedByTLA2B) {
                    System.err.println("Error: File " + machineFile.getName() + " already exists and was not generated by TLA2B.\nDelete or move this file.");
                    System.exit(-1);
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
        }
        PrettyPrinter pp = new PrettyPrinter();
        this.getBAST().apply(pp);
        try (BufferedWriter out = Files.newBufferedWriter(machineFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(GENERATED_BY_TLA2B_HEADER + TranslationGlobals.VERSION_NUMBER + " */\n" + pp.getPrettyPrint());
            System.out.println("B-Machine " + machineFile.getAbsolutePath() + " created.");
        }
        catch (IOException e) {
            System.err.println("Error while creating file '" + machineFile.getAbsolutePath() + "':\n" + e.getMessage());
            System.exit(-1);
        }
    }

    public RecursiveMachineLoader parseAllMachines(Start ast, File f, BParser bparser) throws BCompoundException {
        RecursiveMachineLoader rml = new RecursiveMachineLoader(this.parentPath, bparser.getContentProvider());
        rml.loadAllMachines(f, ast, bparser.getDefinitions());
        rml.getMachineFilesLoaded().clear();
        rml.getMachineFilesLoaded().addAll(this.moduleFiles);
        for (PositionedNode node : this.bAstCreator.getSourcePositions()) {
            rml.getNodeIdMapping().assignIdentifiers(this.bAstCreator.getNodeFileNumbers().lookupFileNumber((Node)node), (Node)node);
        }
        rml.setPositionPrinter(new TlaTypePrinter(rml.getNodeIdMapping(), this.bAstCreator.getTypes()));
        return rml;
    }

    public Start translateExpressionIncludingModel(String tlaExpression) {
        return ExpressionTranslator.translate(tlaExpression, this);
    }

    @Deprecated
    public Start translateExpression(String tlaExpression) {
        return this.translateExpressionIncludingModel(tlaExpression);
    }

    public static Start translateExpressionWithoutModel(String tlaExpression) {
        return ExpressionTranslator.translate(tlaExpression);
    }

    @Deprecated
    public static Start translateTlaExpression(String tlaExpression) {
        return Translator.translateExpressionWithoutModel(tlaExpression);
    }

    public IDefinitions getBDefinitions() {
        return this.bAstCreator.getBDefinitions();
    }

    public ModuleNode getModuleNode() {
        return this.moduleNode;
    }

    protected TypeChecker getTypeChecker() {
        return this.typechecker;
    }

    protected SpecAnalyser getSpecAnalyser() {
        return this.specAnalyser;
    }

    public Start getBAST() {
        return this.bAstCreator.getStartNode();
    }

    public File getModuleFile() {
        return this.moduleFile;
    }

    public List<File> getModuleFiles() {
        return Collections.unmodifiableList(this.moduleFiles);
    }

    public Map<Node, TLAType> getTypes() {
        return this.bAstCreator.getTypes();
    }
}

