/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.types;

import de.be4.classicalb.core.parser.node.PExpression;
import de.tla2b.exceptions.UnificationException;
import de.tla2b.output.TypeVisitorInterface;
import de.tla2b.types.AbstractHasFollowers;
import de.tla2b.types.SetType;
import de.tla2b.types.StringType;
import de.tla2b.types.StructType;
import de.tla2b.types.TLAType;
import de.tla2b.types.TupleType;
import de.tla2b.types.UntypedType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class StructOrFunctionType
extends AbstractHasFollowers {
    private final Map<String, TLAType> types = new LinkedHashMap<String, TLAType>();

    public StructOrFunctionType(String name, TLAType type) {
        super(STRUCT_OR_FUNCTION);
        this.types.put(name, type);
    }

    public StructOrFunctionType() {
        super(STRUCT_OR_FUNCTION);
    }

    public void setNewType(TLAType oldType, TLAType newType) {
        this.types.forEach((name, type) -> {
            if (type == oldType) {
                this.types.put((String)name, newType);
                if (newType instanceof AbstractHasFollowers) {
                    ((AbstractHasFollowers)newType).addFollower(this);
                }
            }
        });
        this.testRecord();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StructOrFunction(");
        Iterator<String> keys = this.types.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            sb.append("\"").append(key).append("\"");
            sb.append(" : ").append(this.types.get(key));
            if (!keys.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean compare(TLAType o) {
        if (this.contains(o) || o.contains(this)) {
            return false;
        }
        if (o.getKind() == UNTYPED) {
            return true;
        }
        if (o instanceof StructType) {
            StructType s = (StructType)o;
            for (String fieldName : this.types.keySet()) {
                if (!s.getFields().contains(fieldName) || this.types.get(fieldName).compare(s.getType(fieldName))) continue;
                return false;
            }
            return true;
        }
        if (o instanceof StructOrFunctionType) {
            StructOrFunctionType s = (StructOrFunctionType)o;
            for (String fieldName : this.types.keySet()) {
                if (!s.types.containsKey(fieldName) || this.types.get(fieldName).compare(s.types.get(fieldName))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(TLAType o) {
        for (String fieldName : this.types.keySet()) {
            TLAType type = this.types.get(fieldName);
            if (!type.equals(o) && !type.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUntyped() {
        return true;
    }

    @Override
    public TLAType cloneTLAType() {
        StructOrFunctionType res = new StructOrFunctionType();
        for (String field : this.types.keySet()) {
            res.types.put(field, this.types.get(field));
        }
        return res;
    }

    @Override
    public TLAType unify(TLAType o) throws UnificationException {
        if (!this.compare(o)) {
            throw new UnificationException();
        }
        if (o instanceof UntypedType) {
            ((UntypedType)o).setFollowersTo(this);
            return this;
        }
        if (o instanceof SetType) {
            Iterator<TLAType> itr = this.types.values().iterator();
            TLAType temp = itr.next();
            while (itr.hasNext()) {
                temp = temp.unify(itr.next());
            }
            SetType found = new SetType(new TupleType(Arrays.asList(StringType.getInstance(), temp)));
            return found.unify(o);
        }
        if (o instanceof StructType) {
            StructType res = StructType.getIncompleteStruct();
            for (String field : this.types.keySet()) {
                res.add(field, this.types.get(field));
            }
            return o.unify(res);
        }
        if (o instanceof StructOrFunctionType) {
            StructOrFunctionType other = (StructOrFunctionType)o;
            for (String field : other.types.keySet()) {
                TLAType type = other.types.get(field);
                if (this.types.containsKey(field)) {
                    TLAType res = this.types.get(field).unify(type);
                    this.types.put(field, res);
                    continue;
                }
                if (type instanceof AbstractHasFollowers) {
                    ((AbstractHasFollowers)type).addFollower(this);
                }
                this.types.put(field, type);
            }
            return this.testRecord();
        }
        return this;
    }

    private TLAType testRecord() {
        Iterator<TLAType> itr = this.types.values().iterator();
        TLAType temp = itr.next().cloneTLAType();
        while (itr.hasNext()) {
            TLAType next = itr.next().cloneTLAType();
            try {
                temp.unify(next);
            }
            catch (UnificationException e) {
                StructType res = new StructType();
                for (String field : this.types.keySet()) {
                    res.add(field, this.types.get(field));
                }
                this.setFollowersTo(res);
                return res;
            }
        }
        return this;
    }

    public SetType getFunction() {
        Iterator<TLAType> itr = this.types.values().iterator();
        return new SetType(new TupleType(Arrays.asList(StringType.getInstance(), itr.next())));
    }

    @Override
    public PExpression getBNode() {
        throw new UnsupportedOperationException("StructOrFunctionType has no corresponding B node");
    }

    @Override
    public void apply(TypeVisitorInterface visitor) {
        visitor.caseStructOrFunction(this);
    }
}

