/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.types;

import de.tla2b.analysis.TypeChecker;
import de.tla2b.types.FunctionType;
import de.tla2b.types.SetType;
import de.tla2b.types.StructOrFunctionType;
import de.tla2b.types.StructType;
import de.tla2b.types.TLAType;
import de.tla2b.types.TupleOrFunction;
import de.tla2b.types.TupleType;
import java.util.ArrayList;
import java.util.List;
import tla2sany.semantic.SemanticNode;

public abstract class AbstractHasFollowers
extends TLAType {
    private List<Object> followers = null;

    public AbstractHasFollowers(int t) {
        super(t);
    }

    public void addFollower(Object o) {
        if (this.followers == null) {
            this.followers = new ArrayList<Object>();
        }
        if (!this.followers.contains(o)) {
            this.followers.add(o);
        }
    }

    public void deleteFollowers() {
        this.followers = null;
    }

    public void removeFollower(Object o) {
        if (this.hasFollowers()) {
            this.followers.remove(o);
        }
    }

    protected void setFollowersTo(TLAType newType) {
        if (!this.hasFollowers()) {
            return;
        }
        new ArrayList<Object>(this.followers).forEach(follower -> {
            if (follower instanceof SemanticNode) {
                TypeChecker.updateTypeAndFollowers((SemanticNode)follower, this, newType);
            } else if (follower instanceof SetType) {
                ((SetType)follower).update(this, newType);
            } else if (follower instanceof TupleType) {
                ((TupleType)follower).update(this, newType);
            } else if (follower instanceof FunctionType) {
                ((FunctionType)follower).update(this, newType);
            } else if (follower instanceof StructType) {
                ((StructType)follower).setNewType(this, newType);
            } else if (follower instanceof StructOrFunctionType) {
                ((StructOrFunctionType)follower).setNewType(this, newType);
            } else if (follower instanceof TupleOrFunction) {
                ((TupleOrFunction)follower).setNewType(this, newType);
            } else {
                throw new RuntimeException("Unknown follower type: " + follower.getClass());
            }
        });
    }

    public boolean hasFollowers() {
        return this.followers != null && !this.followers.isEmpty();
    }
}

