/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.output;

import de.prob.prolog.term.PrologTerm;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Consumer;

public interface IPrologTermOutput {
    default public IPrologTermOutput openTerm(String functor) {
        return this.openTerm(functor, false);
    }

    public IPrologTermOutput openTerm(String var1, boolean var2);

    public IPrologTermOutput closeTerm();

    default public IPrologTermOutput term(String functor, Consumer<? super IPrologTermOutput> scope) {
        scope.accept(this.openTerm(functor));
        return this.closeTerm();
    }

    default public IPrologTermOutput term(String functor, boolean ignoreIndentation, Consumer<? super IPrologTermOutput> scope) {
        scope.accept(this.openTerm(functor, ignoreIndentation));
        return this.closeTerm();
    }

    public IPrologTermOutput printAtom(String var1);

    default public IPrologTermOutput printAtomOrNumber(String content) {
        Objects.requireNonNull(content, "Atom or Number value is null");
        try {
            long n = Long.parseLong(content);
            return this.printNumber(n);
        }
        catch (NumberFormatException ignored) {
            return this.printAtom(content);
        }
    }

    public IPrologTermOutput printString(String var1);

    public IPrologTermOutput printNumber(long var1);

    public IPrologTermOutput printNumber(BigInteger var1);

    public IPrologTermOutput printNumber(double var1);

    public IPrologTermOutput openList();

    public IPrologTermOutput closeList();

    public IPrologTermOutput tailSeparator();

    default public IPrologTermOutput tail(Consumer<? super IPrologTermOutput> scope) {
        scope.accept(this.tailSeparator());
        return this;
    }

    default public IPrologTermOutput emptyList() {
        return this.openList().closeList();
    }

    default public IPrologTermOutput list(Consumer<? super IPrologTermOutput> scope) {
        scope.accept(this.openList());
        return this.closeList();
    }

    default public IPrologTermOutput list(Consumer<? super IPrologTermOutput> scope, Consumer<? super IPrologTermOutput> tailScope) {
        scope.accept(this.openList());
        return this.closeList(tailScope);
    }

    default public IPrologTermOutput closeList(Consumer<? super IPrologTermOutput> scope) {
        scope.accept(this.tailSeparator());
        return this.closeList();
    }

    public IPrologTermOutput printVariable(String var1);

    default public IPrologTermOutput printAnonVariable() {
        return this.printVariable("_");
    }

    public IPrologTermOutput printTerm(PrologTerm var1);

    public IPrologTermOutput flush();

    public IPrologTermOutput fullstop();

    default public IPrologTermOutput sentence(PrologTerm term) {
        return this.printTerm(term).fullstop();
    }
}

