/*
 * Decompiled with CFR 0.152.
 */
package de.prob.parserbase;

import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.parserbase.ProBParserBaseAdapter;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;

public class JoinedParserBase
implements ProBParserBase {
    private final ProBParserBaseAdapter[] parsers;

    public JoinedParserBase(ProBParserBase[] parsers) {
        if (parsers.length == 0) {
            throw new IllegalArgumentException("There should be at least one parser");
        }
        this.parsers = new ProBParserBaseAdapter[parsers.length];
        for (int i = 0; i < parsers.length; ++i) {
            this.parsers[i] = new ProBParserBaseAdapter(parsers[i]);
        }
    }

    @Override
    public void parseExpression(IPrologTermOutput pto, String expression, boolean wrap) throws ProBParseException {
        this.parse(Type.EXPR, pto, expression, wrap);
    }

    @Override
    public void parsePredicate(IPrologTermOutput pto, String predicate, boolean wrap) throws ProBParseException {
        this.parse(Type.PRED, pto, predicate, wrap);
    }

    @Override
    public void parseTransitionPredicate(IPrologTermOutput pto, String trans2, boolean wrap) throws ProBParseException {
        this.parse(Type.TRANS, pto, trans2, wrap);
    }

    private void parse(Type type, IPrologTermOutput pto, String formula, boolean wrap) throws ProBParseException {
        ProBParseException parseException = null;
        UnsupportedOperationException unsupportedException = null;
        for (ProBParserBaseAdapter parser : this.parsers) {
            try {
                PrologTerm term;
                switch (type) {
                    case EXPR: {
                        term = parser.parseExpression(formula, wrap);
                        break;
                    }
                    case PRED: {
                        term = parser.parsePredicate(formula, wrap);
                        break;
                    }
                    case TRANS: {
                        term = parser.parseTransitionPredicate(formula, wrap);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                pto.printTerm(term);
                return;
            }
            catch (ProBParseException e) {
                if (parseException != null) continue;
                parseException = e;
            }
            catch (UnsupportedOperationException e) {
                if (unsupportedException != e) continue;
                unsupportedException = e;
            }
        }
        if (parseException != null) {
            throw parseException;
        }
        throw unsupportedException;
    }

    private static enum Type {
        EXPR,
        PRED,
        TRANS;

    }
}

