/*
 * Decompiled with CFR 0.152.
 */
package tlc2.input;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolMatcher;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.input.MCOutputMessage;
import tlc2.input.MCOutputParser;
import tlc2.input.MCParserResults;
import tlc2.model.MCError;
import tlc2.tool.Defns;
import tlc2.tool.impl.ModelConfig;
import tlc2.tool.impl.SpecProcessor;
import tlc2.tool.impl.SymbolNodeValueLookupProvider;
import tlc2.tool.impl.TLAClass;
import util.FilenameToStream;
import util.SimpleFilenameToStream;

public class MCParser {
    private static final int TOOL_ID = 0;
    private final ModelConfig configParser;
    private MCOutputParser outputParser;
    private final TLAClass tlaClass;
    private final Defns defns;
    private final FilenameToStream resolver;
    private MCParserResults parserResults;
    private final String specBaseName;

    public static MCParserResults generateResultsFromProcessorAndConfig(SpecProcessor specProcessor, ModelConfig modelConfig) {
        String nextOrSpecName;
        ArrayList<Location> initNextLocationsToDelete = new ArrayList<Location>();
        boolean isInitNext = !modelConfig.configDefinesSpecification();
        ModuleNode root = specProcessor.getRootModule();
        if (isInitNext) {
            OpDefNode nextNode;
            OpDefNode initNode;
            String initDefinitionName = modelConfig.getInit();
            nextOrSpecName = modelConfig.getNext();
            Collection<SymbolNode> initNodes = root.getSymbols(new NodeNameMatcher(initDefinitionName));
            Collection<SymbolNode> nextNodes = root.getSymbols(new NodeNameMatcher(nextOrSpecName));
            if (initNodes.size() == 1 && (initNode = (OpDefNode)initNodes.iterator().next()).getOriginallyDefinedInModuleNode().equals(root)) {
                initNextLocationsToDelete.add(initNode.getLocation());
            }
            if (nextNodes.size() == 1 && (nextNode = (OpDefNode)nextNodes.iterator().next()).getOriginallyDefinedInModuleNode().equals(root)) {
                initNextLocationsToDelete.add(nextNode.getLocation());
            }
        } else {
            nextOrSpecName = modelConfig.getSpec();
        }
        initNextLocationsToDelete.sort(new LocationComparator());
        ArrayList<String> extendees = new ArrayList<String>();
        root.getExtendedModuleSet(false).stream().forEach(moduleNode -> extendees.add(moduleNode.getName().toString()));
        HashSet<String> allExtendees = new HashSet<String>();
        root.getExtendedModuleSet(true).stream().forEach(moduleNode -> allExtendees.add(moduleNode.getName().toString()));
        String rootModuleName = root.getName().toString();
        HashSet<String> instantiatedModules = new HashSet<String>();
        MCParser.collectionInstantiatedModules(root, instantiatedModules, allExtendees);
        return new MCParserResults(rootModuleName, extendees, allExtendees, instantiatedModules, initNextLocationsToDelete, isInitNext, nextOrSpecName, modelConfig);
    }

    private static void collectionInstantiatedModules(ModuleNode node, HashSet<String> modulesList, HashSet<String> allExtendees) {
        InstanceNode[] instances;
        for (InstanceNode instance : instances = node.getInstances()) {
            ModuleNode instanceModule = instance.getModule();
            instanceModule.getExtendedModuleSet(true).stream().forEach(moduleNode -> allExtendees.add(moduleNode.getName().toString()));
            modulesList.add(instanceModule.getName().toString());
            MCParser.collectionInstantiatedModules(instanceModule, modulesList, allExtendees);
        }
    }

    public MCParser(File sourceDirectory, String specName) {
        this(sourceDirectory, specName, null);
        File f = new File(sourceDirectory, this.specBaseName + ".out");
        if (!f.exists()) {
            throw new IllegalArgumentException("No readable output file could be found at " + f.getAbsolutePath());
        }
        this.outputParser = new MCOutputParser(f);
        f = new File(sourceDirectory, this.specBaseName + ".tla");
        if (!f.exists()) {
            throw new IllegalArgumentException("No readable TLA file could be found at " + f.getAbsolutePath());
        }
    }

    public MCParser(File sourceDirectory, String specName, boolean ignoreOutputParse) {
        this(sourceDirectory, specName, null);
        File f;
        if (!ignoreOutputParse) {
            f = new File(sourceDirectory, this.specBaseName + ".out");
            if (!f.exists()) {
                throw new IllegalArgumentException("No readable output file could be found at " + f.getAbsolutePath());
            }
            this.outputParser = new MCOutputParser(f);
        }
        if (!(f = new File(sourceDirectory, this.specBaseName + ".tla")).exists()) {
            throw new IllegalArgumentException("No readable TLA file could be found at " + f.getAbsolutePath());
        }
    }

    private MCParser(File sourceDirectory, String specName, Object signatureDifferentiator) {
        this.resolver = new SimpleFilenameToStream(sourceDirectory.getAbsolutePath());
        this.specBaseName = specName;
        File f = new File(sourceDirectory, this.specBaseName + ".cfg");
        if (!f.exists()) {
            throw new IllegalArgumentException("No readable config file could be found at " + f.getAbsolutePath());
        }
        this.configParser = new ModelConfig(f.getAbsolutePath(), this.resolver);
        this.tlaClass = new TLAClass("tlc2.module", this.resolver);
        this.defns = new Defns();
    }

    public MCParserResults getParseResults() {
        return this.parserResults;
    }

    public MCParserResults parse() {
        if (this.parserResults != null) {
            throw new IllegalStateException("Parse has already been called.");
        }
        try {
            List<MCOutputMessage> encounteredMessages = this.outputParser != null ? this.outputParser.parse(true) : null;
            this.configParser.parse();
            if (encounteredMessages == null || encounteredMessages.size() > 0) {
                SymbolNodeValueLookupProvider defaultLookup = new SymbolNodeValueLookupProvider(){};
                SpecProcessor specProcessor = new SpecProcessor(this.specBaseName, this.resolver, 0, this.defns, this.configParser, defaultLookup, null, this.tlaClass);
                this.parserResults = MCParser.generateResultsFromProcessorAndConfig(specProcessor, this.configParser);
                if (this.outputParser != null) {
                    this.parserResults.setError(this.outputParser.getError());
                    this.parserResults.setOutputMessages(encounteredMessages);
                }
            } else {
                this.parserResults = new MCParserResults(null, this.outputParser != null ? this.outputParser.getError() : null, encounteredMessages, new ArrayList<String>(), new HashSet<String>(), new HashSet<String>(), new ArrayList<Location>(), true, null, this.configParser);
            }
            return this.parserResults;
        }
        catch (IOException e) {
            System.out.println("Caught exception while performing MC parsing: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        MCParser parser = new MCParser(new File(args[0]), "MC", null);
        MCParserResults results = parser.parse();
        System.out.println("Parse encountered " + results.getOutputMessages().size() + " messages.");
        MCError error = results.getError();
        if (error != null) {
            System.out.println("Encountered error: ");
            System.out.println(error.toSequenceOfRecords(true));
        }
        List<String> extendedModules = results.getOriginalExtendedModules();
        System.out.println("Found " + extendedModules.size() + " module(s) being extended explicitly by the root spec:");
        for (String module : extendedModules) {
            System.out.println("\t" + module);
        }
    }

    private static class LocationComparator
    implements Comparator<Location> {
        private LocationComparator() {
        }

        @Override
        public int compare(Location l2, Location l1) {
            if (l1.beginLine() == l2.beginLine()) {
                if (l1.beginColumn() != l2.beginColumn()) {
                    return l1.beginColumn() - l2.beginColumn();
                }
                if (l1.endLine() != l2.endLine()) {
                    return l1.endLine() - l2.endLine();
                }
                return l1.endColumn() - l2.endColumn();
            }
            return l1.beginLine() - l2.beginLine();
        }
    }

    private static class NodeNameMatcher
    implements SymbolMatcher {
        private final String name;

        NodeNameMatcher(String nameToMatch) {
            this.name = nameToMatch;
        }

        @Override
        public boolean matches(SymbolNode aSymbol) {
            if (aSymbol.getName() != null) {
                return this.name.equals(aSymbol.getName().toString());
            }
            return false;
        }
    }
}

