/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.tlc;

import de.tlc4b.TLC4BGlobals;
import de.tlc4b.exceptions.NotSupportedException;
import de.tlc4b.tlc.TLCOutputInfo;
import de.tlc4b.tlc.TracePrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.Location;
import tlc2.output.MP;
import tlc2.output.Message;
import tlc2.output.OutputCollector;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.ToolGlobals;

public class TLCResults
implements ToolGlobals {
    private TLCResult tlcResult;
    private String violatedDefinition;
    private String tlcErrorMessage;
    private Date startTime;
    private Date endTime;
    private Map<String, Long> operationsCount;
    private final List<String> violatedAssertions = new ArrayList<String>();
    private int lengthOfTrace;
    private String traceString;
    private String traceFile;
    private int numberOfDistinctStates;
    private int numberOfTransitions;
    private final TLCOutputInfo tlcOutputInfo;

    public boolean hasTrace() {
        return this.lengthOfTrace > 0;
    }

    public void addTraceFilePath(String traceFile) {
        this.traceFile = traceFile;
    }

    public String getTraceFilePath() {
        if (this.hasTrace() && this.traceFile != null) {
            return this.traceFile;
        }
        return null;
    }

    public Map<String, Long> getOperationCount() {
        return this.operationsCount;
    }

    public TLCResults(TLCOutputInfo tlcOutputInfo) {
        this.tlcOutputInfo = tlcOutputInfo;
        this.lengthOfTrace = 0;
    }

    public int getNumberOfDistinctStates() {
        return this.numberOfDistinctStates;
    }

    public String getTrace() {
        return this.traceString;
    }

    public String getViolatedDefinition() {
        return this.violatedDefinition;
    }

    public List<String> getViolatedAssertions() {
        return this.violatedAssertions;
    }

    public int getNumberOfTransitions() {
        return this.numberOfTransitions;
    }

    public double getModelCheckingTime() {
        if (this.endTime == null || this.startTime == null) {
            return -1.0;
        }
        return (double)(this.endTime.getTime() - this.startTime.getTime()) / 1000.0;
    }

    public void evalResults() {
        this.evalAllMessages();
        if (this.hasTrace()) {
            this.evalTrace();
        }
        if (this.tlcResult == TLCResult.NoError && this.tlcOutputInfo.hasInitialisation() && this.numberOfDistinctStates == 0) {
            this.tlcResult = TLCResult.InitialStateError;
        }
        if (TLC4BGlobals.isPrintCoverage() && !TLC4BGlobals.getCurrentLineCounts().isEmpty()) {
            this.evalCoverage();
        }
    }

    private void evalCoverage() {
        Hashtable<Integer, Long> lineCount = new Hashtable<Integer, Long>();
        Set<Map.Entry<Location, Long>> entrySet = TLC4BGlobals.getCurrentLineCounts().entrySet();
        for (Map.Entry<Location, Long> entry : entrySet) {
            int endline = entry.getKey().endLine();
            if (lineCount.containsKey(endline)) {
                lineCount.put(endline, Math.max((Long)lineCount.get(endline), entry.getValue()));
                continue;
            }
            lineCount.put(endline, entry.getValue());
        }
        List<OpDefNode> defs = this.getActionsFromGeneratedModule(OutputCollector.getModuleNode());
        this.operationsCount = new LinkedHashMap<String, Long>();
        for (OpDefNode opDefNode : defs) {
            String operationName = opDefNode.getName().toString();
            Long count = (Long)lineCount.get(opDefNode.getLocation().endLine());
            if (count == null) {
                count = 0L;
            }
            this.operationsCount.put(operationName, count);
        }
    }

    private List<OpDefNode> getActionsFromGeneratedModule(ModuleNode moduleNode) {
        ArrayList<OpDefNode> actions = new ArrayList<OpDefNode>();
        OpDefNode[] opDefs = moduleNode.getOpDefs();
        ExprNode pred = null;
        for (int i = opDefs.length - 1; i > 0; --i) {
            OpDefNode def = opDefs[i];
            if (!def.getName().toString().equals("Next")) continue;
            pred = def.getBody();
            break;
        }
        if (pred == null) {
            return actions;
        }
        OpApplNode dis = (OpApplNode)pred;
        for (int i = 0; i < dis.getArgs().length; ++i) {
            actions.add(this.findAction(dis.getArgs()[i]));
        }
        return actions;
    }

    private OpDefNode findAction(ExprOrOpArgNode arg) {
        OpApplNode op1 = (OpApplNode)arg;
        SymbolNode opNode = op1.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 2) {
            return this.findAction(op1.getArgs()[0]);
        }
        if (opNode instanceof OpDefNode) {
            return (OpDefNode)opNode;
        }
        throw new NotSupportedException("Can not find action in next state relation. Unknown node: " + opNode.getClass());
    }

    private void evalTrace() {
        List<TLCStateInfo> trace = OutputCollector.getTrace();
        TLCState initialState = OutputCollector.getInitialState();
        if (trace.isEmpty() && initialState != null) {
            trace = Collections.singletonList(new TLCStateInfo(initialState));
        }
        if (!trace.isEmpty()) {
            TracePrinter printer = new TracePrinter(trace, this.tlcOutputInfo);
            this.traceString = printer.getTrace().toString();
        }
    }

    private void evalAllMessages() {
        ArrayList<Message> messages = new ArrayList<Message>(TLC4BGlobals.getCurrentMessages());
        for (Message m : messages) {
            switch (m.getMessageClass()) {
                case 1: {
                    this.evalErrorMessage(m);
                    if (this.tlcResult != null) break;
                    this.tlcErrorMessage = MP.getError(m.getMessageCode(), m.getParameters());
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    ++this.lengthOfTrace;
                    break;
                }
                case 3: {
                    break;
                }
                case 0: {
                    this.evalStatusMessage(m);
                    break;
                }
            }
        }
        if (this.tlcErrorMessage != null) {
            this.tlcResult = TLCResult.TLCError;
        }
    }

    private void evalStatusMessage(Message m) {
        switch (m.getMessageCode()) {
            case 2185: {
                this.startTime = m.getDate();
                break;
            }
            case 2186: {
                this.endTime = m.getDate();
                break;
            }
            case 2199: 
            case 2204: {
                this.numberOfTransitions = Integer.parseInt(m.getParameters()[0]);
                this.numberOfDistinctStates = Integer.parseInt(m.getParameters()[1]);
                break;
            }
            case 2193: {
                this.tlcResult = TLCResult.NoError;
                break;
            }
        }
    }

    private void evalErrorMessage(Message m) {
        switch (m.getMessageCode()) {
            case 2107: 
            case 2110: {
                this.tlcResult = m.getParameters()[0].startsWith("Assertion") ? TLCResult.AssertionError : (m.getParameters()[0].equals("NotGoal") ? TLCResult.Goal : (m.getParameters()[0].startsWith("ASSERT_LTL") || m.getParameters()[0].equals("ltl") ? TLCResult.TemporalPropertyViolation : TLCResult.InvariantViolation));
                if (m.getParameters().length <= 0) break;
                this.violatedDefinition = m.getParameters()[0];
                break;
            }
            case 2102: {
                String arg1 = m.getParameters()[0];
                if (arg1.contains("Attempted to compute the number of elements in the overridden")) {
                    // empty if block
                }
                this.tlcResult = TLCResult.EnumerationError;
                return;
            }
            case 2114: {
                this.tlcResult = TLCResult.Deadlock;
                break;
            }
            case 2104: {
                List<ExprNode> violatedAssumptions = TLC4BGlobals.getCurrentViolatedAssumptions();
                if (!violatedAssumptions.isEmpty()) {
                    for (ExprNode exprNode : violatedAssumptions) {
                        AssumeNode assumeNode = this.findAssumeNode(exprNode);
                        ThmOrAssumpDefNode def = assumeNode.getDef();
                        if (def == null) continue;
                        String assertionName = def.getName().toString();
                        if (!this.violatedAssertions.contains(assertionName)) {
                            this.violatedAssertions.add(assertionName);
                        }
                        this.tlcResult = TLCResult.AssertionError;
                    }
                }
                if (this.tlcResult != null) break;
                this.tlcResult = TLCResult.PropertiesError;
                break;
            }
            case 2116: {
                this.tlcResult = TLCResult.TemporalPropertyViolation;
                if (m.getParameters().length <= 0) break;
                this.violatedDefinition = m.getParameters()[0];
                break;
            }
            case 2132: {
                this.tlcResult = TLCResult.WellDefinednessError;
                break;
            }
            case 2154: {
                if (!m.getParameters()[0].contains("tlc2.module.TLC.Assert")) break;
                this.tlcResult = TLCResult.WellDefinednessError;
                break;
            }
            case 2230: {
                String kind = m.getParameters()[0];
                String id = m.getParameters()[1];
                if (kind.contains("property") && id.startsWith("ASSERT_LTL")) {
                    this.tlcResult = TLCResult.TemporalPropertyViolation;
                    break;
                }
                if (kind.contains("invariant") && id.startsWith("Assertion")) {
                    this.tlcResult = TLCResult.AssertionError;
                    break;
                }
                this.tlcResult = this.evaluatingParameter(m.getParameters());
                break;
            }
            case 1000: 
            case 2105: {
                this.tlcResult = this.evaluatingParameter(m.getParameters());
            }
        }
    }

    private AssumeNode findAssumeNode(ExprNode exprNode) {
        AssumeNode[] assumptions;
        ModuleNode moduleNode = OutputCollector.getModuleNode();
        for (AssumeNode assumeNode : assumptions = moduleNode.getAssumptions()) {
            if (assumeNode.getAssume() != exprNode) continue;
            return assumeNode;
        }
        return null;
    }

    private TLCResult evaluatingParameter(String[] params) {
        for (String s : params) {
            if (s == null) break;
            if (s.contains("not enumerable")) {
                return TLCResult.EnumerationError;
            }
            if (s.contains("The invariant of Assertion")) {
                return TLCResult.AssertionError;
            }
            if (s.contains("The invariant of Invariant")) {
                return TLCResult.InvariantViolation;
            }
            if (s.contains("In applying the function") || s.contains("which is not in the domain of the function") || s.contains("tlc2.module.TLC.Assert") || s.contains("CHOOSE x \\in S: P, but no element of S satisfied P") && s.contains("module FunctionsAsRelations") || s.contains("Both operands of the modulo operator must be natural numbers") || s.contains("Division by zero") || s.contains("Applied the inter operator to an empty set") || s.replace("\n", "").matches(".*The.*argument.*operator should be.*sequence.*") || s.replace("\n", "").matches(".*The.*argument.*operator is an invalid number.*")) {
                return TLCResult.WellDefinednessError;
            }
            if (s.contains("ASSERT_LTL")) {
                return TLCResult.TemporalPropertyViolation;
            }
            if (!s.contains("java.lang.InterruptedException")) continue;
            return TLCResult.Interrupted;
        }
        return null;
    }

    public TLCResult getTLCResult() {
        return this.tlcResult;
    }

    public String getTLCErrorMessage() {
        return this.tlcErrorMessage;
    }

    public String getResultString() {
        if (this.tlcResult == TLCResult.InvariantViolation) {
            return "Invariant Violation";
        }
        if (this.tlcResult == TLCResult.TemporalPropertyViolation) {
            return "Temporal Property Violation";
        }
        if (this.tlcResult == null) {
            return TLCResult.TLCError.toString();
        }
        return this.tlcResult.toString();
    }

    public static enum TLCResult {
        Deadlock,
        Goal,
        InvariantViolation,
        ParseError,
        NoError,
        AssertionError,
        PropertiesError,
        EnumerationError,
        TLCError,
        TemporalPropertyViolation,
        WellDefinednessError,
        InitialStateError,
        Interrupted;

    }
}

