/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.tlc;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import util.ToolIO;

public class ModuleMatcher {
    private final String fileName;
    private final HashMap<Integer, String> lineToNameMap;

    public ModuleMatcher(String fileName, String path) {
        this.fileName = fileName;
        this.lineToNameMap = new HashMap();
        ModuleNode moduleNode = this.parse(fileName, path);
        this.evalActions(moduleNode);
    }

    public String getName(String string) {
        int line = this.getLine(string);
        if (line == -1) {
            return "Init";
        }
        return this.lineToNameMap.get(line);
    }

    private void evalActions(ModuleNode moduleNode) {
        OpDefNode[] opdefs;
        for (OpDefNode opdef : opdefs = moduleNode.getOpDefs()) {
            String module = opdef.getSource().getOriginallyDefinedInModuleNode().getName().toString();
            if (!module.equalsIgnoreCase(this.fileName)) continue;
            String opdefName = opdef.getName().toString();
            this.lineToNameMap.put(opdef.getLocation().beginLine(), opdefName);
        }
    }

    private int getLine(String s) {
        Pattern pattern = Pattern.compile("(line\\s)(\\d+)");
        Matcher matcher = pattern.matcher(s);
        boolean res = matcher.find();
        if (res) {
            return Integer.parseInt(matcher.group(2));
        }
        return -1;
    }

    private ModuleNode parse(String fileName, String path) {
        ToolIO.reset();
        ToolIO.setUserDir(path);
        SpecObj spec = new SpecObj(fileName, null);
        try {
            SANY.frontEndMain(spec, fileName, ToolIO.out);
        }
        catch (FrontEndException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        ModuleNode n = spec.getExternalModuleTable().rootModule;
        if (spec.getInitErrors().isFailure()) {
            System.err.println(spec.getInitErrors());
            return null;
        }
        if (n == null) {
            System.out.println("hier");
            System.out.println(ModuleMatcher.allMessagesToString(ToolIO.getAllMessages()));
        }
        return n;
    }

    public static String allMessagesToString(String[] allMessages) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < allMessages.length - 1; ++i) {
            sb.append(allMessages[i]).append("\n");
        }
        return sb.toString();
    }
}

