/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.ltl;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AStringExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.ltl.core.parser.analysis.DepthFirstAdapter;
import de.be4.ltl.core.parser.internal.LtlLexer;
import de.be4.ltl.core.parser.lexer.LexerException;
import de.be4.ltl.core.parser.node.AActionLtl;
import de.be4.ltl.core.parser.node.AAndLtl;
import de.be4.ltl.core.parser.node.AEnabledLtl;
import de.be4.ltl.core.parser.node.AExistsLtl;
import de.be4.ltl.core.parser.node.AForallLtl;
import de.be4.ltl.core.parser.node.AHistoricallyLtl;
import de.be4.ltl.core.parser.node.AOnceLtl;
import de.be4.ltl.core.parser.node.AReleaseLtl;
import de.be4.ltl.core.parser.node.ASinceLtl;
import de.be4.ltl.core.parser.node.AStrongFairLtl;
import de.be4.ltl.core.parser.node.ATriggerLtl;
import de.be4.ltl.core.parser.node.AUnparsedLtl;
import de.be4.ltl.core.parser.node.AUntilLtl;
import de.be4.ltl.core.parser.node.AWeakFairLtl;
import de.be4.ltl.core.parser.node.AWeakuntilLtl;
import de.be4.ltl.core.parser.node.AYesterdayLtl;
import de.be4.ltl.core.parser.node.PLtl;
import de.be4.ltl.core.parser.parser.Parser;
import de.be4.ltl.core.parser.parser.ParserException;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.analysis.typerestriction.TypeRestrictor;
import de.tlc4b.exceptions.LTLParseException;
import de.tlc4b.exceptions.ScopeException;
import de.tlc4b.ltl.LTLBPredicate;
import de.tlc4b.ltl.LTLFormulaPrinter;
import de.tlc4b.prettyprint.TLAPrinter;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;

public class LTLFormulaVisitor
extends DepthFirstAdapter {
    private final String name;
    private final MachineContext machineContext;
    private String ltlFormula;
    private de.be4.ltl.core.parser.node.Start ltlFormulaStart;
    private final LinkedHashMap<de.be4.ltl.core.parser.node.Node, Node> ltlNodeToBNodeTable;
    private final ArrayList<LTLBPredicate> bPredicates;
    private final Hashtable<String, AIdentifierExpression> ltlIdentifierTable;
    private final ArrayList<Hashtable<String, AIdentifierExpression>> contextTable;

    public LTLFormulaVisitor(String name, MachineContext machineContext) {
        this.name = name;
        this.machineContext = machineContext;
        this.bPredicates = new ArrayList();
        this.ltlNodeToBNodeTable = new LinkedHashMap();
        this.ltlIdentifierTable = new Hashtable();
        this.contextTable = new ArrayList();
    }

    public void parseDefinition(AExpressionDefinitionDefinition def) {
        if (!(def.getRhs() instanceof AStringExpression)) {
            throw new LTLParseException("Error: LTL formula is not in a string representation.");
        }
        AStringExpression stringNode = (AStringExpression)def.getRhs();
        this.ltlFormula = stringNode.getContent().getText();
        try {
            this.ltlFormulaStart = LTLFormulaVisitor.parseLTLFormula(this.ltlFormula);
        }
        catch (Exception e) {
            String message = "Parsing definition " + this.name + " (line " + def.getStartPos().getLine() + "):\n";
            throw new LTLParseException(message + e.getMessage(), e);
        }
    }

    public void parseLTLString(String ltlString) {
        try {
            this.ltlFormulaStart = LTLFormulaVisitor.parseLTLFormula(ltlString);
        }
        catch (Exception e) {
            throw new LTLParseException(e);
        }
    }

    public ArrayList<LTLBPredicate> getBPredicates() {
        return this.bPredicates;
    }

    public Collection<AIdentifierExpression> getParameter() {
        return this.ltlIdentifierTable.values();
    }

    public AIdentifierExpression getLTLIdentifier(String identifier) {
        return this.ltlIdentifierTable.get(identifier);
    }

    public LinkedHashMap<de.be4.ltl.core.parser.node.Node, Node> getUnparsedHashTable() {
        return this.ltlNodeToBNodeTable;
    }

    public Node getBAst(de.be4.ltl.core.parser.node.Node unparsedLtl) {
        return this.ltlNodeToBNodeTable.get(unparsedLtl);
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        this.ltlFormulaStart.apply(this);
    }

    public de.be4.ltl.core.parser.node.Start getLTLFormulaStart() {
        return this.ltlFormulaStart;
    }

    public void printLTLFormula(TLAPrinter tlaPrinter, TypeRestrictor typeRestrictor) {
        new LTLFormulaPrinter(tlaPrinter, this, typeRestrictor);
    }

    public static de.be4.ltl.core.parser.node.Start parseLTLFormula(String ltlFormula) throws ParserException, LexerException, IOException {
        StringReader reader = new StringReader(ltlFormula);
        PushbackReader r = new PushbackReader(reader);
        LtlLexer l = new LtlLexer(r);
        Parser p = new Parser(l);
        de.be4.ltl.core.parser.node.Start ast = p.parse();
        return ast;
    }

    @Override
    public void caseAUnparsedLtl(AUnparsedLtl node) {
        Start start = this.parseBPredicate(node.getPredicate().getText());
        this.ltlNodeToBNodeTable.put(node, start);
        LTLBPredicate ltlBPredicate = new LTLBPredicate(this.getUnifiedContext(), (Node)start);
        this.bPredicates.add(ltlBPredicate);
        this.machineContext.checkLTLBPredicate(ltlBPredicate);
    }

    private Start parseBPredicate(String text) {
        Start start;
        BParser parser = new BParser("Testing");
        try {
            start = parser.parsePredicate(text);
        }
        catch (BCompoundException e) {
            throw new LTLParseException(e);
        }
        return start;
    }

    @Override
    public void caseAExistsLtl(AExistsLtl node) {
        this.handleQuantification(node, node.getExistsIdentifier().getText(), node.getPredicate().getText(), node.getLtl());
    }

    @Override
    public void caseAForallLtl(AForallLtl node) {
        this.handleQuantification(node, node.getForallIdentifier().getText(), node.getPredicate().getText(), node.getLtl());
    }

    private void handleQuantification(de.be4.ltl.core.parser.node.Node node, String parameterName, String bPredicateString, PLtl ltl) {
        ArrayList<TIdentifierLiteral> list = new ArrayList<TIdentifierLiteral>();
        list.add(new TIdentifierLiteral(parameterName));
        AIdentifierExpression parameterNode = new AIdentifierExpression(list);
        Hashtable<String, AIdentifierExpression> currentContext = new Hashtable<String, AIdentifierExpression>();
        currentContext.put(parameterName, parameterNode);
        this.contextTable.add(currentContext);
        this.ltlIdentifierTable.put(parameterName, parameterNode);
        Start start = this.parseBPredicate(bPredicateString);
        this.ltlNodeToBNodeTable.put(node, start);
        LTLBPredicate ltlBPredicate = new LTLBPredicate(this.getUnifiedContext(), (Node)start);
        this.bPredicates.add(ltlBPredicate);
        this.machineContext.checkLTLBPredicate(ltlBPredicate);
        ltl.apply(this);
        this.contextTable.remove(this.contextTable.size() - 1);
    }

    private LinkedHashMap<String, Node> getUnifiedContext() {
        LinkedHashMap<String, Node> context = new LinkedHashMap<String, Node>();
        for (Hashtable<String, AIdentifierExpression> stringAIdentifierExpressionHashtable : this.contextTable) {
            context.putAll(stringAIdentifierExpressionHashtable);
        }
        return context;
    }

    @Override
    public void caseAEnabledLtl(AEnabledLtl node) {
        String operationName = node.getOperation().getText();
        if (!this.machineContext.getOperations().containsKey(operationName)) {
            throw new ScopeException("Unkown operation " + operationName + ".");
        }
    }

    @Override
    public void caseAWeakFairLtl(AWeakFairLtl node) {
        String operationName = node.getOperation().getText().trim();
        if (!this.machineContext.getOperations().containsKey(operationName)) {
            throw new ScopeException("Unkown operation " + operationName + ".");
        }
    }

    @Override
    public void caseAStrongFairLtl(AStrongFairLtl node) {
        String operationName = node.getOperation().getText().trim();
        if (!this.machineContext.getOperations().containsKey(operationName)) {
            throw new ScopeException("Unkown operation " + operationName + ".");
        }
    }

    @Override
    public void inAUntilLtl(AUntilLtl node) {
        throw new ScopeException("The 'until' operator is not supported.");
    }

    @Override
    public void inAWeakuntilLtl(AWeakuntilLtl node) {
        throw new ScopeException("The 'weak until' operator is not supported.");
    }

    @Override
    public void inAReleaseLtl(AReleaseLtl node) {
        throw new ScopeException("The 'release' operator is not supported.");
    }

    @Override
    public void inASinceLtl(ASinceLtl node) {
        throw new ScopeException("The 'since' operator is not supported.");
    }

    @Override
    public void inATriggerLtl(ATriggerLtl node) {
        throw new ScopeException("The 'trigger' operator is not supported.");
    }

    @Override
    public void inAHistoricallyLtl(AHistoricallyLtl node) {
        throw new ScopeException("The 'history' operator is not supported.");
    }

    @Override
    public void inAOnceLtl(AOnceLtl node) {
        throw new ScopeException("The 'once' operator is not supported.");
    }

    @Override
    public void inAYesterdayLtl(AYesterdayLtl node) {
        throw new ScopeException("The 'yesterday' operator is not supported.");
    }

    @Override
    public void caseAActionLtl(AActionLtl node) {
        throw new ScopeException("The '[...]' operator is not supported.");
    }

    @Override
    public void caseAAndLtl(AAndLtl node) {
        this.inAAndLtl(node);
        if (node.getLeft() != null) {
            node.getLeft().apply(this);
        }
        if (node.getRight() != null) {
            node.getRight().apply(this);
        }
        this.outAAndLtl(node);
    }

    public MachineContext getMachineContext() {
        return this.machineContext;
    }
}

