/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis.transformation;

import de.be4.classicalb.core.parser.Definitions;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.analysis.checking.DefinitionCollector;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.ADefinitionExpression;
import de.be4.classicalb.core.parser.node.ADefinitionPredicate;
import de.be4.classicalb.core.parser.node.ADefinitionSubstitution;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PMachineClause;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import de.tlc4b.analysis.StandardModules;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;

public class DefinitionsEliminator
extends DepthFirstAdapter {
    private final IDefinitions definitions = new Definitions();
    private final ArrayList<Hashtable<String, PExpression>> contextStack;

    public static void eliminateDefinitions(Start start) {
        new DefinitionsEliminator(start);
    }

    private DefinitionsEliminator(Start node) {
        new DefinitionCollector(this.definitions).collectDefinitions(node);
        this.contextStack = new ArrayList();
        node.apply(this);
    }

    @Override
    public void caseAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        LinkedList<PMachineClause> copy = node.getMachineClauses();
        ADefinitionsMachineClause defClause = null;
        for (PMachineClause e : copy) {
            e.apply(this);
            if (!(e instanceof ADefinitionsMachineClause)) continue;
            defClause = (ADefinitionsMachineClause)e;
        }
        if (defClause != null && defClause.getDefinitions().isEmpty()) {
            defClause.replaceBy(null);
        }
    }

    @Override
    public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
        String name;
        ArrayList<PDefinition> newDefinitionsList = new ArrayList<PDefinition>();
        ArrayList<PDefinition> oldDefinitionsList = new ArrayList<PDefinition>(node.getDefinitions());
        for (PDefinition e : oldDefinitionsList) {
            if (e instanceof AExpressionDefinitionDefinition && Utils.isProBSpecialDefinitionName(name = ((AExpressionDefinitionDefinition)e).getName().getText())) continue;
            e.apply(this);
        }
        for (PDefinition e : oldDefinitionsList) {
            if (e instanceof AExpressionDefinitionDefinition) {
                name = ((AExpressionDefinitionDefinition)e).getName().getText();
                if (!Utils.isProBSpecialDefinitionName(name) && !StandardModules.isKeywordInModuleExternalFunctions(name)) continue;
                newDefinitionsList.add(e);
                continue;
            }
            if (!(e instanceof APredicateDefinitionDefinition) || !Utils.isProBSpecialDefinitionName(name = ((APredicateDefinitionDefinition)e).getName().getText()) && !StandardModules.isKeywordInModuleExternalFunctions(name)) continue;
            newDefinitionsList.add(e);
        }
        for (PDefinition def : newDefinitionsList) {
            def.replaceBy(null);
        }
        node.setDefinitions(newDefinitionsList);
    }

    @Override
    public void caseADefinitionSubstitution(ADefinitionSubstitution node) {
        String name = node.getDefLiteral().getText();
        PDefinition def = this.definitions.getDefinition(name);
        ASubstitutionDefinitionDefinition clone = (ASubstitutionDefinitionDefinition)def.clone();
        Hashtable<String, PExpression> context = new Hashtable<String, PExpression>();
        ArrayList<PExpression> arguments = new ArrayList<PExpression>(node.getParameters());
        for (int i = 0; i < clone.getParameters().size(); ++i) {
            AIdentifierExpression p = (AIdentifierExpression)clone.getParameters().get(i);
            String paramName = Utils.getTIdentifierListAsString(p.getIdentifier());
            Node arg = arguments.get(i);
            arg.apply(this);
            context.put(paramName, node.getParameters().get(i));
        }
        this.contextStack.add(context);
        clone.getRhs().apply(this);
        node.replaceBy(clone.getRhs());
        this.contextStack.remove(context);
    }

    @Override
    public void caseADefinitionExpression(ADefinitionExpression node) {
        String name = node.getDefLiteral().getText();
        ArrayList<PExpression> arguments = new ArrayList<PExpression>(node.getParameters());
        if (StandardModules.isKeywordInModuleExternalFunctions(name)) {
            for (PExpression arg : arguments) {
                arg.apply(this);
            }
            return;
        }
        PDefinition def = this.definitions.getDefinition(name);
        AExpressionDefinitionDefinition clone = (AExpressionDefinitionDefinition)def.clone();
        Hashtable<String, PExpression> context = new Hashtable<String, PExpression>();
        for (int i = 0; i < clone.getParameters().size(); ++i) {
            AIdentifierExpression p = (AIdentifierExpression)clone.getParameters().get(i);
            String paramName = Utils.getTIdentifierListAsString(p.getIdentifier());
            Node arg = arguments.get(i);
            arg.apply(this);
            context.put(paramName, node.getParameters().get(i));
        }
        this.contextStack.add(context);
        clone.getRhs().apply(this);
        node.replaceBy(clone.getRhs());
        this.contextStack.remove(context);
    }

    @Override
    public void caseADefinitionPredicate(ADefinitionPredicate node) {
        String name = node.getDefLiteral().getText();
        PDefinition def = this.definitions.getDefinition(name);
        ArrayList<PExpression> arguments = new ArrayList<PExpression>(node.getParameters());
        if (StandardModules.isKeywordInModuleExternalFunctions(name)) {
            for (PExpression arg : arguments) {
                arg.apply(this);
            }
            return;
        }
        APredicateDefinitionDefinition clone = (APredicateDefinitionDefinition)def.clone();
        Hashtable<String, PExpression> context = new Hashtable<String, PExpression>();
        for (int i = 0; i < clone.getParameters().size(); ++i) {
            AIdentifierExpression p = (AIdentifierExpression)clone.getParameters().get(i);
            String paramName = Utils.getTIdentifierListAsString(p.getIdentifier());
            Node arg = arguments.get(i);
            arg.apply(this);
            context.put(paramName, node.getParameters().get(i));
        }
        this.contextStack.add(context);
        clone.getRhs().apply(this);
        node.replaceBy(clone.getRhs());
        this.contextStack.remove(context);
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        if (this.contextStack.isEmpty()) {
            return;
        }
        String name = Utils.getTIdentifierListAsString(node.getIdentifier());
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            Hashtable<String, PExpression> context = this.contextStack.get(i);
            PExpression e = context.get(name);
            if (e == null) continue;
            node.replaceBy(e.clone());
        }
    }
}

